/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.saml;

import java.io.BufferedReader;
import java.io.IOException;
import java.time.Instant;
import java.util.UUID;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Response;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.TokenInterface;
import org.openmetadata.schema.auth.JWTAuthMechanism;
import org.openmetadata.schema.auth.RefreshToken;
import org.openmetadata.schema.auth.ServiceTokenType;
import org.openmetadata.schema.auth.TokenRefreshRequest;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.service.Entity;
import org.openmetadata.service.auth.JwtResponse;
import org.openmetadata.service.exception.CustomExceptionMessage;
import org.openmetadata.service.jdbi3.TokenRepository;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.security.AuthenticationCodeFlowHandler;
import org.openmetadata.service.security.SecurityUtil;
import org.openmetadata.service.security.jwt.JWTTokenGenerator;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.TokenUtil;
import org.openmetadata.service.util.UserUtil;
import org.pac4j.core.exception.TechnicalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/v1/saml/refresh"})
public class SamlTokenRefreshServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(SamlTokenRefreshServlet.class);
    private final TokenRepository tokenRepository = Entity.getTokenRepository();

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            TokenRefreshRequest tokenRefreshRequest = this.getTokenRefreshRequest(request);
            if (CommonUtil.nullOrEmpty((String)tokenRefreshRequest.getRefreshToken())) {
                throw new BadRequestException("Token Cannot be Null or Empty String");
            }
            TokenInterface tokenInterface = this.tokenRepository.findByToken(tokenRefreshRequest.getRefreshToken());
            UserRepository userRepository = (UserRepository)Entity.getEntityRepository("user");
            User storedUser = (User)userRepository.get(null, tokenInterface.getUserId(), userRepository.getFieldsWithUserAuth("*"));
            if (storedUser.getIsBot() != null && storedUser.getIsBot().booleanValue()) {
                throw new IllegalArgumentException("User are only allowed to refresh");
            }
            RefreshToken refreshToken = this.validateAndReturnNewRefresh(storedUser.getId(), tokenRefreshRequest);
            JWTAuthMechanism jwtAuthMechanism = JWTTokenGenerator.getInstance().generateJWTToken(storedUser.getName(), UserUtil.getRoleListFromUser(storedUser), !CommonUtil.nullOrEmpty((Object)storedUser.getIsAdmin()) && storedUser.getIsAdmin() != false, storedUser.getEmail(), 3600L, false, ServiceTokenType.OM_USER);
            JwtResponse jwtResponse = new JwtResponse();
            jwtResponse.setTokenType("Bearer");
            jwtResponse.setAccessToken(jwtAuthMechanism.getJWTToken());
            jwtResponse.setRefreshToken(refreshToken.getToken().toString());
            jwtResponse.setExpiryDuration(jwtAuthMechanism.getJWTTokenExpiresAt());
            SecurityUtil.writeJsonResponse(response, JsonUtils.pojoToJson(jwtResponse));
        }
        catch (Exception e) {
            AuthenticationCodeFlowHandler.getErrorMessage(response, (Exception)new TechnicalException((Throwable)e));
        }
    }

    private TokenRefreshRequest getTokenRefreshRequest(HttpServletRequest request) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = request.getReader();
        while ((line = reader.readLine()) != null) {
            sb.append(line);
        }
        return JsonUtils.readValue(sb.toString(), TokenRefreshRequest.class);
    }

    public RefreshToken validateAndReturnNewRefresh(UUID currentUserId, TokenRefreshRequest tokenRefreshRequest) {
        String requestRefreshToken = tokenRefreshRequest.getRefreshToken();
        RefreshToken storedRefreshToken = (RefreshToken)this.tokenRepository.findByToken(requestRefreshToken);
        if (storedRefreshToken.getExpiryDate().compareTo(Instant.now().toEpochMilli()) < 0) {
            throw new CustomExceptionMessage(Response.Status.BAD_REQUEST, "PASSWORD_RESET_TOKEN_EXPIRED", "Expired token. Please login again : " + storedRefreshToken.getToken().toString());
        }
        this.tokenRepository.deleteToken(requestRefreshToken);
        RefreshToken newRefreshToken = TokenUtil.getRefreshToken(currentUserId, UUID.randomUUID());
        this.tokenRepository.insertToken((TokenInterface)newRefreshToken);
        return newRefreshToken;
    }
}

