/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openmetadata.schema.email.EmailTemplate;
import org.openmetadata.schema.email.EmailTemplatePlaceholder;
import org.openmetadata.schema.email.TemplateValidationResponse;
import org.openmetadata.schema.entities.docStore.Document;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.DocumentRepository;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.TemplateProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTemplateProvider
implements TemplateProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTemplateProvider.class);
    private final DocumentRepository documentRepository = (DocumentRepository)Entity.getEntityRepository("document");
    public static final String ENTITY_TYPE_EMAIL_TEMPLATE = "EmailTemplate";

    @Override
    public Template getTemplate(String templateName) throws IOException {
        EmailTemplate emailTemplate = this.documentRepository.fetchEmailTemplateByName(templateName);
        String template = emailTemplate.getTemplate();
        if (template == null || template.isEmpty()) {
            throw new IOException("Template content not found for template: " + templateName);
        }
        return new Template(templateName, (Reader)new StringReader(template), new Configuration(Configuration.VERSION_2_3_31));
    }

    @Override
    public Map<String, Set<EmailTemplatePlaceholder>> getDocumentPlaceHolders() {
        List<Document> documents = this.documentRepository.fetchAllEmailTemplates();
        return documents.stream().collect(Collectors.toMap(Document::getName, document -> {
            EmailTemplate emailTemplate = JsonUtils.convertValue((Object)document.getData(), EmailTemplate.class);
            return emailTemplate.getPlaceHolders();
        }));
    }

    public Map<String, Set<String>> getPlaceholdersFromTemplate() {
        List<Document> listOfDocuments = this.documentRepository.fetchAllEmailTemplates();
        return listOfDocuments.stream().collect(Collectors.toMap(Document::getName, document -> DefaultTemplateProvider.extractPlaceholders(JsonUtils.convertValue((Object)document.getData(), EmailTemplate.class).getTemplate())));
    }

    @Override
    public TemplateValidationResponse validateEmailTemplate(String docName, String actualContent) {
        Set expectedPlaceholders = this.documentRepository.fetchEmailTemplateByName(docName).getPlaceHolders().stream().map(EmailTemplatePlaceholder::getName).collect(Collectors.toSet());
        Set<String> actualPlaceholders = DefaultTemplateProvider.extractPlaceholders(actualContent);
        Set missingPlaceholders = expectedPlaceholders.stream().filter(expected -> !actualPlaceholders.contains(expected)).collect(Collectors.toSet());
        Set additionalPlaceholders = actualPlaceholders.stream().filter(expected -> !expectedPlaceholders.contains(expected)).collect(Collectors.toSet());
        boolean isValid = additionalPlaceholders.isEmpty();
        return new TemplateValidationResponse().withIsValid(Boolean.valueOf(isValid)).withMissingPlaceholder(missingPlaceholders).withAdditionalPlaceholder(additionalPlaceholders).withMessage(isValid ? "Email Template passed validations." : "Invalid Email Template. Please check the placeholders for additional Details.");
    }

    private static Set<String> extractPlaceholders(String content) {
        HashSet<String> placeholders = new HashSet<String>();
        Pattern pattern = Pattern.compile("\\$\\{([^}]*)}");
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            placeholders.add(matcher.group(1));
        }
        return placeholders;
    }
}

