/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.email.SmtpSettings;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.settings.SettingsType;
import org.openmetadata.service.apps.bundles.changeEvent.email.EmailMessage;
import org.openmetadata.service.events.scheduled.template.DataInsightDescriptionAndOwnerTemplate;
import org.openmetadata.service.events.scheduled.template.DataInsightTotalAssetTemplate;
import org.openmetadata.service.resources.settings.SettingsCache;
import org.openmetadata.service.util.DefaultTemplateProvider;
import org.openmetadata.service.util.TemplateProvider;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.EmailPopulatingBuilder;
import org.simplejavamail.api.mailer.Mailer;
import org.simplejavamail.api.mailer.config.TransportStrategy;
import org.simplejavamail.email.EmailBuilder;
import org.simplejavamail.mailer.MailerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailUtil {
    private static final Logger LOG = LoggerFactory.getLogger(EmailUtil.class);
    public static final String USERNAME = "userName";
    public static final String ENTITY = "entity";
    public static final String SUPPORT_URL = "supportUrl";
    private static final String EMAIL_VERIFICATION_SUBJECT = "%s: Verify your Email Address (Action Required)";
    public static final String EMAIL_VERIFICATION_LINKKEY = "userEmailTokenVerificationLink";
    public static final String EMAIL_VERIFICATION_TEMPLATE = "email-verification";
    private static final String PASSWORD_RESET_SUBJECT = "%s: Reset your Password";
    public static final String PASSWORD_RESET_LINKKEY = "userResetPasswordLink";
    public static final String EXPIRATION_TIME_KEY = "expirationTime";
    public static final String DEFAULT_EXPIRATION_TIME = "60";
    public static final String PASSWORD = "password";
    public static final String APPLICATION_LOGIN_LINK = "applicationLoginLink";
    public static final String PASSWORD_RESET_TEMPLATE_FILE = "reset-link";
    private static final String ACCOUNT_STATUS_SUBJECT = "%s: Change in Account Status";
    public static final String ACTION_KEY = "action";
    public static final String ACTION_STATUS_KEY = "actionStatus";
    public static final String ACCOUNT_STATUS_TEMPLATE_FILE = "account-activity-change";
    private static final String INVITE_SUBJECT = "Welcome to %s";
    private static final String CHANGE_EVENT_UPDATE = "[%s] - Change Event Update from %s";
    private static final String TASK_SUBJECT = "%s : Task Assignment Notification";
    public static final String INVITE_RANDOM_PWD = "invite-randompwd";
    public static final String CHANGE_EVENT_TEMPLATE = "changeEvent";
    public static final String INVITE_CREATE_PWD = "invite-createPassword";
    public static final String TASK_NOTIFICATION_TEMPLATE = "taskAssignment";
    private static final String REPORT_SUBJECT = "%s: Data Insights Weekly - %s";
    public static final String DATA_INSIGHT_REPORT_TEMPLATE = "dataInsightReport";
    public static final String TEST_EMAIL_TEMPLATE = "testMail";
    public static final String TEST_EMAIL_SUBJECT = "%s : Test Email";
    private static SmtpSettings storedSmtpSettings;
    private static Mailer mailer;
    private static final String EMAIL_IGNORE_MSG = "Email was not sent to {} as SMTP setting is not enabled";
    private static TemplateProvider templateProvider;

    private static void initializeTemplateProvider() {
        templateProvider = new DefaultTemplateProvider();
    }

    private EmailUtil() {
        try {
            EmailUtil.getSmtpSettings();
            EmailUtil.initializeTemplateProvider();
            LOG.info("Email Util cache is initialized");
        }
        catch (Exception ex) {
            LOG.warn("[MAILER] Smtp Configurations are missing : Reason {} ", (Object)ex.getMessage(), (Object)ex);
        }
    }

    private static Mailer createMailer(SmtpSettings smtpServerSettings) {
        if (Boolean.TRUE.equals(smtpServerSettings.getEnableSmtpServer())) {
            TransportStrategy strategy = switch (smtpServerSettings.getTransportationStrategy()) {
                case SmtpSettings.TransportationStrategy.SMTPS -> TransportStrategy.SMTPS;
                case SmtpSettings.TransportationStrategy.SMTP_TLS -> TransportStrategy.SMTP_TLS;
                default -> TransportStrategy.SMTP;
            };
            String username = CommonUtil.nullOrEmpty((String)smtpServerSettings.getUsername()) ? null : smtpServerSettings.getUsername();
            String password = CommonUtil.nullOrEmpty((String)smtpServerSettings.getPassword()) ? null : smtpServerSettings.getPassword();
            return MailerBuilder.withSMTPServer((String)smtpServerSettings.getServerEndpoint(), (Integer)smtpServerSettings.getServerPort(), (String)username, (String)password).withTransportStrategy(strategy).buildMailer();
        }
        return null;
    }

    public static void sendAccountStatus(User user, String action, String status) throws IOException, TemplateException {
        if (Boolean.TRUE.equals(EmailUtil.getSmtpSettings().getEnableSmtpServer())) {
            HashMap<String, Object> templatePopulator = new HashMap<String, Object>();
            templatePopulator.put(ENTITY, EmailUtil.getEmailingEntity());
            templatePopulator.put(SUPPORT_URL, EmailUtil.getSupportUrl());
            templatePopulator.put(USERNAME, user.getName());
            templatePopulator.put(ACTION_KEY, action);
            templatePopulator.put(ACTION_STATUS_KEY, status);
            EmailUtil.sendMail(EmailUtil.getAccountStatusChangeSubject(), templatePopulator, user.getEmail(), ACCOUNT_STATUS_TEMPLATE_FILE, true);
        } else {
            LOG.warn(EMAIL_IGNORE_MSG, (Object)user.getEmail());
        }
    }

    public static void sendEmailVerification(String emailVerificationLink, User user) throws IOException, TemplateException {
        if (Boolean.TRUE.equals(EmailUtil.getSmtpSettings().getEnableSmtpServer())) {
            HashMap<String, Object> templatePopulator = new HashMap<String, Object>();
            templatePopulator.put(ENTITY, EmailUtil.getEmailingEntity());
            templatePopulator.put(SUPPORT_URL, EmailUtil.getSupportUrl());
            templatePopulator.put(USERNAME, user.getName());
            templatePopulator.put(EMAIL_VERIFICATION_LINKKEY, emailVerificationLink);
            templatePopulator.put(EXPIRATION_TIME_KEY, "24");
            EmailUtil.sendMail(EmailUtil.getEmailVerificationSubject(), templatePopulator, user.getEmail(), EMAIL_VERIFICATION_TEMPLATE, true);
        } else {
            LOG.warn(EMAIL_IGNORE_MSG, (Object)user.getEmail());
        }
    }

    public static void sendPasswordResetLink(String passwordResetLink, User user, String subject, String templateFilePath) throws IOException, TemplateException {
        if (Boolean.TRUE.equals(EmailUtil.getSmtpSettings().getEnableSmtpServer())) {
            HashMap<String, Object> templatePopulator = new HashMap<String, Object>();
            templatePopulator.put(ENTITY, EmailUtil.getEmailingEntity());
            templatePopulator.put(SUPPORT_URL, EmailUtil.getSupportUrl());
            templatePopulator.put(USERNAME, user.getName());
            templatePopulator.put(PASSWORD_RESET_LINKKEY, passwordResetLink);
            templatePopulator.put(EXPIRATION_TIME_KEY, DEFAULT_EXPIRATION_TIME);
            EmailUtil.sendMail(subject, templatePopulator, user.getEmail(), templateFilePath, true);
        } else {
            LOG.warn(EMAIL_IGNORE_MSG, (Object)user.getEmail());
        }
    }

    public static void sendTaskAssignmentNotificationToUser(String assigneeName, String email, String taskLink, Thread thread, String subject, String templateFilePath) throws IOException, TemplateException {
        if (Boolean.TRUE.equals(EmailUtil.getSmtpSettings().getEnableSmtpServer())) {
            HashMap<String, Object> templatePopulator = new HashMap<String, Object>();
            templatePopulator.put("assignee", assigneeName);
            templatePopulator.put("createdBy", thread.getCreatedBy());
            templatePopulator.put("taskName", thread.getMessage());
            templatePopulator.put("taskStatus", thread.getTask().getStatus().toString());
            templatePopulator.put("taskType", thread.getTask().getType().toString());
            templatePopulator.put("fieldOldValue", thread.getTask().getOldValue());
            templatePopulator.put("fieldNewValue", thread.getTask().getSuggestion());
            templatePopulator.put("taskLink", taskLink);
            EmailUtil.sendMail(subject, templatePopulator, email, templateFilePath, true);
        } else {
            LOG.warn(EMAIL_IGNORE_MSG, (Object)email);
        }
    }

    public static void sendMail(String subject, Map<String, Object> model, String to, String templateName, boolean async) throws IOException, TemplateException {
        if (Boolean.TRUE.equals(EmailUtil.getSmtpSettings().getEnableSmtpServer())) {
            EmailPopulatingBuilder emailBuilder = EmailBuilder.startingBlank();
            emailBuilder.withSubject(subject);
            emailBuilder.to(to);
            emailBuilder.from(EmailUtil.getSmtpSettings().getSenderMail());
            Template template = templateProvider.getTemplate(templateName);
            StringWriter stringWriter = new StringWriter();
            template.process(model, (Writer)stringWriter);
            String mailContent = stringWriter.toString();
            emailBuilder.withHTMLText(mailContent);
            EmailUtil.sendMail(emailBuilder.buildEmail(), async);
        } else {
            LOG.warn(EMAIL_IGNORE_MSG, (Object)to);
        }
    }

    public static void sendMailToMultiple(String subject, Map<String, Object> model, Set<String> to, String templateName) throws IOException, TemplateException {
        if (Boolean.TRUE.equals(EmailUtil.getSmtpSettings().getEnableSmtpServer())) {
            EmailPopulatingBuilder emailBuilder = EmailBuilder.startingBlank();
            emailBuilder.withSubject(subject);
            emailBuilder.toMultiple(to);
            emailBuilder.from(EmailUtil.getSmtpSettings().getSenderMail());
            Template template = templateProvider.getTemplate(templateName);
            StringWriter stringWriter = new StringWriter();
            template.process(model, (Writer)stringWriter);
            String mailContent = stringWriter.toString();
            emailBuilder.withHTMLText(mailContent);
            EmailUtil.sendMail(emailBuilder.buildEmail(), true);
        }
    }

    public static void sendMail(Email email, boolean async) {
        if (Boolean.TRUE.equals(EmailUtil.getSmtpSettings().getEnableSmtpServer()) && mailer != null) {
            mailer.sendMail(email, async);
        } else {
            LOG.error("Mailer is not initialized or Smtp is not Enabled.");
        }
    }

    public static void sendInviteMailToAdmin(User user, String pwd) {
        if (Boolean.TRUE.equals(EmailUtil.getSmtpSettings().getEnableSmtpServer())) {
            HashMap<String, Object> templatePopulator = new HashMap<String, Object>();
            templatePopulator.put(ENTITY, EmailUtil.getEmailingEntity());
            templatePopulator.put(SUPPORT_URL, EmailUtil.getSupportUrl());
            templatePopulator.put(USERNAME, user.getName());
            templatePopulator.put(PASSWORD, pwd);
            templatePopulator.put(APPLICATION_LOGIN_LINK, EmailUtil.getOMUrl());
            try {
                EmailUtil.sendMail(EmailUtil.getEmailInviteSubject(), templatePopulator, user.getEmail(), INVITE_RANDOM_PWD, true);
            }
            catch (Exception ex) {
                LOG.error("Failed in sending Mail to user [{}]. Reason : {}", (Object)user.getEmail(), (Object)ex.getMessage());
            }
        } else {
            LOG.warn(EMAIL_IGNORE_MSG, (Object)user.getEmail());
        }
    }

    public static void sendChangeEventMail(String publisherName, String receiverMail, EmailMessage emailMessaged) {
        if (Boolean.TRUE.equals(EmailUtil.getSmtpSettings().getEnableSmtpServer())) {
            HashMap<String, Object> templatePopulator = new HashMap<String, Object>();
            templatePopulator.put(USERNAME, receiverMail.split("@")[0]);
            templatePopulator.put("updatedBy", emailMessaged.getUpdatedBy());
            templatePopulator.put("entityUrl", emailMessaged.getEntityUrl());
            StringBuilder buff = new StringBuilder();
            for (String cmessage : emailMessaged.getChangeMessage()) {
                buff.append(cmessage);
                buff.append("\n");
            }
            templatePopulator.put("changeMessage", buff.toString());
            try {
                EmailUtil.sendMail(EmailUtil.getChangeEventTemplate(publisherName), templatePopulator, receiverMail, CHANGE_EVENT_TEMPLATE, true);
            }
            catch (Exception ex) {
                LOG.error("Failed in sending Mail to user [{}]. Reason : {}", (Object)receiverMail, (Object)ex.getMessage());
            }
        } else {
            LOG.warn(EMAIL_IGNORE_MSG, (Object)receiverMail);
        }
    }

    public static void sendDataInsightEmailNotificationToUser(Set<String> emails, String startDate, String endDate, DataInsightTotalAssetTemplate totalAssetObj, DataInsightDescriptionAndOwnerTemplate descriptionObj, DataInsightDescriptionAndOwnerTemplate ownerShipObj, DataInsightDescriptionAndOwnerTemplate tierObj, String subject, String templateFilePath) throws IOException, TemplateException {
        if (Boolean.TRUE.equals(EmailUtil.getSmtpSettings().getEnableSmtpServer())) {
            HashMap<String, Object> templatePopulator = new HashMap<String, Object>();
            templatePopulator.put("startDate", startDate);
            templatePopulator.put("endDate", endDate);
            templatePopulator.put("totalAssetObj", totalAssetObj);
            templatePopulator.put("descriptionObj", descriptionObj);
            templatePopulator.put("ownershipObj", ownerShipObj);
            templatePopulator.put("tierObj", tierObj);
            templatePopulator.put("viewReportUrl", String.format("%s/data-insights/data-assets", EmailUtil.getSmtpSettings().getOpenMetadataUrl()));
            EmailUtil.sendMailToMultiple(subject, templatePopulator, emails, templateFilePath);
        } else {
            LOG.warn(EMAIL_IGNORE_MSG, (Object)emails.toString());
        }
    }

    public static void sendTestEmail(String email, boolean async) throws IOException, TemplateException {
        if (Boolean.TRUE.equals(EmailUtil.getSmtpSettings().getEnableSmtpServer())) {
            HashMap<String, Object> templatePopulator = new HashMap<String, Object>();
            templatePopulator.put(USERNAME, email.split("@")[0]);
            templatePopulator.put(ENTITY, EmailUtil.getSmtpSettings().getEmailingEntity());
            templatePopulator.put(SUPPORT_URL, EmailUtil.getSmtpSettings().getSupportUrl());
            EmailUtil.sendMail(EmailUtil.getTestEmailSubject(), templatePopulator, email, TEST_EMAIL_TEMPLATE, async);
        } else {
            LOG.warn(EMAIL_IGNORE_MSG, (Object)email);
        }
    }

    public static void testConnection() {
        if (Boolean.TRUE.equals(EmailUtil.getSmtpSettings().getEnableSmtpServer()) && mailer != null) {
            mailer.testConnection();
        } else {
            LOG.error("Mailer is not initialized or Smtp is not Enabled.");
        }
    }

    private static String getEmailVerificationSubject() {
        return String.format(EMAIL_VERIFICATION_SUBJECT, EmailUtil.getSmtpSettings().getEmailingEntity());
    }

    public static String getPasswordResetSubject() {
        return String.format(PASSWORD_RESET_SUBJECT, EmailUtil.getSmtpSettings().getEmailingEntity());
    }

    private static String getAccountStatusChangeSubject() {
        return String.format(ACCOUNT_STATUS_SUBJECT, EmailUtil.getSmtpSettings().getEmailingEntity());
    }

    public static String getEmailInviteSubject() {
        return String.format(INVITE_SUBJECT, EmailUtil.getSmtpSettings().getEmailingEntity());
    }

    public static String getChangeEventTemplate(String publisherName) {
        return String.format(CHANGE_EVENT_UPDATE, publisherName, EmailUtil.getSmtpSettings().getEmailingEntity());
    }

    public static String getTaskAssignmentSubject() {
        return String.format(TASK_SUBJECT, EmailUtil.getSmtpSettings().getEmailingEntity());
    }

    public static String getTestEmailSubject() {
        return String.format(TEST_EMAIL_SUBJECT, EmailUtil.getSmtpSettings().getEmailingEntity());
    }

    public static String getDataInsightReportSubject() {
        return String.format(REPORT_SUBJECT, EmailUtil.getSmtpSettings().getEmailingEntity(), new SimpleDateFormat("dd-MM-yy").format(new Date()));
    }

    public static String getEmailingEntity() {
        return EmailUtil.getSmtpSettings().getEmailingEntity();
    }

    public static String getSupportUrl() {
        return EmailUtil.getSmtpSettings().getSupportUrl();
    }

    public static String getOMUrl() {
        return EmailUtil.getSmtpSettings().getOpenMetadataUrl();
    }

    public static SmtpSettings getSmtpSettings() {
        SmtpSettings emailConfig = SettingsCache.getSetting(SettingsType.EMAIL_CONFIGURATION, SmtpSettings.class);
        if (!emailConfig.equals((Object)storedSmtpSettings)) {
            storedSmtpSettings = emailConfig;
            mailer = EmailUtil.createMailer(emailConfig);
        }
        return emailConfig;
    }

    public static Boolean isValidEmail(String email) {
        if (StringUtils.isBlank((CharSequence)email)) {
            return false;
        }
        return email.matches("^[\\w-\\.]+@([\\w-]+\\.)+[\\w-]{2,4}$");
    }

    static {
        EmailUtil.getSmtpSettings();
        EmailUtil.initializeTemplateProvider();
    }
}

