/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.json.JsonPatch;
import javax.json.JsonValue;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.service.ResourceRegistry;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPatchUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JsonPatchUtils.class);

    private JsonPatchUtils() {
    }

    public static List<MetadataOperation> getMetadataOperations(JsonPatch jsonPatch) {
        HashSet<MetadataOperation> uniqueValues = new HashSet<MetadataOperation>();
        for (JsonValue jsonValue : jsonPatch.toJsonArray()) {
            MetadataOperation metadataOperation = JsonPatchUtils.getMetadataOperation(jsonValue);
            if (metadataOperation.equals((Object)MetadataOperation.EDIT_ALL)) {
                return CommonUtil.listOf((Object[])new MetadataOperation[]{MetadataOperation.EDIT_ALL});
            }
            uniqueValues.add(metadataOperation);
        }
        LOG.debug("Returning patch operations {}", (Object)Arrays.toString(uniqueValues.toArray()));
        return new ArrayList<MetadataOperation>(uniqueValues);
    }

    public static MetadataOperation getMetadataOperation(Object jsonPatchObject) {
        Map<String, Object> jsonPatchMap = JsonUtils.getMap(jsonPatchObject);
        String path = jsonPatchMap.get("path").toString();
        return JsonPatchUtils.getMetadataOperation(path);
    }

    public static String getPath(String path) {
        return Arrays.stream(path.split("/")).filter(part -> !part.isEmpty()).findFirst().orElse(path);
    }

    public static MetadataOperation getMetadataOperation(String path) {
        String[] paths;
        String[] stringArray;
        if (path.contains("/")) {
            stringArray = path.split("/");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = path;
        }
        for (String p : paths = stringArray) {
            if (!ResourceRegistry.hasEditOperation(p)) continue;
            return ResourceRegistry.getEditOperation(p);
        }
        LOG.warn("Failed to find specific operation for patch path {}", (Object)path);
        return MetadataOperation.EDIT_ALL;
    }
}

