/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.util.Objects;
import java.util.Set;
import org.openmetadata.schema.api.configuration.pipelineServiceClient.PipelineServiceClientConfiguration;
import org.openmetadata.schema.auth.JWTAuthMechanism;
import org.openmetadata.schema.auth.SSOAuthMechanism;
import org.openmetadata.schema.entity.Bot;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineType;
import org.openmetadata.schema.entity.teams.AuthenticationMechanism;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.security.client.OpenMetadataJWTClientConfig;
import org.openmetadata.schema.security.secrets.SecretsManagerClientLoader;
import org.openmetadata.schema.security.secrets.SecretsManagerProvider;
import org.openmetadata.schema.security.ssl.ValidateSSLClientConfig;
import org.openmetadata.schema.security.ssl.VerifySSL;
import org.openmetadata.schema.services.connections.metadata.AuthProvider;
import org.openmetadata.schema.services.connections.metadata.OpenMetadataConnection;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.BotRepository;
import org.openmetadata.service.jdbi3.IngestionPipelineRepository;
import org.openmetadata.service.jdbi3.UserRepository;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.secrets.SecretsManagerFactory;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenMetadataConnectionBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(OpenMetadataConnectionBuilder.class);
    AuthProvider authProvider;
    OpenMetadataJWTClientConfig securityConfig;
    private VerifySSL verifySSL;
    private String openMetadataURL;
    private String clusterName;
    private SecretsManagerProvider secretsManagerProvider;
    private SecretsManagerClientLoader secretsManagerLoader;
    private Object openMetadataSSLConfig;
    BotRepository botRepository;
    UserRepository userRepository;
    SecretsManager secretsManager;

    public OpenMetadataConnectionBuilder(OpenMetadataApplicationConfig openMetadataApplicationConfig) {
        this.initializeOpenMetadataConnectionBuilder(openMetadataApplicationConfig);
        this.initializeBotUser("ingestion-bot");
    }

    public OpenMetadataConnectionBuilder(OpenMetadataApplicationConfig openMetadataApplicationConfig, String botName) {
        this.initializeOpenMetadataConnectionBuilder(openMetadataApplicationConfig);
        this.initializeBotUser(botName);
    }

    public OpenMetadataConnectionBuilder(OpenMetadataApplicationConfig openMetadataApplicationConfig, IngestionPipeline ingestionPipeline) {
        this.initializeOpenMetadataConnectionBuilder(openMetadataApplicationConfig);
        try {
            this.initializeBotUser(this.getBotFromPipeline(ingestionPipeline));
        }
        catch (Exception e) {
            LOG.warn(String.format("Could not initialize bot for pipeline [%s] due to [%s]", ingestionPipeline.getPipelineType(), e));
            this.initializeBotUser("ingestion-bot");
        }
    }

    private String getBotFromPipeline(IngestionPipeline ingestionPipeline) {
        return switch (ingestionPipeline.getPipelineType()) {
            case PipelineType.METADATA, PipelineType.DBT -> "ingestion-bot";
            case PipelineType.APPLICATION -> {
                String type = IngestionPipelineRepository.getPipelineWorkflowType(ingestionPipeline);
                yield String.format("%sApplicationBot", type);
            }
            case PipelineType.DATA_INSIGHT -> "DataInsightsApplicationBot";
            default -> String.format("%s-bot", ingestionPipeline.getPipelineType().toString().toLowerCase());
        };
    }

    private void initializeOpenMetadataConnectionBuilder(OpenMetadataApplicationConfig openMetadataApplicationConfig) {
        this.botRepository = (BotRepository)Entity.getEntityRepository("bot");
        this.userRepository = (UserRepository)Entity.getEntityRepository("user");
        PipelineServiceClientConfiguration pipelineServiceClientConfiguration = openMetadataApplicationConfig.getPipelineServiceClientConfiguration();
        this.openMetadataURL = pipelineServiceClientConfiguration.getMetadataApiEndpoint();
        this.verifySSL = pipelineServiceClientConfiguration.getVerifySSL();
        this.openMetadataSSLConfig = this.getOMSSLConfigFromPipelineServiceClient(pipelineServiceClientConfiguration.getVerifySSL(), pipelineServiceClientConfiguration.getSslConfig());
        this.clusterName = openMetadataApplicationConfig.getClusterName();
        this.secretsManagerLoader = pipelineServiceClientConfiguration.getSecretsManagerLoader();
        this.secretsManager = SecretsManagerFactory.getSecretsManager();
        this.secretsManagerProvider = this.secretsManager.getSecretsManagerProvider();
    }

    private void initializeBotUser(String botName) {
        User botUser = this.retrieveBotUser(botName);
        this.securityConfig = this.extractSecurityConfig(botUser);
        this.authProvider = this.extractAuthProvider(botUser);
    }

    private AuthProvider extractAuthProvider(User botUser) {
        AuthenticationMechanism.AuthType authType = botUser.getAuthenticationMechanism().getAuthType();
        return switch (authType) {
            case AuthenticationMechanism.AuthType.SSO -> AuthProvider.fromValue((String)JsonUtils.convertValue(botUser.getAuthenticationMechanism().getConfig(), SSOAuthMechanism.class).getSsoServiceType().value());
            case AuthenticationMechanism.AuthType.JWT -> AuthProvider.OPENMETADATA;
            default -> throw new IllegalArgumentException(String.format("Not supported authentication mechanism type: [%s]", authType.value()));
        };
    }

    private OpenMetadataJWTClientConfig extractSecurityConfig(User botUser) {
        AuthenticationMechanism authMechanism = botUser.getAuthenticationMechanism();
        if (Objects.requireNonNull(botUser.getAuthenticationMechanism().getAuthType()) == AuthenticationMechanism.AuthType.JWT) {
            JWTAuthMechanism jwtAuthMechanism = JsonUtils.convertValue(authMechanism.getConfig(), JWTAuthMechanism.class);
            this.secretsManager.decryptJWTAuthMechanism(jwtAuthMechanism);
            return new OpenMetadataJWTClientConfig().withJwtToken(jwtAuthMechanism.getJWTToken());
        }
        throw new IllegalArgumentException(String.format("Not supported authentication mechanism type: [%s]", authMechanism.getAuthType().value()));
    }

    public OpenMetadataConnection build() {
        return new OpenMetadataConnection().withAuthProvider(this.authProvider).withHostPort(this.openMetadataURL).withSecurityConfig(this.securityConfig).withVerifySSL(this.verifySSL).withClusterName(this.clusterName).withSecretsManagerProvider(this.secretsManagerProvider).withSecretsManagerLoader(this.secretsManagerLoader).withSslConfig(this.openMetadataSSLConfig);
    }

    private User retrieveBotUser(String botName) {
        User botUser = this.retrieveIngestionBotUser(botName);
        if (botUser == null) {
            throw new IllegalArgumentException("Please, verify that the ingestion-bot is present.");
        }
        return botUser;
    }

    private User retrieveIngestionBotUser(String botName) {
        try {
            Bot bot = (Bot)this.botRepository.getByName(null, botName, EntityUtil.Fields.EMPTY_FIELDS);
            if (bot.getBotUser() == null) {
                return null;
            }
            User user = this.userRepository.getByName(null, bot.getBotUser().getFullyQualifiedName(), new EntityUtil.Fields(Set.of("authenticationMechanism")));
            if (user.getAuthenticationMechanism() != null) {
                user.getAuthenticationMechanism().setConfig(user.getAuthenticationMechanism().getConfig());
            }
            return user;
        }
        catch (EntityNotFoundException ex) {
            LOG.debug(String.format("User for bot [%s]", botName) + " [{}] not found.", (Object)botName);
            return null;
        }
    }

    protected Object getOMSSLConfigFromPipelineServiceClient(VerifySSL verifySSL, Object sslConfig) {
        return switch (verifySSL) {
            default -> throw new IncompatibleClassChangeError();
            case VerifySSL.NO_SSL, VerifySSL.IGNORE -> null;
            case VerifySSL.VALIDATE -> JsonUtils.convertValue(sslConfig, ValidateSSLClientConfig.class);
        };
    }
}

