/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.workflows.searchIndex;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.glassfish.jersey.internal.util.ExceptionUtils;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.system.IndexingError;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.SearchIndexException;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.openmetadata.service.workflows.interfaces.Source;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaginatedEntitiesSource
implements Source<ResultList<? extends EntityInterface>> {
    private static final Logger LOG = LoggerFactory.getLogger(PaginatedEntitiesSource.class);
    private String name = "PaginatedEntitiesSource";
    private final int batchSize;
    private final String entityType;
    private final List<String> fields;
    private final List<String> readerErrors = new ArrayList<String>();
    private final StepStats stats = new StepStats();
    private ListFilter filter;
    private String lastFailedCursor = null;
    private String cursor = RestUtil.encodeCursor("0");
    private boolean isDone = false;

    public PaginatedEntitiesSource(String entityType, int batchSize, List<String> fields) {
        this.entityType = entityType;
        this.batchSize = batchSize;
        this.fields = fields;
        this.filter = new ListFilter(Include.ALL);
        this.stats.withTotalRecords(Integer.valueOf(Entity.getEntityRepository(entityType).getDao().listTotalCount())).withSuccessRecords(Integer.valueOf(0)).withFailedRecords(Integer.valueOf(0));
    }

    public PaginatedEntitiesSource(String entityType, int batchSize, List<String> fields, ListFilter filter) {
        this.entityType = entityType;
        this.batchSize = batchSize;
        this.fields = fields;
        this.filter = filter;
        this.stats.withTotalRecords(Integer.valueOf(Entity.getEntityRepository(entityType).getDao().listCount(filter))).withSuccessRecords(Integer.valueOf(0)).withFailedRecords(Integer.valueOf(0));
    }

    public PaginatedEntitiesSource withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ResultList<? extends EntityInterface> readNext(Map<String, Object> contextData) throws SearchIndexException {
        ResultList<? extends EntityInterface> data = null;
        if (!this.isDone) {
            data = this.read(this.cursor);
            this.cursor = data.getPaging().getAfter();
            if (this.cursor == null) {
                this.isDone = true;
            }
        }
        return data;
    }

    private ResultList<? extends EntityInterface> read(String cursor) throws SearchIndexException {
        ResultList<? extends EntityInterface> result;
        LOG.debug("[PaginatedEntitiesSource] Fetching a Batch of Size: {} ", (Object)this.batchSize);
        EntityRepository<? extends EntityInterface> entityRepository = Entity.getEntityRepository(this.entityType);
        try {
            result = entityRepository.listAfterWithSkipFailure(null, Entity.getFields(this.entityType, this.fields), this.filter, this.batchSize, cursor);
            if (!result.getErrors().isEmpty()) {
                this.lastFailedCursor = this.cursor;
                if (result.getPaging().getAfter() == null) {
                    this.isDone = true;
                } else {
                    this.cursor = result.getPaging().getAfter();
                }
                return result;
            }
            LOG.debug("[PaginatedEntitiesSource] Batch Stats :- %n Submitted : {} Success: {} Failed: {}", new Object[]{this.batchSize, result.getData().size(), result.getErrors().size()});
        }
        catch (Exception e) {
            int submittedRecords;
            this.lastFailedCursor = this.cursor;
            int remainingRecords = this.stats.getTotalRecords() - this.stats.getFailedRecords() - this.stats.getSuccessRecords();
            if (remainingRecords - this.batchSize <= 0) {
                submittedRecords = remainingRecords;
                this.updateStats(0, remainingRecords);
                this.cursor = null;
                this.isDone = true;
            } else {
                submittedRecords = this.batchSize;
                String decodedCursor = RestUtil.decodeCursor(cursor);
                this.cursor = RestUtil.encodeCursor(String.valueOf(Integer.parseInt(decodedCursor) + this.batchSize));
                this.updateStats(0, this.batchSize);
            }
            IndexingError indexingError = new IndexingError().withErrorSource(IndexingError.ErrorSource.READER).withSubmittedCount(Integer.valueOf(submittedRecords)).withSuccessCount(Integer.valueOf(0)).withFailedCount(Integer.valueOf(submittedRecords)).withMessage("Issues in Reading A Batch For Entities. No Relationship Issue , Json Processing or DB issue.").withLastFailedCursor(this.lastFailedCursor).withStackTrace(ExceptionUtils.exceptionStackTraceAsString((Throwable)e));
            LOG.debug(indexingError.getMessage());
            throw new SearchIndexException(indexingError);
        }
        return result;
    }

    @Override
    public void reset() {
        this.cursor = null;
        this.isDone = false;
    }

    @Override
    public void updateStats(int currentSuccess, int currentFailed) {
        ReindexingUtil.getUpdatedStats(this.stats, currentSuccess, currentFailed);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public String getEntityType() {
        return this.entityType;
    }

    public List<String> getFields() {
        return this.fields;
    }

    @Override
    public List<String> getReaderErrors() {
        return this.readerErrors;
    }

    @Override
    public StepStats getStats() {
        return this.stats;
    }

    public ListFilter getFilter() {
        return this.filter;
    }

    @Override
    public String getLastFailedCursor() {
        return this.lastFailedCursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }
}

