/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.workflows.searchIndex;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import es.org.elasticsearch.action.bulk.BulkItemResponse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.ws.rs.core.Response;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityTimeSeriesInterface;
import org.openmetadata.schema.system.EntityError;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.Entity;
import org.openmetadata.service.apps.bundles.searchIndex.SearchIndexApp;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.EntityTimeSeriesRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.search.SearchRequest;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import os.org.opensearch.action.bulk.BulkResponse;

public class ReindexingUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ReindexingUtil.class);
    public static final String ENTITY_TYPE_KEY = "entityType";
    public static final String ENTITY_NAME_LIST_KEY = "entityNameList";
    public static final String TIMESTAMP_KEY = "@timestamp";

    private ReindexingUtil() {
    }

    public static void getUpdatedStats(StepStats stats, int currentSuccess, int currentFailed) {
        stats.setSuccessRecords(Integer.valueOf(stats.getSuccessRecords() + currentSuccess));
        stats.setFailedRecords(Integer.valueOf(stats.getFailedRecords() + currentFailed));
    }

    public static boolean isDataInsightIndex(String entityType) {
        return Entity.getSearchRepository().getDataInsightReports().contains(entityType);
    }

    public static int getTotalRequestToProcess(Set<String> entities, CollectionDAO dao) {
        int total = 0;
        for (String entityType : entities) {
            try {
                EntityTimeSeriesRepository<? extends EntityTimeSeriesInterface> repository;
                if (!SearchIndexApp.TIME_SERIES_ENTITIES.contains(entityType)) {
                    repository = Entity.getEntityRepository(entityType);
                    total += ((EntityRepository)((Object)repository)).getDao().listTotalCount();
                    continue;
                }
                ListFilter listFilter = new ListFilter(null);
                if (ReindexingUtil.isDataInsightIndex(entityType)) {
                    listFilter.addQueryParam("entityFQNHash", entityType);
                    repository = Entity.getEntityTimeSeriesRepository("entityReportData");
                } else {
                    repository = Entity.getEntityTimeSeriesRepository(entityType);
                }
                total += repository.getTimeSeriesDao().listCount(listFilter);
            }
            catch (Exception e) {
                LOG.debug("Error while getting total entities to index", (Throwable)e);
            }
        }
        return total;
    }

    public static int getSuccessFromBulkResponse(BulkResponse response) {
        int success = 0;
        for (os.org.opensearch.action.bulk.BulkItemResponse bulkItemResponse : response) {
            if (bulkItemResponse.isFailed()) continue;
            ++success;
        }
        return success;
    }

    public static List<EntityError> getErrorsFromBulkResponse(BulkResponse response) {
        ArrayList<EntityError> entityErrors = new ArrayList<EntityError>();
        for (os.org.opensearch.action.bulk.BulkItemResponse bulkItemResponse : response) {
            if (!bulkItemResponse.isFailed()) continue;
            entityErrors.add(new EntityError().withMessage(bulkItemResponse.getFailureMessage()).withEntity((Object)bulkItemResponse.getItemId()));
        }
        return entityErrors;
    }

    public static List<EntityError> getErrorsFromBulkResponse(es.org.elasticsearch.action.bulk.BulkResponse response) {
        ArrayList<EntityError> entityErrors = new ArrayList<EntityError>();
        for (BulkItemResponse bulkItemResponse : response) {
            if (!bulkItemResponse.isFailed()) continue;
            entityErrors.add(new EntityError().withMessage(bulkItemResponse.getFailureMessage()).withEntity((Object)bulkItemResponse.getItemId()));
        }
        return entityErrors;
    }

    public static int getSuccessFromBulkResponseEs(es.org.elasticsearch.action.bulk.BulkResponse response) {
        int success = 0;
        for (BulkItemResponse bulkItemResponse : response) {
            if (bulkItemResponse.isFailed()) continue;
            ++success;
        }
        return success;
    }

    public static List<EntityReference> findReferenceInElasticSearchAcrossAllIndexes(String matchingKey, String sourceFqn, int from) {
        String key = "_source";
        SearchRequest searchRequest = new SearchRequest.ElasticSearchRequestBuilder(String.format("(%s:\"%s\")", matchingKey, sourceFqn), 100, Entity.getSearchRepository().getIndexOrAliasName("all")).from(from).fetchSource(true).trackTotalHits(false).sortFieldParam("_score").deleted(false).sortOrder("desc").includeSourceFields(new ArrayList<String>()).build();
        ArrayList<EntityReference> entities = new ArrayList<EntityReference>();
        Response response = Entity.getSearchRepository().search(searchRequest);
        String json = (String)response.getEntity();
        Iterator it = ((ArrayNode)JsonUtils.extractValue(json, "hits", "hits")).elements();
        while (it.hasNext()) {
            JsonNode jsonNode = (JsonNode)it.next();
            String id = (String)JsonUtils.extractValue(jsonNode, key, "id");
            String fqn = (String)JsonUtils.extractValue(jsonNode, key, "fullyQualifiedName");
            String type = (String)JsonUtils.extractValue(jsonNode, key, ENTITY_TYPE_KEY);
            if (CommonUtil.nullOrEmpty((String)fqn) || CommonUtil.nullOrEmpty((String)type)) continue;
            entities.add(new EntityReference().withId(UUID.fromString(id)).withFullyQualifiedName(fqn).withType(type));
        }
        return entities;
    }

    public static String escapeDoubleQuotes(String str) {
        return str.replace("\"", "\\\"");
    }
}

