/*
CalDavZAP - the open source CalDAV Web Client
Copyright (C) 2011-2015
    Jan Mate <jan.mate@inf-it.com>
    Andrej Lezo <andrej.lezo@inf-it.com>
    Matej Mihalik <matej.mihalik@inf-it.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as
published by the Free Software Foundation, either version 3 of the
License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// NOTE: console.log(...) messages are not translated
var localization = new Object();

localization['cs_CZ']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	txtResources: 'Prostředky',
	txtNote: 'Poznámky',

	errUnableSync: 'Chyba: \'nepodařilo se synchronizovat prostředek\': zkuste to později!',

	loadingResources: 'Načítání prostředků (%act% z %total%) ...',
	loadingCollectionList: 'Načítání zoznamu prostředků',

	txtCacheText: 'Na serveru byla nalezena aktualizace, prosím znovu načtěte stránku!',
	txtCacheButton: 'Znovu načíst'
};

localization['da_DK']=	/* thanks Niels Bo Andersen and Michael Rasmussen */
{
	txtResources: 'Ressourcer',
	txtNote: 'Note',

	errUnableSync: 'Fejl: \'kunne ikke synkronisere ressource\': prøv igen senere!',

	loadingResources: 'Henter ressourcer (%act% af %total%) ...',
	loadingCollectionList: 'Indlæser ressource listen',

	txtCacheText: 'En opdatering er klar på serveren, genindlæs derfor siden!',
	txtCacheButton: 'Genindlæs'
};

localization['de_DE']=	/* thanks Marten Gajda and Thomas Scheel */
{
	txtResources: 'Ressourcen',
	txtNote: 'Notiz',

	errUnableSync: 'Fehler: \'Ressource konnte nicht syncronisiert werden\': Versuchen Sie es später noch einmal!',

	loadingResources: 'Lade Ressourcen (%act% von %total%) ...',
	loadingCollectionList: 'Lade Ressourcenliste',

	txtCacheText: 'Auf dem Server ist ein Update verfügbar. Bitte laden Sie die Seite neu!',
	txtCacheButton: 'Seite neu laden'
};

localization['en_US']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	txtResources: 'Resources',
	txtNote: 'Note',

	errUnableSync: 'Error: \'unable to sync resource\': try again later!',

	loadingResources: 'Loading resources (%act% of %total%) ...',
	loadingCollectionList: 'Loading resource list',

	txtCacheText: 'There is an update available on the server, please reload the page!',
	txtCacheButton: 'Reload'
};

localization['es_ES']=	/* Damian Vila <damianvila@gmail.com> */
{
	txtResources: 'Recursos',
	txtNote: 'Nota',

	errUnableSync: 'Error: \'imposible sincronizar con el recurso\': inténtelo más tarde!',

	loadingResources: 'Cargando recursos (%act% de %total%) ...',
	loadingCollectionList: 'Cargando la lista de recursos',

	txtCacheText: 'Hay una actualización disponible en el servidor, por favor, recarga la página!',
	txtCacheButton: 'Recargar'
};

localization['fr_FR']=	/* thanks John Fischer and Jean-Christophe Bach */
{
	txtResources: 'Ressources',
	txtNote: 'Note',

	errUnableSync: 'Erreur : \'impossible de synchroniser la ressource\' : réessayez plus tard !',

	loadingResources: 'Chargement des ressources (%act% sur %total%)...',
	loadingCollectionList: 'Chargement de la liste des ressources',

	txtCacheText: 'Il y a une mise à jour disponible sur le serveur, veuillez recharger la page s\'il vous plaît !',
	txtCacheButton: 'Recharger'
};

localization['hu_HU']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	txtResources: 'Források',
	txtNote: 'Jegyzetek',

	errUnableSync: 'Hiba: \'nem sikerült a forrás szinkronizálása\': próbálkozzon később!',

	loadingResources: 'Források betöltése (%act%/%total%) ...',
	loadingCollectionList: 'Forrás lista betöltése',

	txtCacheText: 'Frissítés elérhető a szerveren, kérjük töltse be újra az oldalt!',
	txtCacheButton: 'Újratöltés'
};

localization['it_IT']=	/* thanks Luca Ferrario */
{
	txtResources: 'Risorse',
	txtNote: 'Note',

	errUnableSync: 'Errore: \'impossibile sincronizzare la risorsa\': riprovare!',

	loadingResources: 'Caricamento risorse (%act% di %total%) ...',
	loadingCollectionList: 'Caricamento della lista delle risorse',

	txtCacheText: 'La voce è stata aggiornata sul server, per favore ricarica la pagina!',
	txtCacheButton: 'Reload'
};

localization['ja_JP']=	/* Muimu Nakayama */
{
	txtResources: 'リソース',
	txtNote: 'メモ',

	errUnableSync: 'エラー: \'リソースと同期できません\': 後で再度試してみてください!',

	loadingResources: 'リソースを読み込み中 (%total% 個中 %act% 個) ...',
	loadingCollectionList: 'リソースリストを読み込み中',

	txtCacheText: 'サーバ上で更新があります。ページを再読み込みしてください!',
	txtCacheButton: '再読み込み'
};

localization['nl_NL']=	/* thanks Johan Vromans */
{
	txtResources: 'Bronnen',
	txtNote: 'Opmerking',

	errUnableSync: 'Fout: Synchronisatie mislukt, probeer later nog eens!',

	loadingResources: 'Laden (%act% van %total%) ...',
	loadingCollectionList: 'Laden (Bronnenlijst) ...',

	txtCacheText: 'Er zijn updates beschikbaar op de server. Gelieve deze pagina te verversen.',
	txtCacheButton: 'Verversen'
};

localization['sk_SK']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	txtResources: 'Prostriedky',
	txtNote: 'Poznámky',

	errUnableSync: 'Chyba: \'nepodarilo sa synchronizovať prostriedok\': skúste to neskôr!',

	loadingResources: 'Načítavanie prostriedkov (%act% z %total%) ...',
	loadingCollectionList: 'Načítavanie prostriedkov',

	txtCacheText: 'Na servery bola nájdená aktualizácia, prosím znova načítajte stránku!',
	txtCacheButton: 'Znovu načítať'
};

localization['tr_TR']=	/* thanks Selcuk Pultar */
{
	txtResources: 'Kaynaklar',
	txtNote: 'Not',

	errUnableSync: 'Hata: \'kaynak eşlenememiştir\': sonra yeniden deneyin!',

	loadingResources: 'Kaynaklar yükleniyor (%total% taneden %act%) ...',
	loadingCollectionList: 'Kaynak listesi yükleniyor',

	txtCacheText: 'Sunucuda bir güncelleme mevcut, lütfen sayfayı yeniden yükleyin!',
	txtCacheButton: 'Yeniden yükle'
};

localization['ru_RU']=	/* thanks Александр Симонов */
{
	txtResources: 'Ресурсы',
	txtNote: 'Примечание',

	errUnableSync: 'Ошибка: \'невозможно синхронизировать ресурс\': попробуйте позже!',

	loadingResources: 'Загрузка ресурсов (%act% из %total%)...',
	loadingCollectionList: 'Загрузка списка ресурсов',

	txtCacheText: 'На сервере доступно обновление. Перезагрузите страницу!',
	txtCacheButton: 'Перезагрузить'
};

localization['uk_UA']=	/* Serge Yakimchuck <yakim@yakim.org.ua> */
{
	txtResources: 'Ресурси',
	txtNote: 'Примітки',

	errUnableSync: 'Помилка: \'неможливо синхронізувати ресурс\': спробуйте пізніше!',

	loadingResources: 'завантаження ресурсів (%act% з %total%) ...',
	loadingCollectionList: 'Завантаження списку ресурсів',

	txtCacheText: 'на сервері доступне оновлення, перезавантажте, будь ласка, сторінку!',
	txtCacheButton: 'Перезавантаження'
};

localization['zh_CN']=	/* thanks Fandy */
{
	txtResources: '资源',
	txtNote: '备注',

	errUnableSync: '错误: \'不能同步信息\': 请稍后重试!',

	loadingResources: '加载中，请稍等 (%act% of %total%) ...',
	loadingCollectionList: '加载中',

	txtCacheText: '服务器有更新, 请重新加载页面!',
	txtCacheButton: '刷新'
};
var localizationShared = new Object();

localizationShared['cs_CZ']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	_name_: 'Čeština',
	_default_datepicker_format_: 'dd.mm.yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Odhlásit',
	buttonLogin: 'Přihlásit',
	pholderUsername: 'Přihlašovací jméno',
	pholderPassword: 'Heslo',
	txtSearch: 'Hledat',
	txtError: 'Chyba',
	txtRefresh: 'Obnovit',

	buttonEdit: 'Editovat',
	buttonSave: 'Uložit',
	buttonReset: 'Reset',
	buttonCancel: 'Storno',
	buttonDelete: 'Vymazat',

	errCollectionLoad: 'Nepodařilo se uložit nastavení!',
	errHttpCommon: 'chybový kód %%',
	errHttp401: 'neautorizovaný',
	errHttp403: 'přístup zamítnut',
	errHttp405: 'nepovolená metoda',
	errHttp408: 'vypršení doby požadavku',
	errHttp412: 'někdo jiný ho právě změnil na serveru',
	errHttp500: 'vnitřní chyba serveru',
	errHttp501: 'neimplementováno',

	unsupportedBrowser: 'Upozornění: Váš prohlížeč je nepodporovaný!',
	updateNotification: '%name% %new_ver% dostupný (používáte %curr_ver%) - %url%'
};

localizationShared['da_DK']=	/* thanks Niels Bo Andersen and Michael Rasmussen */
{
	_name_: 'Dansk',
	_default_datepicker_format_: 'dd-mm-yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Log ud',
	buttonLogin: 'Log ind',
	pholderUsername: 'Brugernavn',
	pholderPassword: 'Kodeord',
	txtSearch: 'Søg',
	txtError: 'Fejl',
	txtRefresh: 'Opdater',

	buttonEdit: 'Rediger',
	buttonSave: 'Gem',
	buttonReset: 'Fortryd',
	buttonCancel: 'Annuller',
	buttonDelete: 'Slet',

	errCollectionLoad: 'Fejl: \'Kunne ikke gemme konfiguration\'!',
	errHttpCommon: 'fejlkode %%',
	errHttp401: 'uautoriseret',
	errHttp403: 'forbudt',
	errHttp405: 'metode ikke tilladt',
	errHttp408: 'forespørgsels-timeout',
	errHttp412: 'emnet er ændret af en anden på serveren',
	errHttp500: 'intern serverfejl',
	errHttp501: 'ikke implementeret',

	unsupportedBrowser: 'Bemærk: Din browser er ikke understøttet!',
	updateNotification: '%name% %new_ver% er frigivet (du har %curr_ver%) - %url%'
};

localizationShared['de_DE']=	/* thanks Marten Gajda and Thomas Scheel */
{
	_name_: 'Deutsch',
	_default_datepicker_format_: 'dd.mm.yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Abmelden',
	buttonLogin: 'Anmelden',
	pholderUsername: 'Benutzername',
	pholderPassword: 'Passwort',
	txtSearch: 'Suchen',
	txtError: 'Fehler',
	txtRefresh: 'Aktualisieren',

	buttonEdit: 'Bearbeiten',
	buttonSave: 'Speichern',
	buttonReset: 'Verwerfen',
	buttonCancel: 'Abbrechen',
	buttonDelete: 'Löschen',

	errCollectionLoad: 'Fehler: \'Einstellungen konnten nicht gespeichert werden\'!',
	errHttpCommon: 'Fehler Code %%',
	errHttp401: 'nicht berechtigt',
	errHttp403: 'verboten',
	errHttp405: 'Befehl nicht erlaubt',
	errHttp408: 'Anfrage-Timeout',
	errHttp412: 'Kontakt wurde zwischenzeitlich auf der Server geändert',
	errHttp500: 'Interner Server Fehler',
	errHttp501: 'Nicht unterstützt',

	unsupportedBrowser: 'Hinweis: Der verwendete Browser wird nicht unterstützt!',
	updateNotification: '%name% %new_ver% verfügbar (Sie haben %curr_ver%) - %url%'
};

localizationShared['en_US']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	_name_: 'English',
	_default_datepicker_format_: 'yy-mm-dd',
	_default_AMPM_format_: true,

	altLogo: 'Logo',
	altLogout: 'Logout',
	buttonLogin: 'Login',
	pholderUsername: 'Username',
	pholderPassword: 'Password',
	txtSearch: 'Search',
	txtError: 'Error',
	txtRefresh: 'Refresh',

	buttonEdit: 'Edit',
	buttonSave: 'Save',
	buttonReset: 'Revert',
	buttonCancel: 'Cancel',
	buttonDelete: 'Delete',

	errCollectionLoad: 'Error: \'unable to save settings\'!',
	errHttpCommon: 'error code %%',
	errHttp401: 'unauthorized',
	errHttp403: 'forbidden',
	errHttp405: 'method not allowed',
	errHttp408: 'request timeout',
	errHttp412: 'somebody else has already changed it on the server',
	errHttp500: 'internal server error',
	errHttp501: 'not implemented',

	unsupportedBrowser: 'Note: your browser is unsupported!',
	updateNotification: '%name% %new_ver% available (you have %curr_ver%) - %url%'
};

localizationShared['es_ES']=	/* Damian Vila <damianvila@gmail.com> */
{
	_name_: 'Español',
	_default_datepicker_format_: 'dd/mm/yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Desconectar',
	buttonLogin: 'Iniciar sesión',
	pholderUsername: 'Usuario',
	pholderPassword: 'Contraseña',
	txtSearch: 'Buscar',
	txtError: 'Error',
	txtRefresh: 'Refrescar',

	buttonEdit: 'Editar',
	buttonSave: 'Guardar',
	buttonReset: 'Revertir',
	buttonCancel: 'Cancelar',
	buttonDelete: 'Borrar',

	errCollectionLoad: 'Error: \'imposible guardar las configuraciones\'!',
	errHttpCommon: 'código de error %%',
	errHttp401: 'no autorizado',
	errHttp403: 'prohibido',
	errHttp405: 'método no permitido',
	errHttp408: 'petición caducada',
	errHttp412: 'alguien lo ha cambiado ya en el servidor',
	errHttp500: 'error interno de servidor',
	errHttp501: 'no implementado',

	unsupportedBrowser: 'Nota: ¡tu navegador no está soportado!',
	updateNotification: '%name% %new_ver% disponible (tu versión es %curr_ver%) - %url%'
};

localizationShared['fr_FR']=	/* thanks John Fischer and Jean-Christophe Bach */
{
	_name_: 'Français',
	_default_datepicker_format_: 'dd/mm/yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Déconnexion',
	buttonLogin: 'Connexion',
	pholderUsername: 'Identifiant',
	pholderPassword: 'Mot de Passe',
	txtSearch: 'Rechercher',
	txtError: 'Erreur',
	txtRefresh: 'Rafraîchir',

	buttonEdit: 'Éditer',
	buttonSave: 'Sauvegarder',
	buttonReset: 'Revenir',
	buttonCancel: 'Annuler',
	buttonDelete: 'Supprimer',

	errCollectionLoad: 'Impossible de sauvegarder les paramètres !',
	errHttpCommon: 'code d\'erreur %%',
	errHttp401: 'non autorisé',
	errHttp403: 'interdit',
	errHttp405: 'méthode non autorisée',
	errHttp408: 'expiration du délai de la requête',
	errHttp412: 'quelqu\'un d\'autre l\'a déjà modifié sur le serveur',
	errHttp500: 'erreur interne du serveur',
	errHttp501: 'non implémenté',

	unsupportedBrowser: 'Note : votre navigateur n\'est pas supporté !',
	updateNotification: '%name% %new_ver% est disponible (vous êtes actuellement en version %curr_ver%) - %url%'
};

localizationShared['hu_HU']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	_name_: 'Magyar',
	_default_datepicker_format_: 'yy.mm.dd',
	_default_AMPM_format_: false,

	altLogo: 'Logó',
	altLogout: 'Kijelentkezés',
	buttonLogin: 'Bejelentkezés',
	pholderUsername: 'Felhasználónév',
	pholderPassword: 'Jelszó',
	txtSearch: 'Keresés',
	txtError: 'Hiba',
	txtRefresh: 'Frissítés',

	buttonEdit: 'Szerkesztés',
	buttonSave: 'Mentés',
	buttonReset: 'Visszaállítás',
	buttonCancel: 'Mégse',
	buttonDelete: 'Törlés',

	errCollectionLoad: 'Hiba: \'nem sikerült elmenteni a beállításokat\'!',
	errHttpCommon: 'hiba kód %%',
	errHttp401: 'nincs hitelesítve',
	errHttp403: 'tiltva',
	errHttp405: 'nem engedélyezett módszer',
	errHttp408: 'kérelem időtúllépése',
	errHttp412: 'valaki más már megváltoztatta a szerveren',
	errHttp500: 'belső szerverhiba',
	errHttp501: 'nincs megvalósítva',

	unsupportedBrowser: 'Figyelmeztetés: A böngészője nem támogatott!',
	updateNotification: '%name% %new_ver% elérhető (jelenlegi verzió: %curr_ver%) - %url%'
};

localizationShared['it_IT']=	/* thanks Luca Ferrario */
{
	_name_: 'Italiano',
	_default_datepicker_format_: 'dd/mm/yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Logout',
	buttonLogin: 'Login',
	pholderUsername: 'Nome Utente',
	pholderPassword: 'Password',
	txtSearch: 'Cerca',
	txtError: 'Errore',
	txtRefresh: 'Aggiorna',

	buttonEdit: 'Modifica',
	buttonSave: 'Salva',
	buttonReset: 'Annulla',
	buttonCancel: 'Annulla',
	buttonDelete: 'Elimina',

	errCollectionLoad: 'Errore: \'impossibile salvare le impostazioni\'!',
	errHttpCommon: 'codice errore %%',
	errHttp401: 'non autorizzato',
	errHttp403: 'proibito',
	errHttp405: 'metodo non consentito',
	errHttp408: 'timeout della richiesta',
	errHttp412: 'qualcun altro l\'ha già modificato sul server',
	errHttp500: 'errore interno del server',
	errHttp501: 'non implementato',

	unsupportedBrowser: 'Attenzione: browser non supportato!',
	updateNotification: '%name% %new_ver% disponibile (versione attuale: %curr_ver%) - %url%'
};

localizationShared['ja_JP']=	/* Muimu Nakayama */
{
	_name_: '日本語',
	_default_datepicker_format_: 'yy-mm-dd',
	_default_AMPM_format_: true,

	altLogo: 'Logo',
	altLogout: 'ログアウト',
	buttonLogin: 'ログイン',
	pholderUsername: 'ユーザ名',
	pholderPassword: 'パスワード',
	txtSearch: '検索',
	txtError: 'エラー',
	txtRefresh: 'リフレッシュ',

	buttonEdit: '編集',
	buttonSave: '保存',
	buttonReset: '戻す',
	buttonCancel: 'キャンセル',
	buttonDelete: '削除',

	errCollectionLoad: 'エラー: \'設定を保存できません\'!',
	errHttpCommon: 'エラーコード %%',
	errHttp401: '認証失敗',
	errHttp403: 'アクセス不可',
	errHttp405: '許可されないメソッド',
	errHttp408: 'タイムアウト',
	errHttp412: 'サーバ上で他の人によりすでに変更済み',
	errHttp500: 'サーバ内部エラー',
	errHttp501: '実装されていません',

	unsupportedBrowser: '注意: あなたのブラウザはサポートされていません!',
	updateNotification: '%name% %new_ver% が利用できます (現在は %curr_ver%) - %url%'
};

localizationShared['nl_NL']=	/* thanks Johan Vromans */
{
	_name_: 'Nederlands',
	_default_datepicker_format_: 'dd-mm-yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Uitloggen',
	buttonLogin: 'Inloggen',
	pholderUsername: 'Gebruikersnaam',
	pholderPassword: 'Wachtwoord',
	txtSearch: 'Zoeken',
	txtError: 'Fout',
	txtRefresh: 'Herladen',

	buttonEdit: 'Wijzigen',
	buttonSave: 'Opslaan',
	buttonReset: 'Herstellen',
	buttonCancel: 'Annuleren',
	buttonDelete: 'Verwijderen',

	errCollectionLoad: 'Fout: Opslaan van de instellingen is niet gelukt!',
	errHttpCommon: 'Foutcode %%',
	errHttp401: 'geen toegang',
	errHttp403: 'verboden',
	errHttp405: 'bewerking niet toegestaan',
	errHttp408: 'verwerking afgebroken wegens timeout',
	errHttp412: 'iemand anders heeft dit reeds gewijzigd op de server',
	errHttp500: 'interne serverfout',
	errHttp501: 'niet geïmplementeerd',

	unsupportedBrowser: 'Attentie: uw browser wordt niet ondersteund!',
	updateNotification: 'Er is een nieuwe versie van %name% beschikbaar: %new_ver% (u heeft nu %curr_ver%) - %url%'
};

localizationShared['sk_SK']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	_name_: 'Slovenčina',
	_default_datepicker_format_: 'dd.mm.yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Odhlásiť',
	buttonLogin: 'Prihlásiť',
	pholderUsername: 'Prihlasovacie meno',
	pholderPassword: 'Heslo',
	txtSearch: 'Vyhľadať',
	txtError: 'Chyba',
	txtRefresh: 'Obnoviť',

	buttonEdit: 'Editovať',
	buttonSave: 'Uložiť',
	buttonReset: 'Reset',
	buttonCancel: 'Storno',
	buttonDelete: 'Vymazať',

	errCollectionLoad: 'Nepodarilo sa uložiť nastavenia!',
	errHttpCommon: 'chybový kód %%',
	errHttp401: 'neautorizovaný',
	errHttp403: 'prístup zamietnutý',
	errHttp405: 'nepovolená metóda',
	errHttp408: 'časový limit vypršal',
	errHttp412: 'niekto iný ho práve zmenil na serveri',
	errHttp500: 'vnútorná chyba servera',
	errHttp501: 'neimplementované',

	unsupportedBrowser: 'Upozornenie: Váš prehliadač je nepodporovaný!',
	updateNotification: '%name% %new_ver% dostupný (používate %curr_ver%) - %url%'
};

localizationShared['tr_TR']=	/* thanks Selcuk Pultar */
{
	_name_: 'Türkçe',
	_default_datepicker_format_: 'dd.mm.yy',
	_default_AMPM_format_: false,

	altLogo: 'Logo',
	altLogout: 'Çıkış',
	buttonLogin: 'Giriş',
	pholderUsername: 'Kullanıcı Adı',
	pholderPassword: 'Parola',
	txtSearch: 'Ara',
	txtError: 'Hata',
	txtRefresh: 'Yenile',

	buttonEdit: 'Düzenle',
	buttonSave: 'Kaydet',
	buttonReset: 'Geri döndür',
	buttonCancel: 'Vazgeç',
	buttonDelete: 'Sil',

	errCollectionLoad: 'Hata: \'ayarlar kaydedilemedi\'!',
	errHttpCommon: 'hata kodu %%',
	errHttp401: 'yetkisiz',
	errHttp403: 'yasak',
	errHttp405: 'metoda izin verilmemiştir',
	errHttp408: 'istek zaman aşımı',
	errHttp412: 'başkası sunucuda zaten değiştirmiş',
	errHttp500: 'dahili sunucu hatası',
	errHttp501: 'henüz uygulamaya geçirilmemiştir',

	unsupportedBrowser: 'Not: tarayıcınız desteklenmemektedir!',
	updateNotification: '%name% %new_ver% hazır (sizde %curr_ver% var) - %url%'
};

localizationShared['ru_RU']=	/* thanks Александр Симонов */
{
	_name_: 'Русский',
	_default_datepicker_format_: 'dd.mm.yy',
	_default_AMPM_format_: false,

	altLogo: 'Лого',
	altLogout: 'Выход',
	buttonLogin: 'Вход',
	pholderUsername: 'Имя',
	pholderPassword: 'Пароль',
	txtSearch: 'Поиск',
	txtError: 'Ошибка',
	txtRefresh: 'Обновить',

	buttonEdit: 'Изменить',
	buttonSave: 'Сохранить',
	buttonReset: 'Отменить',
	buttonCancel: 'Отмена',
	buttonDelete: 'Удалить',

	errCollectionLoad: 'Ошибка: \'невозможно сохранить настройки\'!',
	errHttpCommon: 'код ошибки %%',
	errHttp401: 'не авторизован',
	errHttp403: 'запрещен',
	errHttp405: 'метод не разрешен',
	errHttp408: 'таймаут запроса',
	errHttp412: 'кто-то другой уже произвел изменения на сервере',
	errHttp500: 'внутренняя ошибка сервера',
	errHttp501: 'не реализовано',

	unsupportedBrowser: 'Ваш браузер не поддерживается!',
	updateNotification: '%name% версии %new_ver% доступен (сейчас у вас версия %curr_ver%) - %url%'
};

localizationShared['uk_UA']=	/* Serge Yakimchuck <yakim@yakim.org.ua> */
{
	_name_: 'Українська',
	_default_datepicker_format_: 'dd.mm.yy',
	_default_AMPM_format_: false,

	altLogo: 'Лого',
	altLogout: 'Вийти',
	buttonLogin: 'Увійти',
	pholderUsername: 'Користувач',
	pholderPassword: 'Пароль',
	txtSearch: 'Пошук',
	txtError: 'Помилка',
	txtRefresh: 'Оновити',

	buttonEdit: 'Правити',
	buttonSave: 'Зберегти',
	buttonReset: 'Скасувати',
	buttonCancel: 'Скасувати',
	buttonDelete: 'Видалити',

	errCollectionLoad: 'Помилка: \'неможливо зберегти настройки\'!',
	errHttpCommon: 'код помилки %%',
	errHttp401: 'не авторизовано',
	errHttp403: 'заборонено',
	errHttp405: 'метод не дозволений',
	errHttp408: 'перевищено час запиту',
	errHttp412: 'хтось ще якраз це змінює на сервері',
	errHttp500: 'внутрішня помилка сервера',
	errHttp501: 'не реалізовано',

	unsupportedBrowser: 'Увага: Ваш браузер не підтримується!',
	updateNotification: '%name% %new_ver% доступна (у вас %curr_ver%) - %url%'
};

localizationShared['zh_CN']=	/* thanks Fandy */
{
	_name_: '中国',
	_default_datepicker_format_: 'yy-mm-dd',
	_default_AMPM_format_: false,

	altLogo: '图标',
	altLogout: '退出',
	buttonLogin: '登录',
	pholderUsername: '用户名',
	pholderPassword: '密码',
	txtSearch: '检索',
	txtError: '错误',
	txtRefresh: '刷新',

	buttonEdit: '编辑',
	buttonSave: '保存',
	buttonReset: '恢复',
	buttonCancel: '取消',
	buttonDelete: '删除',

	errCollectionLoad: '错误: \'不能保持设置\'!',
	errHttpCommon: '错误代码 %%',
	errHttp401: '未认证的',
	errHttp403: '禁止',
	errHttp405: '方法不被允许',
	errHttp408: '请求超时',
	errHttp412: '服务器已更新',
	errHttp500: '内部服务器错误',
	errHttp501: '未实施',

	unsupportedBrowser: '注意：您的浏览器不支持！',
	updateNotification: '%name% %new_ver% 最新版本 (你的系统当前版本 %curr_ver%) - %url%'
};

$.extend(true, localization, localizationShared);
var localizationSharedCalDAV = new Object();

localizationSharedCalDAV['cs_CZ']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	txtCalendars: 'Kalendáře',
	txtTodos: 'Připomínky',
	localTime: 'Lokální čas',
	fullCalendarMonth: 'měsíc',
	fullCalendarMultiWeek: 'mtýden',
	fullCalendarAgendaWeek: 'týden',
	fullCalendarAgendaDay: 'den',

	monthNames: ['Leden','Únor','Březen','Duben','Květen','Červen',
	'Červenec','Srpen','Září','Říjen','Listopad','Prosinec'],
	monthNamesShort: ['Led','Úno','Bře','Dub','Kvě','Čer',
	'Čvc','Srp','Zář','Říj','Lis','Pro'],
	dayNames: ['Neděle', 'Pondělí', 'Úterý', 'Středa', 'Čtvrtek', 'Pátek', 'Sobota'],
	dayNamesShort: ['Ne', 'Po', 'Út', 'St', 'Čt', 'Pá', 'So'],
	dayNamesMin: ['Ne','Po','Út','St','Čt','Pá','So']
};

localizationSharedCalDAV['da_DK']=	/* thanks Niels Bo Andersen and Michael Rasmussen */
{
	txtCalendars: 'Kalendere',
	txtTodos: 'Opgaver',
	localTime: 'Lokal tid',
	fullCalendarMonth: 'måned',
	fullCalendarMultiWeek: 'uger',
	fullCalendarAgendaWeek: 'uge',
	fullCalendarAgendaDay: 'dag',

	monthNames: ['Januar','Februar','Marts','April','Maj','Juni',
	'Juli','August','September','Oktober','November','December'],
	monthNamesShort: ['Jan', 'Feb', 'Mar', 'Apr', 'Maj', 'Jun',
	'Jul', 'Aug', 'Sep', 'Okt', 'Nov', 'Dec'],
	dayNames: ['Søndag', 'Mandag', 'Tirsdag', 'Onsdag', 'Torsdag', 'Fredag', 'Lørdag'],
	dayNamesShort: ['Søn', 'Man', 'Tir', 'Ons', 'Tor', 'Fre', 'Lør'],
	dayNamesMin: ['Sø','Ma','Ti','On','To','Fr','Lø']
};

localizationSharedCalDAV['de_DE']=	/* thanks Marten Gajda and Thomas Scheel */
{
	txtCalendars: 'Kalender',
	txtTodos: 'Aufgaben',
	localTime: 'Lokale Zeit',
	fullCalendarMonth: 'Monat',
	fullCalendarMultiWeek: 'Wochen',
	fullCalendarAgendaWeek: 'Woche',
	fullCalendarAgendaDay: 'Tag',

	monthNames: ['Januar','Februar','März','April','Mai','Juni',
	'Juli','August','September','Oktober','November','Dezember'],
	monthNamesShort: ['Jan','Feb','Mär','Apr','Mai','Jun',
	'Jul','Aug','Sep','Okt','Nov','Dez'],
	dayNames: ['Sonntag','Montag','Dienstag','Mittwoch','Donnerstag','Freitag','Samstag'],
	dayNamesShort: ['So','Mo','Di','Mi','Do','Fr','Sa'],
	dayNamesMin: ['So','Mo','Di','Mi','Do','Fr','Sa']
};

localizationSharedCalDAV['en_US']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	txtCalendars: 'Calendars',
	txtTodos: 'Todos',
	localTime: 'Local Time',
	fullCalendarMonth: 'month',
	fullCalendarMultiWeek: 'mweek',
	fullCalendarAgendaWeek: 'week',
	fullCalendarAgendaDay: 'day',

	monthNames: ['January','February','March','April','May','June',
	'July','August','September','October','November','December'],
	monthNamesShort: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
	'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
	dayNames: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'],
	dayNamesShort: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
	dayNamesMin: ['Su','Mo','Tu','We','Th','Fr','Sa']
};

localizationSharedCalDAV['es_ES']=	/* Damian Vila <damianvila@gmail.com> */
{
	txtCalendars: 'Calendarios',
	txtTodos: 'Tareas',
	localTime: 'Tiempo local',
	fullCalendarMonth: 'mes',
	fullCalendarMultiWeek: 'msemana',
	fullCalendarAgendaWeek: 'semana',
	fullCalendarAgendaDay: 'día',

	monthNames: ['Enero','Febrero','Marzo','Abril','Mayo','Junio',
	'Julio','Agosto','Septiembre','Octubre','Noviembre','Deciembre'],
	monthNamesShort: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun',
	'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
	dayNames: ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
	dayNamesShort: ['Dom', 'Lun', 'Mar', 'Mie', 'Jue', 'Vie', 'Sáb'],
	dayNamesMin: ['D','L','M','X','J','V','S']
};

localizationSharedCalDAV['fr_FR']=	/* thanks John Fischer and Jean-Christophe Bach */
{
	txtCalendars: 'Calendriers',
	txtTodos: 'Tâches',
	localTime: 'Heure locale',
	fullCalendarMonth: 'mois',
	fullCalendarMultiWeek: 'multisem.',
	fullCalendarAgendaWeek: 'semaine',
	fullCalendarAgendaDay: 'jour',

	monthNames: ['janvier','février','mars','avril','mai','juin',
	'juillet','août','septembre','octobre','novembre','décembre'],
	monthNamesShort: ['jan', 'fév', 'mar', 'avr', 'mai', 'jun',
	'jul', 'aoû', 'sep', 'oct', 'nov', 'déc'],
	dayNames: ['dimanche', 'lundi', 'mardi', 'mercredi', 'jeudi', 'vendredi', 'samedi'],
	dayNamesShort: ['dim', 'lun', 'mar', 'mer', 'jeu', 'ven', 'sam'],
	dayNamesMin: ['di','lu','ma','me','je','ve','sa']
};

localizationSharedCalDAV['hu_HU']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	txtCalendars: 'Naptárak',
	txtTodos: 'Feladatok',
	localTime: 'Helyi idő',
	fullCalendarMonth: 'hónap',
	fullCalendarMultiWeek: 'több hét',
	fullCalendarAgendaWeek: 'hét',
	fullCalendarAgendaDay: 'nap',

	monthNames: ['Január', 'Február', 'Március', 'Április', 'Május', 'Június',
	'Július', 'Augusztus', 'Szeptember', 'Október', 'November', 'December'],
	monthNamesShort: ['Jan', 'Feb', 'Már', 'Ápr', 'Máj', 'Jún',
	'Júl', 'Aug', 'Szep', 'Okt', 'Nov', 'Dec'],
	dayNames: ['Vasárnap', 'Hétfő', 'Kedd', 'Szerda', 'Csütörtök', 'Péntek', 'Szombat'],
	dayNamesShort: ['Vas', 'Hét', 'Ked', 'Sze', 'Csü', 'Pén', 'Szo'],
	dayNamesMin: ['V', 'H', 'K', 'Sze', 'Cs', 'P', 'Szo']
};

localizationSharedCalDAV['it_IT']=	/* thanks Luca Ferrario */
{
	txtCalendars: 'Calendari',
	txtTodos: 'Attività',
	localTime: 'Ora Locale',
	fullCalendarMonth: 'mese',
	fullCalendarMultiWeek: 'msett.',
	fullCalendarAgendaWeek: 'sett.',
	fullCalendarAgendaDay: 'giorno',

	monthNames: ['Gennaio','Febbraio','Marzo','Aprile','Maggio','Giugno',
	'Luglio','Agosto','Settembre','Ottobre','Novembre','Dicembre'],
	monthNamesShort: ['Gen', 'Feb', 'Mar', 'Apr', 'Mag', 'Giu',
	'Lug', 'Ago', 'Set', 'Ott', 'Nov', 'Dic'],
	dayNames: ['Domenica', 'Lunedì', 'Martedì', 'Mercoledì', 'Giovedì', 'Venerdì', 'Sabato'],
	dayNamesShort: ['Dom', 'Lun', 'Mar', 'Mer', 'Gio', 'Ven', 'Sab'],
	dayNamesMin: ['Do','Lu','Ma','Me','Gi','Ve','Sa']
};

localizationSharedCalDAV['ja_JP']=	/* Muimu Nakayama */
{
	txtCalendars: 'カレンダー',
	txtTodos: 'ToDo',
	localTime: 'ローカルタイム',
	fullCalendarMonth: '月',
	fullCalendarMultiWeek: '複数週',
	fullCalendarAgendaWeek: '週',
	fullCalendarAgendaDay: '日',

	monthNames: ['1月','2月','3月','4月','5月','6月',
	'7月','8月','9月','10月','11月','12月'],
	monthNamesShort: ['1月','2月','3月','4月','5月','6月',
	'7月','8月','9月','10月','11月','12月'],
	dayNames: ['日曜日', '月曜日', '火曜日', '水曜日', '木曜日', '金曜日', '土曜日'],
	dayNamesShort: ['日', '月', '火', '水', '木', '金', '土'],
	dayNamesMin: ['日','月','火','水','木','金','土']
};

localizationSharedCalDAV['nl_NL']=	/* thanks Johan Vromans */
{
	txtCalendars: 'Agenda’s',
	txtTodos: 'Taken',
	localTime: 'Plaatselijke tijd',
	fullCalendarMonth: 'maand',
	fullCalendarMultiWeek: 'weken',
	fullCalendarAgendaWeek: 'week',
	fullCalendarAgendaDay: 'dag',

	monthNames: ['Januari','Februari','Maart','April','Mei','Juni',
	'Juli','Augustus','September','Oktober','November','December'],
	monthNamesShort: ['Jan', 'Feb', 'Mrt', 'Apr', 'Mei', 'Jun',
	'Jul', 'Aug', 'Sep', 'Okt', 'Nov', 'Dec'],
	dayNames: ['Zondag', 'Maandag', 'Dinsdag', 'Woensdag', 'Donderdag', 'Vrijdag', 'Zaterdag'],
	dayNamesShort: ['Zon', 'Maa', 'Din', 'Woe', 'Don', 'Vrij', 'Zat'],
	dayNamesMin: ['Zo', 'Ma', 'Di', 'Wo', 'Do', 'Vr', 'Za']
};

localizationSharedCalDAV['sk_SK']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	txtCalendars: 'Kalendáre',
	txtTodos: 'Pripomienky',
	localTime: 'Lokálny čas',
	fullCalendarMonth: 'mesiac',
	fullCalendarMultiWeek: 'mtýždeň',
	fullCalendarAgendaWeek: 'týždeň',
	fullCalendarAgendaDay: 'deň',

	monthNames: ['Január','Február','Marec','Apríl','Máj','Jún',
	'Júl','August','September','Október','November','December'],
	monthNamesShort: ['Jan','Feb','Mar','Apr','Máj','Jún',
	'Júl','Aug','Sep','Okt','Nov','Dec'],
	dayNames: ['Nedeľa','Pondelok','Utorok','Streda','Štvrtok','Piatok','Sobota'],
	dayNamesShort: ['Ned','Pon','Uto','Str','Štv','Pia','Sob'],
	dayNamesMin: ['Ne','Po','Ut','St','Št','Pia','So']
};

localizationSharedCalDAV['tr_TR']=	/* thanks Selcuk Pultar */
{
	txtCalendars: 'Takvimler',
	txtTodos: 'Yapılacaklar',
	localTime: 'Yerel Saat',
	fullCalendarMonth: 'ay',
	fullCalendarMultiWeek: 'çokluhafta',
	fullCalendarAgendaWeek: 'hafta',
	fullCalendarAgendaDay: 'gün',

	monthNames: ['Ocak','Şubat','Mart','Nisan','Mayıs','Haziran',
	'Temmuz','Ağustos','Eylül','Ekim','Kasım','Aralık'],
	monthNamesShort: ['Oca', 'Şub', 'Mar', 'Nis', 'May', 'Haz',
	'Tem', 'Ağu', 'Eyl', 'Eki', 'Kas', 'Ara'],
	dayNames: ['Pazar', 'Pazartesi', 'Salı', 'Çarşamba', 'Perşembe', 'Cuma', 'Cumartesi'],
	dayNamesShort: ['Paz', 'Pts', 'Sal', 'Çar', 'Per', 'Cum', 'Cts'],
	dayNamesMin: ['Pz','Pt','Sa','Ça','Pe','Cu','Ct']
};

localizationSharedCalDAV['ru_RU']=	/* thanks Александр Симонов */
{
	txtCalendars: 'Календари',
	txtTodos: 'Задачи',
	localTime: 'Местное время',
	fullCalendarMonth: 'Шесть недель',
	fullCalendarMultiWeek: 'Три недели',
	fullCalendarAgendaWeek: 'Неделя',
	fullCalendarAgendaDay: 'День',

	monthNames: ['Январь','Февраль','Март','Апрель','Май','Июнь',
	'Июль','Август','Сентябрь','Октябрь','Ноябрь','Декабрь'],
	monthNamesShort: ['янв', 'фев', 'мар', 'апр', 'мая', 'июн',
	'июл', 'авг', 'сен', 'окт', 'ноя', 'дек'],
	dayNames: ['Воскресенье', 'Понедельник', 'Вторник', 'Среда', 'Четверг', 'Пятница', 'Суббота'],
	dayNamesShort: ['Вск', 'Пон', 'Втр', 'Срд', 'Чтв', 'Птн', 'Суб'],
	dayNamesMin: ['Вс','Пн','Вт','Ср','Чт','Пт','Сб']
};

localizationSharedCalDAV['uk_UA']=	/* Serge Yakimchuck <yakim@yakim.org.ua> */
{
	txtCalendars: 'Календарі',
	txtTodos: 'Завдання',
	localTime: 'Локальний час',
	fullCalendarMonth: 'місяць',
	fullCalendarMultiWeek: 'тижні',
	fullCalendarAgendaWeek: 'тиждень',
	fullCalendarAgendaDay: 'день',

	monthNames: ['Січень','Лютий','Березень','Квітень','Травень','Червень',
	'Липень','Серпень','Вересень','Жовтень','Листопад','Грудень'],
	monthNamesShort: ['Січ', 'Лют', 'Бер', 'Кві', 'Тра', 'Чер',
	'Лип', 'Сер', 'Вер', 'Жов', 'Лис', 'Гру'],
	dayNames: ['Неділя', 'Понеділок', 'Вівторок', 'Середа', 'Четвер', 'П\'ятниця', 'Субота'],
	dayNamesShort: ['Нед', 'Пон', 'Вівт', 'Сер', 'Чет', 'П\'ят', 'Суб'],
	dayNamesMin: ['Нд','Пн','Вт','Ср','Чт','Пт','Сб']
};

localizationSharedCalDAV['zh_CN']=	/* thanks Fandy */
{
	txtCalendars: '日程',
	txtTodos: '待办事宜',
	localTime: '本地时间',
	fullCalendarMonth: '月',
	fullCalendarMultiWeek: '三周',
	fullCalendarAgendaWeek: '周',
	fullCalendarAgendaDay: '日',

	monthNames: ['1月','2月','3月','4月','5月','6月',
	'7月','8月','9月','10月','11月','12月'],
	monthNamesShort: ['1', '2', '3', '4', '5', '6',
	'7', '8', '9', '10', '11', '12'],
	dayNames: ['星期日', '星期一', '星期二', '星期三', '星期四', '星期五', '星期六'],
	dayNamesShort: ['周日', '周一', '周二', '周三', '周四', '周五', '周六'],
	dayNamesMin: ['周日', '周一', '周二', '周三', '周四', '周五', '周六']
};

$.extend(true, localization, localizationSharedCalDAV);

var localizationCalDAV = new Object();

localizationCalDAV['cs_CZ']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'–\' d MMM yyyy}',
	_default_title_format_day_: 'ddd, d MMM yyyy',
	_default_title_format_table_: 'ddd, MMM yyyy',
	_default_column_format_agenda_: 'ddd, d MMM',

	txtCalendar: 'Kalendář',
	txtEnabledCalendars: 'Zapnuté Kalendáře',
	txtTodo: 'Připomínka',
	txtTodoList: 'Seznam',
	txtTodoLists: 'Seznamy Připomínek',
	txtEnabledTodoLists: 'Zapnuté Seznamy Připomínek',
	txtSubscribed: 'Odběry',
	fullCalendarTable: 'tabulka',
	fullCalendarTodayButton: 'dnes',
	fullCalendarAllDay: 'celej den',
	CalDAVsearch: 'Hledat',
	resourceEnable: 'Zobrazit všechnyy kalendáře v daném prostředku',
	resourceDisable: 'Schovat všechny kalendáře v daném prostředku',
	allEnable: 'Zobrazit všechny kalendáře',
	allDisable: 'Schovat všechny kalendáře',
	timezone: 'Časové pásmo',
	txtTimezonePicker: 'Pásmo:',
	loadingRList: 'Načítaní zoznamu prostředků ...',
	renderingE: 'Vykreslování kalendářů ...',
	timezoneChange: 'Aplikování změny časového pásma ...',
	customTimezone: 'Vlastní (Lokální čas)',
	customRepeat: 'Jiní (změna není podporována)',
	loadPrevMonth: 'Načíst předchádzející měsíc',
	loadNextMonth: 'Načíst následující měsíc',
	repeatBoxButton: 'Opakování',
	repeatBoxContent: 'je opakovací událost.',
	repeatBoxQuestion: 'Se kterými událostmi chcete pracovat?',
	allEvsButton: 'Všechny události',
	allFutureButton: 'Tahle a všechny budoucí události',
	eventOnlyButton: 'Pouze tahle událost',
	repeatBoxContentTODO: 'je opakovací připomínka.',
	repeatBoxQuestionTODO: 'Se kterými připomínkami chcete pracovat?',
	allEvsButtonTODO: 'Všechny připomínky',
	allFutureButtonTODO: 'Tahle a všechny budoucí připomínky',
	eventOnlyButtonTODO: 'Pouze tahle připomínka',
	txtStatus: 'Stav',
	eventAvailability : 'Dostupnost',
	eventAvailabilityBusy : 'Zaneprázdněnej',
	eventAvailabilityFree : 'Volnej',
	eventType: 'Soukromí',
	eventTypePublic: 'Veřejná',
	eventTypePrivate: 'Soukromá',
	eventTypeConfidential: 'Důvěrní',
	txtPriority: 'Priorita',
	txtPriorityNone: 'Žádná',
	txtPriorityLow: 'Nízká',
	txtPriorityMedium: 'Střední',
	txtPriorityHigh: 'Vysoká',
	eventURL : 'URL',
	repeatInterval: 'každých',
	repeatDays: 'dnů',
	repeatWeeks: 'týdnů',
	repeatMonths: 'měsíců',
	repeatYears: 'let',
	repeatChangeTxt: 'byl změnen na serveru!',
	repeatChangeTxtClose: 'Zavřete formulář a otevřte událost znovu',
	repeatTodoChangeTxtClose: 'Zavřete formulář a otevřte připomínku znovu.',
	calendarLoader: 'Znovunačítání ...',
	resizeLoader: 'Přepočítávání velikosti ...',

	// TODOS
	pholderNameTODO: 'Název',
	pholderNewTODO: 'Nová připomínka',
	txtTypeTODO: 'Typ',
	txtTypeTODONone: 'Jednoduchá',
	txtTypeTODOStart: 'S časem začátku',
	txtTypeTODODue: 'S časem konce',
	txtTypeTODOBoth: 'S časmi začátku i konce',
	txtDateFromTODO: 'Od',
	txtDateToTODO: 'Do',
	txtCompletedOn: 'Dokončeno ke',

	pholderDateFromTODO: 'Den od',
	pholderTimeFromTODO: 'Čas od',
	pholderDateToTODO: 'Den do',
	pholderTimeToTODO: 'Čas do',
	pholderCompletedOnDate: 'Den',
	pholderCompletedOnTime: 'Čas',

	txtStatusFiltersHeaderTODO: 'Filtry',
	txtStatusFiltersFooterTODO: '* dokončeno %date% a později',
	txtStatusNeedsActionTODO: 'Potřebuje akci',
	txtStatusCompletedTODO: 'Dokončena',
	txtStatusInProcessTODO: 'Řešená',
	txtStatusCancelledTODO: 'Zrušena',
	txtPercentCompletedTODO: 'Dokončeno',

	txtCalendarTODO: 'Kalendář',
	txtSelectCalendarTODO: 'Vyberte kalendář',
	txtAlertTODO: 'Alarm',
	txtAlertNoneTODO: 'Žádný',
	txtAlertMessageTODO: 'Správa',
	txtAlertOnDateTODO: 'Na datum',
	txtAlertWeeksBeforeTODO: 'Týdnů před',
	txtAlertDaysBeforeTODO: 'Dnů před',
	txtAlertHoursBeforeTODO: 'Hodin před',
	txtAlertMinutesBeforeTODO: 'Minut před',
	txtAlertSecondsBeforeTODO: 'Sekund před',
	txtAlertWeeksAfterTODO: 'Týdnů po',
	txtAlertDaysAfterTODO: 'Dnů po',
	txtAlertHoursAfterTODO: 'Sekund po',
	txtAlertMinutesAfterTODO: 'Minut po',
	txtAlertSecondsAfterTODO: 'Sekund po',

	pholderAfterBeforeValTODO: 'Hodnota',
	pholderAlarmDateTODO: 'Den alarmu',
	pholderAlarmTimeTODO: 'Čas alarmu',

	pholderNoteTODO: 'Poznámka',
	txtNoteTODO: 'Poznámka',

	todoPrevNav: 'Zobrazit předešlou instanci',
	todoNextNav: 'Zobrazit následující instanci',
	todoUncompletedPrevNav: 'Zobrazit předešlou nedokončenou instanci',
	todoUncompletedNextNav: 'Zobrazit následující nedokončenou instanci',

	buttonSaveTODO: 'Uložit',
	buttonEditTODO: 'Editovat',
	buttonDuplicateTODO: 'Duplikovat',
	buttonResetTODO: 'Reset',
	buttonCloseTODO: 'Zavřít',
	buttonDeleteTODO: 'Vymazat',

	// EVENTS
	pholderName: 'Název',
	pholderNewEvent: 'Nová událost',
	txtLocation: 'Místo',
	pholderLocation: 'Místo',

	txtAllDay: 'Celý den',
	from: 'Od',
	to: 'Do',

	pholderDateFrom: 'Den od',
	pholderTimeFrom: 'Čas od',
	pholderDateTo: 'Den do',
	pholderTimeTo: 'Čas do',

	txtStatusNone: 'Nespecifikován',
	txtStatusTentative: 'Předběžná',
	txtStatusConfirmed: 'Potvrzena',
	txtStatusCancelled: 'Zrušena',

	txtRepeat: 'Opakovat',
	txtNoRepeat: 'Neopakovat',
	txtRepeatDay: 'Denně',
	txtRepeatWeek: 'Týdenně',
	txtRepeatWeekend: 'Každý víkend',
	txtRepeatMonth: 'Měsíčně',
	txtRepeatTwoWeek: 'Dvoutýdenně',
	txtRepeatYear: 'Ročně',
	txtRepeatCustomWeek: 'Týdenně vlastní',
	txtRepeatCustomMonth: 'Měsíčně vlastní',
	txtRepeatCustomYear: 'Ročně vlastní',
	txtRepeatWork: 'Každý pracovný den',
	txtRepeatOnDate: 'Do dátumu',
	txtRepeatAfter: 'Výskytů',
	txtRepeatNever: 'Nikdy',
	pholderUntilDate: 'Do dne',
	pholderRepeatCount: 'Počet opakování',
	txtRepeatCustomWeekLabel: 'den',
	txtRepeatCustomMonthLabel: 've dnech',
	txtRepeatCustomMonthEvery: 'Každý',
	txtRepeatCustomMonthFirst: 'První',
	txtRepeatCustomMonthSecond: 'Druhej',
	txtRepeatCustomMonthThird: 'Třetí',
	txtRepeatCustomMonthFourth: 'Čtvrtý',
	txtRepeatCustomMonthFifth: 'Pátý',
	txtRepeatCustomMonthLast: 'Poslední',
	txtRepeatCustomMonthCustom: 'Vlastní',
	txtRepeatCustomMonthMonth: 'Den v měsíci',
	txtRepeatCustomYearLabel1: 'každý',
	txtRepeatCustomYearLabel2: 'v měsíci',

	txtRepeatEnd: 'konec',
	txtEventCalendar: 'Kalendář',
	txtSelectCalendar: 'Vyberte kalendář',
	txtAlert: 'Alarm',
	txtAlertNone: 'Žádný',
	txtAlertMessage: 'Správa',
	txtAlertOnDate: 'Na datum',
	txtAlertWeeksBefore: 'Týdnů před',
	txtAlertDaysBefore: 'Dnů před',
	txtAlertHoursBefore: 'Hodin před',
	txtAlertMinutesBefore: 'Minut před',
	txtAlertSecondsBefore: 'Sekund před',
	txtAlertWeeksAfter: 'Týdnů po',
	txtAlertDaysAfter: 'Dnů po',
	txtAlertHoursAfter: 'Sekund po',
	txtAlertMinutesAfter: 'Minut po',
	txtAlertSecondsAfter: 'Sekund po',

	pholderAfterBeforeVal: 'Hodnota',
	pholderAlarmDate: 'Den alarmu',
	pholderAlarmTime: 'Čas alarmu',

	pholderNote: 'Poznámka',

	eventPrevNav: 'Zobrazit předešlou instanci',
	eventNextNav: 'Zobrazit následující instanci',

	buttonClose: 'Zavřít',
	buttonDuplicate: 'Duplikovat',

	txtAllSavedTodo: 'Připomínka úspěšně uložena!',
	txtAllSaved: 'Událost úspěšně uložena!',

	txtAllDeletedTodo: 'Připomínka úspěšně vymazána!',
	txtAllDeleted: 'Událost úspěšně vymazána!',

	txtNotChooseTodo: 'Chyba: Musíte zvolit kalendář!',
	txtNotChoose: 'Chyba: Musíte zvolit kalendář!',

	txtErorInputTodo: 'Chyba: opravte chybné hodnoty!',
	txtDateTimeErrorTodo: 'Chyba: Musíte zvolit den a čas!',

	txtErrorDates: 'Chyba: Čas začátku musí být před koncem!',
	txtErrorDatesTodo: 'Chyba: Čas začátku musí být před koncem!',

	txtErorInput: 'Chyba: opravte vyznačené chybné hodnoty!',

	txtAlertsH: 'Alarmy',
	buttonAlert: 'Smazat alarmy',

	altAddEvent: 'Přidat událost',
	altAddTodo: 'Přidat připomínku',

	loadingCalendars: 'Načítavání kalendářů (%act% z %total%) ...',
	unloadingCalendars: 'Odčítavání kalendářů ...',

	errUnableSaveBeginCalDAV: 'Chyba: \'nepodařilo sa uložit událost\': %%!',
	errUnableDeleteBeginCalDAV: 'Chyba: \'nepodařilo sa vymazat událost\': %%!',
	CalDAVerrHttp410: 'Událost již není dostupná na serveru',
	errUnableSaveTodoBeginCalDAV: 'Chyba: \'nepodařilo sa uložit připomínku \': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Chyba: \'nepodařilo sa vymazat připomínku\': %%!',
	CalDAVerrTodoHttp410: 'Připomínka již není dostupná na serveru'
};

localizationCalDAV['da_DK']=	/* thanks Niels Bo Andersen and Michael Rasmussen */
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'–\' d MMM yyyy}',
	_default_title_format_day_: 'ddd, d MMM yyyy',
	_default_title_format_table_: 'ddd, MMM yyyy',
	_default_column_format_agenda_: 'ddd, d MMM',

	txtCalendar: 'Kalender',
	txtEnabledCalendars: 'Aktiver kalendere',
	txtTodo: 'Opgave',
	txtTodoList: 'Opgaveliste',
	txtTodoLists: 'Opgavelister',
	txtEnabledTodoLists: 'Aktiver opgavelister',
	txtSubscribed: 'Abonnementer',
	fullCalendarTable: 'tabel',
	fullCalendarTodayButton: 'i dag',
	fullCalendarAllDay: 'hele dagen',
	CalDAVsearch: 'Søg',
	resourceEnable: 'Aktiver alle kalendere i denne ressource',
	resourceDisable: 'Deaktiver alle kalendere i denne ressource',
	allEnable: 'Aktiver alle kalendere',
	allDisable: 'Deaktiver alle kalendere',
	timezone: 'Tidszone',
	txtTimezonePicker: 'Tidszone:',
	loadingRList: 'Henter ressourceliste ...',
	renderingE: 'Klargør kalendere ...',
	timezoneChange: 'Udfører tidszoneskift ...',
	customTimezone: 'Brugerdefineret (Lokal tid)',
	customRepeat: 'Andet (kan ikke redigeres)',
	loadPrevMonth: 'Hent forrige måned',
	loadNextMonth: 'Hent næste måned',
	repeatBoxButton: 'Gentagelse',
	repeatBoxContent: 'er en gentaget begivenhed.',
	repeatBoxQuestion: 'Hvilke forekomster vil du åbne?',
	allEvsButton: 'Alle forekomster',
	allFutureButton: 'Denne og alle fremtidige forekomster',
	eventOnlyButton: 'Kun denne forekomst',
	repeatBoxContentTODO: 'er en tilbagevendende todo.',
	repeatBoxQuestionTODO: 'Hvilke todos vil du arbejde med',
	allEvsButtonTODO: 'Alle todos',
	allFutureButtonTODO: 'Denne og alle fremtidige todos',
	eventOnlyButtonTODO: 'Kun denne todo',
	txtStatus: 'Status',
	eventAvailability : 'Vis som',
	eventAvailabilityBusy : 'Optaget',
	eventAvailabilityFree : 'Ledig',
	eventType: 'Fortrolighed',
	eventTypePublic: 'Offentlig',
	eventTypePrivate: 'Privat',
	eventTypeConfidential: 'Fortrolig',
	txtPriority: 'Prioritet',
	txtPriorityNone: 'Ingen',
	txtPriorityLow: 'Lav',
	txtPriorityMedium: 'Mellem',
	txtPriorityHigh: 'Høj',
	eventURL : 'URL',
	repeatInterval: 'Hver',
	repeatDays: 'dag(e)',
	repeatWeeks: 'uge(r)',
	repeatMonths: 'måned(er)',
	repeatYears: 'år',
	repeatChangeTxt: 'blev ændret på serveren!',
	repeatChangeTxtClose: 'Luk formularen og åbn begivenheden igen',
	repeatTodoChangeTxtClose: 'Close the form and open the todo again',
	calendarLoader: 'Genindlæser ...',
	resizeLoader: 'Tilpasser størrelse ...',

	// TODOS
	pholderNameTODO: 'Emne',
	pholderNewTODO: 'Ny opgave',
	txtTypeTODO: 'Type',
	txtTypeTODONone: 'Simpel',
	txtTypeTODOStart: 'Med startdato',
	txtTypeTODODue: 'Med forfaldsdato',
	txtTypeTODOBoth: 'Med både startdato og forfaldsdato',
	txtDateFromTODO: 'Fra',
	txtDateToTODO: 'Til',
	txtCompletedOn: 'Færdiggjort den',

	pholderDateFromTODO: 'Fra dato',
	pholderTimeFromTODO: 'Fra kl.',
	pholderDateToTODO: 'Til dato',
	pholderTimeToTODO: 'Til kl.',
	pholderCompletedOnDate: 'Dato',
	pholderCompletedOnTime: 'Time',

	txtStatusFiltersHeaderTODO: 'Filtre',
	txtStatusFiltersFooterTODO: '* afsluttet %date% eller senere',
	txtStatusNeedsActionTODO: 'Kræver opfølgning',
	txtStatusCompletedTODO: 'Fuldført',
	txtStatusInProcessTODO: 'Under udførelse',
	txtStatusCancelledTODO: 'Annulleret',
	txtPercentCompletedTODO: 'Fuldført',

	txtCalendarTODO: 'Kalender',
	txtSelectCalendarTODO: 'Vælg kalender',
	txtAlertTODO: 'Påmindelse',
	txtAlertNoneTODO: 'None',
	txtAlertMessageTODO: 'Besked',
	txtAlertOnDateTODO: 'På dagen',
	txtAlertWeeksBeforeTODO: 'Uger før',
	txtAlertDaysBeforeTODO: 'Dage før',
	txtAlertHoursBeforeTODO: 'Timer før',
	txtAlertMinutesBeforeTODO: 'Minutter før',
	txtAlertSecondsBeforeTODO: 'Sekunder før',
	txtAlertWeeksAfterTODO: 'Uger efter',
	txtAlertDaysAfterTODO: 'Dage efter',
	txtAlertHoursAfterTODO: 'Timer efter',
	txtAlertMinutesAfterTODO: 'Minutter efter',
	txtAlertSecondsAfterTODO: 'Sekunder efter',

	pholderAfterBeforeValTODO: 'Værdi',
	pholderAlarmDateTODO: 'Alarmdato',
	pholderAlarmTimeTODO: 'Alarmtid',

	pholderNoteTODO: 'Note',
	txtNoteTODO: 'Note',

	todoPrevNav: 'Vis forrige',
	todoNextNav: 'Vis næste',
	todoUncompletedPrevNav: 'Vis forrige uafsluttede',
	todoUncompletedNextNav: 'Vis næste uafsluttede',

	buttonSaveTODO: 'Gem',
	buttonEditTODO: 'Rediger',
	buttonDuplicateTODO: 'Kopier',
	buttonResetTODO: 'Fortryd',
	buttonCloseTODO: 'Luk',
	buttonDeleteTODO: 'Slet',

	// EVENTS
	pholderName: 'Emne',
	pholderNewEvent: 'Ny begivenhed',
	txtLocation: 'Sted',
	pholderLocation: 'Sted',

	txtAllDay: 'Hele dagen',
	from: 'Fra',
	to: 'Til',

	pholderDateFrom: 'Fra dato',
	pholderTimeFrom: 'Fra kl.',
	pholderDateTo: 'Til dato',
	pholderTimeTo: 'Til kl.',

	txtStatusNone: 'Uspecifiseret',
	txtStatusTentative: 'Usikker',
	txtStatusConfirmed: 'Bekræftet',
	txtStatusCancelled: 'Annulleret',

	txtRepeat: 'Gentagelse',
	txtNoRepeat: 'Ingen gentagelse',
	txtRepeatDay: 'Dagligt',
	txtRepeatWeek: 'Ugentligt',
	txtRepeatWeekend: 'Hver weekend',
	txtRepeatMonth: 'Månedligt',
	txtRepeatTwoWeek: 'Hver anden uge',
	txtRepeatYear: 'Årligt',
	txtRepeatCustomWeek: 'Ugentligt (avanceret)',
	txtRepeatCustomMonth: 'Månedligt (avanceret)',
	txtRepeatCustomYear: 'Årligt (avanceret)',
	txtRepeatWork: 'På arbejdsdage',
	txtRepeatOnDate: 'På dato',
	txtRepeatAfter: 'Forekomster',
	txtRepeatNever: 'Aldrig',
	pholderUntilDate: 'Indtil dato',
	pholderRepeatCount: 'Antal gentagelser',
	txtRepeatCustomWeekLabel: 'På',
	txtRepeatCustomMonthLabel: 'På dage',
	txtRepeatCustomMonthEvery: 'Hver',
	txtRepeatCustomMonthFirst: 'Første',
	txtRepeatCustomMonthSecond: 'Anden',
	txtRepeatCustomMonthThird: 'Tredie',
	txtRepeatCustomMonthFourth: 'Fjerde',
	txtRepeatCustomMonthFifth: 'Femte',
	txtRepeatCustomMonthLast: 'Sidste',
	txtRepeatCustomMonthCustom: 'Valgfri',
	txtRepeatCustomMonthMonth: 'Dag i måneden',
	txtRepeatCustomYearLabel1: 'Hver',
	txtRepeatCustomYearLabel2: 'i',

	txtRepeatEnd: 'Slut',
	txtEventCalendar: 'Kalender',
	txtSelectCalendar: 'Vælg kalender',
	txtAlert: 'Påmindelse',
	txtAlertNone: 'Ingen',
	txtAlertMessage: 'Besked',
	txtAlertOnDate: 'På dato',
	txtAlertWeeksBefore: 'Uger før',
	txtAlertDaysBefore: 'Dage før',
	txtAlertHoursBefore: 'Timer før',
	txtAlertMinutesBefore: 'Minutter før',
	txtAlertSecondsBefore: 'Sekunder før',
	txtAlertWeeksAfter: 'Uger efter',
	txtAlertDaysAfter: 'Dage efter',
	txtAlertHoursAfter: 'Timer efter',
	txtAlertMinutesAfter: 'Minutter efter',
	txtAlertSecondsAfter: 'Sekunder efter',

	pholderAfterBeforeVal: 'Værdi',
	pholderAlarmDate: 'Alarmdato',
	pholderAlarmTime: 'Alarmtid',

	pholderNote: 'Note',

	eventPrevNav: 'Vis forrige',
	eventNextNav: 'Vis næste',

	buttonClose: 'Luk',
	buttonDuplicate: 'Kopier',

	txtAllSavedTodo: 'Opgave gemt!',
	txtAllSaved: 'Begivenhed gemt!',

	txtAllDeletedTodo: 'Opgave slettet!',
	txtAllDeleted: 'Begivenhed slettet!',

	txtNotChooseTodo: 'Fejl: Vælg en kalender!',
	txtNotChoose: 'Fejl: Vælg en kalender!',

	txtErrorDates: 'Fejl: Startdatoen skal komme før slutdatoen!',
	txtErrorDatesTodo: 'Fejl: Startdatoen skal komme før forfaldsdatoen!',

	txtErorInputTodo: 'Kunne ikke gemme: ret de ugyldige værdier!',
	txtDateTimeErrorTodo: 'Der skal vælges dato og tid!',

	txtErorInput: 'Fejl: \'kunne ikke gemme\': ret de markerede ugyldige værdier!',

	txtAlertsH: 'Påmindelser',
	buttonAlert: 'Fjern påmindelser',

	altAddEvent: 'Tilføj begivenhed',
	altAddTodo: 'Tilføj opgave',

	loadingCalendars: 'Indlæser kalendere (%act% af %total%) ...',
	unloadingCalendars: 'Gemmer kalendere ...',

	errUnableSaveBeginCalDAV: 'Fejl: \'kunne ikke gemme begivenheden\': %%!',
	errUnableDeleteBeginCalDAV: 'Fejl: \'kunne ikke slette begivenheden\': %%!',
	CalDAVerrHttp410: 'Begivenheden er ikke længere tilgængelig på serveren',
	errUnableSaveTodoBeginCalDAV: 'Fejl: \'Kunne ikke gemme todo\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Fejl: \'Kunne ikke slette todo\': %%!',
	CalDAVerrTodoHttp410: 'Todo findes ikke længere på serveren'
};

localizationCalDAV['de_DE']=	/* thanks Marten Gajda and Thomas Scheel */
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'–\' d MMM yyyy}',
	_default_title_format_day_: 'ddd, d MMM yyyy',
	_default_title_format_table_: 'ddd, MMM yyyy',
	_default_column_format_agenda_: 'ddd, d MMM',

	txtCalendar: 'Kalender',
	txtEnabledCalendars: 'Aktive Kalender',
	txtTodo: 'Aufgabe',
	txtTodoList: 'Aufgabenliste',
	txtTodoLists: 'Aufgabenlisten',
	txtEnabledTodoLists: 'Aktive Aufgabenlisten',
	txtSubscribed: 'Abonnements',
	fullCalendarTable: 'Liste', /* is this an Agenda? */
	fullCalendarTodayButton: 'Heute',
	fullCalendarAllDay: 'ganztägig',
	CalDAVsearch: 'Suchen',
	resourceEnable: 'Aktiviere alle Kalender in dieser Ressource',
	resourceDisable: 'Deaktiviere alle Kalender in dieser Ressource',
	allEnable: 'Aktiviere alle Kalender',
	allDisable: 'Deaktiviere alle Kalender',
	timezone: 'Zeitzone',
	txtTimezonePicker: 'Zeitzone:',
	loadingRList: 'Lade Ressourcenliste ...',
	renderingE: 'Bereite Ansicht vor ...',
	timezoneChange: 'Anwenden der Zeitzonenänderung ...',
	customTimezone: 'Unbekannt (lokale Zeit)',
	customRepeat: 'Sonstige (nicht änderbar)',
	loadPrevMonth: 'Zeige vorherigen Monat',
	loadNextMonth: 'Zeige nächsten Monat',
	repeatBoxButton: 'Wiederholung',
	repeatBoxContent: 'ist ein Serientermin.',
	repeatBoxQuestion: 'Welche Termine sollen bearbeitet werden?',
	allEvsButton: 'Alle Termine',
	allFutureButton: 'Dieser und alle zukünftigen Termine',
	eventOnlyButton: 'Nur diesen Termin',
	repeatBoxContentTODO: 'ist eine Serienaufgabe.',
	repeatBoxQuestionTODO: 'Welche Aufgaben möchten Sie bearbeiten?',
	allEvsButtonTODO: 'Alle Aufgaben',
	allFutureButtonTODO: 'Diese und alle zukünftigen Aufgaben',
	eventOnlyButtonTODO: 'Nur diese Aufgabe',
	txtStatus: 'Status',
	eventAvailability : 'Verfügbarkeit',
	eventAvailabilityBusy : 'beschäftigt',
	eventAvailabilityFree : 'verfügbar',
	eventType: 'Privatsphäre',
	eventTypePublic: 'öffentlich',
	eventTypePrivate: 'privat',
	eventTypeConfidential: 'vertraulich',
	txtPriority: 'Priorität',
	txtPriorityNone: 'Ohne',
	txtPriorityLow: 'Niedrig',
	txtPriorityMedium: 'Mittel',
	txtPriorityHigh: 'Hoch',
	eventURL : 'URL',
	repeatInterval: 'Alle',
	repeatDays: 'Tage',
	repeatWeeks: 'Wochen',
	repeatMonths: 'Monate',
	repeatYears: 'Jahre',
	repeatChangeTxt: 'wurde auf dem Server geändert!',
	repeatChangeTxtClose: 'Fenster schließen und Termin erneut öffnen',
	repeatTodoChangeTxtClose: 'Fenster schließen und Aufgabe erneut öffnen',
	calendarLoader: 'Lade ...',
	resizeLoader: 'Größe anpassen ...',

	// TODOS
	pholderNameTODO: 'Titel',
	pholderNewTODO: 'Neue Aufgabe',
	txtTypeTODO: 'Aufgabentyp',
	txtTypeTODONone: 'einfach',
	txtTypeTODOStart: 'mit Startzeit',
	txtTypeTODODue: 'mit Fälligkeit',
	txtTypeTODOBoth: 'mit Startzeit und Fälligkeit',
	txtDateFromTODO: 'Von',
	txtDateToTODO: 'Bis',
	txtCompletedOn: 'Fertiggestellt',

	pholderDateFromTODO: 'Startdatum',
	pholderTimeFromTODO: 'Startzeit',
	pholderDateToTODO: 'Enddatum',
	pholderTimeToTODO: 'Endzeit',
	pholderCompletedOnDate: 'Datum',
	pholderCompletedOnTime: 'Zeit',

	txtStatusFiltersHeaderTODO: 'Filter',
	txtStatusFiltersFooterTODO: '* am oder nach dem %date% fertiggestellt.',
	txtStatusNeedsActionTODO: 'offen', /* Lightning translates it to 'Benötigt Eingriff' */
	txtStatusCompletedTODO: 'erledigt',
	txtStatusInProcessTODO: 'in Bearbeitung',
	txtStatusCancelledTODO: 'abgebrochen',
	txtPercentCompletedTODO: 'erledigt',

	txtCalendarTODO: 'Kalender',
	txtSelectCalendarTODO: 'Kalender auswählen',
	txtAlertTODO: 'Alarm',
	txtAlertNoneTODO: 'ohne',
	txtAlertMessageTODO: 'Benachrichtigung',
	txtAlertOnDateTODO: 'am',
	txtAlertWeeksBeforeTODO: 'Wochen vorher',
	txtAlertDaysBeforeTODO: 'Tage vorher',
	txtAlertHoursBeforeTODO: 'Stunden vorher',
	txtAlertMinutesBeforeTODO: 'Minuten vorher',
	txtAlertSecondsBeforeTODO: 'Sekunden vorher',
	txtAlertWeeksAfterTODO: 'Wochen danach',
	txtAlertDaysAfterTODO: 'Tage danach',
	txtAlertHoursAfterTODO: 'Stunden danach',
	txtAlertMinutesAfterTODO: 'Minuten danach',
	txtAlertSecondsAfterTODO: 'Sekunden danach',

	pholderAfterBeforeValTODO: 'Wert', /* is this used anywhere */
	pholderAlarmDateTODO: 'Alarmdatum',
	pholderAlarmTimeTODO: 'Alarmzeit',

	pholderNoteTODO: 'Notiz',
	txtNoteTODO: 'Notiz',

	todoPrevNav: 'Zeige vorherige Instanz',
	todoNextNav: 'Zeige nächste Instanz',
	todoUncompletedPrevNav: 'Zeige vorherige unerledigte Instanz',
	todoUncompletedNextNav: 'Zeige nächste unerledigte Instanz',

	buttonSaveTODO: 'Speichern',
	buttonEditTODO: 'Bearbeiten',
	buttonDuplicateTODO: 'Duplizieren',
	buttonResetTODO: 'Verwerfen',
	buttonCloseTODO: 'Schließen',
	buttonDeleteTODO: 'Löschen',

	// EVENTS
	pholderName: 'Titel',
	pholderNewEvent: 'Neuer Termin',
	txtLocation: 'Ort',
	pholderLocation: 'Ort',

	txtAllDay: 'ganztägig',
	from: 'von',
	to: 'bis',

	pholderDateFrom: 'Startdatum',
	pholderTimeFrom: 'Startzeit',
	pholderDateTo: 'Enddatum',
	pholderTimeTo: 'Endzeit',

	txtStatusNone: 'Nicht angegeben',
	txtStatusTentative: 'Vorläufig',
	txtStatusConfirmed: 'Bestätigt',
	txtStatusCancelled: 'Abgebrochen',

	txtRepeat: 'Wiederholung',
	txtNoRepeat: 'ohne',
	txtRepeatDay: 'täglich',
	txtRepeatWeek: 'wöchentlich',
	txtRepeatWeekend: 'jedes Wochenende',
	txtRepeatMonth: 'monatlich',
	txtRepeatTwoWeek: '14-tägig',
	txtRepeatYear: 'jährlich',
	txtRepeatCustomWeek: 'wöchentlich (benutzerdefiniert)',
	txtRepeatCustomMonth: 'monatlich (benutzerdefiniert)',
	txtRepeatCustomYear: 'jährlich (benutzerdefiniert)',
	txtRepeatWork: 'werktags',
	txtRepeatOnDate: 'am',
	txtRepeatAfter: 'Wiederholungen',
	txtRepeatNever: 'nie',
	pholderUntilDate: 'bis Datum',
	pholderRepeatCount: 'Wiederholungen',
	txtRepeatCustomWeekLabel: 'am',
	txtRepeatCustomMonthLabel: 'an Tagen',
	txtRepeatCustomMonthEvery: 'jeden',
	txtRepeatCustomMonthFirst: 'ersten',
	txtRepeatCustomMonthSecond: 'zweiten',
	txtRepeatCustomMonthThird: 'dritten',
	txtRepeatCustomMonthFourth: 'vierten',
	txtRepeatCustomMonthFifth: 'fünften',
	txtRepeatCustomMonthLast: 'letzten',
	txtRepeatCustomMonthCustom: 'benutzerdefiniert',
	txtRepeatCustomMonthMonth: 'Tag des Monats',
	txtRepeatCustomYearLabel1: 'jeden',
	txtRepeatCustomYearLabel2: 'von',

	txtRepeatEnd: 'Ende',
	txtEventCalendar: 'Kalender',
	txtSelectCalendar: 'Kalender auswählen',
	txtAlert: 'Alarm',
	txtAlertNone: 'ohne',
	txtAlertMessage: 'Benachrichtigung',
	txtAlertOnDate: 'am',
	txtAlertWeeksBefore: 'Wochen vorher',
	txtAlertDaysBefore: 'Tage vorher',
	txtAlertHoursBefore: 'Stunden vorher',
	txtAlertMinutesBefore: 'Minuten vorher',
	txtAlertSecondsBefore: 'Sekunden vorher',
	txtAlertWeeksAfter: 'Wochen danach',
	txtAlertDaysAfter: 'Tage danach',
	txtAlertHoursAfter: 'Stunden danach',
	txtAlertMinutesAfter: 'Minuten danach',
	txtAlertSecondsAfter: 'Sekunden danach',

	pholderAfterBeforeVal: 'Wert',
	pholderAlarmDate: 'Alarmdatum',
	pholderAlarmTime: 'Alarmzeit',

	pholderNote: 'Notiz',

	eventPrevNav: 'Zeige vorherige Instanz',
	eventNextNav: 'Zeige nächste Instanz',

	buttonClose: 'Schließen',
	buttonDuplicate: 'Duplizieren',

	txtAllSavedTodo: 'Aufgabe erfolgreich gespeichert!',
	txtAllSaved: 'Termin erfolgreich gespeichert!',

	txtAllDeletedTodo: 'Aufgabe erfolgreich gelöscht!',
	txtAllDeleted: 'Termin erfolgreich gelöscht!',

	txtNotChooseTodo: 'Fehler: Kalender auswählen!',
	txtNotChoose: 'Fehler: Kalender auswählen!',

	txtErrorDates: 'Fehler: Startdatum muss vor dem Enddatum liegen!',
	txtErrorDatesTodo: 'Fehler: Startdatum muss vor dem Enddatum liegen!',

	txtErorInputTodo: 'Fehler beim Speichern: fehlerhafte Werte korrigieren!',
	txtDateTimeErrorTodo: 'Datum und Uhrzeit wählen!',

	txtErorInput: 'Fehler: \'Speichern nicht möglich\': Hervorgehobenen Werte korrigieren!',

	txtAlertsH: 'Alarme',
	buttonAlert: 'Lösche Alarme',

	altAddEvent: 'Termin hinzufügen',
	altAddTodo: 'Aufgabe hinzufügen',

	loadingCalendars: 'Lade Kalender (%act% von %total%) ...',
	unloadingCalendars: 'Entlade Kalender ...',

	errUnableSaveBeginCalDAV: 'Fehler: \'Termin konnte nicht gespeichert werden\': %%!',
	errUnableDeleteBeginCalDAV: 'Fehler: \'Termin konnte nicht gelöscht werden\': %%!',
	CalDAVerrHttp410: 'Der Termin existiert auf dem Server nicht mehr.',
	errUnableSaveTodoBeginCalDAV: 'Fehler: \'Aufgabe konnte nicht gespeichert werden\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Fehler: \'Aufgabe konnte nicht gelöscht werden\': %%!',
	CalDAVerrTodoHttp410: 'Die Aufgabe existiert auf dem Server nicht mehr.'
};

localizationCalDAV['en_US']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	_default_title_format_month_: 'yyyy MMM',
	_default_title_format_week_: 'yyyy MMM d{ \'–\'[ yyyy][ MMM] d}',
	_default_title_format_day_: 'yyyy MMM d, ddd',
	_default_title_format_table_: 'yyyy MMM, ddd',
	_default_column_format_agenda_: 'ddd, MMM d',

	txtCalendar: 'Calendar',
	txtEnabledCalendars: 'Enabled Calendars',
	txtTodo: 'Todo',
	txtTodoList: 'Todo List',
	txtTodoLists: 'Todo Lists',
	txtEnabledTodoLists: 'Enabled Todo Lists',
	txtSubscribed: 'Subscriptions',
	fullCalendarTable: 'table',
	fullCalendarTodayButton: 'today',
	fullCalendarAllDay: 'all day',
	CalDAVsearch: 'Search',
	resourceEnable: 'Enable all calendars in this resource',
	resourceDisable: 'Disable all calendars in this resource',
	allEnable: 'Enable all calendars',
	allDisable: 'Disable all calendars',
	timezone: 'Timezone',
	txtTimezonePicker: 'Timezone:',
	loadingRList: 'Loading resource list ...',
	renderingE: 'Rendering calendars ...',
	timezoneChange: 'Applying timezone change ...',
	customTimezone: 'Custom (Local Time)',
	customRepeat: 'Other (modification not supported)',
	loadPrevMonth: 'Load previous month',
	loadNextMonth: 'Load next month',
	repeatBoxButton: 'Recurrence',
	repeatBoxContent: 'is a repeating event.',
	repeatBoxQuestion: 'Which events would you like to work with?',
	allEvsButton: 'All events',
	allFutureButton: 'This and all future events',
	eventOnlyButton: 'This event only',
	repeatBoxContentTODO: 'is a repeating todo.',
	repeatBoxQuestionTODO: 'Which todos would you like to work with?',
	allEvsButtonTODO: 'All todos',
	allFutureButtonTODO: 'This and all future todos',
	eventOnlyButtonTODO: 'This todo only',
	txtStatus: 'Status',
	eventAvailability : 'Availability',
	eventAvailabilityBusy : 'Busy',
	eventAvailabilityFree : 'Free',
	eventType: 'Privacy',
	eventTypePublic: 'Public',
	eventTypePrivate: 'Private',
	eventTypeConfidential: 'Confidential',
	txtPriority: 'Priority',
	txtPriorityNone: 'None',
	txtPriorityLow: 'Low',
	txtPriorityMedium: 'Medium',
	txtPriorityHigh: 'High',
	eventURL : 'URL',
	repeatInterval: 'every',
	repeatDays: 'days',
	repeatWeeks: 'weeks',
	repeatMonths: 'months',
	repeatYears: 'years',
	repeatChangeTxt: 'was changed on the server!',
	repeatChangeTxtClose: 'Close the form and open the event again',
	repeatTodoChangeTxtClose: 'Close the form and open the todo again',
	calendarLoader: 'Reloading ...',
	resizeLoader: 'Resizing ...',

	// TODOS
	pholderNameTODO: 'Name',
	pholderNewTODO: 'New Todo',
	txtTypeTODO: 'Type',
	txtTypeTODONone: 'Simple',
	txtTypeTODOStart: 'With start time',
	txtTypeTODODue: 'With due time',
	txtTypeTODOBoth: 'With both start and due times',
	txtDateFromTODO: 'From',
	txtDateToTODO: 'To',
	txtCompletedOn: 'Completed on',

	pholderDateFromTODO: 'Date from',
	pholderTimeFromTODO: 'Time from',
	pholderDateToTODO: 'Date to',
	pholderTimeToTODO: 'Time to',
	pholderCompletedOnDate: 'Date',
	pholderCompletedOnTime: 'Time',

	txtStatusFiltersHeaderTODO: 'Filters',
	txtStatusFiltersFooterTODO: '* completed at or after %date%',
	txtStatusNeedsActionTODO: 'Needs action',
	txtStatusCompletedTODO: 'Completed',
	txtStatusInProcessTODO: 'In progress',
	txtStatusCancelledTODO: 'Canceled',
	txtPercentCompletedTODO: 'Completed',

	txtCalendarTODO: 'Calendar',
	txtSelectCalendarTODO: 'Select a calendar',
	txtAlertTODO: 'Alert',
	txtAlertNoneTODO: 'None',
	txtAlertMessageTODO: 'Message',
	txtAlertOnDateTODO: 'On date',
	txtAlertWeeksBeforeTODO: 'Weeks before',
	txtAlertDaysBeforeTODO: 'Days before',
	txtAlertHoursBeforeTODO: 'Hours before',
	txtAlertMinutesBeforeTODO: 'Minutes before',
	txtAlertSecondsBeforeTODO: 'Seconds before',
	txtAlertWeeksAfterTODO: 'Weeks after',
	txtAlertDaysAfterTODO: 'Days after',
	txtAlertHoursAfterTODO: 'Hours after',
	txtAlertMinutesAfterTODO: 'Minutes after',
	txtAlertSecondsAfterTODO: 'Seconds after',

	pholderAfterBeforeValTODO: 'Value',
	pholderAlarmDateTODO: 'Alarm date',
	pholderAlarmTimeTODO: 'Alarm time',

	pholderNoteTODO: 'Note',
	txtNoteTODO: 'Note',

	todoPrevNav: 'Show previous instance',
	todoNextNav: 'Show next instance',
	todoUncompletedPrevNav: 'Show previous uncompleted instance',
	todoUncompletedNextNav: 'Show next uncompleted instance',

	buttonSaveTODO: 'Save',
	buttonEditTODO: 'Edit',
	buttonDuplicateTODO: 'Duplicate',
	buttonResetTODO: 'Revert',
	buttonCloseTODO: 'Close',
	buttonDeleteTODO: 'Delete',

	// EVENTS
	pholderName: 'Name',
	pholderNewEvent: 'New Event',
	txtLocation: 'Location',
	pholderLocation: 'Location',

	txtAllDay: 'All day',
	from: 'From',
	to: 'To',

	pholderDateFrom: 'Date from',
	pholderTimeFrom: 'Time from',
	pholderDateTo: 'Date to',
	pholderTimeTo: 'Time to',

	txtStatusNone: 'Unspecified',
	txtStatusTentative: 'Tentative',
	txtStatusConfirmed: 'Confirmed',
	txtStatusCancelled: 'Cancelled',

	txtRepeat: 'Repeat',
	txtNoRepeat: 'No repeat',
	txtRepeatDay: 'Daily',
	txtRepeatWeek: 'Weekly',
	txtRepeatWeekend: 'Every weekend',
	txtRepeatMonth: 'Monthly',
	txtRepeatTwoWeek: 'Bi-weekly',
	txtRepeatYear: 'Yearly',
	txtRepeatCustomWeek: 'Custom weekly',
	txtRepeatCustomMonth: 'Custom monthly',
	txtRepeatCustomYear: 'Custom yearly',
	txtRepeatWork: 'Every business day',
	txtRepeatOnDate: 'On date',
	txtRepeatAfter: 'Occurrences',
	txtRepeatNever: 'Never',
	pholderUntilDate: 'Date until',
	pholderRepeatCount: 'Repeat count',
	txtRepeatCustomWeekLabel: 'on',
	txtRepeatCustomMonthLabel: 'on days',
	txtRepeatCustomMonthEvery: 'Every',
	txtRepeatCustomMonthFirst: 'First',
	txtRepeatCustomMonthSecond: 'Second',
	txtRepeatCustomMonthThird: 'Third',
	txtRepeatCustomMonthFourth: 'Fourth',
	txtRepeatCustomMonthFifth: 'Fifth',
	txtRepeatCustomMonthLast: 'Last',
	txtRepeatCustomMonthCustom: 'Custom',
	txtRepeatCustomMonthMonth: 'Day of the month',
	txtRepeatCustomYearLabel1: 'every',
	txtRepeatCustomYearLabel2: 'of',

	txtRepeatEnd: 'end',
	txtEventCalendar: 'Calendar',
	txtSelectCalendar: 'Select a calendar',
	txtAlert: 'Alert',
	txtAlertNone: 'None',
	txtAlertMessage: 'Message',
	txtAlertOnDate: 'On date',
	txtAlertWeeksBefore: 'Weeks before',
	txtAlertDaysBefore: 'Days before',
	txtAlertHoursBefore: 'Hours before',
	txtAlertMinutesBefore: 'Minutes before',
	txtAlertSecondsBefore: 'Seconds before',
	txtAlertWeeksAfter: 'Weeks after',
	txtAlertDaysAfter: 'Days after',
	txtAlertHoursAfter: 'Hours after',
	txtAlertMinutesAfter: 'Minutes after',
	txtAlertSecondsAfter: 'Seconds after',

	pholderAfterBeforeVal: 'Value',
	pholderAlarmDate: 'Alarm date',
	pholderAlarmTime: 'Alarm time',

	pholderNote: 'Note',

	eventPrevNav: 'Show previous instance',
	eventNextNav: 'Show next instance',

	buttonClose: 'Close',
	buttonDuplicate: 'Duplicate',

	txtAllSavedTodo: 'Success: Todo Saved!',
	txtAllSaved: 'Success: Event Saved!',

	txtAllDeletedTodo: 'Success: Todo Deleted!',
	txtAllDeleted: 'Success: Event Deleted!',

	txtNotChooseTodo: 'Error: Have to choose calendar!',
	txtNotChoose: 'Error: Have to choose calendar!',

	txtErrorDates: 'Error: Start date must precede the end date!',
	txtErrorDatesTodo: 'Error: Start date must precede the end date!',

	txtErorInputTodo: 'Unable to save: correct invalid values!',
	txtDateTimeErrorTodo: 'Have to choose date and time!',

	txtErorInput: 'Error: \'unable to save\': correct the highlighted invalid values!',

	txtAlertsH: 'Alerts',
	buttonAlert: 'Clear Alerts',

	altAddEvent: 'Add Event',
	altAddTodo: 'Add Todo',

	loadingCalendars: 'Loading calendars (%act% of %total%) ...',
	unloadingCalendars: 'Unloading calendars ...',

	errUnableSaveBeginCalDAV: 'Error: \'unable to save the event\': %%!',
	errUnableDeleteBeginCalDAV: 'Error: \'unable to delete the event\': %%!',
	CalDAVerrHttp410: 'Event is no longer available at the server',
	errUnableSaveTodoBeginCalDAV: 'Error: \'unable to save the todo\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Error: \'unable to delete todo\': %%!',
	CalDAVerrTodoHttp410: 'Todo is no longer available at the server'
};

localizationCalDAV['es_ES']=	/* Damian Vila <damianvila@gmail.com> */
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'–\' d MMM yyyy}',
	_default_title_format_day_: 'ddd, d MMM yyyy',
	_default_title_format_table_: 'ddd, MMM yyyy',
	_default_column_format_agenda_: 'ddd, d MMM',

	txtCalendar: 'Calendario',
	txtEnabledCalendars: 'Calendars habilitados',
	txtTodo: 'Tarea',
	txtTodoList: 'Lista de tareas',
	txtTodoLists: 'Listas de tareas',
	txtEnabledTodoLists: 'Listas de tareas habilitadas',
	txtSubscribed: 'Suscripciones',
	fullCalendarTable: 'tabla',
	fullCalendarTodayButton: 'hoy',
	fullCalendarAllDay: 'todo el día',
	CalDAVsearch: 'Buscar',
	resourceEnable: 'Habilitar todos los calendarios para este recurso',
	resourceDisable: 'Deshabilitar todos los calendarios para este recurso',
	allEnable: 'Habilitar todos los calendarios',
	allDisable: 'Deshabilitar todos los calendarios',
	timezone: 'Zona horaria',
	txtTimezonePicker: 'Z. horaria:',
	loadingRList: 'Cargando lista de recursos ...',
	renderingE: 'Generando calendarios ...',
	timezoneChange: 'Aplicando cambios de zona horaria ...',
	customTimezone: 'Personalizado (Tiempo local)',
	customRepeat: 'Otra (modificación no soportada)',
	loadPrevMonth: 'Cargar mes anterior',
	loadNextMonth: 'Cargar mes siguiente',
	repeatBoxButton: 'Recurrencia',
	repeatBoxContent: 'es un evento repetitivo.',
	repeatBoxQuestion: '¿Con cuáles eventos quieres trabajar?',
	allEvsButton: 'Todos los eventos',
	allFutureButton: 'Este y los eventos siguientes',
	eventOnlyButton: 'Solo este evento',
	repeatBoxContentTODO: 'es una tarea repetitiva.',
	repeatBoxQuestionTODO: '¿Con qué tareas quieres trabajar?',
	allEvsButtonTODO: 'Todas las tareas',
	allFutureButtonTODO: 'Esta y las futuras tareas',
	eventOnlyButtonTODO: 'Solo esta tarea',
	txtStatus: 'Estado',
	eventAvailability : 'Disponible',
	eventAvailabilityBusy : 'Ocupado',
	eventAvailabilityFree : 'Libre',
	eventType: 'Privacidad',
	eventTypePublic: 'Público',
	eventTypePrivate: 'Privado',
	eventTypeConfidential: 'Confidencial',
	txtPriority: 'Prioridad',
	txtPriorityNone: 'Ninguna',
	txtPriorityLow: 'Baja',
	txtPriorityMedium: 'Media',
	txtPriorityHigh: 'Alta',
	eventURL : 'URL',
	repeatInterval: 'cada',
	repeatDays: 'días',
	repeatWeeks: 'semanas',
	repeatMonths: 'meses',
	repeatYears: 'años',
	repeatChangeTxt: 'ha sido cambiado en el servidor!',
	repeatChangeTxtClose: 'Cierra el formulario y vuelve a abrir el evento',
	repeatTodoChangeTxtClose: 'Cierra el formulario y vuelve a abrir la tarea',
	calendarLoader: 'Recargando ...',
	resizeLoader: 'Redimensionando ...',

	// TODOS
	pholderNameTODO: 'Nombre',
	pholderNewTODO: 'Nueva tarea',
	txtTypeTODO: 'Tipo',
	txtTypeTODONone: 'Simple',
	txtTypeTODOStart: 'Con hora de inicio',
	txtTypeTODODue: 'Con hora de fin',
	txtTypeTODOBoth: 'Con hora de inicio y fin',
	txtDateFromTODO: 'Desde',
	txtDateToTODO: 'Hasta',
	txtCompletedOn: 'Completado en',

	pholderDateFromTODO: 'Fecha desde',
	pholderTimeFromTODO: 'Hora desde',
	pholderDateToTODO: 'Fecha hasta',
	pholderTimeToTODO: 'Hora hasta',
	pholderCompletedOnDate: 'Fecha',
	pholderCompletedOnTime: 'Hora',

	txtStatusFiltersHeaderTODO: 'Filtros',
	txtStatusFiltersFooterTODO: '* completado en o después de %date%',
	txtStatusNeedsActionTODO: 'Necesita atención',
	txtStatusCompletedTODO: 'Completado',
	txtStatusInProcessTODO: 'En progreso',
	txtStatusCancelledTODO: 'Cancelado',
	txtPercentCompletedTODO: 'Completado',

	txtCalendarTODO: 'Calendario',
	txtSelectCalendarTODO: 'Selecciona un calendario',
	txtAlertTODO: 'Alerta',
	txtAlertNoneTODO: 'Ninguno',
	txtAlertMessageTODO: 'Mensaje',
	txtAlertOnDateTODO: 'En la fecha',
	txtAlertWeeksBeforeTODO: 'Semanas antes',
	txtAlertDaysBeforeTODO: 'Días antes',
	txtAlertHoursBeforeTODO: 'Horas antes',
	txtAlertMinutesBeforeTODO: 'Minutos antes',
	txtAlertSecondsBeforeTODO: 'Segundos antes',
	txtAlertWeeksAfterTODO: 'Semanas después',
	txtAlertDaysAfterTODO: 'Días después',
	txtAlertHoursAfterTODO: 'Horas después',
	txtAlertMinutesAfterTODO: 'Minutos después',
	txtAlertSecondsAfterTODO: 'Segundos después',

	pholderAfterBeforeValTODO: 'Valor',
	pholderAlarmDateTODO: 'Fecha de alarma',
	pholderAlarmTimeTODO: 'Hora de alarma',

	pholderNoteTODO: 'Nota',
	txtNoteTODO: 'Nota',

	todoPrevNav: 'Mostrar instancia previa',
	todoNextNav: 'Mostrar siguiente instancia',
	todoUncompletedPrevNav: 'Mostrar instancia previa incompleta',
	todoUncompletedNextNav: 'Mostrar siguiente instancia incompleta',

	buttonSaveTODO: 'Guardar',
	buttonEditTODO: 'Editar',
	buttonDuplicateTODO: 'Duplicar',
	buttonResetTODO: 'Revertir',
	buttonCloseTODO: 'Cerrar',
	buttonDeleteTODO: 'Borrar',

	// EVENTS
	pholderName: 'Nombre',
	pholderNewEvent: 'Nuevo evento',
	txtLocation: 'Lugar',
	pholderLocation: 'Lugar',

	txtAllDay: 'Todo el día',
	from: 'Desde',
	to: 'Hasta',

	pholderDateFrom: 'Fecha desde',
	pholderTimeFrom: 'Hora desde',
	pholderDateTo: 'Fecha hasta',
	pholderTimeTo: 'Hora hasta',

	txtStatusNone: 'No especificado',
	txtStatusTentative: 'Tentativo',
	txtStatusConfirmed: 'Confirmado',
	txtStatusCancelled: 'Cancelado',

	txtRepeat: 'Repetir',
	txtNoRepeat: 'No repetir',
	txtRepeatDay: 'Diariamente',
	txtRepeatWeek: 'Semanalmente',
	txtRepeatWeekend: 'Cada fin de semana',
	txtRepeatMonth: 'Mensualmente',
	txtRepeatTwoWeek: 'Bi-semanalmente',
	txtRepeatYear: 'Anualmente',
	txtRepeatCustomWeek: 'Semanalmente personalizado',
	txtRepeatCustomMonth: 'Mensualmente personalizado',
	txtRepeatCustomYear: 'Anualmente personalizado',
	txtRepeatWork: 'En días de semana',
	txtRepeatOnDate: 'En la fecha',
	txtRepeatAfter: 'Ocurrencias',
	txtRepeatNever: 'Nunca',
	pholderUntilDate: 'Fecha hasta',
	pholderRepeatCount: 'Repetir la cuenta',
	txtRepeatCustomWeekLabel: 'en',
	txtRepeatCustomMonthLabel: 'en los días',
	txtRepeatCustomMonthEvery: 'Cada',
	txtRepeatCustomMonthFirst: 'Primer',
	txtRepeatCustomMonthSecond: 'Segundo',
	txtRepeatCustomMonthThird: 'Tercer',
	txtRepeatCustomMonthFourth: 'Cuarto',
	txtRepeatCustomMonthFifth: 'Quinto',
	txtRepeatCustomMonthLast: 'Último',
	txtRepeatCustomMonthCustom: 'Personalizado',
	txtRepeatCustomMonthMonth: 'Día del mes',
	txtRepeatCustomYearLabel1: 'cada',
	txtRepeatCustomYearLabel2: 'de',

	txtRepeatEnd: 'fin',
	txtEventCalendar: 'Calendario',
	txtSelectCalendar: 'Selecciona un calendario',
	txtAlert: 'Alerta',
	txtAlertNone: 'Ninguno',
	txtAlertMessage: 'Mensaje',
	txtAlertOnDate: 'En la fecha',
	txtAlertWeeksBefore: 'Semanas antes',
	txtAlertDaysBefore: 'Días antes',
	txtAlertHoursBefore: 'Horas antes',
	txtAlertMinutesBefore: 'Minutos antes',
	txtAlertSecondsBefore: 'Segundos antes',
	txtAlertWeeksAfter: 'Semanas después',
	txtAlertDaysAfter: 'Días después',
	txtAlertHoursAfter: 'Horas después',
	txtAlertMinutesAfter: 'Minutos después',
	txtAlertSecondsAfter: 'Segundos después',

	pholderAfterBeforeVal: 'Valor',
	pholderAlarmDate: 'Fecha de alarm',
	pholderAlarmTime: 'Hora de alarma',

	pholderNote: 'Nota',

	eventPrevNav: 'Mostrar instancia previa',
	eventNextNav: 'Mostrar siguiente instancia',

	buttonClose: 'Cerrar',
	buttonDuplicate: 'Duplicar',

	txtAllSavedTodo: 'Éxito: Tarea guardada!',
	txtAllSaved: 'Éxito: Evento guardado!',

	txtAllDeletedTodo: 'Éxito: Tarea borrada!',
	txtAllDeleted: 'Éxito: Evento borrado!',

	txtNotChooseTodo: 'Error: Tienes que elegir un calendario!',
	txtNotChoose: 'Error: Tienes que elegir un calendario!',

	txtErrorDates: 'Error: La fecha de comienzo debe ser anterior a la de fin!',
	txtErrorDatesTodo: 'Error: La fecha de comienzo debe ser anterior a la de fin!',

	txtErorInputTodo: 'Imposible guardar: corrige los valores inválidos!',
	txtDateTimeErrorTodo: 'Debes elegir una fecha y hora!',

	txtErorInput: 'Error: \'imposible guardar\': corrige los valores marcados!',

	txtAlertsH: 'Alertas',
	buttonAlert: 'Limpiar alertas',

	altAddEvent: 'Agregar evento',
	altAddTodo: 'Agregar tarea',

	loadingCalendars: 'Cargando calendarios (%act% de %total%) ...',
	unloadingCalendars: 'Quitando calendarios ...',

	errUnableSaveBeginCalDAV: 'Error: \'imposible guardar el evento\': %%!',
	errUnableDeleteBeginCalDAV: 'Error: \'imposible borrar el evento\': %%!',
	CalDAVerrHttp410: 'El evento ya no está disponible en el servidor',
	errUnableSaveTodoBeginCalDAV: 'Error: \'imposible guardar la tarea\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Error: \'imposible borrar la tarea\': %%!',
	CalDAVerrTodoHttp410: 'La tarea ya no está disponible en el servidor'
};

localizationCalDAV['fr_FR']=	/* thanks John Fischer and Jean-Christophe Bach */
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'–\' d MMM yyyy}',
	_default_title_format_day_: 'ddd, d MMM yyyy',
	_default_title_format_table_: 'ddd, MMM yyyy',
	_default_column_format_agenda_: 'ddd, d MMM',

	txtCalendar: 'Calendrier',
	txtEnabledCalendars: 'Calendriers activés',
	txtTodo: 'À faire',
	txtTodoList: 'Liste des tâches',
	txtTodoLists: 'Listes des tâches',
	txtEnabledTodoLists: 'Listes des tâches activées',
	txtSubscribed: 'Abonnements',
	fullCalendarTable: 'tableau',
	fullCalendarTodayButton: 'aujourd\'hui',
	fullCalendarAllDay: 'Toute la journée',
	CalDAVsearch: 'Recherche',
	resourceEnable: 'Activer tous les calendriers pour cette ressource',
	resourceDisable: 'Désactiver tous les calendriers pour cette ressource',
	allEnable: 'Activer tous les calendriers',
	allDisable: 'Désactiver tous les calendriers',
	timezone: 'Fuseau horaire',
	txtTimezonePicker: 'Fuseau horaire : ',
	loadingRList: 'Chargement de la liste des ressources...',
	renderingE: 'Prévisualisation des calendriers ...',
	timezoneChange: 'Changement de fuseau horaire...',
	customTimezone: 'Personnalisé (heure locale)',
	customRepeat: 'Autre (changement n\'est pas supporté)',
	loadPrevMonth: 'Charger le mois précédent',
	loadNextMonth: 'Charger le mois suivant',
	repeatBoxButton: 'Récurrence',
	repeatBoxContent: 'est un évènement récurrent.',
	repeatBoxQuestion: 'Avec quels évènements voulez-vous travailler ?',
	allEvsButton: 'Tous les évènements',
	allFutureButton: 'Tous les évènements à venir',
	eventOnlyButton: 'Cet évènement seulement',
	repeatBoxContentTODO: 'est une tâche récurrente.',
	repeatBoxQuestionTODO: 'Quelles tâches désirez-vous associer ?',
	allEvsButtonTODO: 'Toutes les tâches',
	allFutureButtonTODO: 'Toutes les tâches futures à faire',
	eventOnlyButtonTODO: 'Cette tâche seulement',
	txtStatus: 'État',
	eventAvailability : 'Disponibilité',
	eventAvailabilityBusy : 'Occupé',
	eventAvailabilityFree : 'Disponible',
	eventType: 'Confidentialité',
	eventTypePublic: 'Public',
	eventTypePrivate: 'Privé',
	eventTypeConfidential: 'Confidentiel',
	txtPriority: 'Priorité',
	txtPriorityNone: 'Aucune',
	txtPriorityLow: 'Basse',
	txtPriorityMedium: 'Moyenne',
	txtPriorityHigh: 'Haute',
	eventURL : 'URL',
	repeatInterval: 'Tous les',
	repeatDays: 'jours',
	repeatWeeks: 'semaines',
	repeatMonths: 'mois',
	repeatYears: 'ans',
	repeatChangeTxt: 'a été modifié sur le serveur !',
	repeatChangeTxtClose: 'Fermer ce formulaire et rouvrir cet évènement',
	repeatTodoChangeTxtClose: 'Fermer la boîte de dialogue et ouvrir à nouveau la tâche',
	calendarLoader: 'Rechargement...',
	resizeLoader: 'Redimensionnement...',

	// TODOS
	pholderNameTODO: 'Nom',
	pholderNewTODO: 'Nouvelle tâche',
	txtTypeTODO: 'Type',
	txtTypeTODONone: 'Simple',
	txtTypeTODOStart: 'Avec date de début',
	txtTypeTODODue: 'Avec date butoir',
	txtTypeTODOBoth: 'Avec des dates de début et de fin',
	txtDateFromTODO: 'De',
	txtDateToTODO: 'À',
	txtCompletedOn: 'Se termine le',

	pholderDateFromTODO: 'Date de',
	pholderTimeFromTODO: 'Heure de',
	pholderDateToTODO: 'Date à',
	pholderTimeToTODO: 'Heure à',
	pholderCompletedOnDate: 'Date',
	pholderCompletedOnTime: 'Heure',

	txtStatusFiltersHeaderTODO: 'Filtres',
	txtStatusFiltersFooterTODO: '* Se termine à ou après le %date%',
	txtStatusNeedsActionTODO: 'En attente d\'action',
	txtStatusCompletedTODO: 'Terminée',
	txtStatusInProcessTODO: 'En cours',
	txtStatusCancelledTODO: 'Annulée',
	txtPercentCompletedTODO: 'Achevée',

	txtCalendarTODO: 'Calendrier',
	txtSelectCalendarTODO: 'Sélection d\'un calendrier',
	txtAlertTODO: 'Alerte',
	txtAlertNoneTODO: 'Vide',
	txtAlertMessageTODO: 'Message',
	txtAlertOnDateTODO: 'à la date',
	txtAlertWeeksBeforeTODO: 'Semaines avant',
	txtAlertDaysBeforeTODO: 'Jours avant',
	txtAlertHoursBeforeTODO: 'Heures avant',
	txtAlertMinutesBeforeTODO: 'Minutes avant',
	txtAlertSecondsBeforeTODO: 'Secondes avant',
	txtAlertWeeksAfterTODO: 'Semaines après',
	txtAlertDaysAfterTODO: 'Jours après',
	txtAlertHoursAfterTODO: 'Heures après',
	txtAlertMinutesAfterTODO: 'Minutes après',
	txtAlertSecondsAfterTODO: 'Secondes après',

	pholderAfterBeforeValTODO: 'Valeur',
	pholderAlarmDateTODO: 'Date de l\'alarme',
	pholderAlarmTimeTODO: 'Heure de l\'alarme',

	pholderNoteTODO: 'Note',
	txtNoteTODO: 'Note',

	todoPrevNav: 'Montrer l\'instance précédente',
	todoNextNav: 'Montrer l\'instance suivante',
	todoUncompletedPrevNav: 'Montrer la précédente instance incomplète',
	todoUncompletedNextNav: 'Montrer l\'instance suivante incomplète',

	buttonSaveTODO: 'Enregistrer',
	buttonEditTODO: 'Éditer',
	buttonDuplicateTODO: 'Dupliquer',
	buttonResetTODO: 'Revenir',
	buttonCloseTODO: 'Fermer',
	buttonDeleteTODO: 'Effacer',

	// EVENTS
	pholderName: 'Nom',
	pholderNewEvent: 'Nouvel évènement',
	txtLocation: 'Lieu',
	pholderLocation: 'Lieu',

	txtAllDay: 'Toute la journée',
	from: 'De',
	to: 'À',

	pholderDateFrom: 'Date de',
	pholderTimeFrom: 'Heure de',
	pholderDateTo: 'Date à',
	pholderTimeTo: 'Heure à',

	txtStatusNone: 'Non spécifié',
	txtStatusTentative: 'Tentative',
	txtStatusConfirmed: 'Confirmé',
	txtStatusCancelled: 'Annulé',

	txtRepeat: 'Répéter',
	txtNoRepeat: 'Ne pas répéter',
	txtRepeatDay: 'Quotidien',
	txtRepeatWeek: 'Hebdomadaire',
	txtRepeatWeekend: 'Tous les weekends',
	txtRepeatMonth: 'Mensuel',
	txtRepeatTwoWeek: 'Bi-mensuel',
	txtRepeatYear: 'Annuel',
	txtRepeatCustomWeek: 'Hebdomadaire personnalisé',
	txtRepeatCustomMonth: 'Mensuel personnalisé',
	txtRepeatCustomYear: 'Annuel personnalisé',
	txtRepeatWork: 'Tous les jours ouvrables',
	txtRepeatOnDate: 'À la date',
	txtRepeatAfter: 'Occurrences',
	txtRepeatNever: 'Jamais',
	pholderUntilDate: 'Jusqu\'à la date',
	pholderRepeatCount: 'nombre de répétitions',
	txtRepeatCustomWeekLabel: 'Le',
	txtRepeatCustomMonthLabel: 'Les jours',
	txtRepeatCustomMonthEvery: 'Tous',
	txtRepeatCustomMonthFirst: 'Premier',
	txtRepeatCustomMonthSecond: 'Deuxième',
	txtRepeatCustomMonthThird: 'Troisième',
	txtRepeatCustomMonthFourth: 'Quatrième',
	txtRepeatCustomMonthFifth: 'Cinquième',
	txtRepeatCustomMonthLast: 'Dernier',
	txtRepeatCustomMonthCustom: 'Personnalisé',
	txtRepeatCustomMonthMonth: 'Jour du mois',
	txtRepeatCustomYearLabel1: 'Tous',
	txtRepeatCustomYearLabel2: 'De',

	txtRepeatEnd: 'Fin',
	txtEventCalendar: 'Calendrier',
	txtSelectCalendar: 'Selectonner un calendrier',
	txtAlert: 'Alerte',
	txtAlertNone: 'Vide',
	txtAlertMessage: 'Message',
	txtAlertOnDate: 'À la date',
	txtAlertWeeksBefore: 'Semaines avant',
	txtAlertDaysBefore: 'Jours avant',
	txtAlertHoursBefore: 'Heures avant',
	txtAlertMinutesBefore: 'Minutes avant',
	txtAlertSecondsBefore: 'Secondes avant',
	txtAlertWeeksAfter: 'Semaines après',
	txtAlertDaysAfter: 'Jours après',
	txtAlertHoursAfter: 'Heures après',
	txtAlertMinutesAfter: 'Minutes après',
	txtAlertSecondsAfter: 'Secondes après',

	pholderAfterBeforeVal: 'Valeur',
	pholderAlarmDate: 'Date de l\'alarme',
	pholderAlarmTime: 'Heure de l\'alarme',

	pholderNote: 'Note',

	eventPrevNav: 'Montrer la précédente instance',
	eventNextNav: 'Montrer l\'instance suivante',

	buttonClose: 'Fermer',
	buttonDuplicate: 'Dupliquer',

	txtAllSavedTodo: 'Succès : Tâche enregistrée !',
	txtAllSaved: 'Succès : Évènement enregistré !',

	txtAllDeletedTodo: 'Succès : Tâche effacée !',
	txtAllDeleted: 'Succès : Évènement effacé !',

	txtNotChooseTodo: 'Erreur : il faut choisir un calendrier !',
	txtNotChoose: 'Erreur : il faut choisir un calendrier !',

	txtErrorDates: 'Erreur : La date de début doit précéder la date de fin !',
	txtErrorDatesTodo: 'Erreur : La date de début doit précéder la date de fin !',

	txtErorInputTodo: 'Impossible d\'enregistrer : corrigez les valeurs non valides !',
	txtDateTimeErrorTodo: 'Il faut choisir une date et une heure !',

	txtErorInput: 'Erreur : \'Impossible d\'enregistrer\' : corrigez les valeurs surlignées !',

	txtAlertsH: 'Alertes',
	buttonAlert: 'Vider les Alertes',

	altAddEvent: 'Ajouter un évènement',
	altAddTodo: 'Ajouter une tâche',

	loadingCalendars: 'Chargement des calendriers (%act% sur %total%) ...',
	unloadingCalendars: 'Déchargement des calendriers ...',

	errUnableSaveBeginCalDAV: 'Erreur : \'impossible d\'enregistrer l\'évènement\' : %% !',
	errUnableDeleteBeginCalDAV: 'Erreur : \'impossible d\'effacer l\'évènement\' : %% !',
	CalDAVerrHttp410: 'Évènement non présent sur le serveur',
	errUnableSaveTodoBeginCalDAV: 'Erreur : \'impossible de sauvegarder la tâche\' : %% !',
	errUnableDeleteTodoBeginCalDAV: 'Erreur : \'impossible de supprimer la tâche\' : %% !',
	CalDAVerrTodoHttp410: 'La tâche n\'est plus disponible sur le serveur'
};

localizationCalDAV['hu_HU']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	_default_title_format_month_: 'yyyy MMM',
	_default_title_format_week_: 'yyyy MMM d{ \'–\'[ yyyy][ MMM] d}',
	_default_title_format_day_: 'yyyy MMM d, ddd',
	_default_title_format_table_: 'yyyy MMM, ddd',
	_default_column_format_agenda_: 'ddd, MMM d',

	txtCalendar: 'Naptár',
	txtEnabledCalendars: 'Engedélyezett naptárak',
	txtTodo: 'Feladat',
	txtTodoList: 'Feladat lista',
	txtTodoLists: 'Feladat listák',
	txtEnabledTodoLists: 'Engedélyezett feladat listák',
	txtSubscribed: 'Előfizetések',
	fullCalendarTable: 'táblázat',
	fullCalendarTodayButton: 'ma',
	fullCalendarAllDay: 'eg. napi',
	CalDAVsearch: 'Keresés',
	resourceEnable: 'A forrás minden naptára megjelenítése',
	resourceDisable: 'A forrás minden naptára elrejtése',
	allEnable: 'Minden naptár megjelenítése',
	allDisable: 'Minden naptár elrejtése',
	timezone: 'Időzóna',
	txtTimezonePicker: 'Időzóna:',
	loadingRList: 'Forrás lista betöltése ...',
	renderingE: 'Naptárak megjelenítése ...',
	timezoneChange: 'Időzónaváltás alkalmazása ...',
	customTimezone: 'Egyéni (Helyi idő)',
	customRepeat: 'Egyéb (módosítás nem támogatott)',
	loadPrevMonth: 'Előző hónap betöltése',
	loadNextMonth: 'Következő hónap betöltése',
	repeatBoxButton: 'Ismétlődés',
	repeatBoxContent: 'ismétlődő esemény.',
	repeatBoxQuestion: 'Melyik eseménnyel szeretne dolgozni?',
	allEvsButton: 'Minden eseménnyel',
	allFutureButton: 'Ez és az összes jövőbeli eseménnyel',
	eventOnlyButton: 'Csak ezzel az eseménnyel',
	repeatBoxContentTODO: 'ismétlődő feladat.',
	repeatBoxQuestionTODO: 'Melyik feladattal szeretne dolgozni?',
	allEvsButtonTODO: 'Minden feladattal',
	allFutureButtonTODO: 'Ez és az összes jövőbeli feladattal',
	eventOnlyButtonTODO: 'Csak ezzel a feladattal',
	txtStatus: 'Állapot',
	eventAvailability : 'Elérhetőség',
	eventAvailabilityBusy : 'Elfoglalt',
	eventAvailabilityFree : 'Szabad',
	eventType: 'Adatvédelem',
	eventTypePublic: 'Nyilvános',
	eventTypePrivate: 'Magán',
	eventTypeConfidential: 'Bizalmas',
	txtPriority: 'Prioritás',
	txtPriorityNone: 'Semmilyen',
	txtPriorityLow: 'Alacsony',
	txtPriorityMedium: 'Közepes',
	txtPriorityHigh: 'Magas',
	eventURL : 'URL',
	repeatInterval: 'minden',
	repeatDays: 'nap',
	repeatWeeks: 'hét',
	repeatMonths: 'hónap',
	repeatYears: 'év',
	repeatChangeTxt: 'megváltozott a szerveren!',
	repeatChangeTxtClose: 'Zárja be az űrlapot, és nyissa meg az eseményt újra',
	repeatTodoChangeTxtClose: 'Zárja be az űrlapot, és nyissa meg a feladatot újra',
	calendarLoader: 'Újratöltés ...',
	resizeLoader: 'Átméretezés ...',

	// TODOS
	pholderNameTODO: 'Cím',
	pholderNewTODO: 'Új feladat',
	txtTypeTODO: 'Típus',
	txtTypeTODONone: 'Egyszerű',
	txtTypeTODOStart: 'Kezdet időpontal',
	txtTypeTODODue: 'Határidő időpontal',
	txtTypeTODOBoth: 'Kezdet és határidő időpontal',
	txtDateFromTODO: 'Kezdet',
	txtDateToTODO: 'Határidő',
	txtCompletedOn: 'Befejeződött',

	pholderDateFromTODO: 'Kezdet dátum',
	pholderTimeFromTODO: 'Kezdet időpont',
	pholderDateToTODO: 'Határidő dátum',
	pholderTimeToTODO: 'Határidő időpont',
	pholderCompletedOnDate: 'Dátum',
	pholderCompletedOnTime: 'Időpont',

	txtStatusFiltersHeaderTODO: 'Szűrők',
	txtStatusFiltersFooterTODO: '* befejezett feladatok %date% és később',
	txtStatusNeedsActionTODO: 'Foglalkozni kell vele',
	txtStatusCompletedTODO: 'Befejezve',
	txtStatusInProcessTODO: 'Folyamatban',
	txtStatusCancelledTODO: 'Megszakítva',
	txtPercentCompletedTODO: 'Befejezve',

	txtCalendarTODO: 'Naptár',
	txtSelectCalendarTODO: 'Válassz egy naptárat',
	txtAlertTODO: 'Emlékeztető',
	txtAlertNoneTODO: 'Nincs',
	txtAlertMessageTODO: 'Értesítés',
	txtAlertOnDateTODO: 'Egyéni',
	txtAlertWeeksBeforeTODO: 'Héttel előtte',
	txtAlertDaysBeforeTODO: 'Nappal előtte',
	txtAlertHoursBeforeTODO: 'Órával előtte',
	txtAlertMinutesBeforeTODO: 'Perccel előtte',
	txtAlertSecondsBeforeTODO: 'Másodperccel előtte',
	txtAlertWeeksAfterTODO: 'Héttel után',
	txtAlertDaysAfterTODO: 'Nappal után',
	txtAlertHoursAfterTODO: 'Órával után',
	txtAlertMinutesAfterTODO: 'Perccel után',
	txtAlertSecondsAfterTODO: 'Másodperccel után',

	pholderAfterBeforeValTODO: 'Érték',
	pholderAlarmDateTODO: 'Emlékeztető dátum',
	pholderAlarmTimeTODO: 'Emlékeztető időpont',

	pholderNoteTODO: 'Megjegyzés',
	txtNoteTODO: 'Megjegyzés',

	todoPrevNav: 'Mutasd az előző példányt',
	todoNextNav: 'Mutasd a következő példányt',
	todoUncompletedPrevNav: 'Mutasd az előző befejezetlen példányt',
	todoUncompletedNextNav: 'Mutasd a következő befejezetlen példányt',

	buttonSaveTODO: 'Mentés',
	buttonEditTODO: 'Szerkesztés',
	buttonDuplicateTODO: 'Másolat',
	buttonResetTODO: 'Visszaállítás',
	buttonCloseTODO: 'Bezárás',
	buttonDeleteTODO: 'Törlés',

	// EVENTS
	pholderName: 'Cím',
	pholderNewEvent: 'Új esemény',
	txtLocation: 'Hely',
	pholderLocation: 'Hely',

	txtAllDay: 'Egész napos',
	from: 'Kezdet',
	to: 'Vége',

	pholderDateFrom: 'Kezdet dátum',
	pholderTimeFrom: 'Kezdet időpont',
	pholderDateTo: 'Határidő dátum',
	pholderTimeTo: 'Határidő időpont',

	txtStatusNone: 'Nem meghatározott',
	txtStatusTentative: 'Feltételes',
	txtStatusConfirmed: 'Megerősített',
	txtStatusCancelled: 'Törölt',

	txtRepeat: 'Ismétlés',
	txtNoRepeat: 'Nem ismétlődik',
	txtRepeatDay: 'Naponta',
	txtRepeatWeek: 'Hetente',
	txtRepeatWeekend: 'Minden hétköznap',
	txtRepeatMonth: 'Havonta',
	txtRepeatTwoWeek: 'Kéthetente',
	txtRepeatYear: 'Évente',
	txtRepeatCustomWeek: 'Egyéni hetente',
	txtRepeatCustomMonth: 'Egyéni havonta',
	txtRepeatCustomYear: 'Egyéni évente',
	txtRepeatWork: 'Minden munkanapon',
	txtRepeatOnDate: 'Egyéni',
	txtRepeatAfter: 'Ismétlődés után',
	txtRepeatNever: 'Soha',
	pholderUntilDate: 'Dátum-ig',
	pholderRepeatCount: 'Ismétlésszám',
	txtRepeatCustomWeekLabel: '/',
	txtRepeatCustomMonthLabel: '/',
	txtRepeatCustomMonthEvery: 'Minden',
	txtRepeatCustomMonthFirst: 'Első',
	txtRepeatCustomMonthSecond: 'Második',
	txtRepeatCustomMonthThird: 'Harmadik',
	txtRepeatCustomMonthFourth: 'Negyedik',
	txtRepeatCustomMonthFifth: 'Ötodik',
	txtRepeatCustomMonthLast: 'Utolsó',
	txtRepeatCustomMonthCustom: 'Egyéni',
	txtRepeatCustomMonthMonth: 'Nap a hónapban',
	txtRepeatCustomYearLabel1: 'minden',
	txtRepeatCustomYearLabel2: '/',
	txtRepeatEnd: 'vége',

	txtEventCalendar: 'Naptár',
	txtSelectCalendar: 'Válassz egy naptárat',
	txtAlert: 'Emlékeztető',
	txtAlertNone: 'Nincs',
	txtAlertMessage: 'Értesítés',
	txtAlertOnDate: 'Egyéni',
	txtAlertWeeksBefore: 'Héttel előtte',
	txtAlertDaysBefore: 'Nappal előtte',
	txtAlertHoursBefore: 'Órával előtte',
	txtAlertMinutesBefore: 'Perccel előtte',
	txtAlertSecondsBefore: 'Másodperccel előtte',
	txtAlertWeeksAfter: 'Héttel után',
	txtAlertDaysAfter: 'Nappal után',
	txtAlertHoursAfter: 'Órával után',
	txtAlertMinutesAfter: 'Perccel után',
	txtAlertSecondsAfter: 'Másodperccel után',

	pholderAfterBeforeVal: 'Érték',
	pholderAlarmDate: 'Emlékeztető dátum',
	pholderAlarmTime: 'Emlékeztető időpont',

	pholderNote: 'Megjegyzés',

	eventPrevNav: 'Mutasd az előző példányt',
	eventNextNav: 'Mutasd a következő befejezetlen példányt',

	buttonClose: 'Bezárás',
	buttonDuplicate: 'Másolat',

	txtAllSavedTodo: 'A feladat sikeresen elmentve!',
	txtAllSaved: 'Az esemény sikeresen elmentve!',

	txtAllDeletedTodo: 'A feladat sikeresen törölve!',
	txtAllDeleted: 'Az esemény sikeresen törölve!',

	txtNotChooseTodo: 'Hiba: naptárat kell választani!',
	txtNotChoose: 'Hiba: naptárat kell választani!',

	txtErrorDates: 'Hiba: a kezdési dátumnak korábbinak kell lennie a befejezési dátumnál!',
	txtErrorDatesTodo: 'Hiba: a kezdési dátumnak korábbinak kell lennie a befejezési dátumnál!',

	txtErorInputTodo: 'Hiba: javítsa ki a kijelölt érvénytelen értékeket!',
	txtDateTimeErrorTodo: 'Hiba: ki kell választani a dátumot és az időt!',

	txtErorInput: 'Hiba: javítsa ki a kijelölt érvénytelen értékeket!',

	txtAlertsH: 'Emlékeztetők',
	buttonAlert: 'Emlékeztetők eltávolítása',

	altAddEvent: 'Új esemény',
	altAddTodo: 'Új feladat',

	loadingCalendars: 'Naptárak betöltése (%act%/%total%) ...',
	unloadingCalendars: 'Naptárak eltávolítása ...', // better translation?

	errUnableSaveBeginCalDAV: 'Hiba: \'nem sikerült az esemény elmentése\': %%!',
	errUnableDeleteBeginCalDAV: 'Hiba: \'nem sikerült az esemény törlése\': %%!',
	CalDAVerrHttp410: 'az esemény már nem elérhető a szerveren',
	errUnableSaveTodoBeginCalDAV: 'Hiba: \'nem sikerült a feladat elmentése\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Hiba: \'nem sikerült a feladat törlése\': %%!',
	CalDAVerrTodoHttp410: 'a feladat már nem elérhető a szerveren'
};

localizationCalDAV['it_IT']=	/* thanks Luca Ferrario */
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'–\' d MMM yyyy}',
	_default_title_format_day_: 'ddd, d MMM yyyy',
	_default_title_format_table_: 'ddd, MMM yyyy',
	_default_column_format_agenda_: 'ddd, d MMM',

	txtCalendar: 'Calendario',
	txtEnabledCalendars: 'Calendari abilitati',
	txtTodo: 'Attività',
	txtTodoList: 'Attività',
	txtTodoLists: 'Liste',
	txtEnabledTodoLists: 'Attività abilitate',
	txtSubscribed: 'Iscrizioni',
	fullCalendarTable: 'tabella',
	fullCalendarTodayButton: 'oggi',
	fullCalendarAllDay: 'tutto il giorno',
	CalDAVsearch: 'Cerca',
	resourceEnable: 'Abilita tutti i calendari in questa risorsa',
	resourceDisable: 'Disabilita tutti i calendari in questa risorsa',
	allEnable: 'Abilita tutti i calendari',
	allDisable: 'Disabilita tutti i calendari',
	timezone: 'Fuso orario',
	txtTimezonePicker: 'Fuso orario:',
	loadingRList: 'Caricamento delle risorse in corso ...',
	renderingE: 'Elaborazione dei calendari in corso ...',
	timezoneChange: 'Applicazione nuovo fuso orario ...',
	customTimezone: 'Personalizzato (Ora Locale)',
	customRepeat: 'Altro (modifica non supportata)',
	loadPrevMonth: 'Carica mese precedente',
	loadNextMonth: 'Carica mese successivo',
	repeatBoxButton: 'Ripeti',
	repeatBoxContent: 'è un evento con ripetizione.',
	repeatBoxQuestion: 'Su quali eventi desideri lavorare?',
	allEvsButton: 'Tutti gli eventi',
	allFutureButton: 'Questo e tutti gli eventi futuri',
	eventOnlyButton: 'Soltanto questo evento',
	repeatBoxContentTODO: 'è un\'attività ripetuta.',
	repeatBoxQuestionTODO: 'Su quali attività vorresti lavorare?',
	allEvsButtonTODO: 'Tutte le attività',
	allFutureButtonTODO: 'Questa e tutte le future attività',
	eventOnlyButtonTODO: 'Soltanto questa attività',
	txtStatus: 'Stato',
	eventAvailability : 'Disponibilità',
	eventAvailabilityBusy : 'Occupato',
	eventAvailabilityFree : 'Libero',
	eventType: 'Privacy',
	eventTypePublic: 'Pubblico',
	eventTypePrivate: 'Privato',
	eventTypeConfidential: 'Confidenziale',
	txtPriority: 'Priorità',
	txtPriorityNone: 'Nessuna',
	txtPriorityLow: 'Bassa',
	txtPriorityMedium: 'Media',
	txtPriorityHigh: 'Alta',
	eventURL : 'URL',
	repeatInterval: 'Tutti',
	repeatDays: 'giorni',
	repeatWeeks: 'settimane',
	repeatMonths: 'mesi',
	repeatYears: 'anni',
	repeatChangeTxt: 'è stato modificato sul server!',
	repeatChangeTxtClose: 'Chiudi il form e apri nuovamente l\'evento',
	repeatTodoChangeTxtClose: 'Chiudi e riapri l\'attività',
	calendarLoader: 'Aggiornamento ...',
	resizeLoader: 'Ridimensionamento ...',

	// TODOS
	pholderNameTODO: 'Nome',
	pholderNewTODO: 'Nuova Attività',
	txtTypeTODO: 'Tipo',
	txtTypeTODONone: 'Semplice',
	txtTypeTODOStart: 'Con orario d\'inizio',
	txtTypeTODODue: 'Con orario di termine',
	txtTypeTODOBoth: 'Con orari di inizio e termine',
	txtDateFromTODO: 'Da',
	txtDateToTODO: 'A',
	txtCompletedOn: 'Completato il',

	pholderDateFromTODO: 'Dal giorno',
	pholderTimeFromTODO: 'Dall ore',
	pholderDateToTODO: 'Al giorno',
	pholderTimeToTODO: 'Alle ore',
	pholderCompletedOnDate: 'Data',
	pholderCompletedOnTime: 'Ora',

	txtStatusFiltersHeaderTODO: 'Filtri',
	txtStatusFiltersFooterTODO: '* completato dal giorno %date%',
	txtStatusNeedsActionTODO: 'Azione richiesta',
	txtStatusCompletedTODO: 'Completato',
	txtStatusInProcessTODO: 'In corso',
	txtStatusCancelledTODO: 'Annullato',
	txtPercentCompletedTODO: 'Completato',

	txtCalendarTODO: 'Calendario',
	txtSelectCalendarTODO: 'Seleziona un calendario',
	txtAlertTODO: 'Avviso',
	txtAlertNoneTODO: 'Nessuno',
	txtAlertMessageTODO: 'Messaggio',
	txtAlertOnDateTODO: 'Il giorno',
	txtAlertWeeksBeforeTODO: 'Settimane prima',
	txtAlertDaysBeforeTODO: 'Giorni prima',
	txtAlertHoursBeforeTODO: 'Ore prima',
	txtAlertMinutesBeforeTODO: 'Minuti prima',
	txtAlertSecondsBeforeTODO: 'Secondi prima',
	txtAlertWeeksAfterTODO: 'Settimane dopo',
	txtAlertDaysAfterTODO: 'Giorni dopo',
	txtAlertHoursAfterTODO: 'Ore dopo',
	txtAlertMinutesAfterTODO: 'Minuti dopo',
	txtAlertSecondsAfterTODO: 'Secondi dopo',

	pholderAfterBeforeValTODO: 'Valore',
	pholderAlarmDateTODO: 'Data sveglia',
	pholderAlarmTimeTODO: 'Orario sveglia',

	pholderNoteTODO: 'Nota',
	txtNoteTODO: 'Nota',

	todoPrevNav: 'Vai all\'attività precedente',
	todoNextNav: 'Vai all\'attività successiva',
	todoUncompletedPrevNav: 'Vai all\'attività non completata precedente',
	todoUncompletedNextNav: 'Vai all\'attività non completata successiva',

	buttonSaveTODO: 'Salva',
	buttonEditTODO: 'Modifica',
	buttonDuplicateTODO: 'Duplica',
	buttonResetTODO: 'Annulla',
	buttonCloseTODO: 'Chiudi',
	buttonDeleteTODO: 'Elimina',

	// EVENTS
	pholderName: 'Nome',
	pholderNewEvent: 'Nuovo Evento',
	txtLocation: 'Luogo',
	pholderLocation: 'Luogo',

	txtAllDay: 'Tutto il giorno',
	from: 'Da',
	to: 'A',

	pholderDateFrom: 'Dal giorno',
	pholderTimeFrom: 'Dalle ore',
	pholderDateTo: 'Al giorno',
	pholderTimeTo: 'Alle ore',

	txtStatusNone: 'Non specificato',
	txtStatusTentative: 'Provvisorio',
	txtStatusConfirmed: 'Confermato',
	txtStatusCancelled: 'Annullato',

	txtRepeat: 'Ripeti',
	txtNoRepeat: 'Non ripetere',
	txtRepeatDay: 'Quotidianamente',
	txtRepeatWeek: 'Settimanalmente',
	txtRepeatWeekend: 'Ogni weekend',
	txtRepeatMonth: 'Mensilmente',
	txtRepeatTwoWeek: 'Bi-settimanalmente',
	txtRepeatYear: 'Annualmente',
	txtRepeatCustomWeek: 'Settimanalmente personalizzato',
	txtRepeatCustomMonth: 'Mensilmente personalizzato',
	txtRepeatCustomYear: 'Annualmente personalizzato',
	txtRepeatWork: 'Tutti i giorni lavorativi',
	txtRepeatOnDate: 'Il giorno',
	txtRepeatAfter: 'Ripetizioni',
	txtRepeatNever: 'Mai',
	pholderUntilDate: 'Fino alla data',
	pholderRepeatCount: 'Numero ripetizioni',
	txtRepeatCustomWeekLabel: 'Il',
	txtRepeatCustomMonthLabel: 'I giorni',
	txtRepeatCustomMonthEvery: 'Ogni',
	txtRepeatCustomMonthFirst: 'Primo',
	txtRepeatCustomMonthSecond: 'Secondo',
	txtRepeatCustomMonthThird: 'Terzo',
	txtRepeatCustomMonthFourth: 'Quarto',
	txtRepeatCustomMonthFifth: 'Quinto',
	txtRepeatCustomMonthLast: 'Ultimo',
	txtRepeatCustomMonthCustom: 'Personalizzato',
	txtRepeatCustomMonthMonth: 'Giorno del mese',
	txtRepeatCustomYearLabel1: 'Ogni',
	txtRepeatCustomYearLabel2: 'Di',

	txtRepeatEnd: 'Fine',
	txtEventCalendar: 'Calendario',
	txtSelectCalendar: 'Seleziona un calendario',
	txtAlert: 'Avviso',
	txtAlertNone: 'Nessuno',
	txtAlertMessage: 'Messaggio',
	txtAlertOnDate: 'Il giorno',
	txtAlertWeeksBefore: 'Settimane prima',
	txtAlertDaysBefore: 'Giorni prima',
	txtAlertHoursBefore: 'Ore prima',
	txtAlertMinutesBefore: 'Minuti prima',
	txtAlertSecondsBefore: 'Secondi prima',
	txtAlertWeeksAfter: 'Settimane dopo',
	txtAlertDaysAfter: 'Giorni dopo',
	txtAlertHoursAfter: 'Ore dopo',
	txtAlertMinutesAfter: 'Minuti dopo',
	txtAlertSecondsAfter: 'Secondi dopo',

	pholderAfterBeforeVal: 'Valore',
	pholderAlarmDate: 'Data sveglia',
	pholderAlarmTime: 'Orario sveglia',

	pholderNote: 'Nota',

	eventPrevNav: 'Vai all\'evento precedente',
	eventNextNav: 'Vai all\'evento successivo',

	buttonClose: 'Chiudi',
	buttonDuplicate: 'Duplica',

	txtAllSavedTodo: 'Successo: Attività Salvata!',
	txtAllSaved: 'Successo: Evento Salvato!',

	txtAllDeletedTodo: 'Successo: Attività Eliminata!',
	txtAllDeleted: 'Successo: Evento Eliminato!',

	txtNotChooseTodo: 'Errore: è necessario selezionare un calendario!',
	txtNotChoose: 'Errore: è necessario selezionare un calendario!',

	txtErrorDates: 'Errore: la data di inizio deve essere antecedente alla data di fine!',
	txtErrorDatesTodo: 'Errore: la data di inizio deve essere antecedente alla data di fine!',

	txtErorInputTodo: 'Impossibile salvare: correggere i valori non validi!',
	txtDateTimeErrorTodo: 'E\' necessario selezionare data e ora',

	txtErorInput: 'Errore: \'impossibile salvare\': correggere i valori non validi evidenziati!',

	txtAlertsH: 'Avvisi',
	buttonAlert: 'Cancella avvisi',

	altAddEvent: 'Aggiungi Evento',
	altAddTodo: 'Aggiungi Attività',

	loadingCalendars: 'Caricamento calendari in corso (%act% di %total%) ...',
	unloadingCalendars: 'Chiusura calendari...',

	errUnableSaveBeginCalDAV: 'Errore: \'impossibile salvare l\'evento\': %%!',
	errUnableDeleteBeginCalDAV: 'Error: \'impossibile eliminare l\'evento\': %%!',
	CalDAVerrHttp410: 'L\'evento non risulta più disponibile sul server',
	errUnableSaveTodoBeginCalDAV: 'Errore: \'impossibile salvare l\'attività\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Errore: \'impossibile eliminare l\'attività\': %%!',
	CalDAVerrTodoHttp410: 'L\'attività non risulta più disponibile sul server'
};

localizationCalDAV['ja_JP']=	/* Muimu Nakayama */
{
	_default_title_format_month_: 'yyyy年 MMM',
	_default_title_format_week_: 'yyyy年 MMM d日{ \'–\'[ yyyy年][ MMM] d日}',
	_default_title_format_day_: 'yyyy年 MMM d日（dddd）',
	_default_title_format_table_: 'yyyy年 MMM, dddd',
	_default_column_format_agenda_: 'MMM d日（ddd）',

	txtCalendar: 'カレンダー',
	txtEnabledCalendars: '有効なカレンダー',
	txtTodo: 'ToDo',
	txtTodoList: 'ToDoリスト',
	txtTodoLists: 'ToDoリスト',
	txtEnabledTodoLists: '有効なToDoリスト',
	txtSubscribed: '購読',
	fullCalendarTable: '表',
	fullCalendarTodayButton: '今日',
	fullCalendarAllDay: '終日',
	CalDAVsearch: '検索',
	resourceEnable: 'このリソースの全てのカレンダーを有効にする',
	resourceDisable: 'このリソースの全てのカレンダーを無効にする',
	allEnable: '全てのカレンダーを有効にする',
	allDisable: '全てのカレンダーを無効にする',
	timezone: 'タイムゾーン',
	txtTimezonePicker: 'タイムゾーン:',
	loadingRList: 'リソースのリストを読み込み中 ...',
	renderingE: 'カレンダーを表示中 ...',
	timezoneChange: 'タイムゾーンの変更を適用中 ...',
	customTimezone: 'カスタム (ローカルタイム)',
	customRepeat: 'その他（修正はサポートされません）',
	loadPrevMonth: '前月を読み込み',
	loadNextMonth: '次月を読み込み',
	repeatBoxButton: '繰り返し',
	repeatBoxContent: 'は繰り返しの予定です。',
	repeatBoxQuestion: 'どのイベントを処理しますか?',
	allEvsButton: '全てのイベント',
	allFutureButton: 'このイベントと今後の全てのイベント',
	eventOnlyButton: 'このイベントのみ',
	repeatBoxContentTODO: 'は繰り返しのToDoです。',
	repeatBoxQuestionTODO: 'どのToDoを処理しますか?',
	allEvsButtonTODO: 'すべてのToDo',
	allFutureButtonTODO: 'このToDoと今後の全てのToDo',
	eventOnlyButtonTODO: 'このToDoのみ',
	txtStatus: '状態',
	eventAvailability : '空き状況',
	eventAvailabilityBusy : '予定あり',
	eventAvailabilityFree : '空き',
	eventType: 'プライバシー',
	eventTypePublic: '公開',
	eventTypePrivate: '非公開',
	eventTypeConfidential: '限定公開',
	txtPriority: '優先度',
	txtPriorityNone: 'なし',
	txtPriorityLow: '低',
	txtPriorityMedium: '中',
	txtPriorityHigh: '高',
	eventURL : 'URL',
	repeatInterval: '間隔',
	repeatDays: '日毎',
	repeatWeeks: '週毎',
	repeatMonths: '月毎',
	repeatYears: '年毎',
	repeatChangeTxt: 'はサーバ上で変更されました!',
	repeatChangeTxtClose: 'フォームを閉じて，イベントを開き直してください',
	repeatTodoChangeTxtClose: 'フォームを閉じて，ToDoを開き直してください',
	calendarLoader: '再読み込み中 ...',
	resizeLoader: 'サイズ変更中 ...',

	// TODOS
	pholderNameTODO: '名前',
	pholderNewTODO: '新しいToDo',
	txtTypeTODO: '種類',
	txtTypeTODONone: 'なし',
	txtTypeTODOStart: '開始時刻あり',
	txtTypeTODODue: '締切時刻あり',
	txtTypeTODOBoth: '開始・締切時刻あり',
	txtDateFromTODO: '自',
	txtDateToTODO: '至',
	txtCompletedOn: '完了',

	pholderDateFromTODO: '日付 自',
	pholderTimeFromTODO: '時刻 自',
	pholderDateToTODO: '日付 至',
	pholderTimeToTODO: '時刻 至',
	pholderCompletedOnDate: '日付',
	pholderCompletedOnTime: '時刻',

	txtStatusFiltersHeaderTODO: 'フィルター',
	txtStatusFiltersFooterTODO: '* %date% 以降に完了',
	txtStatusNeedsActionTODO: '行動が必要',
	txtStatusCompletedTODO: '完了済',
	txtStatusInProcessTODO: '進行中',
	txtStatusCancelledTODO: 'キャンセル',
	txtPercentCompletedTODO: '完了',

	txtCalendarTODO: 'カレンダー',
	txtSelectCalendarTODO: 'カレンダーを選択',
	txtAlertTODO: '通知',
	txtAlertNoneTODO: 'なし',
	txtAlertMessageTODO: 'メッセージ',
	txtAlertOnDateTODO: '日付指定',
	txtAlertWeeksBeforeTODO: '次の週前',
	txtAlertDaysBeforeTODO: '次の日前',
	txtAlertHoursBeforeTODO: '次の時間前',
	txtAlertMinutesBeforeTODO: '次の分前',
	txtAlertSecondsBeforeTODO: '次の秒前',
	txtAlertWeeksAfterTODO: '次の週後',
	txtAlertDaysAfterTODO: '次の日後',
	txtAlertHoursAfterTODO: '次の時間後',
	txtAlertMinutesAfterTODO: '次の分後',
	txtAlertSecondsAfterTODO: '次の秒後',

	pholderAfterBeforeValTODO: '値',
	pholderAlarmDateTODO: '通知 日付',
	pholderAlarmTimeTODO: '通知 時刻',

	pholderNoteTODO: 'メモ',
	txtNoteTODO: 'メモ',

	todoPrevNav: '１つ前を表示',
	todoNextNav: '１つ後を表示',
	todoUncompletedPrevNav: '１つ前の未完了を表示',
	todoUncompletedNextNav: '１つ後の未完了を表示',

	buttonSaveTODO: '保存',
	buttonEditTODO: '編集',
	buttonDuplicateTODO: '複製',
	buttonResetTODO: '戻す',
	buttonCloseTODO: '閉じる',
	buttonDeleteTODO: '削除',

	// EVENTS
	pholderName: '名前',
	pholderNewEvent: '新しいイベント',
	txtLocation: '場所',
	pholderLocation: '場所',

	txtAllDay: '終日',
	from: '自',
	to: '至',

	pholderDateFrom: '日付 自',
	pholderTimeFrom: '時刻 自',
	pholderDateTo: '日付 至',
	pholderTimeTo: '時刻 至',

	txtStatusNone: '指定なし',
	txtStatusTentative: '仮設定',
	txtStatusConfirmed: '確認済み',
	txtStatusCancelled: 'キャンセル済み',

	txtRepeat: '繰り返し',
	txtNoRepeat: 'なし',
	txtRepeatDay: '毎日',
	txtRepeatWeek: '毎週',
	txtRepeatWeekend: '毎週末',
	txtRepeatMonth: '毎月',
	txtRepeatTwoWeek: '隔週',
	txtRepeatYear: '毎年',
	txtRepeatCustomWeek: 'カスタム 毎週',
	txtRepeatCustomMonth: 'カスタム 毎月',
	txtRepeatCustomYear: 'カスタム 毎年',
	txtRepeatWork: '毎営業日',
	txtRepeatOnDate: '日付指定',
	txtRepeatAfter: '次の回数の後',
	txtRepeatNever: 'なし',
	pholderUntilDate: '日付 迄',
	pholderRepeatCount: '繰り返し数',
	txtRepeatCustomWeekLabel: '曜日',
	txtRepeatCustomMonthLabel: '日付',
	txtRepeatCustomMonthEvery: '毎',
	txtRepeatCustomMonthFirst: '第１',
	txtRepeatCustomMonthSecond: '第２',
	txtRepeatCustomMonthThird: '第３',
	txtRepeatCustomMonthFourth: '第４',
	txtRepeatCustomMonthFifth: '第５',
	txtRepeatCustomMonthLast: '最終',
	txtRepeatCustomMonthCustom: 'カスタム',
	txtRepeatCustomMonthMonth: '日付',
	txtRepeatCustomYearLabel1: '対象日',
	txtRepeatCustomYearLabel2: '対象月',

	txtRepeatEnd: '終了',
	txtEventCalendar: 'カレンダー',
	txtSelectCalendar: 'カレンダーを選択',
	txtAlert: '通知',
	txtAlertNone: 'なし',
	txtAlertMessage: 'メッセージ',
	txtAlertOnDate: '日付指定',
	txtAlertWeeksBefore: '次の週前',
	txtAlertDaysBefore: '次の日前',
	txtAlertHoursBefore: '次の時間前',
	txtAlertMinutesBefore: '次の分前',
	txtAlertSecondsBefore: '次の秒前',
	txtAlertWeeksAfter: '次の週後',
	txtAlertDaysAfter: '次の日後',
	txtAlertHoursAfter: '次の時間後',
	txtAlertMinutesAfter: '次の分後',
	txtAlertSecondsAfter: '次の秒後',

	pholderAfterBeforeVal: '値',
	pholderAlarmDate: '通知 日付',
	pholderAlarmTime: '通知 時刻',

	pholderNote: 'メモ',

	eventPrevNav: '１つ前を表示',
	eventNextNav: '１つ後を表示',

	buttonClose: '閉じる',
	buttonDuplicate: '複製',

	txtAllSavedTodo: '成功: ToDoは保存されました!',
	txtAllSaved: '成功: イベントは保存されました!',

	txtAllDeletedTodo: '成功: ToDoは削除されました!',
	txtAllDeleted: '成功: イベントは削除されました!',

	txtNotChooseTodo: 'エラー: カレンダーを選択する必要があります!',
	txtNotChoose: 'エラー: カレンダーを選択する必要があります!',

	txtErrorDates: 'エラー: 開始日は終了日よりも前でなければなりません!',
	txtErrorDatesTodo: 'エラー: 開始日は終了日よりも前でなければなりません!',

	txtErorInputTodo: '保存できません: 不正な値を直してください!',
	txtDateTimeErrorTodo: '日付と時刻を選択する必要があります!',

	txtErorInput: 'エラー: \'保存できません\': 指定された不正な値を直してください!',

	txtAlertsH: '通知',
	buttonAlert: '通知を消去',

	altAddEvent: 'イベントを追加',
	altAddTodo: 'ToDoを追加',

	loadingCalendars: 'カレンダーを読み込み中 (%total% 個中 %act% 個) ...',
	unloadingCalendars: 'カレンダーの読み込みを解除中 ...',

	errUnableSaveBeginCalDAV: 'エラー: \'イベントを保存できません\': %%!',
	errUnableDeleteBeginCalDAV: 'エラー: \'イベントを削除できません\': %%!',
	CalDAVerrHttp410: 'イベントは既にサーバ上にありません',
	errUnableSaveTodoBeginCalDAV: 'エラー: \'ToDoを保存できません\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'エラー: \'ToDoを削除できません\': %%!',
	CalDAVerrTodoHttp410: 'ToDoは既にサーバ上にありません'
};

localizationCalDAV['nl_NL']=	/* thanks Johan Vromans */
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'–\' d MMM yyyy}',
	_default_title_format_day_: 'ddd, d MMM yyyy',
	_default_title_format_table_: 'ddd, MMM yyyy',
	_default_column_format_agenda_: 'ddd, d MMM',

	txtCalendar: 'Agenda',
	txtEnabledCalendars: 'Actieve agenda\'s',
	txtTodo: 'Taak',
	txtTodoList: 'Taaklijst',
	txtTodoLists: 'Taaklijsten',
	txtEnabledTodoLists: 'Actieve taaklijsten',
	txtSubscribed: 'Andere bronnen',
	fullCalendarTable: 'tabel',
	fullCalendarTodayButton: 'vandaag',
	fullCalendarAllDay: 'dag-omvattend',
	CalDAVsearch: 'Zoeken',
	resourceEnable: 'Alle agenda’s van deze bron aktiveren',
	resourceDisable: 'Alle agenda’s van deze bron deaktiveren',
	allEnable: 'Alle agenda’s aktiveren',
	allDisable: 'Alle agenda’s deaktiveren',
	timezone: 'Tijdzone',
	txtTimezonePicker: 'Tijdzone:',
	loadingRList: 'Agenda\'s opmaken ...',
	renderingE: 'Kalenders opmaken ...',
	timezoneChange: 'Tijdzonewijziging uitvoeren ...',
	customTimezone: 'Speciaal (Plaatselijke tijd)',
	customRepeat: 'Anders (kan niet worden gewijzigd)',
	loadPrevMonth: 'Vorige maand',
	loadNextMonth: 'Volgende maand',
	repeatBoxButton: 'Herhaling',
	repeatBoxContent: 'is een herhalende afspraak.',
	repeatBoxQuestion: 'Welke afspraken wilt u bewerken?',
	allEvsButton: 'Alle afspraken',
	allFutureButton: 'Deze en alle volgende afspraken',
	eventOnlyButton: 'Alleen deze afspraak',
	repeatBoxContentTODO: 'is een herhalende taak.',
	repeatBoxQuestionTODO: 'Welke taken wilt u aanpassen?',
	allEvsButtonTODO: 'Alle taken',
	allFutureButtonTODO: 'Deze en toekomstige taken',
	eventOnlyButtonTODO: 'Alleen deze taak',
	txtStatus: 'Status',
	eventAvailability : 'Beschikbaarheid',
	eventAvailabilityBusy : 'Bezet',
	eventAvailabilityFree : 'Vrij',
	eventType: 'Privacy',
	eventTypePublic: 'Openbaar',
	eventTypePrivate: 'Besloten',
	eventTypeConfidential: 'Vertrouwelijk',
	txtPriority: 'Prioriteit',
	txtPriorityNone: 'Geen',
	txtPriorityLow: 'Laag',
	txtPriorityMedium: 'Gemiddeld',
	txtPriorityHigh: 'Hoog',
	eventURL : 'URL',
	repeatInterval: 'Elke',
	repeatDays: 'dagen',
	repeatWeeks: 'weken',
	repeatMonths: 'maanden',
	repeatYears: 'jaar',
	repeatChangeTxt: 'is gewijzigd op de server!',
	repeatChangeTxtClose: 'Sluit dit formulier en open het opnieuw',
	repeatTodoChangeTxtClose: 'Sluit het formulier en heropen de taak',
	calendarLoader: 'Opnieuw laden ...',
	resizeLoader: 'Aanpassen ...',	// ???

	// TODOS
	pholderNameTODO: 'Naam',
	pholderNewTODO: 'Nieuwe taak',
	txtTypeTODO: 'Tijdstippen',
	txtTypeTODONone: 'Geen',
	txtTypeTODOStart: 'Met aanvangstijd',
	txtTypeTODODue: 'Met eindtijd',
	txtTypeTODOBoth: 'Met aanvangs- en eindtijd',
	txtDateFromTODO: 'Vanaf',
	txtDateToTODO: 'Tot',	// totaan? tot en met?
	txtCompletedOn: 'Afgehandeld op',

	pholderDateFromTODO: 'Datum vanaf',
	pholderTimeFromTODO: 'Tijd vanaf',
	pholderDateToTODO: 'Datum tot',	// totaan? tot en met?
	pholderTimeToTODO: 'Tijd tot',	// totaan? tot en met?
	pholderCompletedOnDate: 'Datum',
	pholderCompletedOnTime: 'Tijd',

	txtStatusFiltersHeaderTODO: 'Filters',
	txtStatusFiltersFooterTODO: '* afgehandeld op of na %date%',
	txtStatusNeedsActionTODO: 'Aktie nodig',
	txtStatusCompletedTODO: 'Afgewerkt',
	txtStatusInProcessTODO: 'In behandeling',
	txtStatusCancelledTODO: 'Vervallen',
	txtPercentCompletedTODO: 'Afgewerkt', // ???

	txtCalendarTODO: 'Agenda',
	txtSelectCalendarTODO: 'Kies een agenda',
	txtAlertTODO: 'Herinnering',
	txtAlertNoneTODO: 'Geen',
	txtAlertMessageTODO: 'Boodschap',
	txtAlertOnDateTODO: 'Op datum',
	txtAlertWeeksBeforeTODO: 'Weken tevoren',
	txtAlertDaysBeforeTODO: 'Dagen tevoren',
	txtAlertHoursBeforeTODO: 'Uren tevoren',
	txtAlertMinutesBeforeTODO: 'Minuten tevoren',
	txtAlertSecondsBeforeTODO: 'Seconden tevoren',
	txtAlertWeeksAfterTODO: 'Weken erna',
	txtAlertDaysAfterTODO: 'Dagen erna',
	txtAlertHoursAfterTODO: 'Uren erna',
	txtAlertMinutesAfterTODO: 'Minuten erna',
	txtAlertSecondsAfterTODO: 'Seconden erna',

	pholderAfterBeforeValTODO: 'Waarde',
	pholderAlarmDateTODO: 'Alarmdatum',
	pholderAlarmTimeTODO: 'Alarmtijd',

	pholderNoteTODO: 'Boodschap',
	txtNoteTODO: 'Boodschap',

	todoPrevNav: 'Toon vorige',
	todoNextNav: 'Toon volgende',
	todoUncompletedPrevNav: 'Toon eerstvorige onafgewerkte taak',
	todoUncompletedNextNav: 'Toon eerstvolgende onafgewerkte taak',

	buttonSaveTODO: 'Opslaan',
	buttonEditTODO: 'Wijzigen',
	buttonDuplicateTODO: 'Kopieer',
	buttonResetTODO: 'Herstellen',
	buttonCloseTODO: 'Sluiten',
	buttonDeleteTODO: 'Verwijderen',

	// EVENTS
	pholderName: 'Naam',
	pholderNewEvent: 'Nieuwe afspraak',
	txtLocation: 'Plaats',
	pholderLocation: 'Plaats',

	txtAllDay: 'Dag-omvattend',
	from: 'Vanaf',
	to: 'Tot',		// totaan??? tot en met???

	pholderDateFrom: 'Datum vanaf',
	pholderTimeFrom: 'Tijd vanaf',
	pholderDateTo: 'Datum tot',	// totaan??? tot en met???
	pholderTimeTo: 'Tijd tot',	// totaan??? tot en met???

	txtStatusNone: 'Onbekend',
	txtStatusTentative: 'Onbevestigd',
	txtStatusConfirmed: 'Definitief',
	txtStatusCancelled: 'Vervallen',

	txtRepeat: 'Herhalend',
	txtNoRepeat: 'Eenmalig',
	txtRepeatDay: 'Dagelijks',
	txtRepeatWeek: 'Wekelijks',
	txtRepeatWeekend: 'Elk weekend',
	txtRepeatMonth: 'Maandelijks',
	txtRepeatTwoWeek: 'Tweewekelijks',
	txtRepeatYear: 'Jaarlijks',
	txtRepeatCustomWeek: 'Aangepast wekelijks',
	txtRepeatCustomMonth: 'Aangepast maandelijks',
	txtRepeatCustomYear: 'Aangepast jaarlijks',
	txtRepeatWork: 'Elke werkdag',
	txtRepeatOnDate: 'Op datum',
	txtRepeatAfter: 'Herhalingen',
	txtRepeatNever: 'Nooit',
	pholderUntilDate: 'Datum tot',	// totaan??? tot en met???
	pholderRepeatCount: 'Aantal',
	txtRepeatCustomWeekLabel: 'Op',
	txtRepeatCustomMonthLabel: 'Op dag',
	txtRepeatCustomMonthEvery: 'Elke',
	txtRepeatCustomMonthFirst: 'Eerste',
	txtRepeatCustomMonthSecond: 'Tweede',
	txtRepeatCustomMonthThird: 'Derde',
	txtRepeatCustomMonthFourth: 'Vierde',
	txtRepeatCustomMonthFifth: 'Vijfde',
	txtRepeatCustomMonthLast: 'Laatste',
	txtRepeatCustomMonthCustom: 'Aangepast',
	txtRepeatCustomMonthMonth: 'Dag van de maand',
	txtRepeatCustomYearLabel1: 'Elke',
	txtRepeatCustomYearLabel2: 'Van',

	txtRepeatEnd: 'Einde',
	txtEventCalendar: 'Agenda',
	txtSelectCalendar: 'Kies een agenda',
	txtAlert: 'Boodschap',
	txtAlertNone: 'Geen',
	txtAlertMessage: 'Boodschap',
	txtAlertOnDate: 'Op datum',
	txtAlertWeeksBefore: 'Weken tevoren',
	txtAlertDaysBefore: 'Dagen tevoren',
	txtAlertHoursBefore: 'Uren tevoren',
	txtAlertMinutesBefore: 'Minuten tevoren',
	txtAlertSecondsBefore: 'Seconden tevoren',
	txtAlertWeeksAfter: 'Weken erna',
	txtAlertDaysAfter: 'Dagen erna',
	txtAlertHoursAfter: 'Uren erna',
	txtAlertMinutesAfter: 'Minuten erna',
	txtAlertSecondsAfter: 'Seconden erna',

	pholderAfterBeforeVal: 'Waarde',
	pholderAlarmDate: 'Alarmdatum',
	pholderAlarmTime: 'Alarmtijd',

	pholderNote: 'Boodschap',

	eventPrevNav: 'Toon vorige taak',
	eventNextNav: 'Toon volgende taak',

	buttonClose: 'Sluiten',
	buttonDuplicate: 'Kopieer',

	txtAllSavedTodo: 'De taak is opgeslagen',
	txtAllSaved: 'De afspraak is opgeslagen',

	txtAllDeletedTodo: 'De taak is verwijderd',
	txtAllDeleted: 'De afspraak is verwijderd',

	txtNotChooseTodo: 'Fout: Kies eerst een agenda',
	txtNotChoose: 'Fout: Kies eerst een agenda',

	txtErrorDates: 'Fout: De begindatum mag niet na de einddatum vallen',
	txtErrorDatesTodo: 'Fout: De begindatum mag niet na de einddatum vallen',

	txtErorInputTodo: 'opslaan niet mogelijk, corrigeer eerst de foutieve gegevens',
	txtDateTimeErrorTodo: 'Kies eerst een datum en tijd',

	txtErorInput: 'Fout: opslaan niet mogelijk, corrigeer eerst de aangegeven gegevens',

	txtAlertsH: 'Alerts',
	buttonAlert: 'Alerts opheffen',

	altAddEvent: 'Afspraak aanmaken',
	altAddTodo: 'Taak aanmaken',

	loadingCalendars: 'Agenda\'s worden geladen (%act% van %total%) ...',
	unloadingCalendars: 'Agenda\'s worden ontladen ...',

	errUnableSaveBeginCalDAV: 'Fout: de afspraak kon niet worden opgeslagen: %%',
	errUnableDeleteBeginCalDAV: 'Fout: de afspraak kon niet worden verwijderd: %%',
	CalDAVerrHttp410: 'Deze afspraak is niet langer beschikbaar op de server',
	errUnableSaveTodoBeginCalDAV: 'Fout: de taak kon niet worden opgeslagen: %%!',
	errUnableDeleteTodoBeginCalDAV: 'Fout: de taak kon niet worden verwijderd: %%!',
	CalDAVerrTodoHttp410: 'de taak is niet meer beschikbaar op de server'
};

localizationCalDAV['sk_SK']=	/* Jan Mate <jan.mate@inf-it.com> */
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'–\' d MMM yyyy}',
	_default_title_format_day_: 'ddd, d MMM yyyy',
	_default_title_format_table_: 'ddd, MMM yyyy',
	_default_column_format_agenda_: 'ddd, d MMM',

	txtCalendar: 'Kalendár',
	txtEnabledCalendars: 'Zapnuté Kalendáre',
	txtTodo: 'Pripomienka',
	txtTodoList: 'Zoznam',
	txtTodoLists: 'Zoznamy Pripomienok',
	txtEnabledTodoLists: 'Zapnuté Zoznamy Pripomienok',
	txtSubscribed: 'Odbery',
	fullCalendarTable: 'tabuľka',
	fullCalendarTodayButton: 'dnes',
	fullCalendarAllDay: 'celý deň',
	CalDAVsearch: 'Hľadať',
	resourceEnable: 'Zobraziť všetky kalendáre v danom prostriedku',
	resourceDisable: 'Schovať všetky kalendáre v danom prostriedku',
	allEnable: 'Zobraziť všetky kalendáre',
	allDisable: 'Schovať všetky kalendáre',
	timezone: 'Časové pásmo',
	txtTimezonePicker: 'Pásmo:',
	loadingRList: 'Načítavanie zoznamu prostriedkov ...',
	renderingE: 'Vykreslovanie kalendárov ...',
	timezoneChange: 'Aplikovanie zmeny časového pásma ...',
	customTimezone: 'Vlastná (Lokálny čas)',
	customRepeat: 'Iné (zmena nie je podporovaná)',
	loadPrevMonth: 'Načítať predchádzajúci mesiac',
	loadNextMonth: 'Načítať nasledujúci mesiac',
	repeatBoxButton: 'Opakovanie',
	repeatBoxContent: 'je opakovacia udalosť.',
	repeatBoxQuestion: 'S ktorými udalosťami chcete pracovať?',
	allEvsButton: 'Všetky udalosti',
	allFutureButton: 'Táto a všetky budúce udalosti',
	eventOnlyButton: 'Iba táto udalosť',
	repeatBoxContentTODO: 'je opakovacia pripomienka.',
	repeatBoxQuestionTODO: 'S ktorými pripomienkami chcete pracovať?',
	allEvsButtonTODO: 'Všetky pripomienky',
	allFutureButtonTODO: 'Táto a všetky budúce pripomienky',
	eventOnlyButtonTODO: 'Iba táto pripomienka',
	txtStatus: 'Stav',
	eventAvailability : 'Dostupnosť',
	eventAvailabilityBusy : 'Zaneprázdnený',
	eventAvailabilityFree : 'Voľný',
	eventType: 'Súkromie',
	eventTypePublic: 'Verejná',
	eventTypePrivate: 'Súkromná',
	eventTypeConfidential: 'Dôverná',
	txtPriority: 'Priority',
	txtPriorityNone: 'Žiadna',
	txtPriorityLow: 'Nízka',
	txtPriorityMedium: 'Stredná',
	txtPriorityHigh: 'Vysoká',
	eventURL : 'URL',
	repeatInterval: 'každých',
	repeatDays: 'dní',
	repeatWeeks: 'týždňov',
	repeatMonths: 'mesiacov',
	repeatYears: 'rokov',
	repeatChangeTxt: 'bol zmenený na serveri!',
	repeatChangeTxtClose: 'Zatvorte formulár a znova otvorte udalosť',
	repeatTodoChangeTxtClose: 'Zatvorte formulár a znova otvorte pripomienku.',
	calendarLoader: 'Znovunačítanie ...',
	resizeLoader: 'Prepočítavanie veľkosti ...',

	// TODOS
	pholderNameTODO: 'Názov',
	pholderNewTODO: 'Nová pripomienka',
	txtTypeTODO: 'Typ',
	txtTypeTODONone: 'Jednoduchá',
	txtTypeTODOStart: 'S časom začiatku',
	txtTypeTODODue: 'S časom konca',
	txtTypeTODOBoth: 'S časmi začiatku aj konca',
	txtDateFromTODO: 'Od',
	txtDateToTODO: 'Do',
	txtCompletedOn: 'Dokončené ku',

	pholderDateFromTODO: 'Deň od',
	pholderTimeFromTODO: 'Čas od',
	pholderDateToTODO: 'Deň do',
	pholderTimeToTODO: 'Čas do',
	pholderCompletedOnDate: 'Deň',
	pholderCompletedOnTime: 'Čas',

	txtStatusFiltersHeaderTODO: 'Filtre',
	txtStatusFiltersFooterTODO: '* dokončené %date% a neskôr',
	txtStatusNeedsActionTODO: 'Potrebuje akciu',
	txtStatusCompletedTODO: 'Dokončená',
	txtStatusInProcessTODO: 'Riešená',
	txtStatusCancelledTODO: 'Zrušená',
	txtPercentCompletedTODO: 'Dokončené',

	txtCalendarTODO: 'Kalendár',
	txtSelectCalendarTODO: 'Vyberte kalendár',
	txtAlertTODO: 'Alarm',
	txtAlertNoneTODO: 'Žiadny',
	txtAlertMessageTODO: 'Správa',
	txtAlertOnDateTODO: 'Na dátum',
	txtAlertWeeksBeforeTODO: 'Týždňov pred',
	txtAlertDaysBeforeTODO: 'Dní pred',
	txtAlertHoursBeforeTODO: 'Hodín pred',
	txtAlertMinutesBeforeTODO: 'Minút pred',
	txtAlertSecondsBeforeTODO: 'Sekúnd',
	txtAlertWeeksAfterTODO: 'Týždňov po',
	txtAlertDaysAfterTODO: 'Dní po',
	txtAlertHoursAfterTODO: 'Hodín po',
	txtAlertMinutesAfterTODO: 'Minút po',
	txtAlertSecondsAfterTODO: 'Sekúnd po',

	pholderAfterBeforeValTODO: 'Hodnota',
	pholderAlarmDateTODO: 'Deň alarmu',
	pholderAlarmTimeTODO: 'Čas alarmu',

	pholderNoteTODO: 'Poznámka',
	txtNoteTODO: 'Poznámka',

	todoPrevNav: 'Zobraziť prechádzajúcu inštanciu',
	todoNextNav: 'Zobraziť nasledujúcu inštanciu',
	todoUncompletedPrevNav: 'Zobraziť prechádzajúcu nedokončenú inštanciu',
	todoUncompletedNextNav: 'Zobraziť nasledujúcu nedokončenú inštanciu',

	buttonSaveTODO: 'Uložiť',
	buttonEditTODO: 'Editovať',
	buttonDuplicateTODO: 'Duplikovať',
	buttonResetTODO: 'Reset',
	buttonCloseTODO: 'Zatvoriť',
	buttonDeleteTODO: 'Vymazať',

	// EVENTS
	pholderName: 'Názov',
	pholderNewEvent: 'Nová udalosť',
	txtLocation: 'Miesto',
	pholderLocation: 'Miesto',

	txtAllDay: 'Celý deň',
	from: 'Od',
	to: 'Do',

	pholderDateFrom: 'Deň od',
	pholderTimeFrom: 'Čas od',
	pholderDateTo: 'Deň do',
	pholderTimeTo: 'Čas do',

	txtStatusNone: 'Nešpecifikovaný',
	txtStatusTentative: 'Predbežný',
	txtStatusConfirmed: 'Potvrdený',
	txtStatusCancelled: 'Zrušený',

	txtRepeat: 'Opakovať',
	txtNoRepeat: 'Neopakovať',
	txtRepeatDay: 'Denne',
	txtRepeatWeek: 'Týždenne',
	txtRepeatWeekend: 'Každý víkend',
	txtRepeatMonth: 'Mesačne',
	txtRepeatTwoWeek: 'Dvojtýždenne',
	txtRepeatYear: 'Ročne',
	txtRepeatCustomWeek: 'Týždenne vlastné',
	txtRepeatCustomMonth: 'Mesačne vlastné',
	txtRepeatCustomYear: 'Ročne vlastné',
	txtRepeatWork: 'Každý pracovný deň',
	txtRepeatOnDate: 'Do dátumu',
	txtRepeatAfter: 'Výskytov',
	txtRepeatNever: 'Nikdy',
	pholderUntilDate: 'Do dňa',
	pholderRepeatCount: 'Počet opakovaní',
	txtRepeatCustomWeekLabel: 'deň',
	txtRepeatCustomMonthLabel: 'v dni',
	txtRepeatCustomMonthEvery: 'Každý',
	txtRepeatCustomMonthFirst: 'Prvý',
	txtRepeatCustomMonthSecond: 'Druhý',
	txtRepeatCustomMonthThird: 'Tretí',
	txtRepeatCustomMonthFourth: 'Štvrtý',
	txtRepeatCustomMonthFifth: 'Piaty',
	txtRepeatCustomMonthLast: 'Posledný',
	txtRepeatCustomMonthCustom: 'Vlastné',
	txtRepeatCustomMonthMonth: 'Deň v mesiaci',
	txtRepeatCustomYearLabel1: 'každý',
	txtRepeatCustomYearLabel2: 'v mesiaci',

	txtRepeatEnd: 'koniec',
	txtEventCalendar: 'Kalendár',
	txtSelectCalendar: 'Vyberte kalendár',
	txtAlert: 'Alarm',
	txtAlertNone: 'Žiadny',
	txtAlertMessage: 'Správa',
	txtAlertOnDate: 'Na dátum',
	txtAlertWeeksBefore: 'Týždňov pred',
	txtAlertDaysBefore: 'Dní pred',
	txtAlertHoursBefore: 'Hodín pred',
	txtAlertMinutesBefore: 'Minút pred',
	txtAlertSecondsBefore: 'Sekúnd',
	txtAlertWeeksAfter: 'Týždňov po',
	txtAlertDaysAfter: 'Dní po',
	txtAlertHoursAfter: 'Hodín po',
	txtAlertMinutesAfter: 'Minút po',
	txtAlertSecondsAfter: 'Sekúnd po',

	pholderAfterBeforeVal: 'Hodnota',
	pholderAlarmDate: 'Deň alarmu',
	pholderAlarmTime: 'Čas alarmu',

	pholderNote: 'Poznámka',

	eventPrevNav: 'Zobraziť prechádzajúcu inštanciu',
	eventNextNav: 'Zobraziť nasledujúcu inštanciu',

	buttonClose: 'Zatvoriť',
	buttonDuplicate: 'Duplikovať',

	txtAllSavedTodo: 'Pripomienka úspešne uložená!',
	txtAllSaved: 'Udalosť úspešne uložená!',

	txtAllDeletedTodo: 'Pripomienka úspešne vymazaná!',
	txtAllDeleted: 'Udalosť úspešne vymazaná!',

	txtNotChooseTodo: 'Chyba: Musíte zvoliť kalendár!',
	txtNotChoose: 'Chyba: Musíte zvoliť kalendár!',

	txtErorInputTodo: 'Chyba: opravte chybné hodnoty!',
	txtDateTimeErrorTodo: 'Chyba: Musíte zvoliť deň a čas!',

	txtErrorDates: 'Chyba: Čas začiatku musí byť pred koncom!',
	txtErrorDatesTodo: 'Chyba: Čas začiatku musí byť pred koncom!',

	txtErorInput: 'Chyba: opravte vyznačené chybné hodnoty!',

	txtAlertsH: 'Alarmy',
	buttonAlert: 'Zmazať alarmy',

	altAddEvent: 'Pridať udalosť',
	altAddTodo: 'Pridať pripomienku',

	loadingCalendars: 'Načítavanie kalendárov (%act% z %total%) ...',
	unloadingCalendars: 'Odčítavanie kalendárov ...',

	errUnableSaveBeginCalDAV: 'Chyba: \'nepodarilo sa uložiť udalosť\': %%!',
	errUnableDeleteBeginCalDAV: 'Chyba: \'nepodarilo sa vymazať udalosť\': %%!',
	CalDAVerrHttp410: 'Udalosť už nie je dostupná na serveri',
	errUnableSaveTodoBeginCalDAV: 'Chyba: \'nepodarilo sa uložiť pripomienku\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Chyba: \'nepodarilo sa vymazať pripomienku\': %%!',
	CalDAVerrTodoHttp410: 'Pripomienka už nie je dostupná na serveri'
};

localizationCalDAV['tr_TR']=	/* thanks Selcuk Pultar */
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'–\' d MMM yyyy}',
	_default_title_format_day_: 'ddd, d MMM yyyy',
	_default_title_format_table_: 'ddd, MMM yyyy',
	_default_column_format_agenda_: 'ddd, d MMM',

	txtCalendar: 'Takvimler',
	txtEnabledCalendars: 'Takvimler yüklendi',
	txtTodo: 'Yapılacak',
	txtTodoList: 'Yapılacak Listesi',
	txtTodoLists: 'Yapılacak Listeleri',
	txtEnabledTodoLists: 'Kullanılabilir Yapılacak Listeleri',
	txtSubscribed: 'Abonelikler',
	fullCalendarTable: 'tablo',
	fullCalendarTodayButton: 'bugün',
	fullCalendarAllDay: 'tüm gün',
	CalDAVsearch: 'Ara',
	resourceEnable: 'Bu kaynaktaki tüm takvimleri etkinleştir',
	resourceDisable: 'Bu kaynaktaki tüm takvimleri etkisizleştir',
	allEnable: 'Tüm takvimleri etkinleştir',
	allDisable: 'Tüm takvimleri etkisizleştir',
	timezone: 'Saat dilimi',
	txtTimezonePicker: 'Saat dilimi:',
	loadingRList: 'Kaynak listesi yükleniyor ...',
	renderingE: 'Takvimler oluşturuluyor ...',
	timezoneChange: 'Saat dilimi değişikliği uygulanıyor ...',
	customTimezone: 'Özel (Yerel Saat)',
	customRepeat: 'Diğer (değişiklik desteklenmez)',
	loadPrevMonth: 'Önceki ayı yükle',
	loadNextMonth: 'Sonraki ayı yükle',
	repeatBoxButton: 'Yineleme',
	repeatBoxContent: 'tekrar eden bir etkinlik.',
	repeatBoxQuestion: 'Hangi etkinlikler üzerinde çalışmak istersiniz?',
	allEvsButton: 'Tüm etkinlikler',
	allFutureButton: 'Bu ve tüm gelecek etkinlikler',
	eventOnlyButton: 'Sadece bu etkinlik',
	repeatBoxContentTODO: 'tekrar eden bir yapılacak.',
	repeatBoxQuestionTODO: 'Hangi yapılacaklar üzerinde çalışmak istersiniz?',
	allEvsButtonTODO: 'Tüm yapılacaklar',
	allFutureButtonTODO: 'Bu ve tüm gelecek yapılacak',
	eventOnlyButtonTODO: 'Sadece bu yapılacak',
	txtStatus: 'Durum',
	eventAvailability : 'Müsaitlik',
	eventAvailabilityBusy : 'Meşgul',
	eventAvailabilityFree : 'Serbest',
	eventType: 'Mahremiyet',
	eventTypePublic: 'Halka açık',
	eventTypePrivate: 'Özel',
	eventTypeConfidential: 'Gizli',
	txtPriority: 'Öncelik',
	txtPriorityNone: 'Yok',
	txtPriorityLow: 'Düşük',
	txtPriorityMedium: 'Orta',
	txtPriorityHigh: 'Yüksek',
	eventURL : 'URL',
	repeatInterval: 'her',
	repeatDays: 'günler',
	repeatWeeks: 'haftalar',
	repeatMonths: 'aylar',
	repeatYears: 'yıllar',
	repeatChangeTxt: 'sunucuda değiştirilmiş!',
	repeatChangeTxtClose: 'Formu kapatıp etkinliği yeniden açın',
	repeatTodoChangeTxtClose: 'Formu kapatıp yapılacağı yeniden açın',
	calendarLoader: 'Yeniden yükleniyor ...',
	resizeLoader: 'Yeniden boyutlandırılıyor ...',

	// TODOS
	pholderNameTODO: 'İsim',
	pholderNewTODO: 'Yeni Yapılacak',
	txtTypeTODO: 'Tür',
	txtTypeTODONone: 'Basit',
	txtTypeTODOStart: 'Başlangıç zamanı ile',
	txtTypeTODODue: 'Vadesi dolma zamanı ile',
	txtTypeTODOBoth: 'Hem başlangıç ve hemde vadesi dolma zamanı ile',
	txtDateFromTODO: 'Başlangıç',
	txtDateToTODO: 'Bitiş',
	txtCompletedOn: 'Tamamlandığı tarih',

	pholderDateFromTODO: 'Tarihten',
	pholderTimeFromTODO: 'Saatten',
	pholderDateToTODO: 'Tarihe',
	pholderTimeToTODO: 'Saate',
	pholderCompletedOnDate: 'Tarih',
	pholderCompletedOnTime: 'Saat',

	txtStatusFiltersHeaderTODO: 'Filtreler',
	txtStatusFiltersFooterTODO: '* %date% tarihinde veya daha sonrasında tamamlanmış',
	txtStatusNeedsActionTODO: 'Eylem gerektiriyor',
	txtStatusCompletedTODO: 'Tamamlandı',
	txtStatusInProcessTODO: 'İlerlemekte',
	txtStatusCancelledTODO: 'İptal edildi',
	txtPercentCompletedTODO: 'Tamamlandı',

	txtCalendarTODO: 'Takvim',
	txtSelectCalendarTODO: 'Bir takvim seçin',
	txtAlertTODO: 'Uyarı',
	txtAlertNoneTODO: 'Yok',
	txtAlertMessageTODO: 'Mesaj',
	txtAlertOnDateTODO: 'Tarihte',
	txtAlertWeeksBeforeTODO: 'Hafta önce',
	txtAlertDaysBeforeTODO: 'Gün önce',
	txtAlertHoursBeforeTODO: 'Saat önce',
	txtAlertMinutesBeforeTODO: 'Dakika önce',
	txtAlertSecondsBeforeTODO: 'Saniye önce',
	txtAlertWeeksAfterTODO: 'Hafta sonra',
	txtAlertDaysAfterTODO: 'Gün sonra',
	txtAlertHoursAfterTODO: 'Saat sonra',
	txtAlertMinutesAfterTODO: 'Dakika sonra',
	txtAlertSecondsAfterTODO: 'Saniye sonra',

	pholderAfterBeforeValTODO: 'Değer',
	pholderAlarmDateTODO: 'Alarm tarihi',
	pholderAlarmTimeTODO: 'Alarm saati',

	pholderNoteTODO: 'Not',
	txtNoteTODO: 'Not',

	todoPrevNav: 'Önceki gerçekleşmesini göster',
	todoNextNav: 'Sonraki gerçekleşmesini göster',
	todoUncompletedPrevNav: 'Önceki tamamlanmamış gerçekleşmesini göster',
	todoUncompletedNextNav: 'Sonraki tamamlanmamış gerçekleşmesini göster',

	buttonSaveTODO: 'Kaydet',
	buttonEditTODO: 'Düzenle',
	buttonDuplicateTODO: 'Çift kopya',
	buttonResetTODO: 'Geri döndür',
	buttonCloseTODO: 'Kapat',
	buttonDeleteTODO: 'Sil',

	// EVENTS
	pholderName: 'İsim',
	pholderNewEvent: 'Yeni etkinlik',
	txtLocation: 'Yer',
	pholderLocation: 'Yer',

	txtAllDay: 'Tüm gün',
	from: 'Başlangıç',
	to: 'Bitiş',

	pholderDateFrom: 'Tarihten',
	pholderTimeFrom: 'Saatten',
	pholderDateTo: 'Tarihe',
	pholderTimeTo: 'Saate',

	txtStatusNone: 'Belirtilmemiş',
	txtStatusTentative: 'Olası',
	txtStatusConfirmed: 'Teyid Edilmiş',
	txtStatusCancelled: 'İptal Edilmiş',

	txtRepeat: 'Tekrar et',
	txtNoRepeat: 'Tekrar etme',
	txtRepeatDay: 'Günde bir',
	txtRepeatWeek: 'Haftada bir',
	txtRepeatWeekend: 'Her haftasonu',
	txtRepeatMonth: 'Ayda bir',
	txtRepeatTwoWeek: 'İki haftada bir',
	txtRepeatYear: 'Yılda bir',
	txtRepeatCustomWeek: 'Özel haftada bir',
	txtRepeatCustomMonth: 'Özel ayda bir',
	txtRepeatCustomYear: 'Özel yılda bir',
	txtRepeatWork: 'Her iş günü',
	txtRepeatOnDate: 'Tarihinde',
	txtRepeatAfter: 'Kereden sonra',
	txtRepeatNever: 'Hiç bir zaman',
	pholderUntilDate: 'Tarihine kadar',
	pholderRepeatCount: 'Tekrar sayısı',
	txtRepeatCustomWeekLabel: 'taihinde',
	txtRepeatCustomMonthLabel: 'günlerinde',
	txtRepeatCustomMonthEvery: 'Her',
	txtRepeatCustomMonthFirst: 'İlk',
	txtRepeatCustomMonthSecond: 'İkinci',
	txtRepeatCustomMonthThird: 'Üçüncü',
	txtRepeatCustomMonthFourth: 'Dördüncü',
	txtRepeatCustomMonthFifth: 'Beşinci',
	txtRepeatCustomMonthLast: 'Son',
	txtRepeatCustomMonthCustom: 'Özel',
	txtRepeatCustomMonthMonth: 'Ayın gününde',
	txtRepeatCustomYearLabel1: 'her',
	txtRepeatCustomYearLabel2: 'nin',

	txtRepeatEnd: 'son',
	txtEventCalendar: 'Takvim',
	txtSelectCalendar: 'Bir takvim seçin',
	txtAlert: 'Uyarı',
	txtAlertNone: 'Yok',
	txtAlertMessage: 'Mesaj',
	txtAlertOnDate: 'Tarihinde',
	txtAlertWeeksBefore: 'Hafta önce',
	txtAlertDaysBefore: 'Gün önce',
	txtAlertHoursBefore: 'Saat önce',
	txtAlertMinutesBefore: 'Dakika önce',
	txtAlertSecondsBefore: 'Saniye önce',
	txtAlertWeeksAfter: 'Hafta sonra',
	txtAlertDaysAfter: 'Gün sonra',
	txtAlertHoursAfter: 'Saat sonra',
	txtAlertMinutesAfter: 'Dakika sonra',
	txtAlertSecondsAfter: 'Saniye sonra',

	pholderAfterBeforeVal: 'Değer',
	pholderAlarmDate: 'Alarm tarihi',
	pholderAlarmTime: 'Alarm saati',

	pholderNote: 'Not',

	eventPrevNav: 'Önceki gerçekleşmesini göster',
	eventNextNav: 'Sonraki gerçekleşmesini göster',

	buttonClose: 'Kapat',
	buttonDuplicate: 'Çift kopya',

	txtAllSavedTodo: 'Başarılı: Yapılacak kaydedildi!',
	txtAllSaved: 'Başarılı: Etkinlik kaydedildi!',

	txtAllDeletedTodo: 'Başarılı: Yapılacak silindi!',
	txtAllDeleted: 'Başarılı: Etkinlik silindi!',

	txtNotChooseTodo: 'Hata: Takvim seçmeniz gerek!',
	txtNotChoose: 'Hata: Takvim seçmeniz gerek!',

	txtErrorDates: 'Hata: Başlangıç tarihi bitiş tarihinden önce olmalıdır!',
	txtErrorDatesTodo: 'Hata: Başlangıç tarihi bitiş tarihinden önce olmalıdır!',

	txtErorInputTodo: 'Kaydedilemedi: hatalı değerleri düzeltin!',
	txtDateTimeErrorTodo: 'Taih ve saat seçmeniz gerekiyor!',

	txtErorInput: 'Hata: \'kaydedilemedi\': renklendirilmiş hatalı değerleri düzeltin!',

	txtAlertsH: 'Uyarılar',
	buttonAlert: 'Uyarıları temizle',

	altAddEvent: 'Etkinlik ekle',
	altAddTodo: 'Yapılacak ekle',

	loadingCalendars: 'Takvimler yükleniyor (%total% taneden %act%) ...',
	unloadingCalendars: 'Takvimler kaldırılıyor ...',

	errUnableSaveBeginCalDAV: 'Hata: \'etkinlik kaydedilemedi\': %%!',
	errUnableDeleteBeginCalDAV: 'Hata: \'etkinlik silinemedi\': %%!',
	CalDAVerrHttp410: 'Etkinlik artık sunucuda mevcut değil',
	errUnableSaveTodoBeginCalDAV: 'Hata: \'yapılacak kaydedilemedi\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Hata: \'yapılacak silinemedi\': %%!',
	CalDAVerrTodoHttp410: 'Yapılacak artık sunucuda mevcut değil'
};

localizationCalDAV['ru_RU']=	/* thanks Александр Симонов */
{
	_default_title_format_month_: 'MMMM yyyy',
	_default_title_format_week_: 'd MMM yyyy{ \'–\' d MMM yyyy}',
	_default_title_format_day_: 'd MMM yyyy, dddd',
	_default_title_format_table_: 'MMM yyyy, ddd',
	_default_column_format_agenda_: 'd MMM, ddd',

	txtCalendar: 'Календарь',
	txtEnabledCalendars: 'Включенные календари',
	txtTodo: 'Задача',
	txtTodoList: 'Список задач',
	txtTodoLists: 'Списки задач',
	txtEnabledTodoLists: 'Включенные списки задач',
	txtSubscribed: 'Подписки',
	fullCalendarTable: 'Таблица',
	fullCalendarTodayButton: 'Сегодня',
	fullCalendarAllDay: 'Весь день',
	CalDAVsearch: 'Поиск',
	resourceEnable: 'Отобразить все календари в этом ресурсе',
	resourceDisable: 'Скрыть все календари в этом ресурсе',
	allEnable: 'Отобразить все календари',
	allDisable: 'Скрыть все календари',
	timezone: 'Врем. зона',
	txtTimezonePicker: 'Вр. зона:',
	loadingRList: 'Загрузка списка ресурсов...',
	renderingE: 'Отображение календарей...',
	timezoneChange: 'Применение временной зоны ...',
	customTimezone: 'Заказная (местное время)',
	customRepeat: 'Другое (без возможности изменения)',
	loadPrevMonth: 'Загрузить предыдущий месяц',
	loadNextMonth: 'Загрузить следующий месяц',
	repeatBoxButton: 'Повторение',
	repeatBoxContent: '- повторяющееся событие.',
	repeatBoxQuestion: 'С какими экземплярами события вы хотите работать?',
	allEvsButton: 'Со всеми',
	allFutureButton: 'С этим и со всеми будущими',
	eventOnlyButton: 'Только с этим',
	repeatBoxContentTODO: '- повторяющаяся задача.',
	repeatBoxQuestionTODO: 'С какими экземплярами задачи вы хотите работать?',
	allEvsButtonTODO: 'Со всеми',
	allFutureButtonTODO: 'С этим и со всеми будущими',
	eventOnlyButtonTODO: 'Только с этим',
	txtStatus: 'Состояние',
	eventAvailability : 'Доступность',
	eventAvailabilityBusy : 'Занят',
	eventAvailabilityFree : 'Свободен',
	eventType: 'Приватность',
	eventTypePublic: 'Публичное',
	eventTypePrivate: 'Приватное',
	eventTypeConfidential: 'Конфиденциальное',
	txtPriority: 'Приоритет',
	txtPriorityNone: 'Нет',
	txtPriorityLow: 'Низкий',
	txtPriorityMedium: 'Средний',
	txtPriorityHigh: 'Высокий',
	eventURL : 'URL',
	repeatInterval: 'каждый(ую)',
	repeatDays: 'день',
	repeatWeeks: 'неделю',
	repeatMonths: 'месяц',
	repeatYears: 'год',
	repeatChangeTxt: 'было изменено на сервере!',
	repeatChangeTxtClose: 'Закройте и откройте событие заново',
	repeatTodoChangeTxtClose: 'Закройте и откройте задачу заново',
	calendarLoader: 'Перезагрузка...',
	resizeLoader: 'Изменение размера...',

	// TODOS
	pholderNameTODO: 'Название',
	pholderNewTODO: 'новая задача',
	txtTypeTODO: 'Тип',
	txtTypeTODONone: 'Простая',
	txtTypeTODOStart: 'С датой/временем начала',
	txtTypeTODODue: 'С датой/временем окончания',
	txtTypeTODOBoth: 'С датой/временем начала и окончания',
	txtDateFromTODO: 'Начало',
	txtDateToTODO: 'Окончание',
	txtCompletedOn: 'Выполнена',

	pholderDateFromTODO: 'Дата начала',
	pholderTimeFromTODO: 'Время начала',
	pholderDateToTODO: 'Дата окончания',
	pholderTimeToTODO: 'Время окончания',
	pholderCompletedOnDate: 'Дата выполнения',
	pholderCompletedOnTime: 'Время выполнения',

	txtStatusFiltersHeaderTODO: 'Отбор по состоянию',
	txtStatusFiltersFooterTODO: '* выполненных %date% или позже',
	txtStatusNeedsActionTODO: 'Новая',
	txtStatusCompletedTODO: 'Выполнена',
	txtStatusInProcessTODO: 'В процессе',
	txtStatusCancelledTODO: 'Отменена',
	txtPercentCompletedTODO: 'Выполнено на',

	txtCalendarTODO: 'Календарь',
	txtSelectCalendarTODO: 'Выберите календарь',
	txtAlertTODO: 'Уведомление',
	txtAlertNoneTODO: 'Нет',
	txtAlertMessageTODO: 'Сообщение',
	txtAlertOnDateTODO: 'По дате',
	txtAlertWeeksBeforeTODO: 'За N недель до',
	txtAlertDaysBeforeTODO: 'За N дней до',
	txtAlertHoursBeforeTODO: 'За N часов до',
	txtAlertMinutesBeforeTODO: 'За N минут до',
	txtAlertSecondsBeforeTODO: 'За N секунд до',
	txtAlertWeeksAfterTODO: 'Через N недель после',
	txtAlertDaysAfterTODO: 'Через N дней после',
	txtAlertHoursAfterTODO: 'Через N часов после',
	txtAlertMinutesAfterTODO: 'Через N минут после',
	txtAlertSecondsAfterTODO: 'Через N секунд после',

	pholderAfterBeforeValTODO: 'Значение',
	pholderAlarmDateTODO: 'Дата уведомления',
	pholderAlarmTimeTODO: 'Время уведомления',

	pholderNoteTODO: 'Примечание',
	txtNoteTODO: 'Примечание',

	todoPrevNav: 'Показать предыдущий экземпляр',
	todoNextNav: 'Показать следующий экземпляр',
	todoUncompletedPrevNav: 'Показать предыдущий невыполненный экземпляр',
	todoUncompletedNextNav: 'Показать следующий невыполненный экземпляр',

	buttonSaveTODO: 'Сохранить',
	buttonEditTODO: 'Изменить',
	buttonDuplicateTODO: 'Дубликат',
	buttonResetTODO: 'Отменить',
	buttonCloseTODO: 'Закрыть',
	buttonDeleteTODO: 'Удалить',

	// EVENTS
	pholderName: 'Название',
	pholderNewEvent: 'Новое событие',
	txtLocation: 'Место',
	pholderLocation: 'Местоположение',

	txtAllDay: 'Весь день',
	from: 'Начало',
	to: 'Конец',

	pholderDateFrom: 'Дата начала',
	pholderTimeFrom: 'Время начала',
	pholderDateTo: 'Дата окончания',
	pholderTimeTo: 'Время окончания',

	txtStatusNone: 'Не указано',
	txtStatusTentative: 'Неизвестно',
	txtStatusConfirmed: 'Подтверждено',
	txtStatusCancelled: 'Отменено',

	txtRepeat: 'Повторять',
	txtNoRepeat: 'Не повторять',
	txtRepeatDay: 'Каждый божий день',
	txtRepeatWeek: 'Каждую неделю',
	txtRepeatWeekend: 'Каждый выходной',
	txtRepeatMonth: 'Раз в месяц',
	txtRepeatTwoWeek: 'Раз в две недели',
	txtRepeatYear: 'Раз в год',
	txtRepeatCustomWeek: 'Раз в неделю (настр.)',
	txtRepeatCustomMonth: 'Раз в месяц (настр.)',
	txtRepeatCustomYear: 'Раз в год (настр.)',
	txtRepeatWork: 'Каждый рабочий день',
	txtRepeatOnDate: 'По дате',
	txtRepeatAfter: 'Через N повторений',
	txtRepeatNever: 'Никогда',
	pholderUntilDate: 'Повторять до',
	pholderRepeatCount: 'Повторять раз',
	txtRepeatCustomWeekLabel: 'в',
	txtRepeatCustomMonthLabel: 'по дням',
	txtRepeatCustomMonthEvery: 'Каждый(ую/ое)',
	txtRepeatCustomMonthFirst: 'Первый(ую/ое)',
	txtRepeatCustomMonthSecond: 'Второй(ую/ое)',
	txtRepeatCustomMonthThird: 'Третий(ью/ье)',
	txtRepeatCustomMonthFourth: 'Четвертый(ую/ое)',
	txtRepeatCustomMonthFifth: 'Пятый(ую/ое)',
	txtRepeatCustomMonthLast: 'Крайний(юю/ее)',
	txtRepeatCustomMonthCustom: 'Указать дни (настр.)',
	txtRepeatCustomMonthMonth: 'День месяца',
	txtRepeatCustomYearLabel1: 'по дням',
	txtRepeatCustomYearLabel2: 'по месяцам',

	txtRepeatEnd: 'и закончить',
	txtEventCalendar: 'Календарь',
	txtSelectCalendar: 'Выберите календарь',
	txtAlert: 'Уведомление',
	txtAlertNone: 'Нет',
	txtAlertMessage: 'Сообщение',
	txtAlertOnDate: 'По дате',
	txtAlertWeeksBefore: 'За N недель до',
	txtAlertDaysBefore: 'За N дней до',
	txtAlertHoursBefore: 'За N часов до',
	txtAlertMinutesBefore: 'За N минут до',
	txtAlertSecondsBefore: 'За N секунд до',
	txtAlertWeeksAfter: 'Через N недель после',
	txtAlertDaysAfter: 'Через N дней после',
	txtAlertHoursAfter: 'Через N часов после',
	txtAlertMinutesAfter: 'Через N мирнут после',
	txtAlertSecondsAfter: 'Через N секунд после',

	pholderAfterBeforeVal: 'Значение',
	pholderAlarmDate: 'Дата уведомления',
	pholderAlarmTime: 'Время уведомления',

	pholderNote: 'Примечание',

	eventPrevNav: 'Показать предыдущий экземпляр',
	eventNextNav: 'Показать следующий экземпляр',

	buttonClose: 'Закрыть',
	buttonDuplicate: 'Дубликат',

	txtAllSavedTodo: 'Задача успешно сохранена!',
	txtAllSaved: 'Событие успешно сохранено!',

	txtAllDeletedTodo: 'Задача успешно удалена!',
	txtAllDeleted: 'Событие успешно удалено!',

	txtNotChooseTodo: 'Ошибка: необходимо выбрать календарь!',
	txtNotChoose: 'Ошибка: необходимо выбрать календарь!',

	txtErrorDates: 'Ошибка: дата начала не может быть позже даты окончания!',
	txtErrorDatesTodo: 'Ошибка: дата начала не может быть позже даты окончания!',

	txtErorInputTodo: 'Исправьте неверные значения!',
	txtDateTimeErrorTodo: 'Укажите дату и время!',

	txtErorInput: 'Ошибка: исправьте подсвеченные неверные значения!',

	txtAlertsH: 'Уведомления',
	buttonAlert: 'Очистить уведомления',

	altAddEvent: 'Добавить событие',
	altAddTodo: 'Добавить задачу',

	loadingCalendars: 'Загрузка календарей (%act% из %total%) ...',
	unloadingCalendars: 'Выгружаю календари ...',

	errUnableSaveBeginCalDAV: 'Ошибка: \'не могу сохранить событие\': %%!',
	errUnableDeleteBeginCalDAV: 'Ошибка: \'не могу удалить событие\': %%!',
	CalDAVerrHttp410: 'Событие более не существует на сервере',
	errUnableSaveTodoBeginCalDAV: 'Ошибка: \'не могу сохранить задачу\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Ошибка: \'не могу удалить задачу\': %%!',
	CalDAVerrTodoHttp410: 'Задача более не существует на сервере'
};

localizationCalDAV['uk_UA']=	/* Sergey Yakimchuck <yakim@yakim.org.ua> */
{
	_default_title_format_month_: 'MMM yyyy',
	_default_title_format_week_: 'd[ MMM][ yyyy]{ \'–\' d MMM yyyy}',
	_default_title_format_day_: 'ddd, d MMM yyyy',
	_default_title_format_table_: 'ddd, MMM yyyy',
	_default_column_format_agenda_: 'ddd, d MMM',

	txtCalendar: 'Календар',
	txtEnabledCalendars: 'Включені календарі',
	txtTodo: 'Завдання',
	txtTodoList: 'Список завданя',
	txtTodoLists: 'Списки завдань',
	txtEnabledTodoLists: 'Включені списки завдань',
	txtSubscribed: 'Підписка',
	fullCalendarTable: 'таблиця',
	fullCalendarTodayButton: 'сьогодні',
	fullCalendarAllDay: 'всі дні',
	CalDAVsearch: 'Пошук',
	resourceEnable: 'Включити всі календарі на цьому ресурсі',
	resourceDisable: 'Вимкнути всі календарі на цьому ресурсі',
	allEnable: 'Включити всі календарі',
	allDisable: 'Вимкнути всі календарі',
	timezone: 'Часова зона',
	txtTimezonePicker: 'Часова зона:',
	loadingRList: 'Завантаження списку ресурсів ...',
	renderingE: 'Надання календарів ...',
	timezoneChange: 'Прийняття змін часової зони ...',
	customTimezone: 'Налаштований (локальний час)',
	customRepeat: 'Інше (Зміни не підтримуються)',
	loadPrevMonth: 'Завантаження попереднього місяця',
	loadNextMonth: 'Завантаження наступного місяця',
	repeatBoxButton: 'Повторення',
	repeatBoxContent: 'ця подія повторюється.',
	repeatBoxQuestion: 'З якою подією ви бажаєте працювати?',
	allEvsButton: 'Всі події',
	allFutureButton: 'Ця, та всі наступні події',
	eventOnlyButton: 'Лише ця подія',
	repeatBoxContentTODO: 'Завдання що повторюється.',
	repeatBoxQuestionTODO: 'З яким завданням ви бажаєте працювати?',
	allEvsButtonTODO: 'Всі завдання',
	allFutureButtonTODO: 'Це, та всі наступні завдання',
	eventOnlyButtonTODO: 'Лише це завдання',
	txtStatus: 'Статус',
	eventAvailability : 'Доступність',
	eventAvailabilityBusy : 'Зайнятий',
	eventAvailabilityFree : 'Вільний',
	eventType: 'Приватність',
	eventTypePublic: 'Загальнодоступне',
	eventTypePrivate: 'Приватне',
	eventTypeConfidential: 'Конфіденційне',
	txtPriority: 'Приорітет',
	txtPriorityNone: 'Немає',
	txtPriorityLow: 'Низький',
	txtPriorityMedium: 'Середній',
	txtPriorityHigh: 'Високий',
	eventURL : 'URL',
	repeatInterval: 'кожен',
	repeatDays: 'день',
	repeatWeeks: 'тиждень',
	repeatMonths: 'місяць',
	repeatYears: 'рік',
	repeatChangeTxt: 'було змінено на сервері!',
	repeatChangeTxtClose: 'Закрийте форму та відкрийте подію знову',
	repeatTodoChangeTxtClose: 'Закрийте форму та відкрийте завдання знову',
	calendarLoader: 'перезавантаження ...',
	resizeLoader: 'зміна розміру ...',

	// TODOS
	pholderNameTODO: 'Назва',
	pholderNewTODO: 'Нове  завдання',
	txtTypeTODO: 'Тип',
	txtTypeTODONone: 'Просте',
	txtTypeTODOStart: 'Час початку',
	txtTypeTODODue: 'Тривалість',
	txtTypeTODOBoth: 'З часом початку та тривалістю',
	txtDateFromTODO: 'З',
	txtDateToTODO: 'До',
	txtCompletedOn: 'Завершено в',

	pholderDateFromTODO: 'Початкова дата',
	pholderTimeFromTODO: 'Початковий час',
	pholderDateToTODO: 'Кінцева дата',
	pholderTimeToTODO: 'Кінцевий час',
	pholderCompletedOnDate: 'Дата',
	pholderCompletedOnTime: 'Час',

	txtStatusFiltersHeaderTODO: 'Фільтри',
	txtStatusFiltersFooterTODO: '* завершення після чи в  %date%',
	txtStatusNeedsActionTODO: 'Потребує дії',
	txtStatusCompletedTODO: 'Завершено',
	txtStatusInProcessTODO: 'В процесі',
	txtStatusCancelledTODO: 'Скасовано',
	txtPercentCompletedTODO: 'Завершено',

	txtCalendarTODO: 'Календар',
	txtSelectCalendarTODO: 'Оберіть календар',
	txtAlertTODO: 'Попередження',
	txtAlertNoneTODO: 'Нічого',
	txtAlertMessageTODO: 'Повідомлення',
	txtAlertOnDateTODO: 'За дати',
	txtAlertWeeksBeforeTODO: 'За тижнів',
	txtAlertDaysBeforeTODO: 'За днів',
	txtAlertHoursBeforeTODO: 'За годин',
	txtAlertMinutesBeforeTODO: 'За хвилин',
	txtAlertSecondsBeforeTODO: 'За секунд',
	txtAlertWeeksAfterTODO: 'Через тижнів',
	txtAlertDaysAfterTODO: 'Через днів',
	txtAlertHoursAfterTODO: 'Через годин',
	txtAlertMinutesAfterTODO: 'Через хвилин',
	txtAlertSecondsAfterTODO: 'Через секунд',

	pholderAfterBeforeValTODO: 'Значення',
	pholderAlarmDateTODO: 'Дата попередження',
	pholderAlarmTimeTODO: 'Час попередження',

	pholderNoteTODO: 'Примітка',
	txtNoteTODO: 'Примітка',

	todoPrevNav: 'Показати попередній елемент',
	todoNextNav: 'Показати наступний елемент',
	todoUncompletedPrevNav: 'Показати попередній незавершений елемент',
	todoUncompletedNextNav: 'Показати наступний незавершений елемент',

	buttonSaveTODO: 'Зберегти',
	buttonEditTODO: 'Редагувати',
	buttonDuplicateTODO: 'Дублікат',
	buttonResetTODO: 'Скасувати',
	buttonCloseTODO: 'Закрити',
	buttonDeleteTODO: 'Видалити',

	// EVENTS
	pholderName: 'Назва',
	pholderNewEvent: 'Нова подія',
	txtLocation: 'Місцерозташування',
	pholderLocation: 'Місцерозташування',

	txtAllDay: 'Весь день',
	from: 'З',
	to: 'До',

	pholderDateFrom: 'З дати',
	pholderTimeFrom: 'З часу',
	pholderDateTo: 'До дати',
	pholderTimeTo: 'До часу',

	txtStatusNone: 'Не визначено',
	txtStatusTentative: 'Не певно',
	txtStatusConfirmed: 'Підтверджено',
	txtStatusCancelled: 'Скасовано',

	txtRepeat: 'Повторити',
	txtNoRepeat: 'Не повторювати',
	txtRepeatDay: 'Щоденно',
	txtRepeatWeek: 'Щотижня',
	txtRepeatWeekend: 'Кожні вихідні',
	txtRepeatMonth: 'Щомісяця',
	txtRepeatTwoWeek: 'кожних два тижні',
	txtRepeatYear: 'Щорічно',
	txtRepeatCustomWeek: 'Тижнева періодичність',
	txtRepeatCustomMonth: 'Місячна періодичність',
	txtRepeatCustomYear: 'Річна періодичність',
	txtRepeatWork: 'Кожен робочий день',
	txtRepeatOnDate: 'За дати',
	txtRepeatAfter: 'Повторів',
	txtRepeatNever: 'Ніколи',
	pholderUntilDate: 'До дати',
	pholderRepeatCount: 'Кількість повторень',
	txtRepeatCustomWeekLabel: 'в',
	txtRepeatCustomMonthLabel: 'в дні',
	txtRepeatCustomMonthEvery: 'кожен',
	txtRepeatCustomMonthFirst: 'Перший',
	txtRepeatCustomMonthSecond: 'Другий',
	txtRepeatCustomMonthThird: 'Третій',
	txtRepeatCustomMonthFourth: 'Четвертий',
	txtRepeatCustomMonthFifth: 'П\'ятий',
	txtRepeatCustomMonthLast: 'Останній',
	txtRepeatCustomMonthCustom: 'Обрати',
	txtRepeatCustomMonthMonth: 'День місяця',
	txtRepeatCustomYearLabel1: 'кожен',
	txtRepeatCustomYearLabel2: 'з',

	txtRepeatEnd: 'Кінець',
	txtEventCalendar: 'Календар',
	txtSelectCalendar: 'Оберіть календар',
	txtAlert: 'Попередження',
	txtAlertNone: 'Немає',
	txtAlertMessage: 'Повідомлення',
	txtAlertOnDate: 'За дати',
	txtAlertWeeksBefore: 'За тижнів',
	txtAlertDaysBefore: 'За днів',
	txtAlertHoursBefore: 'За годин',
	txtAlertMinutesBefore: 'За хвилин',
	txtAlertSecondsBefore: 'За секунд',
	txtAlertWeeksAfter: 'Через тижнів',
	txtAlertDaysAfter: 'Через днів',
	txtAlertHoursAfter: 'Через днів',
	txtAlertMinutesAfter: 'Через хвилин',
	txtAlertSecondsAfter: 'Через секунд',

	pholderAfterBeforeVal: 'Значення',
	pholderAlarmDate: 'Дата попередження',
	pholderAlarmTime: 'Час попередження',

	pholderNote: 'Примітка',

	eventPrevNav: 'Показати попередній елемент',
	eventNextNav: 'Показати наступний елемент',

	buttonClose: 'Закрити',
	buttonDuplicate: 'Дублікат',

	txtAllSavedTodo: 'Успіх: Завдання збережено!',
	txtAllSaved: 'Успіх: Подію збережено',

	txtAllDeletedTodo: 'Успіх: Завдання видалено!',
	txtAllDeleted: 'Успіх: Подію видалено!',

	txtNotChooseTodo: 'Помилка: Треба обрати календар!',
	txtNotChoose: 'Помилка: Треба обрати календар!',

	txtErrorDates: 'Помилка: Дата початки має передувати даті закінчення!',
	txtErrorDatesTodo: 'Помилка: Дата початки має передувати даті закінчення!',

	txtErorInputTodo: 'Неможливо зберегти: виправіть помилкові значення!',
	txtDateTimeErrorTodo: 'Треба обрати дату та час!',

	txtErorInput: 'Помилка: \'неможливо зберегти\': виправіть підсвічені помилкові значення!',

	txtAlertsH: 'Попередження',
	buttonAlert: 'Очистити попередження',

	altAddEvent: 'Додати подію',
	altAddTodo: 'Додати завдання',

	loadingCalendars: 'Завантаження календарів (%act% з %total%) ...',
	unloadingCalendars: 'Розвантаження календарі ...',

	errUnableSaveBeginCalDAV: 'Помилка: \'неможливо зберегти подію\': %%!',
	errUnableDeleteBeginCalDAV: 'Помилка: \'неможливо видалити подію\': %%!',
	CalDAVerrHttp410: 'Подія більше недоступна на сервері',
	errUnableSaveTodoBeginCalDAV: 'Помилка: \'неможливо видалити завдання\': %%!',
	errUnableDeleteTodoBeginCalDAV: 'Помилка: \'неможливо зберегти завдання\': %%!',
	CalDAVerrTodoHttp410: 'Завдання більше недоступне на сервері'
};

localizationCalDAV['zh_CN']=	/* thanks Fandy */
{
	_default_title_format_month_: 'yyyy年MMM月',
	_default_title_format_week_: 'yyyy年MMM月d日{ \'–\'[ yyyy年][ MMM月]d 日}',
	_default_title_format_day_: 'yyyy年MMM月d日, ddd',
	_default_title_format_table_: 'yyyy年MMM月, ddd',
	_default_column_format_agenda_: 'ddd, MMM月 d日',

	txtCalendar: '日程',
	txtEnabledCalendars: '选择日程表',
	txtTodo: '待办',
	txtTodoList: '待办列表',
	txtTodoLists: '待办列表',
	txtEnabledTodoLists: '可选待办列表',
	txtSubscribed: '订阅',
	fullCalendarTable: '日程表',
	fullCalendarTodayButton: '今天',
	fullCalendarAllDay: '全天',
	CalDAVsearch: '查找',
	resourceEnable: '启用此资源中的所有日历',
	resourceDisable: '关闭此资源中的所有日历',
	allEnable: '启用所有日历',
	allDisable: '关闭所有日历',
	timezone: '时区',
	txtTimezonePicker: '时区:',
	loadingRList: '加载资源列表 ...',
	renderingE: '加载日程 ...',
	timezoneChange: '应用更改时区 ...',
	customTimezone: '自定义 (本地时区)',
	customRepeat: '其它 (不支持修改)',
	loadPrevMonth: '加载上个月',
	loadNextMonth: '加载下个月',
	repeatBoxButton: '重复',
	repeatBoxContent: '重复事件.',
	repeatBoxQuestion: '你将要要处理哪件活动?',
	allEvsButton: '所有事宜',
	allFutureButton: '未来事宜',
	eventOnlyButton: '本事宜',
	repeatBoxContentTODO: '重复待办事件',
	repeatBoxQuestionTODO: '你将要处理哪件待办事情?',
	allEvsButtonTODO: '所有待办',
	allFutureButtonTODO: '目前及以后待办事情',
	eventOnlyButtonTODO: '仅此待办事情',
	txtStatus: '状态',
	eventAvailability : '可用性',
	eventAvailabilityBusy : '忙碌',
	eventAvailabilityFree : '空闲',
	eventType: '私有',
	eventTypePublic: '公开',
	eventTypePrivate: '私有',
	eventTypeConfidential: '机密',
	txtPriority: '优先',
	txtPriorityNone: '无',
	txtPriorityLow: '低',
	txtPriorityMedium: '中',
	txtPriorityHigh: '高',
	eventURL : '链接',
	repeatInterval: '间隔',
	repeatDays: '每日',
	repeatWeeks: '每周',
	repeatMonths: '每月',
	repeatYears: '每年',
	repeatChangeTxt: '在服务器上发生了改变！',
	repeatChangeTxtClose: '关闭窗体，重新打开活动',
	repeatTodoChangeTxtClose: '关闭窗体，重新打开待办',
	calendarLoader: '重新加载中 ...',
	resizeLoader: '调整大小...',

	// TODOS
	pholderNameTODO: '待办事宜',
	pholderNewTODO: '新待办',
	txtTypeTODO: '类型',
	txtTypeTODONone: '简易',
	txtTypeTODOStart: '开始时间',
	txtTypeTODODue: '结束时间',
	txtTypeTODOBoth: '开始时间和结束时间',
	txtDateFromTODO: '从',
	txtDateToTODO: '到',
	txtCompletedOn: '完成',

	pholderDateFromTODO: '开始日期',
	pholderTimeFromTODO: '开始时间',
	pholderDateToTODO: '结束日期',
	pholderTimeToTODO: '结束时间',
	pholderCompletedOnDate: '日期',
	pholderCompletedOnTime: '时间',

	txtStatusFiltersHeaderTODO: '过滤',
	txtStatusFiltersFooterTODO: '* 已完成及 %date%之后待办',
	txtStatusNeedsActionTODO: '待办',
	txtStatusCompletedTODO: '完成',
	txtStatusInProcessTODO: '进行中',
	txtStatusCancelledTODO: '取消',
	txtPercentCompletedTODO: '完成',

	txtCalendarTODO: '日历',
	txtSelectCalendarTODO: '请选择一个日历',
	txtAlertTODO: '提醒',
	txtAlertNoneTODO: '无提醒',
	txtAlertMessageTODO: '消息',
	txtAlertOnDateTODO: '指定日期',
	txtAlertWeeksBeforeTODO: '下一周之前',
	txtAlertDaysBeforeTODO: '第二天前',
	txtAlertHoursBeforeTODO: '下一个小时前',
	txtAlertMinutesBeforeTODO: '下一分钟前',
	txtAlertSecondsBeforeTODO: '下一秒前',
	txtAlertWeeksAfterTODO: '下一周之后 ',
	txtAlertDaysAfterTODO: '下一天后',
	txtAlertHoursAfterTODO: '下一个小时后',
	txtAlertMinutesAfterTODO: '下一分钟后 ',
	txtAlertSecondsAfterTODO: '下一秒后',

	pholderAfterBeforeValTODO: '值',
	pholderAlarmDateTODO: '提醒日期 ',
	pholderAlarmTimeTODO: '提醒时间',

	pholderNoteTODO: '备注',
	txtNoteTODO: '备注',

	todoPrevNav: '显示上一个',
	todoNextNav: '显示下一个',
	todoUncompletedPrevNav: '显示上一个未完成的',
	todoUncompletedNextNav: '显示下一个未完成的',

	buttonSaveTODO: '保存',
	buttonEditTODO: '编辑',
	buttonDuplicateTODO: '复制',
	buttonResetTODO: '撤销',
	buttonCloseTODO: '关闭',
	buttonDeleteTODO: '删除',

	// EVENTS
	pholderName: '名称',
	pholderNewEvent: '新建事件',
	txtLocation: '地点',
	pholderLocation: '地点',

	txtAllDay: '全天否',
	from: '开始时间',
	to: '结束时间',

	pholderDateFrom: '开始日期',
	pholderTimeFrom: '开始时间',
	pholderDateTo: '结束日期',
	pholderTimeTo: '结束时间',

	txtStatusNone: '未指定',
	txtStatusTentative: '暂定',
	txtStatusConfirmed: '确认',
	txtStatusCancelled: '取消',

	txtRepeat: '重复',
	txtNoRepeat: '不重复',
	txtRepeatDay: '每日',
	txtRepeatWeek: '每周',
	txtRepeatWeekend: '每周末',
	txtRepeatMonth: '每月',
	txtRepeatTwoWeek: '双周',
	txtRepeatYear: '每年',
	txtRepeatCustomWeek: '自定义周',
	txtRepeatCustomMonth: '自定义月',
	txtRepeatCustomYear: '自定义年',
	txtRepeatWork: '每个工作日',
	txtRepeatOnDate: '指定日期',
	txtRepeatAfter: '事后',
	txtRepeatNever: '从不',
	pholderUntilDate: '日期为止',
	pholderRepeatCount: '重复数',
	txtRepeatCustomWeekLabel: '星期',
	txtRepeatCustomMonthLabel: '日期',
	txtRepeatCustomMonthEvery: '每',
	txtRepeatCustomMonthFirst: '第一',
	txtRepeatCustomMonthSecond: '第二',
	txtRepeatCustomMonthThird: '第三',
	txtRepeatCustomMonthFourth: '第四',
	txtRepeatCustomMonthFifth: '第五',
	txtRepeatCustomMonthLast: '最终',
	txtRepeatCustomMonthCustom: '定制',
	txtRepeatCustomMonthMonth: '日期',
	txtRepeatCustomYearLabel1: '每',
	txtRepeatCustomYearLabel2: '共',

	txtRepeatEnd: '结束',
	txtEventCalendar: '日程类型',
	txtSelectCalendar: '请选择日程',
	txtAlert: '提醒',
	txtAlertNone: '无提醒',
	txtAlertMessage: '消息',
	txtAlertOnDate: '指定日期',
	txtAlertWeeksBefore: '下一周之前',
	txtAlertDaysBefore: '第二天前',
	txtAlertHoursBefore: '下一个小时前',
	txtAlertMinutesBefore: '下一分钟前',
	txtAlertSecondsBefore: '下一秒前',
	txtAlertWeeksAfter: '下一周之后',
	txtAlertDaysAfter: '下一天后',
	txtAlertHoursAfter: '下一个小时后',
	txtAlertMinutesAfter: '下一分钟后',
	txtAlertSecondsAfter: '下一秒后',

	pholderAfterBeforeVal: '值',
	pholderAlarmDate: '提醒日期',
	pholderAlarmTime: '提醒时间',

	pholderNote: '备注',

	eventPrevNav: '显示上一个',
	eventNextNav: '显示下一个',

	buttonClose: '关闭',
	buttonDuplicate: '复制',

	txtAllSavedTodo: '待办保存成功! ',
	txtAllSaved: '保存成功!',

	txtAllDeletedTodo: '待办删除成功!',
	txtAllDeleted: '删除成功!',

	txtNotChooseTodo: '错误:请先关闭日程!',
	txtNotChoose: '错误:请先选择日程!',

	txtErrorDates: '错误：开始日期必须小于结束日期!',
	txtErrorDatesTodo: '错误：开始日期必须小于结束日期!',

	txtErorInputTodo: '不能保存: 请修改无效的值!',
	txtDateTimeErrorTodo: '请选择日期和时间!',

	txtErorInput: '错误: \'不能保存\': 请修改高亮的值!',

	txtAlertsH: '提醒',
	buttonAlert: '清空提醒',

	altAddEvent: '新建日程',
	altAddTodo: '新建待办',

	loadingCalendars: '日程加载中 (第%act% 个/共%total%个) ...',
	unloadingCalendars: '卸载日程...',

	errUnableSaveBeginCalDAV: '错误: \'活动不能保存\': %%!',
	errUnableDeleteBeginCalDAV: '错误: \'活动不能删除\': %%!',
	CalDAVerrHttp410: '活动已经在服务器上',
	errUnableSaveTodoBeginCalDAV: '错误: \'不能保存待办\': %%!',
	errUnableDeleteTodoBeginCalDAV: '错误: \'不能删除待办\': %%!',
	CalDAVerrTodoHttp410: '待办已经服务器上。'
};

$.extend(true, localization, localizationCalDAV);
