/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.holder;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.drools.core.common.AgendaItem;
import org.drools.core.spi.Activation;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.api.score.holder.ScoreHolder;

public abstract class AbstractScoreHolder<Score_ extends Score<Score_>>
implements ScoreHolder<Score_>,
Serializable {
    protected final boolean constraintMatchEnabled;
    protected final Map<String, ConstraintMatchTotal> constraintMatchTotalMap;
    protected final Map<Object, Indictment> indictmentMap;
    protected final Score_ zeroScore;

    protected AbstractScoreHolder(boolean constraintMatchEnabled, Score_ zeroScore) {
        this.constraintMatchEnabled = constraintMatchEnabled;
        this.constraintMatchTotalMap = constraintMatchEnabled ? new LinkedHashMap() : null;
        this.indictmentMap = constraintMatchEnabled ? new LinkedHashMap() : null;
        this.zeroScore = zeroScore;
    }

    @Override
    public boolean isConstraintMatchEnabled() {
        return this.constraintMatchEnabled;
    }

    @Override
    public Collection<ConstraintMatchTotal> getConstraintMatchTotals() {
        if (!this.isConstraintMatchEnabled()) {
            throw new IllegalStateException("When constraintMatchEnabled (" + this.isConstraintMatchEnabled() + ") is disabled in the constructor, this method should not be called.");
        }
        return this.constraintMatchTotalMap.values();
    }

    @Override
    public Map<String, ConstraintMatchTotal> getConstraintMatchTotalMap() {
        if (!this.isConstraintMatchEnabled()) {
            throw new IllegalStateException("When constraintMatchEnabled (" + this.isConstraintMatchEnabled() + ") is disabled in the constructor, this method should not be called.");
        }
        return this.constraintMatchTotalMap;
    }

    @Override
    public Map<Object, Indictment> getIndictmentMap() {
        if (!this.isConstraintMatchEnabled()) {
            throw new IllegalStateException("When constraintMatchEnabled (" + this.isConstraintMatchEnabled() + ") is disabled in the constructor, this method should not be called.");
        }
        return this.indictmentMap;
    }

    @Override
    public void configureConstraintWeight(Rule rule, Score_ constraintWeight) {
        if (constraintWeight.getInitScore() != 0) {
            throw new IllegalStateException("The initScore (" + constraintWeight.getInitScore() + ") must be 0.");
        }
        if (this.constraintMatchEnabled) {
            String constraintPackage = rule.getPackageName();
            String constraintName = rule.getName();
            String constraintId = ConstraintMatchTotal.composeConstraintId(constraintPackage, constraintName);
            this.constraintMatchTotalMap.put(constraintId, new ConstraintMatchTotal(constraintPackage, constraintName, (Score)constraintWeight, (Score)this.zeroScore));
        }
    }

    protected void registerConstraintMatch(RuleContext kcontext, Runnable constraintUndoListener, Supplier<Score_> scoreSupplier) {
        AgendaItem agendaItem = (AgendaItem)kcontext.getMatch();
        ConstraintActivationUnMatchListener constraintActivationUnMatchListener = new ConstraintActivationUnMatchListener(constraintUndoListener);
        agendaItem.setCallback((Runnable)constraintActivationUnMatchListener);
        if (this.constraintMatchEnabled) {
            List<Object> justificationList = this.extractJustificationList(kcontext);
            constraintActivationUnMatchListener.constraintMatchTotal = this.findConstraintMatchTotal(kcontext);
            ConstraintMatch constraintMatch = constraintActivationUnMatchListener.constraintMatchTotal.addConstraintMatch(justificationList, (Score)scoreSupplier.get());
            List indictmentList = justificationList.stream().distinct().map(justification -> {
                Indictment indictment = this.indictmentMap.computeIfAbsent(justification, k -> new Indictment(justification, (Score)this.zeroScore));
                indictment.addConstraintMatch(constraintMatch);
                return indictment;
            }).collect(Collectors.toList());
            constraintActivationUnMatchListener.constraintMatch = constraintMatch;
            constraintActivationUnMatchListener.indictmentList = indictmentList;
        }
    }

    private ConstraintMatchTotal findConstraintMatchTotal(RuleContext kcontext) {
        Rule rule = kcontext.getRule();
        String constraintPackage = rule.getPackageName();
        String constraintName = rule.getName();
        String constraintId = ConstraintMatchTotal.composeConstraintId(constraintPackage, constraintName);
        return this.constraintMatchTotalMap.computeIfAbsent(constraintId, k -> new ConstraintMatchTotal(constraintPackage, constraintName, null, (Score)this.zeroScore));
    }

    protected List<Object> extractJustificationList(RuleContext kcontext) {
        return ((Activation)kcontext.getMatch()).getObjectsDeep();
    }

    public class ConstraintActivationUnMatchListener
    implements Runnable {
        private final Runnable constraintUndoListener;
        private ConstraintMatchTotal constraintMatchTotal;
        private List<Indictment> indictmentList;
        private ConstraintMatch constraintMatch;

        public ConstraintActivationUnMatchListener(Runnable constraintUndoListener) {
            this.constraintUndoListener = constraintUndoListener;
        }

        @Override
        public final void run() {
            this.constraintUndoListener.run();
            if (AbstractScoreHolder.this.constraintMatchEnabled) {
                this.constraintMatchTotal.removeConstraintMatch(this.constraintMatch);
                for (Indictment indictment : this.indictmentList) {
                    indictment.removeConstraintMatch(this.constraintMatch);
                    if (!indictment.getConstraintMatchSet().isEmpty()) continue;
                    AbstractScoreHolder.this.indictmentMap.remove(indictment.getJustification());
                }
            }
        }
    }
}

