/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet;

import java.util.LinkedHashMap;
import java.util.List;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.stream.ConstraintSession;
import org.optaplanner.core.impl.score.stream.ConstraintSessionFactory;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintSession;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetConstraint;

public final class BavetConstraintSessionFactory<Solution_>
implements ConstraintSessionFactory<Solution_> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final List<BavetConstraint<Solution_>> constraintList;

    public BavetConstraintSessionFactory(SolutionDescriptor<Solution_> solutionDescriptor, List<BavetConstraint<Solution_>> constraintList) {
        this.solutionDescriptor = solutionDescriptor;
        this.constraintList = constraintList;
    }

    @Override
    public ConstraintSession<Solution_> buildSession(boolean constraintMatchEnabled, Solution_ workingSolution) {
        Object zeroScore = this.solutionDescriptor.getScoreDefinition().getZeroScore();
        LinkedHashMap constraintToWeightMap = new LinkedHashMap(this.constraintList.size());
        for (BavetConstraint<Solution_> constraint : this.constraintList) {
            Score<?> constraintWeight = constraint.extractConstraintWeight(workingSolution);
            if (constraintWeight.equals(zeroScore)) continue;
            constraintToWeightMap.put(constraint, constraintWeight);
        }
        return new BavetConstraintSession(constraintMatchEnabled, this.solutionDescriptor.getScoreDefinition(), constraintToWeightMap);
    }
}

