/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.drools.model.Global;
import org.drools.model.PatternDSL;
import org.drools.model.Rule;
import org.drools.model.RuleItemBuilder;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsFromUniConstraintStream;

public class DroolsConstraint<Solution_>
implements Constraint {
    private final DroolsConstraintFactory<Solution_> constraintFactory;
    private final String constraintPackage;
    private final String constraintName;
    private Function<Solution_, Score<?>> constraintWeightExtractor;
    private final boolean positive;
    private final List<DroolsFromUniConstraintStream<Solution_, Object>> fromStreamList;

    public DroolsConstraint(DroolsConstraintFactory<Solution_> constraintFactory, String constraintPackage, String constraintName, Function<Solution_, Score<?>> constraintWeightExtractor, boolean positive, List<DroolsFromUniConstraintStream<Solution_, Object>> fromStreamList) {
        this.constraintFactory = constraintFactory;
        this.constraintPackage = constraintPackage;
        this.constraintName = constraintName;
        this.constraintWeightExtractor = constraintWeightExtractor;
        this.positive = positive;
        this.fromStreamList = fromStreamList;
    }

    public Score<?> extractConstraintWeight(Solution_ workingSolution) {
        Score<?> constraintWeight = this.constraintWeightExtractor.apply(workingSolution);
        this.constraintFactory.getSolutionDescriptor().validateConstraintWeight(this.constraintPackage, this.constraintName, constraintWeight);
        return this.positive ? constraintWeight : constraintWeight.negate();
    }

    public Rule createRule(Global<? extends AbstractScoreHolder> scoreHolderGlobal) {
        ArrayList ruleItemBuilderList = new ArrayList(this.fromStreamList.size());
        for (DroolsFromUniConstraintStream<Solution_, Object> fromStream : this.fromStreamList) {
            fromStream.createRuleItemBuilders(ruleItemBuilderList, scoreHolderGlobal);
        }
        return PatternDSL.rule((String)this.constraintPackage, (String)this.constraintName).build(ruleItemBuilderList.toArray(new RuleItemBuilder[0]));
    }

    @Override
    public ConstraintFactory getConstraintFactory() {
        return this.constraintFactory;
    }

    @Override
    public String getConstraintPackage() {
        return this.constraintPackage;
    }

    @Override
    public String getConstraintName() {
        return this.constraintName;
    }
}

