/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.bi;

import java.io.Serializable;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.drools.model.Declaration;
import org.drools.model.PatternDSL;
import org.drools.model.functions.Predicate2;
import org.optaplanner.core.api.score.stream.bi.BiJoiner;
import org.optaplanner.core.impl.score.stream.bi.AbstractBiJoiner;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsAbstractBiConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsAbstractUniConstraintStream;

public class DroolsJoinBiConstraintStream<Solution_, A, B>
extends DroolsAbstractBiConstraintStream<Solution_, A, B> {
    private final DroolsAbstractUniConstraintStream<Solution_, A> leftParentStream;
    private final DroolsAbstractUniConstraintStream<Solution_, B> rightParentStream;
    private final AbstractBiJoiner<A, B> biJoiner;
    private final PatternDSL.PatternDef<B> rightPattern;
    private final Map<JoinerType, BiPredicate<Object, Object>> joinerTypeToMatcherMap = new EnumMap<JoinerType, BiPredicate<Object, Object>>(JoinerType.class);

    public DroolsJoinBiConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractUniConstraintStream<Solution_, A> parent, DroolsAbstractUniConstraintStream<Solution_, B> otherStream, BiJoiner<A, B> biJoiner) {
        super(constraintFactory, null);
        this.leftParentStream = parent;
        this.rightParentStream = otherStream;
        this.biJoiner = (AbstractBiJoiner)biJoiner;
        this.rightPattern = otherStream.getPattern().expr(this.getLeftVariableDeclaration(), (Predicate2 & Serializable)(b, a) -> this.matches(a, b));
    }

    @Override
    public DroolsAbstractUniConstraintStream<Solution_, A> getLeftParentStream() {
        return this.leftParentStream;
    }

    @Override
    public DroolsAbstractUniConstraintStream<Solution_, B> getRightParentStream() {
        return this.rightParentStream;
    }

    @Override
    public Declaration<A> getLeftVariableDeclaration() {
        return this.leftParentStream.getVariableDeclaration();
    }

    @Override
    public PatternDSL.PatternDef<A> getLeftPattern() {
        return this.leftParentStream.getPattern();
    }

    @Override
    public Declaration<B> getRightVariableDeclaration() {
        return this.rightParentStream.getVariableDeclaration();
    }

    @Override
    public PatternDSL.PatternDef<B> getRightPattern() {
        return this.rightPattern;
    }

    private boolean matches(A left, B right) {
        Object[] leftMappings = this.biJoiner.getLeftCombinedMapping().apply(left);
        Object[] rightMappings = this.biJoiner.getRightCombinedMapping().apply(right);
        BiPredicate[] matchers = (BiPredicate[])Stream.of(this.biJoiner.getJoinerTypes()).map(joinerType -> this.joinerTypeToMatcherMap.computeIfAbsent((JoinerType)((Object)joinerType), DroolsJoinBiConstraintStream::createMatcher)).toArray(BiPredicate[]::new);
        for (int i = 0; i < matchers.length; ++i) {
            BiPredicate matcher = matchers[i];
            if (matcher.test(leftMappings[i], rightMappings[i])) continue;
            return false;
        }
        return true;
    }

    private static BiPredicate<Object, Object> createMatcher(JoinerType type) {
        switch (type) {
            case EQUAL: {
                return Object::equals;
            }
            case LESS_THAN: {
                return (a, b) -> DroolsJoinBiConstraintStream.lessThan((Comparable)a, b);
            }
            case LESS_THAN_OR_EQUAL: {
                return (a, b) -> DroolsJoinBiConstraintStream.lessThanOrEqual((Comparable)a, b);
            }
            case GREATER_THAN: {
                return (a, b) -> DroolsJoinBiConstraintStream.greaterThan((Comparable)a, b);
            }
            case GREATER_THAN_OR_EQUAL: {
                return (a, b) -> DroolsJoinBiConstraintStream.greaterThanOrEqual((Comparable)a, b);
            }
            case CONTAINING: {
                return (a, b) -> ((Collection)a).contains(b);
            }
            case DISJOINT: {
                return (a, b) -> DroolsJoinBiConstraintStream.disjointColections((Collection)a, (Collection)b);
            }
            case INTERSECTING: {
                return (a, b) -> DroolsJoinBiConstraintStream.intersectingCollections((Collection)a, (Collection)b);
            }
        }
        throw new IllegalStateException("Unsupported joiner type (" + (Object)((Object)type) + ").");
    }

    private static boolean lessThan(Comparable left, Object right) {
        return left.compareTo(right) < 0;
    }

    private static boolean lessThanOrEqual(Comparable left, Object right) {
        return left.compareTo(right) <= 0;
    }

    private static boolean greaterThan(Comparable left, Object right) {
        return left.compareTo(right) > 0;
    }

    private static boolean greaterThanOrEqual(Comparable left, Object right) {
        return left.compareTo(right) >= 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean disjointColections(Collection leftCollection, Collection rightCollection) {
        if (!leftCollection.stream().noneMatch(rightCollection::contains)) return false;
        if (!rightCollection.stream().noneMatch(leftCollection::contains)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean intersectingCollections(Collection leftCollection, Collection rightCollection) {
        if (leftCollection.stream().anyMatch(rightCollection::contains)) return true;
        if (!rightCollection.stream().anyMatch(leftCollection::contains)) return false;
        return true;
    }

    public String toString() {
        return "BiJoin() with " + this.childStreamList.size() + " children";
    }
}

