/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.bi;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.ToIntBiFunction;
import java.util.function.ToLongBiFunction;
import org.drools.model.Declaration;
import org.drools.model.Global;
import org.drools.model.PatternDSL;
import org.drools.model.RuleItemBuilder;
import org.drools.model.consequences.ConsequenceBuilder;
import org.drools.model.functions.Block4;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsAbstractBiConstraintStream;

public final class DroolsScoringBiConstraintStream<Solution_, A, B>
extends DroolsAbstractBiConstraintStream<Solution_, A, B> {
    private final DroolsConstraint<Solution_> constraint;
    private final boolean noMatchWeigher;
    private final ToIntBiFunction<A, B> intMatchWeigher;
    private final ToLongBiFunction<A, B> longMatchWeigher;
    private final BiFunction<A, B, BigDecimal> bigDecimalMatchWeigher;

    public DroolsScoringBiConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractBiConstraintStream<Solution_, A, B> parent, DroolsConstraint<Solution_> constraint) {
        this(constraintFactory, parent, constraint, true, null, null, null);
    }

    public DroolsScoringBiConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractBiConstraintStream<Solution_, A, B> parent, DroolsConstraint<Solution_> constraint, ToIntBiFunction<A, B> intMatchWeigher) {
        this(constraintFactory, parent, constraint, false, intMatchWeigher, null, null);
        if (intMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public DroolsScoringBiConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractBiConstraintStream<Solution_, A, B> parent, DroolsConstraint<Solution_> constraint, ToLongBiFunction<A, B> longMatchWeigher) {
        this(constraintFactory, parent, constraint, false, null, longMatchWeigher, null);
        if (longMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public DroolsScoringBiConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractBiConstraintStream<Solution_, A, B> parent, DroolsConstraint<Solution_> constraint, BiFunction<A, B, BigDecimal> bigDecimalMatchWeigher) {
        this(constraintFactory, parent, constraint, false, null, null, bigDecimalMatchWeigher);
        if (bigDecimalMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    private DroolsScoringBiConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractBiConstraintStream<Solution_, A, B> parent, DroolsConstraint<Solution_> constraint, boolean noMatchWeigher, ToIntBiFunction<A, B> intMatchWeigher, ToLongBiFunction<A, B> longMatchWeigher, BiFunction<A, B, BigDecimal> bigDecimalMatchWeigher) {
        super(constraintFactory, parent);
        this.constraint = constraint;
        this.noMatchWeigher = noMatchWeigher;
        this.intMatchWeigher = intMatchWeigher;
        this.longMatchWeigher = longMatchWeigher;
        this.bigDecimalMatchWeigher = bigDecimalMatchWeigher;
    }

    @Override
    public void createRuleItemBuilders(List<RuleItemBuilder<?>> ruleItemBuilderList, Global<? extends AbstractScoreHolder> scoreHolderGlobal) {
        ConsequenceBuilder._3 consequence;
        ruleItemBuilderList.add((RuleItemBuilder<?>)this.getLeftPattern());
        ruleItemBuilderList.add((RuleItemBuilder<?>)this.getRightPattern());
        Declaration<A> aVar = this.getLeftVariableDeclaration();
        Declaration<B> bVar = this.getRightVariableDeclaration();
        if (this.intMatchWeigher != null) {
            consequence = PatternDSL.on(scoreHolderGlobal, aVar, bVar).execute((Block4 & Serializable)(drools, scoreHolder, a, b) -> {
                RuleContext kcontext = (RuleContext)drools;
                int weightMultiplier = this.intMatchWeigher.applyAsInt(a, b);
                scoreHolder.impactScore(kcontext, weightMultiplier);
            });
        } else if (this.longMatchWeigher != null) {
            consequence = PatternDSL.on(scoreHolderGlobal, aVar, bVar).execute((Block4 & Serializable)(drools, scoreHolder, a, b) -> {
                RuleContext kcontext = (RuleContext)drools;
                long weightMultiplier = this.longMatchWeigher.applyAsLong(a, b);
                scoreHolder.impactScore(kcontext, weightMultiplier);
            });
        } else if (this.bigDecimalMatchWeigher != null) {
            consequence = PatternDSL.on(scoreHolderGlobal, aVar, bVar).execute((Block4 & Serializable)(drools, scoreHolder, a, b) -> {
                RuleContext kcontext = (RuleContext)drools;
                BigDecimal weightMultiplier = this.bigDecimalMatchWeigher.apply(a, b);
                scoreHolder.impactScore(kcontext, weightMultiplier);
            });
        } else if (this.noMatchWeigher) {
            consequence = PatternDSL.on(scoreHolderGlobal, aVar, bVar).execute((Block4 & Serializable)(drools, scoreHolder, a, b) -> {
                RuleContext kcontext = (RuleContext)drools;
                scoreHolder.impactScore(kcontext);
            });
        } else {
            throw new IllegalStateException("Impossible state: noMatchWeigher (" + this.noMatchWeigher + ").");
        }
        ruleItemBuilderList.add((RuleItemBuilder<?>)consequence);
    }

    @Override
    public Declaration<A> getLeftVariableDeclaration() {
        return this.parent.getLeftVariableDeclaration();
    }

    @Override
    public PatternDSL.PatternDef<A> getLeftPattern() {
        return this.parent.getLeftPattern();
    }

    @Override
    public Declaration<B> getRightVariableDeclaration() {
        return this.parent.getRightVariableDeclaration();
    }

    @Override
    public PatternDSL.PatternDef<B> getRightPattern() {
        return this.parent.getRightPattern();
    }

    public String toString() {
        return "BiScoring()";
    }
}

