/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.uni;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintSession;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetTupleState;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetAbstractUniNode;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetAbstractUniTuple;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetFilterUniTuple;

public final class BavetFilterUniNode<A>
extends BavetAbstractUniNode<A> {
    private final BavetAbstractUniNode<A> parentNode;
    private final Predicate<A> predicate;
    private List<BavetAbstractUniNode<A>> childNodeList = new ArrayList<BavetAbstractUniNode<A>>();

    public BavetFilterUniNode(BavetConstraintSession session, int nodeOrder, BavetAbstractUniNode<A> parentNode, Predicate<A> predicate) {
        super(session, nodeOrder);
        this.parentNode = parentNode;
        this.predicate = predicate;
    }

    @Override
    public void addChildNode(BavetAbstractUniNode<A> childNode) {
        this.childNodeList.add(childNode);
    }

    public int hashCode() {
        return 31 * System.identityHashCode(this.parentNode) + System.identityHashCode(this.predicate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BavetFilterUniNode) {
            BavetFilterUniNode other = (BavetFilterUniNode)o;
            return this.parentNode == other.parentNode && this.predicate == other.predicate;
        }
        return false;
    }

    @Override
    public BavetFilterUniTuple<A> createTuple(BavetAbstractUniTuple<A> parentTuple) {
        return new BavetFilterUniTuple<A>(this, parentTuple);
    }

    public void refresh(BavetFilterUniTuple<A> tuple) {
        A a = tuple.getFactA();
        List<BavetAbstractUniTuple<A>> childTupleList = tuple.getChildTupleList();
        for (BavetAbstractUniTuple<A> bavetAbstractUniTuple : childTupleList) {
            this.session.transitionTuple(bavetAbstractUniTuple, BavetTupleState.DYING);
        }
        childTupleList.clear();
        if (tuple.isActive() && this.predicate.test(a)) {
            for (BavetAbstractUniNode bavetAbstractUniNode : this.childNodeList) {
                BavetAbstractUniTuple<A> childTuple = bavetAbstractUniNode.createTuple(tuple);
                childTupleList.add(childTuple);
                this.session.transitionTuple(childTuple, BavetTupleState.CREATING);
            }
        }
        tuple.refreshed();
    }

    public String toString() {
        return "Filter() with " + this.childNodeList.size() + " children";
    }
}

