/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.api.KieBase;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.KieSession;
import org.kie.internal.event.rule.RuleEventListener;
import org.kie.internal.event.rule.RuleEventManager;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.drools.OptaPlannerRuleEventListener;
import org.optaplanner.core.impl.score.stream.ConstraintSession;
import org.optaplanner.core.impl.score.stream.ConstraintSessionFactory;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintSession;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsGroupByAccumulator;

public class DroolsConstraintSessionFactory<Solution_>
implements ConstraintSessionFactory<Solution_> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final KieBase kieBase;
    private final Map<Rule, DroolsConstraint<Solution_>> constraints;

    public DroolsConstraintSessionFactory(SolutionDescriptor<Solution_> solutionDescriptor, KieBase kieBase, List<DroolsConstraint<Solution_>> constraintList) {
        this.solutionDescriptor = solutionDescriptor;
        this.kieBase = kieBase;
        this.constraints = constraintList.stream().collect(Collectors.toMap(constraint -> kieBase.getRule(constraint.getConstraintPackage(), constraint.getConstraintName()), Function.identity()));
    }

    @Override
    public ConstraintSession<Solution_> buildSession(boolean constraintMatchEnabled, Solution_ workingSolution) {
        ScoreDefinition scoreDefinition = this.solutionDescriptor.getScoreDefinition();
        AbstractScoreHolder scoreHolder = (AbstractScoreHolder)scoreDefinition.buildScoreHolder(constraintMatchEnabled);
        scoreHolder.setJustificationListConverter((justificationList, rule) -> DroolsConstraintSessionFactory.unpair((List)justificationList, this.constraints.get(rule).getConstraintStreamCardinality()));
        this.constraints.forEach((rule, constraint) -> scoreHolder.configureConstraintWeight((Rule)rule, constraint.extractConstraintWeight(workingSolution)));
        KieSession kieSession = this.kieBase.newKieSession();
        ((RuleEventManager)kieSession).addEventListener((RuleEventListener)new OptaPlannerRuleEventListener());
        kieSession.setGlobal("scoreHolder", (Object)scoreHolder);
        return new DroolsConstraintSession(constraintMatchEnabled, kieSession, scoreHolder);
    }

    private static List<Object> unpair(List<Object> justificationList, int expectedJustificationCount) {
        return justificationList.stream().flatMap(item -> {
            if (item instanceof DroolsGroupByAccumulator.Pair) {
                DroolsGroupByAccumulator.Pair pair = (DroolsGroupByAccumulator.Pair)item;
                return Stream.of(pair.key, pair.value);
            }
            return Stream.of(item);
        }).limit(expectedJustificationCount).collect(Collectors.toList());
    }
}

