/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.bi;

import java.math.BigDecimal;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.ToIntBiFunction;
import java.util.function.ToLongBiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.bi.BiConstraintCollector;
import org.optaplanner.core.api.score.stream.bi.BiConstraintStream;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintStream;
import org.optaplanner.core.api.score.stream.tri.TriConstraintStream;
import org.optaplanner.core.api.score.stream.tri.TriJoiner;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;
import org.optaplanner.core.impl.score.stream.bi.InnerBiConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsBiCondition;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsFilterBiConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsGroupingBiConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsJoinBiConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsScoringBiConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsGroupingQuadConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsGroupingTriConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsJoinTriConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsAbstractUniConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsFromUniConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsGroupingUniConstraintStream;

public abstract class DroolsAbstractBiConstraintStream<Solution_, A, B>
extends DroolsAbstractConstraintStream<Solution_>
implements InnerBiConstraintStream<A, B> {
    public DroolsAbstractBiConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory) {
        super(constraintFactory);
    }

    @Override
    public BiConstraintStream<A, B> filter(BiPredicate<A, B> predicate) {
        DroolsFilterBiConstraintStream stream = new DroolsFilterBiConstraintStream(this.constraintFactory, this, predicate);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <C> TriConstraintStream<A, B, C> join(UniConstraintStream<C> otherStream, TriJoiner<A, B, C> joiner) {
        DroolsJoinTriConstraintStream stream = new DroolsJoinTriConstraintStream(this.constraintFactory, this, (DroolsAbstractUniConstraintStream)otherStream, joiner);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <ResultContainer_, Result_> UniConstraintStream<Result_> groupBy(BiConstraintCollector<A, B, ResultContainer_, Result_> collector) {
        this.throwWhenGroupByNotAllowed();
        DroolsGroupingUniConstraintStream stream = new DroolsGroupingUniConstraintStream(this.constraintFactory, this, collector);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <GroupKey_> UniConstraintStream<GroupKey_> groupBy(BiFunction<A, B, GroupKey_> groupKeyMapping) {
        this.throwWhenGroupByNotAllowed();
        DroolsGroupingUniConstraintStream stream = new DroolsGroupingUniConstraintStream(this.constraintFactory, this, groupKeyMapping);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <GroupKey_, __, Result_> BiConstraintStream<GroupKey_, Result_> groupBy(BiFunction<A, B, GroupKey_> groupKeyMapping, BiConstraintCollector<A, B, __, Result_> collector) {
        this.throwWhenGroupByNotAllowed();
        DroolsGroupingBiConstraintStream stream = new DroolsGroupingBiConstraintStream(this.constraintFactory, this, groupKeyMapping, collector);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <GroupKeyA_, GroupKeyB_> BiConstraintStream<GroupKeyA_, GroupKeyB_> groupBy(BiFunction<A, B, GroupKeyA_> groupKeyAMapping, BiFunction<A, B, GroupKeyB_> groupKeyBMapping) {
        this.throwWhenGroupByNotAllowed();
        DroolsGroupingBiConstraintStream stream = new DroolsGroupingBiConstraintStream(this.constraintFactory, this, groupKeyAMapping, groupKeyBMapping);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <GroupKeyA_, GroupKeyB_, ResultContainer_, Result_> TriConstraintStream<GroupKeyA_, GroupKeyB_, Result_> groupBy(BiFunction<A, B, GroupKeyA_> groupKeyAMapping, BiFunction<A, B, GroupKeyB_> groupKeyBMapping, BiConstraintCollector<A, B, ResultContainer_, Result_> collector) {
        this.throwWhenGroupByNotAllowed();
        DroolsGroupingTriConstraintStream stream = new DroolsGroupingTriConstraintStream(this.constraintFactory, this, groupKeyAMapping, groupKeyBMapping, collector);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <GroupKeyA_, GroupKeyB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, ResultC_, ResultD_> groupBy(BiFunction<A, B, GroupKeyA_> groupKeyAMapping, BiFunction<A, B, GroupKeyB_> groupKeyBMapping, BiConstraintCollector<A, B, ResultContainerC_, ResultC_> collectorC, BiConstraintCollector<A, B, ResultContainerD_, ResultD_> collectorD) {
        this.throwWhenGroupByNotAllowed();
        DroolsGroupingQuadConstraintStream stream = new DroolsGroupingQuadConstraintStream(this.constraintFactory, this, groupKeyAMapping, groupKeyBMapping, collectorC, collectorD);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public final Constraint impactScore(String constraintPackage, String constraintName, Score<?> constraintWeight, boolean positive) {
        DroolsScoringBiConstraintStream stream = new DroolsScoringBiConstraintStream(this.constraintFactory, this);
        this.addChildStream(stream);
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, positive, stream);
    }

    @Override
    public final Constraint impactScore(String constraintPackage, String constraintName, Score<?> constraintWeight, ToIntBiFunction<A, B> matchWeigher, boolean positive) {
        DroolsScoringBiConstraintStream stream = new DroolsScoringBiConstraintStream(this.constraintFactory, this, matchWeigher);
        this.addChildStream(stream);
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, positive, stream);
    }

    @Override
    public final Constraint impactScoreLong(String constraintPackage, String constraintName, Score<?> constraintWeight, ToLongBiFunction<A, B> matchWeigher, boolean positive) {
        DroolsScoringBiConstraintStream stream = new DroolsScoringBiConstraintStream(this.constraintFactory, this, matchWeigher);
        this.addChildStream(stream);
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, positive, stream);
    }

    @Override
    public final Constraint impactScoreBigDecimal(String constraintPackage, String constraintName, Score<?> constraintWeight, BiFunction<A, B, BigDecimal> matchWeigher, boolean positive) {
        DroolsScoringBiConstraintStream stream = new DroolsScoringBiConstraintStream(this.constraintFactory, this, matchWeigher);
        this.addChildStream(stream);
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, positive, stream);
    }

    @Override
    public final Constraint impactScoreConfigurable(String constraintPackage, String constraintName, boolean positive) {
        DroolsScoringBiConstraintStream stream = new DroolsScoringBiConstraintStream(this.constraintFactory, this);
        this.addChildStream(stream);
        return this.buildConstraintConfigurable(constraintPackage, constraintName, positive, stream);
    }

    @Override
    public final Constraint impactScoreConfigurable(String constraintPackage, String constraintName, ToIntBiFunction<A, B> matchWeigher, boolean positive) {
        DroolsScoringBiConstraintStream stream = new DroolsScoringBiConstraintStream(this.constraintFactory, this, matchWeigher);
        this.addChildStream(stream);
        return this.buildConstraintConfigurable(constraintPackage, constraintName, positive, stream);
    }

    @Override
    public final Constraint impactScoreConfigurableLong(String constraintPackage, String constraintName, ToLongBiFunction<A, B> matchWeigher, boolean positive) {
        DroolsScoringBiConstraintStream stream = new DroolsScoringBiConstraintStream(this.constraintFactory, this, matchWeigher);
        this.addChildStream(stream);
        return this.buildConstraintConfigurable(constraintPackage, constraintName, positive, stream);
    }

    @Override
    public final Constraint impactScoreConfigurableBigDecimal(String constraintPackage, String constraintName, BiFunction<A, B, BigDecimal> matchWeigher, boolean positive) {
        DroolsScoringBiConstraintStream stream = new DroolsScoringBiConstraintStream(this.constraintFactory, this, matchWeigher);
        this.addChildStream(stream);
        return this.buildConstraintConfigurable(constraintPackage, constraintName, positive, stream);
    }

    @Override
    public List<DroolsFromUniConstraintStream<Solution_, Object>> getFromStreamList() {
        DroolsAbstractConstraintStream<Solution_> parent = this.getParent();
        if (parent == null) {
            DroolsJoinBiConstraintStream joinStream = (DroolsJoinBiConstraintStream)this;
            List leftParentFromStreamList = joinStream.getLeftParentStream().getFromStreamList();
            List rightParentFromStreamList = joinStream.getRightParentStream().getFromStreamList();
            return Stream.concat(leftParentFromStreamList.stream(), rightParentFromStreamList.stream()).collect(Collectors.toList());
        }
        return parent.getFromStreamList();
    }

    protected abstract DroolsAbstractConstraintStream<Solution_> getParent();

    public abstract DroolsBiCondition<A, B> getCondition();

    @Override
    public boolean isGroupByAllowed() {
        return this.getParent().isGroupByAllowed();
    }
}

