/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.drools.core.base.accumulators.CollectSetAccumulateFunction;
import org.drools.model.DSL;
import org.drools.model.Drools;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.functions.Predicate1;
import org.drools.model.functions.accumulate.AccumulateFunction;
import org.drools.model.view.ExprViewItem;
import org.drools.model.view.ViewItem;
import org.drools.model.view.ViewItemBuilder;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsBiCondition;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsBiRuleStructure;
import org.optaplanner.core.impl.score.stream.drools.common.BiTuple;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractAccumulateFunctionBridge;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractGroupByInvoker;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsRuleStructure;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsQuadCondition;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsQuadRuleStructure;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsTriCondition;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsTriRuleStructure;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsUniCondition;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsUniRuleStructure;

public abstract class DroolsCondition<T extends DroolsRuleStructure> {
    protected final T ruleStructure;

    protected DroolsCondition(T ruleStructure) {
        this.ruleStructure = ruleStructure;
    }

    protected <NewA, InTuple, OutTuple, __> DroolsUniCondition<NewA> collect(DroolsAbstractAccumulateFunctionBridge<__, InTuple, OutTuple> accumulateFunctionBridge, BiFunction<PatternDSL.PatternDef<Object>, Variable<InTuple>, PatternDSL.PatternDef<Object>> bindFunction) {
        Variable tupleVariable = ((DroolsRuleStructure)this.ruleStructure).createVariable("tuple");
        PatternDSL.PatternDef<Object> mainAccumulatePattern = ((DroolsRuleStructure)this.ruleStructure).getPrimaryPattern().expand(p -> (PatternDSL.PatternDef)bindFunction.apply((PatternDSL.PatternDef<Object>)p, (Variable)tupleVariable)).build();
        ViewItem<?> innerAccumulatePattern = this.getInnerAccumulatePattern(mainAccumulatePattern);
        Variable outputVariable = ((DroolsRuleStructure)this.ruleStructure).createVariable("collected");
        ExprViewItem outerAccumulatePattern = DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)DSL.accFunction(() -> accumulateFunctionBridge, tupleVariable).as(outputVariable), (AccumulateFunction[])new AccumulateFunction[0]);
        DroolsUniRuleStructure newRuleStructure = ((DroolsRuleStructure)this.ruleStructure).recollect(outputVariable, (ViewItem<?>)outerAccumulatePattern);
        return new DroolsUniCondition(newRuleStructure);
    }

    protected <NewA> DroolsUniCondition<NewA> group(BiFunction<PatternDSL.PatternDef<Object>, Variable<NewA>, PatternDSL.PatternDef<Object>> bindFunction) {
        return (DroolsUniCondition)this.universalGroup(bindFunction, (var, pattern, accumulate) -> {
            DroolsUniRuleStructure newRuleStructure = ((DroolsRuleStructure)this.ruleStructure).regroup(var, pattern, (ViewItem<?>)accumulate);
            return new DroolsUniCondition(newRuleStructure);
        });
    }

    public <NewA, NewB> DroolsBiCondition<NewA, NewB> groupBi(BiFunction<PatternDSL.PatternDef<Object>, Variable<BiTuple<NewA, NewB>>, PatternDSL.PatternDef<Object>> bindFunction) {
        return (DroolsBiCondition)this.universalGroup(bindFunction, (var, pattern, accumulate) -> {
            DroolsBiRuleStructure newRuleStructure = ((DroolsRuleStructure)this.ruleStructure).regroupBi(var, pattern, (ViewItem<?>)accumulate);
            return new DroolsBiCondition(newRuleStructure);
        });
    }

    private <InTuple, R extends DroolsRuleStructure, C extends DroolsCondition<R>> C universalGroup(BiFunction<PatternDSL.PatternDef<Object>, Variable<InTuple>, PatternDSL.PatternDef<Object>> bindFunction, Mutator<InTuple, R, C> mutator) {
        Variable mappedVariable = ((DroolsRuleStructure)this.ruleStructure).createVariable("biMapped");
        PatternDSL.PatternDef<Object> mainAccumulatePattern = ((DroolsRuleStructure)this.ruleStructure).getPrimaryPattern().expand(p -> (PatternDSL.PatternDef)bindFunction.apply((PatternDSL.PatternDef<Object>)p, (Variable)mappedVariable)).build();
        ViewItem<?> innerAccumulatePattern = this.getInnerAccumulatePattern(mainAccumulatePattern);
        Variable<Set> tupleSet = ((DroolsRuleStructure)this.ruleStructure).createVariable(Set.class, "tupleSet");
        PatternDSL.PatternDef pattern = PatternDSL.pattern(tupleSet).expr("Non-empty", (Predicate1 & Serializable)set -> !set.isEmpty(), PatternDSL.alphaIndexedBy(Integer.class, (Index.ConstraintType)Index.ConstraintType.GREATER_THAN, (int)-1, Set::size, (Object)0));
        ExprViewItem accumulate = DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)DSL.accFunction(CollectSetAccumulateFunction.class, mappedVariable).as(tupleSet), (AccumulateFunction[])new AccumulateFunction[0]);
        return (C)((DroolsCondition)mutator.apply(tupleSet, pattern, accumulate));
    }

    protected <NewA, NewB, InTuple> DroolsBiCondition<NewA, NewB> groupWithCollect(Supplier<? extends DroolsAbstractGroupByInvoker<InTuple>> invokerSupplier) {
        return (DroolsBiCondition)this.universalGroupWithCollect(invokerSupplier, (var, pattern, accumulate) -> {
            DroolsBiRuleStructure newRuleStructure = ((DroolsRuleStructure)this.ruleStructure).regroupBi(var, pattern, (ViewItem<?>)accumulate);
            return new DroolsBiCondition(newRuleStructure);
        });
    }

    protected <NewA, NewB, NewC, InTuple> DroolsTriCondition<NewA, NewB, NewC> groupBiWithCollect(Supplier<? extends DroolsAbstractGroupByInvoker<InTuple>> invokerSupplier) {
        return (DroolsTriCondition)this.universalGroupWithCollect(invokerSupplier, (var, pattern, accumulate) -> {
            DroolsTriRuleStructure newRuleStructure = ((DroolsRuleStructure)this.ruleStructure).regroupBiToTri(var, pattern, (ViewItem<?>)accumulate);
            return new DroolsTriCondition(newRuleStructure);
        });
    }

    protected <NewA, NewB, NewC, NewD, InTuple> DroolsQuadCondition<NewA, NewB, NewC, NewD> groupBiWithCollectBi(Supplier<? extends DroolsAbstractGroupByInvoker<InTuple>> invokerSupplier) {
        return (DroolsQuadCondition)this.universalGroupWithCollect(invokerSupplier, (var, pattern, accumulate) -> {
            DroolsQuadRuleStructure newRuleStructure = ((DroolsRuleStructure)this.ruleStructure).regroupBiToQuad(var, pattern, (ViewItem<?>)accumulate);
            return new DroolsQuadCondition(newRuleStructure);
        });
    }

    private <InTuple, R extends DroolsRuleStructure, C extends DroolsCondition<R>> C universalGroupWithCollect(Supplier<? extends DroolsAbstractGroupByInvoker<InTuple>> invokerSupplier, Mutator<InTuple, R, C> mutator) {
        Variable<Set> tupleSet = ((DroolsRuleStructure)this.ruleStructure).createVariable(Set.class, "tupleSet");
        PatternDSL.PatternDef pattern = PatternDSL.pattern(tupleSet).expr("Non-empty", (Predicate1 & Serializable)set -> !set.isEmpty(), PatternDSL.alphaIndexedBy(Integer.class, (Index.ConstraintType)Index.ConstraintType.GREATER_THAN, (int)-1, Set::size, (Object)0));
        PatternDSL.PatternDef<Object> innerCollectingPattern = ((DroolsRuleStructure)this.ruleStructure).getPrimaryPattern().build();
        ViewItem<?> innerAccumulatePattern = this.getInnerAccumulatePattern(innerCollectingPattern);
        ExprViewItem accumulate = DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)DSL.accFunction(invokerSupplier).as(tupleSet), (AccumulateFunction[])new AccumulateFunction[0]);
        return (C)((DroolsCondition)mutator.apply(tupleSet, pattern, accumulate));
    }

    protected <S extends Score<S>, H extends AbstractScoreHolder<S>> void impactScore(Drools drools, H scoreHolder) {
        RuleContext kcontext = (RuleContext)drools;
        scoreHolder.impactScore(kcontext);
    }

    protected <S extends Score<S>, H extends AbstractScoreHolder<S>> void impactScore(Drools drools, H scoreHolder, int impact) {
        RuleContext kcontext = (RuleContext)drools;
        scoreHolder.impactScore(kcontext, impact);
    }

    protected <S extends Score<S>, H extends AbstractScoreHolder<S>> void impactScore(Drools drools, H scoreHolder, long impact) {
        RuleContext kcontext = (RuleContext)drools;
        scoreHolder.impactScore(kcontext, impact);
    }

    protected <S extends Score<S>, H extends AbstractScoreHolder<S>> void impactScore(Drools drools, H scoreHolder, BigDecimal impact) {
        RuleContext kcontext = (RuleContext)drools;
        scoreHolder.impactScore(kcontext, impact);
    }

    protected ViewItem<?> getInnerAccumulatePattern(PatternDSL.PatternDef<Object> mainAccumulatePattern) {
        ViewItem[] items = (ViewItem[])Stream.concat(((DroolsRuleStructure)this.ruleStructure).getOpenRuleItems().stream(), Stream.of(mainAccumulatePattern)).toArray(ViewItem[]::new);
        return PatternDSL.and((ViewItemBuilder)items[0], (ViewItemBuilder[])((ViewItemBuilder[])Arrays.copyOfRange(items, 1, items.length)));
    }

    public T getRuleStructure() {
        return this.ruleStructure;
    }

    @FunctionalInterface
    private static interface Mutator<InTuple, R extends DroolsRuleStructure, C extends DroolsCondition<R>>
    extends TriFunction<Variable<Set<InTuple>>, PatternDSL.PatternDef<Set<InTuple>>, ViewItem<?>, C> {
    }
}

