/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.quad;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.QuadPredicate;
import org.optaplanner.core.api.function.ToIntQuadFunction;
import org.optaplanner.core.api.function.ToLongQuadFunction;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.bi.BiConstraintStream;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintCollector;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintStream;
import org.optaplanner.core.api.score.stream.tri.TriConstraintStream;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsGroupingBiConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsFilterQuadConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsGroupingQuadConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsJoinQuadConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsQuadCondition;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsScoringQuadConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsGroupingTriConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsFromUniConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsGroupingUniConstraintStream;
import org.optaplanner.core.impl.score.stream.quad.InnerQuadConstraintStream;

public abstract class DroolsAbstractQuadConstraintStream<Solution_, A, B, C, D>
extends DroolsAbstractConstraintStream<Solution_>
implements InnerQuadConstraintStream<A, B, C, D> {
    protected final DroolsAbstractConstraintStream<Solution_> parent;

    public DroolsAbstractQuadConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractConstraintStream<Solution_> parent) {
        super(constraintFactory);
        if (parent == null && !(this instanceof DroolsJoinQuadConstraintStream)) {
            throw new IllegalArgumentException("The stream (" + this + ") must have a parent (null), unless it's a join stream.");
        }
        this.parent = parent;
    }

    @Override
    public QuadConstraintStream<A, B, C, D> filter(QuadPredicate<A, B, C, D> predicate) {
        DroolsFilterQuadConstraintStream stream = new DroolsFilterQuadConstraintStream(this.constraintFactory, this, predicate);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <ResultContainer_, Result_> UniConstraintStream<Result_> groupBy(QuadConstraintCollector<A, B, C, D, ResultContainer_, Result_> collector) {
        this.throwWhenGroupByNotAllowed();
        DroolsGroupingUniConstraintStream stream = new DroolsGroupingUniConstraintStream(this.constraintFactory, this, collector);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <GroupKey_> UniConstraintStream<GroupKey_> groupBy(QuadFunction<A, B, C, D, GroupKey_> groupKeyMapping) {
        this.throwWhenGroupByNotAllowed();
        DroolsGroupingUniConstraintStream stream = new DroolsGroupingUniConstraintStream(this.constraintFactory, this, groupKeyMapping);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <GroupKey_, ResultContainer_, Result_> BiConstraintStream<GroupKey_, Result_> groupBy(QuadFunction<A, B, C, D, GroupKey_> groupKeyMapping, QuadConstraintCollector<A, B, C, D, ResultContainer_, Result_> collector) {
        this.throwWhenGroupByNotAllowed();
        DroolsGroupingBiConstraintStream stream = new DroolsGroupingBiConstraintStream(this.constraintFactory, this, groupKeyMapping, collector);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <GroupKeyA_, GroupKeyB_> BiConstraintStream<GroupKeyA_, GroupKeyB_> groupBy(QuadFunction<A, B, C, D, GroupKeyA_> groupKeyAMapping, QuadFunction<A, B, C, D, GroupKeyB_> groupKeyBMapping) {
        this.throwWhenGroupByNotAllowed();
        DroolsGroupingBiConstraintStream stream = new DroolsGroupingBiConstraintStream(this.constraintFactory, this, groupKeyAMapping, groupKeyBMapping);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <GroupKeyA_, GroupKeyB_, ResultContainer_, Result_> TriConstraintStream<GroupKeyA_, GroupKeyB_, Result_> groupBy(QuadFunction<A, B, C, D, GroupKeyA_> groupKeyAMapping, QuadFunction<A, B, C, D, GroupKeyB_> groupKeyBMapping, QuadConstraintCollector<A, B, C, D, ResultContainer_, Result_> collector) {
        this.throwWhenGroupByNotAllowed();
        DroolsGroupingTriConstraintStream stream = new DroolsGroupingTriConstraintStream(this.constraintFactory, this, groupKeyAMapping, groupKeyBMapping, collector);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    public <GroupKeyA_, GroupKeyB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, ResultC_, ResultD_> groupBy(QuadFunction<A, B, C, D, GroupKeyA_> groupKeyAMapping, QuadFunction<A, B, C, D, GroupKeyB_> groupKeyBMapping, QuadConstraintCollector<A, B, C, D, ResultContainerC_, ResultC_> collectorC, QuadConstraintCollector<A, B, C, D, ResultContainerD_, ResultD_> collectorD) {
        this.throwWhenGroupByNotAllowed();
        DroolsGroupingQuadConstraintStream stream = new DroolsGroupingQuadConstraintStream(this.constraintFactory, this, groupKeyAMapping, groupKeyBMapping, collectorC, collectorD);
        this.addChildStream(stream);
        return stream;
    }

    @Override
    protected Constraint impactScore(String constraintPackage, String constraintName, Score<?> constraintWeight, boolean positive) {
        DroolsScoringQuadConstraintStream stream = new DroolsScoringQuadConstraintStream(this.constraintFactory, this);
        this.addChildStream(stream);
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, positive, stream);
    }

    @Override
    public Constraint impactScore(String constraintPackage, String constraintName, Score<?> constraintWeight, ToIntQuadFunction<A, B, C, D> matchWeigher, boolean positive) {
        DroolsScoringQuadConstraintStream stream = new DroolsScoringQuadConstraintStream(this.constraintFactory, this, matchWeigher);
        this.addChildStream(stream);
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, positive, stream);
    }

    @Override
    public Constraint impactScoreLong(String constraintPackage, String constraintName, Score<?> constraintWeight, ToLongQuadFunction<A, B, C, D> matchWeigher, boolean positive) {
        DroolsScoringQuadConstraintStream stream = new DroolsScoringQuadConstraintStream(this.constraintFactory, this, matchWeigher);
        this.addChildStream(stream);
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, positive, stream);
    }

    @Override
    public Constraint impactScoreBigDecimal(String constraintPackage, String constraintName, Score<?> constraintWeight, QuadFunction<A, B, C, D, BigDecimal> matchWeigher, boolean positive) {
        DroolsScoringQuadConstraintStream stream = new DroolsScoringQuadConstraintStream(this.constraintFactory, this, matchWeigher);
        this.addChildStream(stream);
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, positive, stream);
    }

    @Override
    protected Constraint impactScoreConfigurable(String constraintPackage, String constraintName, boolean positive) {
        DroolsScoringQuadConstraintStream stream = new DroolsScoringQuadConstraintStream(this.constraintFactory, this);
        this.addChildStream(stream);
        return this.buildConstraintConfigurable(constraintPackage, constraintName, positive, stream);
    }

    @Override
    public Constraint impactScoreConfigurable(String constraintPackage, String constraintName, ToIntQuadFunction<A, B, C, D> matchWeigher, boolean positive) {
        DroolsScoringQuadConstraintStream stream = new DroolsScoringQuadConstraintStream(this.constraintFactory, this, matchWeigher);
        this.addChildStream(stream);
        return this.buildConstraintConfigurable(constraintPackage, constraintName, positive, stream);
    }

    @Override
    public Constraint impactScoreConfigurableLong(String constraintPackage, String constraintName, ToLongQuadFunction<A, B, C, D> matchWeigher, boolean positive) {
        DroolsScoringQuadConstraintStream stream = new DroolsScoringQuadConstraintStream(this.constraintFactory, this, matchWeigher);
        this.addChildStream(stream);
        return this.buildConstraintConfigurable(constraintPackage, constraintName, positive, stream);
    }

    @Override
    public Constraint impactScoreConfigurableBigDecimal(String constraintPackage, String constraintName, QuadFunction<A, B, C, D, BigDecimal> matchWeigher, boolean positive) {
        DroolsScoringQuadConstraintStream stream = new DroolsScoringQuadConstraintStream(this.constraintFactory, this, matchWeigher);
        this.addChildStream(stream);
        return this.buildConstraintConfigurable(constraintPackage, constraintName, positive, stream);
    }

    @Override
    public List<DroolsFromUniConstraintStream<Solution_, Object>> getFromStreamList() {
        if (this.parent == null) {
            DroolsJoinQuadConstraintStream joinStream = (DroolsJoinQuadConstraintStream)this;
            List leftParentFromStreamList = joinStream.getLeftParentStream().getFromStreamList();
            List rightParentFromStreamList = joinStream.getRightParentStream().getFromStreamList();
            return Stream.concat(leftParentFromStreamList.stream(), rightParentFromStreamList.stream()).collect(Collectors.toList());
        }
        return this.parent.getFromStreamList();
    }

    public abstract DroolsQuadCondition<A, B, C, D> getCondition();

    @Override
    public boolean isGroupByAllowed() {
        return this.parent.isGroupByAllowed();
    }
}

