/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.quad;

import java.util.function.Function;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.quad.AbstractQuadJoiner;

public final class SingleQuadJoiner<A, B, C, D>
extends AbstractQuadJoiner<A, B, C, D> {
    private final TriFunction<A, B, C, ?> leftMapping;
    private final JoinerType joinerType;
    private final Function<D, ?> rightMapping;

    public SingleQuadJoiner(TriFunction<A, B, C, ?> leftMapping, JoinerType joinerType, Function<D, ?> rightMapping) {
        this.leftMapping = leftMapping;
        this.joinerType = joinerType;
        this.rightMapping = rightMapping;
    }

    public TriFunction<A, B, C, ?> getLeftMapping() {
        return this.leftMapping;
    }

    public JoinerType getJoinerType() {
        return this.joinerType;
    }

    public Function<D, ?> getRightMapping() {
        return this.rightMapping;
    }

    @Override
    public TriFunction<A, B, C, Object> getLeftMapping(int joinerId) {
        return this.leftMapping;
    }

    @Override
    public TriFunction<A, B, C, Object[]> getLeftCombinedMapping() {
        return (a, b, c) -> new Object[]{this.leftMapping.apply(a, b, c)};
    }

    @Override
    public JoinerType[] getJoinerTypes() {
        return new JoinerType[]{this.joinerType};
    }

    @Override
    public Function<D, Object> getRightMapping(int joinerId) {
        return this.rightMapping;
    }

    @Override
    public Function<D, Object[]> getRightCombinedMapping() {
        return d -> new Object[]{this.rightMapping.apply(d)};
    }
}

