/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.bendablelong;

import java.util.Arrays;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.optaplanner.core.impl.score.inliner.LongWeightedScoreImpacter;
import org.optaplanner.core.impl.score.inliner.ScoreInliner;

public class BendableLongScoreInliner
extends ScoreInliner<BendableLongScore> {
    private long[] hardScores;
    private long[] softScores;

    public BendableLongScoreInliner(boolean constraintMatchEnabled, int hardLevelsSize, int softLevelsSize) {
        super(constraintMatchEnabled);
        this.hardScores = new long[hardLevelsSize];
        this.softScores = new long[softLevelsSize];
    }

    public LongWeightedScoreImpacter buildWeightedScoreImpacter(BendableLongScore constraintWeight) {
        if (constraintWeight.equals(BendableLongScore.zero(this.hardScores.length, this.softScores.length))) {
            throw new IllegalArgumentException("The constraintWeight (" + constraintWeight + ") cannot be zero, this constraint should have been culled during node creation.");
        }
        Integer singleLevel = null;
        for (int i = 0; i < constraintWeight.getLevelsSize(); ++i) {
            if (constraintWeight.getHardOrSoftScore(i) == 0L) continue;
            if (singleLevel != null) {
                singleLevel = null;
                break;
            }
            singleLevel = i;
        }
        if (singleLevel != null) {
            long levelWeight = constraintWeight.getHardOrSoftScore(singleLevel);
            if (singleLevel < constraintWeight.getHardLevelsSize()) {
                int level = singleLevel;
                return (matchWeight, matchScoreConsumer) -> {
                    long hardImpact = levelWeight * matchWeight;
                    int n = level;
                    this.hardScores[n] = this.hardScores[n] + hardImpact;
                    if (this.constraintMatchEnabled) {
                        matchScoreConsumer.accept(BendableLongScore.ofHard(this.hardScores.length, this.softScores.length, level, hardImpact));
                    }
                    return () -> {
                        int n = level;
                        this.hardScores[n] = this.hardScores[n] - hardImpact;
                    };
                };
            }
            int level = singleLevel - constraintWeight.getHardLevelsSize();
            return (matchWeight, matchScoreConsumer) -> {
                long softImpact = levelWeight * matchWeight;
                int n = level;
                this.softScores[n] = this.softScores[n] + softImpact;
                if (this.constraintMatchEnabled) {
                    matchScoreConsumer.accept(BendableLongScore.ofSoft(this.hardScores.length, this.softScores.length, level, softImpact));
                }
                return () -> {
                    int n = level;
                    this.softScores[n] = this.softScores[n] - softImpact;
                };
            };
        }
        return (matchWeight, matchScoreConsumer) -> {
            int i;
            long[] hardImpacts = new long[this.hardScores.length];
            long[] softImpacts = new long[this.softScores.length];
            for (i = 0; i < hardImpacts.length; ++i) {
                hardImpacts[i] = constraintWeight.getHardScore(i) * matchWeight;
                int n = i;
                this.hardScores[n] = this.hardScores[n] + hardImpacts[i];
            }
            for (i = 0; i < softImpacts.length; ++i) {
                softImpacts[i] = constraintWeight.getSoftScore(i) * matchWeight;
                int n = i;
                this.softScores[n] = this.softScores[n] + softImpacts[i];
            }
            if (this.constraintMatchEnabled) {
                matchScoreConsumer.accept(BendableLongScore.of(hardImpacts, softImpacts));
            }
            return () -> {
                int i;
                for (i = 0; i < hardImpacts.length; ++i) {
                    int n = i;
                    this.hardScores[n] = this.hardScores[n] - hardImpacts[i];
                }
                for (i = 0; i < softImpacts.length; ++i) {
                    int n = i;
                    this.softScores[n] = this.softScores[n] - softImpacts[i];
                }
            };
        };
    }

    @Override
    public BendableLongScore extractScore(int initScore) {
        return BendableLongScore.ofUninitialized(initScore, Arrays.copyOf(this.hardScores, this.hardScores.length), Arrays.copyOf(this.softScores, this.softScores.length));
    }

    public String toString() {
        return BendableLongScore.class.getSimpleName() + " inliner";
    }
}

