/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.random;

import java.util.Random;

public class RandomUtils {
    public static long nextLong(Random random, long n) {
        long val;
        long bits;
        if (n <= 0L) {
            throw new IllegalArgumentException("n must be positive");
        }
        if (n < Integer.MAX_VALUE) {
            return random.nextInt((int)n);
        }
        while ((bits = random.nextLong() << 1 >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    public static double nextDouble(Random random, double n) {
        if (n <= 0.0) {
            throw new IllegalArgumentException("n must be positive");
        }
        return random.nextDouble() * n;
    }

    private RandomUtils() {
    }
}

