/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.common.iterator;

import java.util.ListIterator;
import java.util.NoSuchElementException;

public class SingletonIterator<T>
implements ListIterator<T> {
    private final T singleton;
    private boolean hasNext;
    private boolean hasPrevious;

    public SingletonIterator(T singleton) {
        this.singleton = singleton;
        this.hasNext = true;
        this.hasPrevious = true;
    }

    public SingletonIterator(T singleton, int index) {
        this.singleton = singleton;
        if (index < 0 || index > 1) {
            throw new IllegalArgumentException("The index (" + index + ") is invalid.");
        }
        this.hasNext = index == 0;
        this.hasPrevious = !this.hasNext;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public T next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        this.hasNext = false;
        this.hasPrevious = true;
        return this.singleton;
    }

    @Override
    public boolean hasPrevious() {
        return this.hasPrevious;
    }

    @Override
    public T previous() {
        if (!this.hasPrevious) {
            throw new NoSuchElementException();
        }
        this.hasNext = true;
        this.hasPrevious = false;
        return this.singleton;
    }

    @Override
    public int nextIndex() {
        return this.hasNext ? 0 : 1;
    }

    @Override
    public int previousIndex() {
        return this.hasPrevious ? 0 : -1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(T t) {
        throw new UnsupportedOperationException();
    }
}

