/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.bi;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.stream.bi.BiConstraintCollector;
import org.optaplanner.core.impl.score.stream.drools.common.BiTuple;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractUniCollectingGroupByCollectorProcessor;
import org.optaplanner.core.impl.score.stream.drools.common.TriTuple;

final class DroolsBiToTriGroupByCollectorProcessor<A, B, ResultContainer, NewA, NewB, NewC>
extends DroolsAbstractUniCollectingGroupByCollectorProcessor<ResultContainer, BiTuple<A, B>, BiTuple<NewA, NewB>, TriTuple<NewA, NewB, NewC>> {
    private final BiFunction<A, B, NewA> groupKeyAMapping;
    private final BiFunction<A, B, NewB> groupKeyBMapping;
    private final Supplier<ResultContainer> supplier;
    private final TriFunction<ResultContainer, A, B, Runnable> accumulator;
    private final Function<ResultContainer, NewC> finisher;

    public DroolsBiToTriGroupByCollectorProcessor(BiFunction<A, B, NewA> groupKeyAMapping, BiFunction<A, B, NewB> groupKeyBMapping, BiConstraintCollector<A, B, ResultContainer, NewC> collector) {
        this.groupKeyAMapping = groupKeyAMapping;
        this.groupKeyBMapping = groupKeyBMapping;
        this.supplier = collector.supplier();
        this.accumulator = collector.accumulator();
        this.finisher = collector.finisher();
    }

    @Override
    protected BiTuple<NewA, NewB> toKey(BiTuple<A, B> abBiTuple) {
        return new BiTuple<NewA, NewB>(this.groupKeyAMapping.apply(abBiTuple.a, abBiTuple.b), this.groupKeyBMapping.apply(abBiTuple.a, abBiTuple.b));
    }

    @Override
    protected ResultContainer newContainer() {
        return this.supplier.get();
    }

    @Override
    protected Runnable process(BiTuple<A, B> abBiTuple, ResultContainer container) {
        return this.accumulator.apply(container, abBiTuple.a, abBiTuple.b);
    }

    @Override
    protected TriTuple<NewA, NewB, NewC> toResult(BiTuple<NewA, NewB> key, ResultContainer container) {
        return new TriTuple(key.a, key.b, this.finisher.apply(container));
    }
}

