/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.stream;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.Period;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongBiFunction;
import java.util.function.ToLongFunction;
import org.optaplanner.core.api.function.PentaFunction;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.QuadPredicate;
import org.optaplanner.core.api.function.ToIntQuadFunction;
import org.optaplanner.core.api.function.ToIntTriFunction;
import org.optaplanner.core.api.function.ToLongQuadFunction;
import org.optaplanner.core.api.function.ToLongTriFunction;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.function.TriPredicate;
import org.optaplanner.core.api.score.stream.bi.BiConstraintCollector;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintCollector;
import org.optaplanner.core.api.score.stream.tri.TriConstraintCollector;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.core.impl.score.stream.bi.DefaultBiConstraintCollector;
import org.optaplanner.core.impl.score.stream.quad.DefaultQuadConstraintCollector;
import org.optaplanner.core.impl.score.stream.tri.DefaultTriConstraintCollector;
import org.optaplanner.core.impl.score.stream.uni.DefaultUniConstraintCollector;

public final class ConstraintCollectors {
    private static final Runnable NOOP = () -> {};

    public static <A> UniConstraintCollector<A, ?, Integer> count() {
        return new DefaultUniConstraintCollector<Object, int[], Integer>(() -> new int[1], (resultContainer, a) -> {
            resultContainer[0] = resultContainer[0] + 1;
            return () -> {
                resultContainer[0] = resultContainer[0] - 1;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A> UniConstraintCollector<A, ?, Long> countLong() {
        return new DefaultUniConstraintCollector<Object, long[], Long>(() -> new long[1], (resultContainer, a) -> {
            resultContainer[0] = resultContainer[0] + 1L;
            return () -> {
                resultContainer[0] = resultContainer[0] - 1L;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Integer> countBi() {
        return new DefaultBiConstraintCollector<Object, Object, int[], Integer>(() -> new int[1], (resultContainer, a, b) -> {
            resultContainer[0] = resultContainer[0] + 1;
            return () -> {
                resultContainer[0] = resultContainer[0] - 1;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Long> countLongBi() {
        return new DefaultBiConstraintCollector<Object, Object, long[], Long>(() -> new long[1], (resultContainer, a, b) -> {
            resultContainer[0] = resultContainer[0] + 1L;
            return () -> {
                resultContainer[0] = resultContainer[0] - 1L;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, Integer> countTri() {
        return new DefaultTriConstraintCollector<Object, Object, Object, int[], Integer>(() -> new int[1], (resultContainer, a, b, c) -> {
            resultContainer[0] = resultContainer[0] + 1;
            return () -> {
                resultContainer[0] = resultContainer[0] - 1;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, Long> countLongTri() {
        return new DefaultTriConstraintCollector<Object, Object, Object, long[], Long>(() -> new long[1], (resultContainer, a, b, c) -> {
            resultContainer[0] = resultContainer[0] + 1L;
            return () -> {
                resultContainer[0] = resultContainer[0] - 1L;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B, C, D> QuadConstraintCollector<A, B, C, D, ?, Integer> countQuad() {
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, int[], Integer>(() -> new int[1], (resultContainer, a, b, c, d) -> {
            resultContainer[0] = resultContainer[0] + 1;
            return () -> {
                resultContainer[0] = resultContainer[0] - 1;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B, C, D> QuadConstraintCollector<A, B, C, D, ?, Long> countLongQuad() {
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, long[], Long>(() -> new long[1], (resultContainer, a, b, c, d) -> {
            resultContainer[0] = resultContainer[0] + 1L;
            return () -> {
                resultContainer[0] = resultContainer[0] - 1L;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A> UniConstraintCollector<A, ?, Integer> countDistinct() {
        return ConstraintCollectors.countDistinct(Function.identity());
    }

    public static <A> UniConstraintCollector<A, ?, Integer> countDistinct(Function<A, ?> groupValueMapping) {
        return new DefaultUniConstraintCollector<Object, CountDistinctResultContainer, Integer>(() -> new CountDistinctResultContainer(), (resultContainer, a) -> {
            Object value = groupValueMapping.apply(a);
            return ConstraintCollectors.innerCountDistinct(resultContainer, value);
        }, resultContainer -> resultContainer.count);
    }

    public static <A> UniConstraintCollector<A, ?, Long> countDistinctLong(Function<A, ?> groupValueMapping) {
        return new DefaultUniConstraintCollector<Object, CountDistinctLongResultContainer, Long>(() -> new CountDistinctLongResultContainer(), (resultContainer, a) -> {
            Object value = groupValueMapping.apply(a);
            return ConstraintCollectors.innerCountDistinctLong(resultContainer, value);
        }, resultContainer -> resultContainer.count);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Integer> countDistinct(BiFunction<A, B, ?> groupValueMapping) {
        return new DefaultBiConstraintCollector<Object, Object, CountDistinctResultContainer, Integer>(() -> new CountDistinctResultContainer(), (resultContainer, a, b) -> {
            Object value = groupValueMapping.apply(a, b);
            return ConstraintCollectors.innerCountDistinct(resultContainer, value);
        }, resultContainer -> resultContainer.count);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Long> countDistinctLong(BiFunction<A, B, ?> groupValueMapping) {
        return new DefaultBiConstraintCollector<Object, Object, CountDistinctLongResultContainer, Long>(() -> new CountDistinctLongResultContainer(), (resultContainer, a, b) -> {
            Object value = groupValueMapping.apply(a, b);
            return ConstraintCollectors.innerCountDistinctLong(resultContainer, value);
        }, resultContainer -> resultContainer.count);
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, Integer> countDistinct(TriFunction<A, B, C, ?> groupValueMapping) {
        return new DefaultTriConstraintCollector<Object, Object, Object, CountDistinctResultContainer, Integer>(() -> new CountDistinctResultContainer(), (resultContainer, a, b, c) -> {
            Object value = groupValueMapping.apply(a, b, c);
            return ConstraintCollectors.innerCountDistinct(resultContainer, value);
        }, resultContainer -> resultContainer.count);
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, Long> countDistinctLong(TriFunction<A, B, C, ?> groupValueMapping) {
        return new DefaultTriConstraintCollector<Object, Object, Object, CountDistinctLongResultContainer, Long>(() -> new CountDistinctLongResultContainer(), (resultContainer, a, b, c) -> {
            Object value = groupValueMapping.apply(a, b, c);
            return ConstraintCollectors.innerCountDistinctLong(resultContainer, value);
        }, resultContainer -> resultContainer.count);
    }

    public static <A, B, C, D> QuadConstraintCollector<A, B, C, D, ?, Integer> countDistinct(QuadFunction<A, B, C, D, ?> groupValueMapping) {
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, CountDistinctResultContainer, Integer>(() -> new CountDistinctResultContainer(), (resultContainer, a, b, c, d) -> {
            Object value = groupValueMapping.apply(a, b, c, d);
            return ConstraintCollectors.innerCountDistinct(resultContainer, value);
        }, resultContainer -> resultContainer.count);
    }

    public static <A, B, C, D> QuadConstraintCollector<A, B, C, D, ?, Long> countDistinctLong(QuadFunction<A, B, C, D, ?> groupValueMapping) {
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, CountDistinctLongResultContainer, Long>(() -> new CountDistinctLongResultContainer(), (resultContainer, a, b, c, d) -> {
            Object value = groupValueMapping.apply(a, b, c, d);
            return ConstraintCollectors.innerCountDistinctLong(resultContainer, value);
        }, resultContainer -> resultContainer.count);
    }

    private static Runnable innerCountDistinct(CountDistinctResultContainer resultContainer, Object value) {
        int[] objectCount = resultContainer.objectCountMap.computeIfAbsent(value, k -> new int[1]);
        if ((long)objectCount[0] == 0L) {
            ++resultContainer.count;
        }
        objectCount[0] = objectCount[0] + 1;
        return () -> {
            int[] objectCount2 = resultContainer.objectCountMap.get(value);
            if (objectCount2 == null) {
                throw new IllegalStateException("Impossible state: the value (" + value + ") is removed more times than it was added.");
            }
            objectCount2[0] = objectCount2[0] - 1;
            if ((long)objectCount2[0] == 0L) {
                resultContainer.objectCountMap.remove(value);
                --resultContainer.count;
            }
        };
    }

    private static Runnable innerCountDistinctLong(CountDistinctLongResultContainer resultContainer, Object value) {
        long[] objectCount = resultContainer.objectCountMap.computeIfAbsent(value, k -> new long[1]);
        if (objectCount[0] == 0L) {
            ++resultContainer.count;
        }
        objectCount[0] = objectCount[0] + 1L;
        return () -> {
            long[] objectCount2 = resultContainer.objectCountMap.get(value);
            if (objectCount2 == null) {
                throw new IllegalStateException("Impossible state: the value (" + value + ") is removed more times than it was added.");
            }
            objectCount2[0] = objectCount2[0] - 1L;
            if (objectCount2[0] == 0L) {
                resultContainer.objectCountMap.remove(value);
                --resultContainer.count;
            }
        };
    }

    public static <A> UniConstraintCollector<A, ?, Integer> sum(ToIntFunction<? super A> groupValueMapping) {
        return new DefaultUniConstraintCollector<Object, int[], Integer>(() -> new int[1], (resultContainer, a) -> {
            int value = groupValueMapping.applyAsInt((Object)a);
            resultContainer[0] = resultContainer[0] + value;
            return () -> {
                resultContainer[0] = resultContainer[0] - value;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A> UniConstraintCollector<A, ?, Long> sumLong(ToLongFunction<? super A> groupValueMapping) {
        return new DefaultUniConstraintCollector<Object, long[], Long>(() -> new long[1], (resultContainer, a) -> {
            long value = groupValueMapping.applyAsLong((Object)a);
            resultContainer[0] = resultContainer[0] + value;
            return () -> {
                resultContainer[0] = resultContainer[0] - value;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, Result> UniConstraintCollector<A, ?, Result> sum(Function<? super A, Result> groupValueMapping, Result zero, BinaryOperator<Result> adder, BinaryOperator<Result> subtractor) {
        return new DefaultUniConstraintCollector<Object, Object[], Object>(() -> ConstraintCollectors.createContainer(zero), (resultContainer, a) -> {
            Object value = groupValueMapping.apply((Object)a);
            resultContainer[0] = adder.apply(resultContainer[0], value);
            return () -> {
                resultContainer[0] = subtractor.apply(resultContainer[0], value);
            };
        }, resultContainer -> resultContainer[0]);
    }

    private static <Result> Result[] createContainer(Result initialValue) {
        Object[] container = (Object[])Array.newInstance(initialValue.getClass(), 1);
        container[0] = initialValue;
        return container;
    }

    public static <A> UniConstraintCollector<A, ?, BigDecimal> sumBigDecimal(Function<? super A, BigDecimal> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, BigDecimal.ZERO, BigDecimal::add, BigDecimal::subtract);
    }

    public static <A> UniConstraintCollector<A, ?, BigInteger> sumBigInteger(Function<? super A, BigInteger> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, BigInteger.ZERO, BigInteger::add, BigInteger::subtract);
    }

    public static <A> UniConstraintCollector<A, ?, Duration> sumDuration(Function<? super A, Duration> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, Duration.ZERO, Duration::plus, Duration::minus);
    }

    public static <A> UniConstraintCollector<A, ?, Period> sumPeriod(Function<? super A, Period> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, Period.ZERO, Period::plus, Period::minus);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Integer> sum(ToIntBiFunction<? super A, ? super B> groupValueMapping) {
        return new DefaultBiConstraintCollector<Object, Object, int[], Integer>(() -> new int[1], (resultContainer, a, b) -> {
            int value = groupValueMapping.applyAsInt((Object)a, (Object)b);
            resultContainer[0] = resultContainer[0] + value;
            return () -> {
                resultContainer[0] = resultContainer[0] - value;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Long> sumLong(ToLongBiFunction<? super A, ? super B> groupValueMapping) {
        return new DefaultBiConstraintCollector<Object, Object, long[], Long>(() -> new long[1], (resultContainer, a, b) -> {
            long value = groupValueMapping.applyAsLong((Object)a, (Object)b);
            resultContainer[0] = resultContainer[0] + value;
            return () -> {
                resultContainer[0] = resultContainer[0] - value;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B, Result> BiConstraintCollector<A, B, ?, Result> sum(BiFunction<? super A, ? super B, Result> groupValueMapping, Result zero, BinaryOperator<Result> adder, BinaryOperator<Result> subtractor) {
        return new DefaultBiConstraintCollector<Object, Object, Object[], Object>(() -> ConstraintCollectors.createContainer(zero), (resultContainer, a, b) -> {
            Object value = groupValueMapping.apply((Object)a, (Object)b);
            resultContainer[0] = adder.apply(resultContainer[0], value);
            return () -> {
                resultContainer[0] = subtractor.apply(resultContainer[0], value);
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, BigDecimal> sumBigDecimal(BiFunction<? super A, ? super B, BigDecimal> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, BigDecimal.ZERO, BigDecimal::add, BigDecimal::subtract);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, BigInteger> sumBigInteger(BiFunction<? super A, ? super B, BigInteger> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, BigInteger.ZERO, BigInteger::add, BigInteger::subtract);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Duration> sumDuration(BiFunction<? super A, ? super B, Duration> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, Duration.ZERO, Duration::plus, Duration::minus);
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Period> sumPeriod(BiFunction<? super A, ? super B, Period> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, Period.ZERO, Period::plus, Period::minus);
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, Integer> sum(ToIntTriFunction<? super A, ? super B, ? super C> groupValueMapping) {
        return new DefaultTriConstraintCollector<Object, Object, Object, int[], Integer>(() -> new int[1], (resultContainer, a, b, c) -> {
            int value = groupValueMapping.applyAsInt(a, b, c);
            resultContainer[0] = resultContainer[0] + value;
            return () -> {
                resultContainer[0] = resultContainer[0] - value;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, Long> sumLong(ToLongTriFunction<? super A, ? super B, ? super C> groupValueMapping) {
        return new DefaultTriConstraintCollector<Object, Object, Object, long[], Long>(() -> new long[1], (resultContainer, a, b, c) -> {
            long value = groupValueMapping.applyAsLong(a, b, c);
            resultContainer[0] = resultContainer[0] + value;
            return () -> {
                resultContainer[0] = resultContainer[0] - value;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B, C, Result> TriConstraintCollector<A, B, C, ?, Result> sum(TriFunction<? super A, ? super B, ? super C, Result> groupValueMapping, Result zero, BinaryOperator<Result> adder, BinaryOperator<Result> subtractor) {
        return new DefaultTriConstraintCollector<Object, Object, Object, Object[], Object>(() -> ConstraintCollectors.createContainer(zero), (resultContainer, a, b, c) -> {
            Object value = groupValueMapping.apply(a, b, c);
            resultContainer[0] = adder.apply(resultContainer[0], value);
            return () -> {
                resultContainer[0] = subtractor.apply(resultContainer[0], value);
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, BigDecimal> sumBigDecimal(TriFunction<? super A, ? super B, ? super C, BigDecimal> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, BigDecimal.ZERO, BigDecimal::add, BigDecimal::subtract);
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, BigInteger> sumBigInteger(TriFunction<? super A, ? super B, ? super C, BigInteger> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, BigInteger.ZERO, BigInteger::add, BigInteger::subtract);
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, Duration> sumDuration(TriFunction<? super A, ? super B, ? super C, Duration> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, Duration.ZERO, Duration::plus, Duration::minus);
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, Period> sumPeriod(TriFunction<? super A, ? super B, ? super C, Period> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, Period.ZERO, Period::plus, Period::minus);
    }

    public static <A, B, C, D> QuadConstraintCollector<A, B, C, D, ?, Integer> sum(ToIntQuadFunction<? super A, ? super B, ? super C, ? super D> groupValueMapping) {
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, int[], Integer>(() -> new int[1], (resultContainer, a, b, c, d) -> {
            int value = groupValueMapping.applyAsInt(a, b, c, d);
            resultContainer[0] = resultContainer[0] + value;
            return () -> {
                resultContainer[0] = resultContainer[0] - value;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B, C, D> QuadConstraintCollector<A, B, C, D, ?, Long> sumLong(ToLongQuadFunction<? super A, ? super B, ? super C, ? super D> groupValueMapping) {
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, long[], Long>(() -> new long[1], (resultContainer, a, b, c, d) -> {
            long value = groupValueMapping.applyAsLong(a, b, c, d);
            resultContainer[0] = resultContainer[0] + value;
            return () -> {
                resultContainer[0] = resultContainer[0] - value;
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B, C, D, Result> QuadConstraintCollector<A, B, C, D, ?, Result> sum(QuadFunction<? super A, ? super B, ? super C, ? super D, Result> groupValueMapping, Result zero, BinaryOperator<Result> adder, BinaryOperator<Result> subtractor) {
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, Object[], Object>(() -> ConstraintCollectors.createContainer(zero), (resultContainer, a, b, c, d) -> {
            Object value = groupValueMapping.apply(a, b, c, d);
            resultContainer[0] = adder.apply(resultContainer[0], value);
            return () -> {
                resultContainer[0] = subtractor.apply(resultContainer[0], value);
            };
        }, resultContainer -> resultContainer[0]);
    }

    public static <A, B, C, D> QuadConstraintCollector<A, B, C, D, ?, BigDecimal> sumBigDecimal(QuadFunction<? super A, ? super B, ? super C, ? super D, BigDecimal> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, BigDecimal.ZERO, BigDecimal::add, BigDecimal::subtract);
    }

    public static <A, B, C, D> QuadConstraintCollector<A, B, C, D, ?, BigInteger> sumBigInteger(QuadFunction<? super A, ? super B, ? super C, ? super D, BigInteger> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, BigInteger.ZERO, BigInteger::add, BigInteger::subtract);
    }

    public static <A, B, C, D> QuadConstraintCollector<A, B, C, D, ?, Duration> sumDuration(QuadFunction<? super A, ? super B, ? super C, ? super D, Duration> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, Duration.ZERO, Duration::plus, Duration::minus);
    }

    public static <A, B, C, D> QuadConstraintCollector<A, B, C, D, ?, Period> sumPeriod(QuadFunction<? super A, ? super B, ? super C, ? super D, Period> groupValueMapping) {
        return ConstraintCollectors.sum(groupValueMapping, Period.ZERO, Period::plus, Period::minus);
    }

    public static <A extends Comparable<A>> UniConstraintCollector<A, ?, A> min() {
        return ConstraintCollectors.min(Comparator.naturalOrder());
    }

    public static <A, Mapped extends Comparable<Mapped>> UniConstraintCollector<A, ?, Mapped> min(Function<A, Mapped> groupValueMapping) {
        return ConstraintCollectors.min(groupValueMapping, Comparator.naturalOrder());
    }

    public static <A> UniConstraintCollector<A, ?, A> min(Comparator<A> comparator) {
        return ConstraintCollectors.min(Function.identity(), comparator);
    }

    public static <A, Mapped> UniConstraintCollector<A, ?, Mapped> min(Function<A, Mapped> groupValueMapping, Comparator<Mapped> comparator) {
        return ConstraintCollectors.minOrMax(groupValueMapping, comparator, true);
    }

    public static <A, B, Mapped extends Comparable<Mapped>> BiConstraintCollector<A, B, ?, Mapped> min(BiFunction<A, B, Mapped> groupValueMapping) {
        return ConstraintCollectors.min(groupValueMapping, Comparator.naturalOrder());
    }

    public static <A, B, Mapped> BiConstraintCollector<A, B, ?, Mapped> min(BiFunction<A, B, Mapped> groupValueMapping, Comparator<Mapped> comparator) {
        return ConstraintCollectors.minOrMax(groupValueMapping, comparator, true);
    }

    public static <A, B, C, Mapped extends Comparable<Mapped>> TriConstraintCollector<A, B, C, ?, Mapped> min(TriFunction<A, B, C, Mapped> groupValueMapping) {
        return ConstraintCollectors.min(groupValueMapping, Comparator.naturalOrder());
    }

    public static <A, B, C, Mapped> TriConstraintCollector<A, B, C, ?, Mapped> min(TriFunction<A, B, C, Mapped> groupValueMapping, Comparator<Mapped> comparator) {
        return ConstraintCollectors.minOrMax(groupValueMapping, comparator, true);
    }

    public static <A, B, C, D, Mapped extends Comparable<Mapped>> QuadConstraintCollector<A, B, C, D, ?, Mapped> min(QuadFunction<A, B, C, D, Mapped> groupValueMapping) {
        return ConstraintCollectors.min(groupValueMapping, Comparator.naturalOrder());
    }

    public static <A, B, C, D, Mapped> QuadConstraintCollector<A, B, C, D, ?, Mapped> min(QuadFunction<A, B, C, D, Mapped> groupValueMapping, Comparator<Mapped> comparator) {
        return ConstraintCollectors.minOrMax(groupValueMapping, comparator, true);
    }

    public static <A extends Comparable<A>> UniConstraintCollector<A, ?, A> max() {
        return ConstraintCollectors.max(Comparator.naturalOrder());
    }

    public static <A, Mapped extends Comparable<Mapped>> UniConstraintCollector<A, ?, Mapped> max(Function<A, Mapped> groupValueMapping) {
        return ConstraintCollectors.max(groupValueMapping, Comparator.naturalOrder());
    }

    public static <A> UniConstraintCollector<A, ?, A> max(Comparator<A> comparator) {
        return ConstraintCollectors.max(Function.identity(), comparator);
    }

    public static <A, Mapped> UniConstraintCollector<A, ?, Mapped> max(Function<A, Mapped> groupValueMapping, Comparator<Mapped> comparator) {
        return ConstraintCollectors.minOrMax(groupValueMapping, comparator, false);
    }

    private static <A, Mapped> UniConstraintCollector<A, SortedMap<Mapped, Long>, Mapped> minOrMax(Function<A, Mapped> groupValueMapping, Comparator<Mapped> comparator, boolean min) {
        return new DefaultUniConstraintCollector(() -> new TreeMap(comparator), (resultContainer, a) -> {
            Object mapped = groupValueMapping.apply(a);
            return ConstraintCollectors.valueCountAccumulator(resultContainer, mapped);
        }, ConstraintCollectors.getMinOrMaxFinisher(min));
    }

    private static <Value_> Runnable valueCountAccumulator(Map<Value_, Long> resultContainer, Value_ value) {
        resultContainer.compute(value, (key, count) -> count == null ? 1L : count + 1L);
        return () -> resultContainer.compute(value, (key, count) -> count == 1L ? null : Long.valueOf(count - 1L));
    }

    private static <Value_> Function<SortedMap<Value_, Long>, Value_> getMinOrMaxFinisher(boolean returnMinimum) {
        if (returnMinimum) {
            return resultContainer -> resultContainer.isEmpty() ? null : resultContainer.firstKey();
        }
        return resultContainer -> resultContainer.isEmpty() ? null : resultContainer.lastKey();
    }

    public static <A, B, Mapped extends Comparable<Mapped>> BiConstraintCollector<A, B, ?, Mapped> max(BiFunction<A, B, Mapped> groupValueMapping) {
        return ConstraintCollectors.max(groupValueMapping, Comparator.naturalOrder());
    }

    public static <A, B, Mapped> BiConstraintCollector<A, B, ?, Mapped> max(BiFunction<A, B, Mapped> groupValueMapping, Comparator<Mapped> comparator) {
        return ConstraintCollectors.minOrMax(groupValueMapping, comparator, false);
    }

    private static <A, B, Mapped> BiConstraintCollector<A, B, SortedMap<Mapped, Long>, Mapped> minOrMax(BiFunction<A, B, Mapped> groupValueMapping, Comparator<Mapped> comparator, boolean min) {
        return new DefaultBiConstraintCollector(() -> new TreeMap(comparator), (resultContainer, a, b) -> {
            Object mapped = groupValueMapping.apply(a, b);
            return ConstraintCollectors.valueCountAccumulator(resultContainer, mapped);
        }, ConstraintCollectors.getMinOrMaxFinisher(min));
    }

    public static <A, B, C, Mapped extends Comparable<Mapped>> TriConstraintCollector<A, B, C, ?, Mapped> max(TriFunction<A, B, C, Mapped> groupValueMapping) {
        return ConstraintCollectors.max(groupValueMapping, Comparator.naturalOrder());
    }

    public static <A, B, C, Mapped> TriConstraintCollector<A, B, C, ?, Mapped> max(TriFunction<A, B, C, Mapped> groupValueMapping, Comparator<Mapped> comparator) {
        return ConstraintCollectors.minOrMax(groupValueMapping, comparator, false);
    }

    private static <A, B, C, Mapped> TriConstraintCollector<A, B, C, SortedMap<Mapped, Long>, Mapped> minOrMax(TriFunction<A, B, C, Mapped> groupValueMapping, Comparator<Mapped> comparator, boolean min) {
        return new DefaultTriConstraintCollector(() -> new TreeMap(comparator), (resultContainer, a, b, c) -> {
            Object mapped = groupValueMapping.apply(a, b, c);
            return ConstraintCollectors.valueCountAccumulator(resultContainer, mapped);
        }, ConstraintCollectors.getMinOrMaxFinisher(min));
    }

    public static <A, B, C, D, Mapped extends Comparable<Mapped>> QuadConstraintCollector<A, B, C, D, ?, Mapped> max(QuadFunction<A, B, C, D, Mapped> groupValueMapping) {
        return ConstraintCollectors.max(groupValueMapping, Comparator.naturalOrder());
    }

    public static <A, B, C, D, Mapped> QuadConstraintCollector<A, B, C, D, ?, Mapped> max(QuadFunction<A, B, C, D, Mapped> groupValueMapping, Comparator<Mapped> comparator) {
        return ConstraintCollectors.minOrMax(groupValueMapping, comparator, false);
    }

    private static <A, B, C, D, Mapped> QuadConstraintCollector<A, B, C, D, SortedMap<Mapped, Long>, Mapped> minOrMax(QuadFunction<A, B, C, D, Mapped> groupValueMapping, Comparator<Mapped> comparator, boolean min) {
        return new DefaultQuadConstraintCollector(() -> new TreeMap(comparator), (resultContainer, a, b, c, d) -> {
            Object mapped = groupValueMapping.apply(a, b, c, d);
            return ConstraintCollectors.valueCountAccumulator(resultContainer, mapped);
        }, ConstraintCollectors.getMinOrMaxFinisher(min));
    }

    @Deprecated
    public static <A, Result extends Collection<A>> UniConstraintCollector<A, ?, Result> toCollection(IntFunction<Result> collectionFunction) {
        return ConstraintCollectors.toCollection(Function.identity(), collectionFunction);
    }

    public static <A> UniConstraintCollector<A, ?, Double> average(ToIntFunction<A> groupValueMapping) {
        return ConstraintCollectors.compose(ConstraintCollectors.count(), ConstraintCollectors.sum(groupValueMapping), (SubResult1_ count, SubResult2_ sum) -> {
            if (count == 0) {
                return null;
            }
            return (double)sum.intValue() / (double)count.intValue();
        });
    }

    public static <A> UniConstraintCollector<A, ?, Double> averageLong(ToLongFunction<A> groupValueMapping) {
        return ConstraintCollectors.compose(ConstraintCollectors.count(), ConstraintCollectors.sumLong(groupValueMapping), (SubResult1_ count, SubResult2_ sum) -> {
            if (count == 0) {
                return null;
            }
            return (double)sum.longValue() / (double)count.intValue();
        });
    }

    public static <A> UniConstraintCollector<A, ?, BigDecimal> averageBigDecimal(Function<A, BigDecimal> groupValueMapping) {
        return ConstraintCollectors.compose(ConstraintCollectors.count(), ConstraintCollectors.sumBigDecimal(groupValueMapping), (SubResult1_ count, SubResult2_ sum) -> {
            if (count == 0) {
                return null;
            }
            return sum.divide(BigDecimal.valueOf(count.intValue()), RoundingMode.HALF_EVEN);
        });
    }

    public static <A> UniConstraintCollector<A, ?, BigDecimal> averageBigInteger(Function<A, BigInteger> groupValueMapping) {
        return ConstraintCollectors.compose(ConstraintCollectors.count(), ConstraintCollectors.sumBigInteger(groupValueMapping), (SubResult1_ count, SubResult2_ sum) -> {
            if (count == 0) {
                return null;
            }
            return new BigDecimal((BigInteger)sum).divide(BigDecimal.valueOf(count.intValue()), RoundingMode.HALF_EVEN);
        });
    }

    public static <A> UniConstraintCollector<A, ?, Duration> averageDuration(Function<A, Duration> groupValueMapping) {
        return ConstraintCollectors.compose(ConstraintCollectors.count(), ConstraintCollectors.sumDuration(groupValueMapping), (SubResult1_ count, SubResult2_ sum) -> {
            if (count == 0) {
                return null;
            }
            long nanos = sum.toNanos();
            return Duration.ofNanos(nanos / (long)count.intValue());
        });
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Double> average(ToIntBiFunction<A, B> groupValueMapping) {
        return ConstraintCollectors.compose(ConstraintCollectors.countBi(), ConstraintCollectors.sum(groupValueMapping), (SubResult1_ count, SubResult2_ sum) -> {
            if (count == 0) {
                return null;
            }
            return (double)sum.intValue() / (double)count.intValue();
        });
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Double> averageLong(ToLongBiFunction<A, B> groupValueMapping) {
        return ConstraintCollectors.compose(ConstraintCollectors.countBi(), ConstraintCollectors.sumLong(groupValueMapping), (SubResult1_ count, SubResult2_ sum) -> {
            if (count == 0) {
                return null;
            }
            return (double)sum.longValue() / (double)count.intValue();
        });
    }

    public static <A, B> BiConstraintCollector<A, B, ?, BigDecimal> averageBigDecimal(BiFunction<A, B, BigDecimal> groupValueMapping) {
        return ConstraintCollectors.compose(ConstraintCollectors.countBi(), ConstraintCollectors.sumBigDecimal(groupValueMapping), (SubResult1_ count, SubResult2_ sum) -> {
            if (count == 0) {
                return null;
            }
            return sum.divide(BigDecimal.valueOf(count.intValue()), RoundingMode.HALF_EVEN);
        });
    }

    public static <A, B> BiConstraintCollector<A, B, ?, BigDecimal> averageBigInteger(BiFunction<A, B, BigInteger> groupValueMapping) {
        return ConstraintCollectors.compose(ConstraintCollectors.countBi(), ConstraintCollectors.sumBigInteger(groupValueMapping), (SubResult1_ count, SubResult2_ sum) -> {
            if (count == 0) {
                return null;
            }
            return new BigDecimal((BigInteger)sum).divide(BigDecimal.valueOf(count.intValue()), RoundingMode.HALF_EVEN);
        });
    }

    public static <A, B> BiConstraintCollector<A, B, ?, Duration> averageDuration(BiFunction<A, B, Duration> groupValueMapping) {
        return ConstraintCollectors.compose(ConstraintCollectors.countBi(), ConstraintCollectors.sumDuration(groupValueMapping), (SubResult1_ count, SubResult2_ sum) -> {
            if (count == 0) {
                return null;
            }
            long nanos = sum.toNanos();
            return Duration.ofNanos(nanos / (long)count.intValue());
        });
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, Double> average(ToIntTriFunction<A, B, C> groupValueMapping) {
        return ConstraintCollectors.compose(ConstraintCollectors.countTri(), ConstraintCollectors.sum(groupValueMapping), (SubResult1_ count, SubResult2_ sum) -> {
            if (count == 0) {
                return null;
            }
            return (double)sum.intValue() / (double)count.intValue();
        });
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, Double> averageLong(ToLongTriFunction<A, B, C> groupValueMapping) {
        return ConstraintCollectors.compose(ConstraintCollectors.countTri(), ConstraintCollectors.sumLong(groupValueMapping), (SubResult1_ count, SubResult2_ sum) -> {
            if (count == 0) {
                return null;
            }
            return (double)sum.longValue() / (double)count.intValue();
        });
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, BigDecimal> averageBigDecimal(TriFunction<A, B, C, BigDecimal> groupValueMapping) {
        return ConstraintCollectors.compose(ConstraintCollectors.countTri(), ConstraintCollectors.sumBigDecimal(groupValueMapping), (SubResult1_ count, SubResult2_ sum) -> {
            if (count == 0) {
                return null;
            }
            return sum.divide(BigDecimal.valueOf(count.intValue()), RoundingMode.HALF_EVEN);
        });
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, BigDecimal> averageBigInteger(TriFunction<A, B, C, BigInteger> groupValueMapping) {
        return ConstraintCollectors.compose(ConstraintCollectors.countTri(), ConstraintCollectors.sumBigInteger(groupValueMapping), (SubResult1_ count, SubResult2_ sum) -> {
            if (count == 0) {
                return null;
            }
            return new BigDecimal((BigInteger)sum).divide(BigDecimal.valueOf(count.intValue()), RoundingMode.HALF_EVEN);
        });
    }

    public static <A, B, C> TriConstraintCollector<A, B, C, ?, Duration> averageDuration(TriFunction<A, B, C, Duration> groupValueMapping) {
        return ConstraintCollectors.compose(ConstraintCollectors.countTri(), ConstraintCollectors.sumDuration(groupValueMapping), (SubResult1_ count, SubResult2_ sum) -> {
            if (count == 0) {
                return null;
            }
            long nanos = sum.toNanos();
            return Duration.ofNanos(nanos / (long)count.intValue());
        });
    }

    public static <A, B, C, D> QuadConstraintCollector<A, B, C, D, ?, Double> average(ToIntQuadFunction<A, B, C, D> groupValueMapping) {
        return ConstraintCollectors.compose(ConstraintCollectors.countQuad(), ConstraintCollectors.sum(groupValueMapping), (SubResult1_ count, SubResult2_ sum) -> {
            if (count == 0) {
                return null;
            }
            return (double)sum.intValue() / (double)count.intValue();
        });
    }

    public static <A, B, C, D> QuadConstraintCollector<A, B, C, D, ?, Double> averageLong(ToLongQuadFunction<A, B, C, D> groupValueMapping) {
        return ConstraintCollectors.compose(ConstraintCollectors.countQuad(), ConstraintCollectors.sumLong(groupValueMapping), (SubResult1_ count, SubResult2_ sum) -> {
            if (count == 0) {
                return null;
            }
            return (double)sum.longValue() / (double)count.intValue();
        });
    }

    public static <A, B, C, D> QuadConstraintCollector<A, B, C, D, ?, BigDecimal> averageBigDecimal(QuadFunction<A, B, C, D, BigDecimal> groupValueMapping) {
        return ConstraintCollectors.compose(ConstraintCollectors.countQuad(), ConstraintCollectors.sumBigDecimal(groupValueMapping), (SubResult1_ count, SubResult2_ sum) -> {
            if (count == 0) {
                return null;
            }
            return sum.divide(BigDecimal.valueOf(count.intValue()), RoundingMode.HALF_EVEN);
        });
    }

    public static <A, B, C, D> QuadConstraintCollector<A, B, C, D, ?, BigDecimal> averageBigInteger(QuadFunction<A, B, C, D, BigInteger> groupValueMapping) {
        return ConstraintCollectors.compose(ConstraintCollectors.countQuad(), ConstraintCollectors.sumBigInteger(groupValueMapping), (SubResult1_ count, SubResult2_ sum) -> {
            if (count == 0) {
                return null;
            }
            return new BigDecimal((BigInteger)sum).divide(BigDecimal.valueOf(count.intValue()), RoundingMode.HALF_EVEN);
        });
    }

    public static <A, B, C, D> QuadConstraintCollector<A, B, C, D, ?, Duration> averageDuration(QuadFunction<A, B, C, D, Duration> groupValueMapping) {
        return ConstraintCollectors.compose(ConstraintCollectors.countQuad(), ConstraintCollectors.sumDuration(groupValueMapping), (SubResult1_ count, SubResult2_ sum) -> {
            if (count == 0) {
                return null;
            }
            long nanos = sum.toNanos();
            return Duration.ofNanos(nanos / (long)count.intValue());
        });
    }

    public static <A> UniConstraintCollector<A, ?, Set<A>> toSet() {
        return ConstraintCollectors.toSet(Function.identity());
    }

    public static <A extends Comparable<A>> UniConstraintCollector<A, ?, SortedSet<A>> toSortedSet() {
        return ConstraintCollectors.toSortedSet((A a) -> a);
    }

    public static <A> UniConstraintCollector<A, ?, SortedSet<A>> toSortedSet(Comparator<A> comparator) {
        return ConstraintCollectors.toSortedSet((A a) -> a, comparator);
    }

    public static <A> UniConstraintCollector<A, ?, List<A>> toList() {
        return ConstraintCollectors.toList(Function.identity());
    }

    @Deprecated
    public static <A, Mapped, Result extends Collection<Mapped>> UniConstraintCollector<A, ?, Result> toCollection(Function<A, Mapped> groupValueMapping, IntFunction<Result> collectionFunction) {
        return new DefaultUniConstraintCollector<Object, List, Collection>(ArrayList::new, (resultContainer, a) -> {
            Object mapped = groupValueMapping.apply(a);
            resultContainer.add(mapped);
            return () -> resultContainer.remove(mapped);
        }, resultContainer -> ConstraintCollectors.toCollectionFinisher(collectionFunction, resultContainer));
    }

    private static <Mapped, Container extends List<Mapped>, Result extends Collection<Mapped>> Result toCollectionFinisher(IntFunction<Result> collectionFunction, Container resultContainer) {
        int size = resultContainer.size();
        Collection collection = (Collection)collectionFunction.apply(size);
        if (size > 0) {
            collection.addAll(resultContainer);
        }
        return (Result)collection;
    }

    public static <A, Mapped> UniConstraintCollector<A, ?, Set<Mapped>> toSet(Function<A, Mapped> groupValueMapping) {
        return new DefaultUniConstraintCollector<Object, HashMap, Set>(HashMap::new, (resultContainer, a) -> {
            Object mapped = groupValueMapping.apply(a);
            return ConstraintCollectors.valueCountAccumulator(resultContainer, mapped);
        }, HashMap::keySet);
    }

    public static <A, Mapped extends Comparable<Mapped>> UniConstraintCollector<A, ?, SortedSet<Mapped>> toSortedSet(Function<A, Mapped> groupValueMapping) {
        return ConstraintCollectors.toSortedSet(groupValueMapping, Comparator.naturalOrder());
    }

    public static <A, Mapped> UniConstraintCollector<A, ?, SortedSet<Mapped>> toSortedSet(Function<A, Mapped> groupValueMapping, Comparator<Mapped> comparator) {
        return new DefaultUniConstraintCollector<Object, TreeMap, SortedSet>(() -> new TreeMap(comparator), (resultContainer, a) -> {
            Object mapped = groupValueMapping.apply(a);
            return ConstraintCollectors.valueCountAccumulator(resultContainer, mapped);
        }, TreeMap::navigableKeySet);
    }

    public static <A, Mapped> UniConstraintCollector<A, ?, List<Mapped>> toList(Function<A, Mapped> groupValueMapping) {
        return new DefaultUniConstraintCollector(ArrayList::new, (resultContainer, a) -> {
            Object mapped = groupValueMapping.apply(a);
            resultContainer.add(mapped);
            return () -> resultContainer.remove(mapped);
        }, Function.identity());
    }

    @Deprecated
    public static <A, B, Mapped, Result extends Collection<Mapped>> BiConstraintCollector<A, B, ?, Result> toCollection(BiFunction<A, B, Mapped> groupValueMapping, IntFunction<Result> collectionFunction) {
        return new DefaultBiConstraintCollector<Object, Object, List, Collection>(ArrayList::new, (resultContainer, a, b) -> {
            Object mapped = groupValueMapping.apply(a, b);
            resultContainer.add(mapped);
            return () -> resultContainer.remove(mapped);
        }, resultContainer -> ConstraintCollectors.toCollectionFinisher(collectionFunction, resultContainer));
    }

    public static <A, B, Mapped> BiConstraintCollector<A, B, ?, Set<Mapped>> toSet(BiFunction<A, B, Mapped> groupValueMapping) {
        return new DefaultBiConstraintCollector<Object, Object, HashMap, Set>(HashMap::new, (resultContainer, a, b) -> {
            Object mapped = groupValueMapping.apply(a, b);
            return ConstraintCollectors.valueCountAccumulator(resultContainer, mapped);
        }, HashMap::keySet);
    }

    public static <A, B, Mapped extends Comparable<Mapped>> BiConstraintCollector<A, B, ?, SortedSet<Mapped>> toSortedSet(BiFunction<A, B, Mapped> groupValueMapping) {
        return ConstraintCollectors.toSortedSet(groupValueMapping, Comparator.naturalOrder());
    }

    public static <A, B, Mapped> BiConstraintCollector<A, B, ?, SortedSet<Mapped>> toSortedSet(BiFunction<A, B, Mapped> groupValueMapping, Comparator<Mapped> comparator) {
        return new DefaultBiConstraintCollector<Object, Object, TreeMap, SortedSet>(() -> new TreeMap(comparator), (resultContainer, a, b) -> {
            Object mapped = groupValueMapping.apply(a, b);
            return ConstraintCollectors.valueCountAccumulator(resultContainer, mapped);
        }, TreeMap::navigableKeySet);
    }

    public static <A, B, Mapped> BiConstraintCollector<A, B, ?, List<Mapped>> toList(BiFunction<A, B, Mapped> groupValueMapping) {
        return new DefaultBiConstraintCollector(ArrayList::new, (resultContainer, a, b) -> {
            Object mapped = groupValueMapping.apply(a, b);
            resultContainer.add(mapped);
            return () -> resultContainer.remove(mapped);
        }, Function.identity());
    }

    @Deprecated
    public static <A, B, C, Mapped, Result extends Collection<Mapped>> TriConstraintCollector<A, B, C, ?, Result> toCollection(TriFunction<A, B, C, Mapped> groupValueMapping, IntFunction<Result> collectionFunction) {
        return new DefaultTriConstraintCollector<Object, Object, Object, List, Collection>(ArrayList::new, (resultContainer, a, b, c) -> {
            Object mapped = groupValueMapping.apply(a, b, c);
            resultContainer.add(mapped);
            return () -> resultContainer.remove(mapped);
        }, resultContainer -> ConstraintCollectors.toCollectionFinisher(collectionFunction, resultContainer));
    }

    public static <A, B, C, Mapped> TriConstraintCollector<A, B, C, ?, Set<Mapped>> toSet(TriFunction<A, B, C, Mapped> groupValueMapping) {
        return new DefaultTriConstraintCollector<Object, Object, Object, HashMap, Set>(HashMap::new, (resultContainer, a, b, c) -> {
            Object mapped = groupValueMapping.apply(a, b, c);
            return ConstraintCollectors.valueCountAccumulator(resultContainer, mapped);
        }, HashMap::keySet);
    }

    public static <A, B, C, Mapped extends Comparable<Mapped>> TriConstraintCollector<A, B, C, ?, SortedSet<Mapped>> toSortedSet(TriFunction<A, B, C, Mapped> groupValueMapping) {
        return ConstraintCollectors.toSortedSet(groupValueMapping, Comparator.naturalOrder());
    }

    public static <A, B, C, Mapped> TriConstraintCollector<A, B, C, ?, SortedSet<Mapped>> toSortedSet(TriFunction<A, B, C, Mapped> groupValueMapping, Comparator<Mapped> comparator) {
        return new DefaultTriConstraintCollector<Object, Object, Object, TreeMap, SortedSet>(() -> new TreeMap(comparator), (resultContainer, a, b, c) -> {
            Object mapped = groupValueMapping.apply(a, b, c);
            return ConstraintCollectors.valueCountAccumulator(resultContainer, mapped);
        }, TreeMap::navigableKeySet);
    }

    public static <A, B, C, Mapped> TriConstraintCollector<A, B, C, ?, List<Mapped>> toList(TriFunction<A, B, C, Mapped> groupValueMapping) {
        return new DefaultTriConstraintCollector(ArrayList::new, (resultContainer, a, b, c) -> {
            Object mapped = groupValueMapping.apply(a, b, c);
            resultContainer.add(mapped);
            return () -> resultContainer.remove(mapped);
        }, Function.identity());
    }

    @Deprecated
    public static <A, B, C, D, Mapped, Result extends Collection<Mapped>> QuadConstraintCollector<A, B, C, D, ?, Result> toCollection(QuadFunction<A, B, C, D, Mapped> groupValueMapping, IntFunction<Result> collectionFunction) {
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, List, Collection>(ArrayList::new, (resultContainer, a, b, c, d) -> {
            Object mapped = groupValueMapping.apply(a, b, c, d);
            resultContainer.add(mapped);
            return () -> resultContainer.remove(mapped);
        }, resultContainer -> ConstraintCollectors.toCollectionFinisher(collectionFunction, resultContainer));
    }

    public static <A, B, C, D, Mapped> QuadConstraintCollector<A, B, C, D, ?, Set<Mapped>> toSet(QuadFunction<A, B, C, D, Mapped> groupValueMapping) {
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, HashMap, Set>(HashMap::new, (resultContainer, a, b, c, d) -> {
            Object mapped = groupValueMapping.apply(a, b, c, d);
            return ConstraintCollectors.valueCountAccumulator(resultContainer, mapped);
        }, HashMap::keySet);
    }

    public static <A, B, C, D, Mapped extends Comparable<Mapped>> QuadConstraintCollector<A, B, C, D, ?, SortedSet<Mapped>> toSortedSet(QuadFunction<A, B, C, D, Mapped> groupValueMapping) {
        return ConstraintCollectors.toSortedSet(groupValueMapping, Comparator.naturalOrder());
    }

    public static <A, B, C, D, Mapped> QuadConstraintCollector<A, B, C, D, ?, SortedSet<Mapped>> toSortedSet(QuadFunction<A, B, C, D, Mapped> groupValueMapping, Comparator<Mapped> comparator) {
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, TreeMap, SortedSet>(() -> new TreeMap(comparator), (resultContainer, a, b, c, d) -> {
            Object mapped = groupValueMapping.apply(a, b, c, d);
            return ConstraintCollectors.valueCountAccumulator(resultContainer, mapped);
        }, TreeMap::navigableKeySet);
    }

    public static <A, B, C, D, Mapped> QuadConstraintCollector<A, B, C, D, ?, List<Mapped>> toList(QuadFunction<A, B, C, D, Mapped> groupValueMapping) {
        return new DefaultQuadConstraintCollector(ArrayList::new, (resultContainer, a, b, c, d) -> {
            Object mapped = groupValueMapping.apply(a, b, c, d);
            resultContainer.add(mapped);
            return () -> resultContainer.remove(mapped);
        }, Function.identity());
    }

    public static <A, Key, Value> UniConstraintCollector<A, ?, Map<Key, Set<Value>>> toMap(Function<? super A, ? extends Key> keyMapper, Function<? super A, ? extends Value> valueMapper) {
        return ConstraintCollectors.toMap(keyMapper, valueMapper, LinkedHashSet::new);
    }

    public static <A, Key, Value, ValueSet extends Set<Value>> UniConstraintCollector<A, ?, Map<Key, ValueSet>> toMap(Function<? super A, ? extends Key> keyMapper, Function<? super A, ? extends Value> valueMapper, IntFunction<ValueSet> valueSetFunction) {
        return new DefaultUniConstraintCollector<Object, ToMultiMapResultContainer, Map>(() -> new ToMultiMapResultContainer(HashMap::new, valueSetFunction), (resultContainer, a) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a), ToMultiMapResultContainer::getResult);
    }

    private static <A, Key, Value> Runnable toMapAccumulator(Function<? super A, ? extends Key> keyMapper, Function<? super A, ? extends Value> valueMapper, ToMapResultContainer<Key, Value, ?, ?> resultContainer, A a) {
        Key key = keyMapper.apply(a);
        Value value = valueMapper.apply(a);
        return ConstraintCollectors.toMapInnerAccumulator(key, value, resultContainer);
    }

    private static <Key, Value> Runnable toMapInnerAccumulator(Key key, Value value, ToMapResultContainer<Key, Value, ?, ?> resultContainer) {
        resultContainer.add(key, value);
        return () -> resultContainer.remove(key, value);
    }

    public static <A, Key, Value> UniConstraintCollector<A, ?, Map<Key, Value>> toMap(Function<? super A, ? extends Key> keyMapper, Function<? super A, ? extends Value> valueMapper, BinaryOperator<Value> mergeFunction) {
        return new DefaultUniConstraintCollector<Object, ToSimpleMapResultContainer, Map>(() -> new ToSimpleMapResultContainer(HashMap::new, mergeFunction), (resultContainer, a) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a), ToMapResultContainer::getResult);
    }

    public static <A, Key extends Comparable<Key>, Value> UniConstraintCollector<A, ?, SortedMap<Key, Set<Value>>> toSortedMap(Function<? super A, ? extends Key> keyMapper, Function<? super A, ? extends Value> valueMapper) {
        return ConstraintCollectors.toSortedMap(keyMapper, valueMapper, LinkedHashSet::new);
    }

    public static <A, Key extends Comparable<Key>, Value, ValueSet extends Set<Value>> UniConstraintCollector<A, ?, SortedMap<Key, ValueSet>> toSortedMap(Function<? super A, ? extends Key> keyMapper, Function<? super A, ? extends Value> valueMapper, IntFunction<ValueSet> valueSetFunction) {
        return new DefaultUniConstraintCollector<Object, ToMultiMapResultContainer, SortedMap>(() -> new ToMultiMapResultContainer(TreeMap::new, valueSetFunction), (resultContainer, a) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a), ToMultiMapResultContainer::getResult);
    }

    public static <A, Key extends Comparable<Key>, Value> UniConstraintCollector<A, ?, SortedMap<Key, Value>> toSortedMap(Function<? super A, ? extends Key> keyMapper, Function<? super A, ? extends Value> valueMapper, BinaryOperator<Value> mergeFunction) {
        return new DefaultUniConstraintCollector<Object, ToSimpleMapResultContainer, SortedMap>(() -> new ToSimpleMapResultContainer(TreeMap::new, mergeFunction), (resultContainer, a) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a), ToSimpleMapResultContainer::getResult);
    }

    public static <A, B, Key, Value> BiConstraintCollector<A, B, ?, Map<Key, Set<Value>>> toMap(BiFunction<? super A, ? super B, ? extends Key> keyMapper, BiFunction<? super A, ? super B, ? extends Value> valueMapper) {
        return ConstraintCollectors.toMap(keyMapper, valueMapper, LinkedHashSet::new);
    }

    public static <A, B, Key, Value, ValueSet extends Set<Value>> BiConstraintCollector<A, B, ?, Map<Key, ValueSet>> toMap(BiFunction<? super A, ? super B, ? extends Key> keyMapper, BiFunction<? super A, ? super B, ? extends Value> valueMapper, IntFunction<ValueSet> valueSetFunction) {
        return new DefaultBiConstraintCollector<Object, Object, ToMultiMapResultContainer, Map>(() -> new ToMultiMapResultContainer(HashMap::new, valueSetFunction), (resultContainer, a, b) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a, b), ToMultiMapResultContainer::getResult);
    }

    private static <A, B, Key, Value> Runnable toMapAccumulator(BiFunction<? super A, ? super B, ? extends Key> keyMapper, BiFunction<? super A, ? super B, ? extends Value> valueMapper, ToMapResultContainer<Key, Value, ?, ?> resultContainer, A a, B b) {
        Key key = keyMapper.apply(a, b);
        Value value = valueMapper.apply(a, b);
        return ConstraintCollectors.toMapInnerAccumulator(key, value, resultContainer);
    }

    public static <A, B, Key, Value> BiConstraintCollector<A, B, ?, Map<Key, Value>> toMap(BiFunction<? super A, ? super B, ? extends Key> keyMapper, BiFunction<? super A, ? super B, ? extends Value> valueMapper, BinaryOperator<Value> mergeFunction) {
        return new DefaultBiConstraintCollector<Object, Object, ToSimpleMapResultContainer, Map>(() -> new ToSimpleMapResultContainer(HashMap::new, mergeFunction), (resultContainer, a, b) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a, b), ToSimpleMapResultContainer::getResult);
    }

    public static <A, B, Key extends Comparable<Key>, Value> BiConstraintCollector<A, B, ?, SortedMap<Key, Set<Value>>> toSortedMap(BiFunction<? super A, ? super B, ? extends Key> keyMapper, BiFunction<? super A, ? super B, ? extends Value> valueMapper) {
        return ConstraintCollectors.toSortedMap(keyMapper, valueMapper, LinkedHashSet::new);
    }

    public static <A, B, Key extends Comparable<Key>, Value, ValueSet extends Set<Value>> BiConstraintCollector<A, B, ?, SortedMap<Key, ValueSet>> toSortedMap(BiFunction<? super A, ? super B, ? extends Key> keyMapper, BiFunction<? super A, ? super B, ? extends Value> valueMapper, IntFunction<ValueSet> valueSetFunction) {
        return new DefaultBiConstraintCollector<Object, Object, ToMultiMapResultContainer, SortedMap>(() -> new ToMultiMapResultContainer(TreeMap::new, valueSetFunction), (resultContainer, a, b) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a, b), ToMultiMapResultContainer::getResult);
    }

    public static <A, B, Key extends Comparable<Key>, Value> BiConstraintCollector<A, B, ?, SortedMap<Key, Value>> toSortedMap(BiFunction<? super A, ? super B, ? extends Key> keyMapper, BiFunction<? super A, ? super B, ? extends Value> valueMapper, BinaryOperator<Value> mergeFunction) {
        return new DefaultBiConstraintCollector<Object, Object, ToSimpleMapResultContainer, SortedMap>(() -> new ToSimpleMapResultContainer(TreeMap::new, mergeFunction), (resultContainer, a, b) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a, b), ToSimpleMapResultContainer::getResult);
    }

    public static <A, B, C, Key, Value> TriConstraintCollector<A, B, C, ?, Map<Key, Set<Value>>> toMap(TriFunction<? super A, ? super B, ? super C, ? extends Key> keyMapper, TriFunction<? super A, ? super B, ? super C, ? extends Value> valueMapper) {
        return ConstraintCollectors.toMap(keyMapper, valueMapper, LinkedHashSet::new);
    }

    public static <A, B, C, Key, Value, ValueSet extends Set<Value>> TriConstraintCollector<A, B, C, ?, Map<Key, ValueSet>> toMap(TriFunction<? super A, ? super B, ? super C, ? extends Key> keyMapper, TriFunction<? super A, ? super B, ? super C, ? extends Value> valueMapper, IntFunction<ValueSet> valueSetFunction) {
        return new DefaultTriConstraintCollector<Object, Object, Object, ToMultiMapResultContainer, Map>(() -> new ToMultiMapResultContainer(HashMap::new, valueSetFunction), (resultContainer, a, b, c) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a, b, c), ToMultiMapResultContainer::getResult);
    }

    private static <A, B, C, Key, Value> Runnable toMapAccumulator(TriFunction<? super A, ? super B, ? super C, ? extends Key> keyMapper, TriFunction<? super A, ? super B, ? super C, ? extends Value> valueMapper, ToMapResultContainer<Key, Value, ?, ?> resultContainer, A a, B b, C c) {
        Key key = keyMapper.apply(a, b, c);
        Value value = valueMapper.apply(a, b, c);
        return ConstraintCollectors.toMapInnerAccumulator(key, value, resultContainer);
    }

    public static <A, B, C, Key, Value> TriConstraintCollector<A, B, C, ?, Map<Key, Value>> toMap(TriFunction<? super A, ? super B, ? super C, ? extends Key> keyMapper, TriFunction<? super A, ? super B, ? super C, ? extends Value> valueMapper, BinaryOperator<Value> mergeFunction) {
        return new DefaultTriConstraintCollector<Object, Object, Object, ToSimpleMapResultContainer, Map>(() -> new ToSimpleMapResultContainer(HashMap::new, mergeFunction), (resultContainer, a, b, c) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a, b, c), ToSimpleMapResultContainer::getResult);
    }

    public static <A, B, C, Key extends Comparable<Key>, Value> TriConstraintCollector<A, B, C, ?, SortedMap<Key, Set<Value>>> toSortedMap(TriFunction<? super A, ? super B, ? super C, ? extends Key> keyMapper, TriFunction<? super A, ? super B, ? super C, ? extends Value> valueMapper) {
        return ConstraintCollectors.toSortedMap(keyMapper, valueMapper, LinkedHashSet::new);
    }

    public static <A, B, C, Key extends Comparable<Key>, Value, ValueSet extends Set<Value>> TriConstraintCollector<A, B, C, ?, SortedMap<Key, ValueSet>> toSortedMap(TriFunction<? super A, ? super B, ? super C, ? extends Key> keyMapper, TriFunction<? super A, ? super B, ? super C, ? extends Value> valueMapper, IntFunction<ValueSet> valueSetFunction) {
        return new DefaultTriConstraintCollector<Object, Object, Object, ToMultiMapResultContainer, SortedMap>(() -> new ToMultiMapResultContainer(TreeMap::new, valueSetFunction), (resultContainer, a, b, c) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a, b, c), ToMultiMapResultContainer::getResult);
    }

    public static <A, B, C, Key extends Comparable<Key>, Value> TriConstraintCollector<A, B, C, ?, SortedMap<Key, Value>> toSortedMap(TriFunction<? super A, ? super B, ? super C, ? extends Key> keyMapper, TriFunction<? super A, ? super B, ? super C, ? extends Value> valueMapper, BinaryOperator<Value> mergeFunction) {
        return new DefaultTriConstraintCollector<Object, Object, Object, ToSimpleMapResultContainer, SortedMap>(() -> new ToSimpleMapResultContainer(TreeMap::new, mergeFunction), (resultContainer, a, b, c) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a, b, c), ToSimpleMapResultContainer::getResult);
    }

    public static <A, B, C, D, Key, Value> QuadConstraintCollector<A, B, C, D, ?, Map<Key, Set<Value>>> toMap(QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Key> keyMapper, QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Value> valueMapper) {
        return ConstraintCollectors.toMap(keyMapper, valueMapper, LinkedHashSet::new);
    }

    public static <A, B, C, D, Key, Value, ValueSet extends Set<Value>> QuadConstraintCollector<A, B, C, D, ?, Map<Key, ValueSet>> toMap(QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Key> keyMapper, QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Value> valueMapper, IntFunction<ValueSet> valueSetFunction) {
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, ToMultiMapResultContainer, Map>(() -> new ToMultiMapResultContainer(HashMap::new, valueSetFunction), (resultContainer, a, b, c, d) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a, b, c, d), ToMultiMapResultContainer::getResult);
    }

    private static <A, B, C, D, Key, Value> Runnable toMapAccumulator(QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Key> keyMapper, QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Value> valueMapper, ToMapResultContainer<Key, Value, ?, ?> resultContainer, A a, B b, C c, D d) {
        Key key = keyMapper.apply(a, b, c, d);
        Value value = valueMapper.apply(a, b, c, d);
        return ConstraintCollectors.toMapInnerAccumulator(key, value, resultContainer);
    }

    public static <A, B, C, D, Key, Value> QuadConstraintCollector<A, B, C, D, ?, Map<Key, Value>> toMap(QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Key> keyMapper, QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Value> valueMapper, BinaryOperator<Value> mergeFunction) {
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, ToSimpleMapResultContainer, Map>(() -> new ToSimpleMapResultContainer(HashMap::new, mergeFunction), (resultContainer, a, b, c, d) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a, b, c, d), ToSimpleMapResultContainer::getResult);
    }

    public static <A, B, C, D, Key extends Comparable<Key>, Value> QuadConstraintCollector<A, B, C, D, ?, SortedMap<Key, Set<Value>>> toSortedMap(QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Key> keyMapper, QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Value> valueMapper) {
        return ConstraintCollectors.toSortedMap(keyMapper, valueMapper, LinkedHashSet::new);
    }

    public static <A, B, C, D, Key extends Comparable<Key>, Value, ValueSet extends Set<Value>> QuadConstraintCollector<A, B, C, D, ?, SortedMap<Key, ValueSet>> toSortedMap(QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Key> keyMapper, QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Value> valueMapper, IntFunction<ValueSet> valueSetFunction) {
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, ToMultiMapResultContainer, SortedMap>(() -> new ToMultiMapResultContainer(TreeMap::new, valueSetFunction), (resultContainer, a, b, c, d) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a, b, c, d), ToMultiMapResultContainer::getResult);
    }

    public static <A, B, C, D, Key extends Comparable<Key>, Value> QuadConstraintCollector<A, B, C, D, ?, SortedMap<Key, Value>> toSortedMap(QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Key> keyMapper, QuadFunction<? super A, ? super B, ? super C, ? super D, ? extends Value> valueMapper, BinaryOperator<Value> mergeFunction) {
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, ToSimpleMapResultContainer, SortedMap>(() -> new ToSimpleMapResultContainer(TreeMap::new, mergeFunction), (resultContainer, a, b, c, d) -> ConstraintCollectors.toMapAccumulator(keyMapper, valueMapper, resultContainer, a, b, c, d), ToSimpleMapResultContainer::getResult);
    }

    public static <A, ResultContainer_, Result_> UniConstraintCollector<A, ResultContainer_, Result_> conditionally(Predicate<A> condition, UniConstraintCollector<A, ResultContainer_, Result_> delegate) {
        BiFunction accumulator = delegate.accumulator();
        return new DefaultUniConstraintCollector<Object, Object, Result_>(delegate.supplier(), (resultContainer, a) -> {
            if (condition.test(a)) {
                return (Runnable)accumulator.apply(resultContainer, a);
            }
            return NOOP;
        }, delegate.finisher());
    }

    public static <A, B, ResultContainer_, Result_> BiConstraintCollector<A, B, ResultContainer_, Result_> conditionally(BiPredicate<A, B> condition, BiConstraintCollector<A, B, ResultContainer_, Result_> delegate) {
        TriFunction accumulator = delegate.accumulator();
        return new DefaultBiConstraintCollector<Object, Object, Object, Result_>(delegate.supplier(), (resultContainer, a, b) -> {
            if (condition.test(a, b)) {
                return (Runnable)accumulator.apply(resultContainer, a, b);
            }
            return NOOP;
        }, delegate.finisher());
    }

    public static <A, B, C, ResultContainer_, Result_> TriConstraintCollector<A, B, C, ResultContainer_, Result_> conditionally(TriPredicate<A, B, C> condition, TriConstraintCollector<A, B, C, ResultContainer_, Result_> delegate) {
        QuadFunction accumulator = delegate.accumulator();
        return new DefaultTriConstraintCollector<Object, Object, Object, Object, Result_>(delegate.supplier(), (resultContainer, a, b, c) -> {
            if (condition.test(a, b, c)) {
                return (Runnable)accumulator.apply(resultContainer, a, b, c);
            }
            return NOOP;
        }, delegate.finisher());
    }

    public static <A, B, C, D, ResultContainer_, Result_> QuadConstraintCollector<A, B, C, D, ResultContainer_, Result_> conditionally(QuadPredicate<A, B, C, D> condition, QuadConstraintCollector<A, B, C, D, ResultContainer_, Result_> delegate) {
        PentaFunction accumulator = delegate.accumulator();
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, Object, Result_>(delegate.supplier(), (resultContainer, a, b, c, d) -> {
            if (condition.test(a, b, c, d)) {
                return (Runnable)accumulator.apply(resultContainer, a, b, c, d);
            }
            return NOOP;
        }, delegate.finisher());
    }

    public static <A, Result_, SubResultContainer1_, SubResultContainer2_, SubResult1_, SubResult2_> UniConstraintCollector<A, ?, Result_> compose(UniConstraintCollector<A, SubResultContainer1_, SubResult1_> subCollector1, UniConstraintCollector<A, SubResultContainer2_, SubResult2_> subCollector2, BiFunction<SubResult1_, SubResult2_, Result_> composeFunction) {
        BiFunction subResult1Accumulator = subCollector1.accumulator();
        BiFunction subResult2Accumulator = subCollector2.accumulator();
        return new DefaultUniConstraintCollector<Object, BiResultContainer<SubResultContainer1_, SubResultContainer2_>, Result_>(() -> BiResultContainer.of(subCollector1.supplier(), subCollector2.supplier()), (resultContainer, a) -> {
            Runnable undo1 = (Runnable)subResult1Accumulator.apply(resultContainer.resultContainer1, a);
            Runnable undo2 = (Runnable)subResult2Accumulator.apply(resultContainer.resultContainer2, a);
            return ConstraintCollectors.compose(undo1, undo2);
        }, ConstraintCollectors.createComposedFinisher(subCollector1.finisher(), subCollector2.finisher(), composeFunction));
    }

    private static <Result_, SubResultContainer1_, SubResultContainer2_, SubResult1_, SubResult2_> Function<BiResultContainer<SubResultContainer1_, SubResultContainer2_>, Result_> createComposedFinisher(Function<SubResultContainer1_, SubResult1_> subResult1Finisher, Function<SubResultContainer2_, SubResult2_> subResult2Finisher, BiFunction<SubResult1_, SubResult2_, Result_> composeFunction) {
        return resultContainer -> {
            Object result1 = subResult1Finisher.apply(resultContainer.resultContainer1);
            Object result2 = subResult2Finisher.apply(resultContainer.resultContainer2);
            return composeFunction.apply(result1, result2);
        };
    }

    private static Runnable compose(Runnable runnable1, Runnable runnable2) {
        return () -> {
            runnable1.run();
            runnable2.run();
        };
    }

    public static <A, Result_, SubResultContainer1_, SubResultContainer2_, SubResultContainer3_, SubResult1_, SubResult2_, SubResult3_> UniConstraintCollector<A, ?, Result_> compose(UniConstraintCollector<A, SubResultContainer1_, SubResult1_> subCollector1, UniConstraintCollector<A, SubResultContainer2_, SubResult2_> subCollector2, UniConstraintCollector<A, SubResultContainer3_, SubResult3_> subCollector3, TriFunction<SubResult1_, SubResult2_, SubResult3_, Result_> composeFunction) {
        BiFunction subResult1Accumulator = subCollector1.accumulator();
        BiFunction subResult2Accumulator = subCollector2.accumulator();
        BiFunction subResult3Accumulator = subCollector3.accumulator();
        return new DefaultUniConstraintCollector<Object, TriResultContainer<SubResultContainer1_, SubResultContainer2_, SubResultContainer3_>, Result_>(() -> TriResultContainer.of(subCollector1.supplier(), subCollector2.supplier(), subCollector3.supplier()), (resultContainer, a) -> {
            Runnable undo1 = (Runnable)subResult1Accumulator.apply(resultContainer.resultContainer1, a);
            Runnable undo2 = (Runnable)subResult2Accumulator.apply(resultContainer.resultContainer2, a);
            Runnable undo3 = (Runnable)subResult3Accumulator.apply(resultContainer.resultContainer3, a);
            return ConstraintCollectors.compose(undo1, undo2, undo3);
        }, ConstraintCollectors.createComposedFinisher(subCollector1.finisher(), subCollector2.finisher(), subCollector3.finisher(), composeFunction));
    }

    private static <Result_, SubResultContainer1_, SubResultContainer2_, SubResultContainer3_, SubResult1_, SubResult2_, SubResult3_> Function<TriResultContainer<SubResultContainer1_, SubResultContainer2_, SubResultContainer3_>, Result_> createComposedFinisher(Function<SubResultContainer1_, SubResult1_> subResult1Finisher, Function<SubResultContainer2_, SubResult2_> subResult2Finisher, Function<SubResultContainer3_, SubResult3_> subResult3Finisher, TriFunction<SubResult1_, SubResult2_, SubResult3_, Result_> composeFunction) {
        return resultContainer -> {
            Object result1 = subResult1Finisher.apply(resultContainer.resultContainer1);
            Object result2 = subResult2Finisher.apply(resultContainer.resultContainer2);
            Object result3 = subResult3Finisher.apply(resultContainer.resultContainer3);
            return composeFunction.apply(result1, result2, result3);
        };
    }

    private static Runnable compose(Runnable runnable1, Runnable runnable2, Runnable runnable3) {
        return () -> {
            runnable1.run();
            runnable2.run();
            runnable3.run();
        };
    }

    public static <A, Result_, SubResultContainer1_, SubResultContainer2_, SubResultContainer3_, SubResultContainer4_, SubResult1_, SubResult2_, SubResult3_, SubResult4_> UniConstraintCollector<A, ?, Result_> compose(UniConstraintCollector<A, SubResultContainer1_, SubResult1_> subCollector1, UniConstraintCollector<A, SubResultContainer2_, SubResult2_> subCollector2, UniConstraintCollector<A, SubResultContainer3_, SubResult3_> subCollector3, UniConstraintCollector<A, SubResultContainer4_, SubResult4_> subCollector4, QuadFunction<SubResult1_, SubResult2_, SubResult3_, SubResult4_, Result_> composeFunction) {
        BiFunction subResult1Accumulator = subCollector1.accumulator();
        BiFunction subResult2Accumulator = subCollector2.accumulator();
        BiFunction subResult3Accumulator = subCollector3.accumulator();
        BiFunction subResult4Accumulator = subCollector4.accumulator();
        return new DefaultUniConstraintCollector<Object, QuadResultContainer<SubResultContainer1_, SubResultContainer2_, SubResultContainer3_, SubResultContainer4_>, Result_>(() -> QuadResultContainer.of(subCollector1.supplier(), subCollector2.supplier(), subCollector3.supplier(), subCollector4.supplier()), (resultContainer, a) -> {
            Runnable undo1 = (Runnable)subResult1Accumulator.apply(resultContainer.resultContainer1, a);
            Runnable undo2 = (Runnable)subResult2Accumulator.apply(resultContainer.resultContainer2, a);
            Runnable undo3 = (Runnable)subResult3Accumulator.apply(resultContainer.resultContainer3, a);
            Runnable undo4 = (Runnable)subResult4Accumulator.apply(resultContainer.resultContainer4, a);
            return ConstraintCollectors.compose(undo1, undo2, undo3, undo4);
        }, ConstraintCollectors.createComposedFinisher(subCollector1.finisher(), subCollector2.finisher(), subCollector3.finisher(), subCollector4.finisher(), composeFunction));
    }

    private static <Result_, SubResultContainer1_, SubResultContainer2_, SubResultContainer3_, SubResultContainer4_, SubResult1_, SubResult2_, SubResult3_, SubResult4_> Function<QuadResultContainer<SubResultContainer1_, SubResultContainer2_, SubResultContainer3_, SubResultContainer4_>, Result_> createComposedFinisher(Function<SubResultContainer1_, SubResult1_> subResult1Finisher, Function<SubResultContainer2_, SubResult2_> subResult2Finisher, Function<SubResultContainer3_, SubResult3_> subResult3Finisher, Function<SubResultContainer4_, SubResult4_> subResult4Finisher, QuadFunction<SubResult1_, SubResult2_, SubResult3_, SubResult4_, Result_> composeFunction) {
        return resultContainer -> {
            Object result1 = subResult1Finisher.apply(resultContainer.resultContainer1);
            Object result2 = subResult2Finisher.apply(resultContainer.resultContainer2);
            Object result3 = subResult3Finisher.apply(resultContainer.resultContainer3);
            Object result4 = subResult4Finisher.apply(resultContainer.resultContainer4);
            return composeFunction.apply(result1, result2, result3, result4);
        };
    }

    private static Runnable compose(Runnable runnable1, Runnable runnable2, Runnable runnable3, Runnable runnable4) {
        return () -> {
            runnable1.run();
            runnable2.run();
            runnable3.run();
            runnable4.run();
        };
    }

    public static <A, B, Result_, SubResultContainer1_, SubResultContainer2_, SubResult1_, SubResult2_> BiConstraintCollector<A, B, ?, Result_> compose(BiConstraintCollector<A, B, SubResultContainer1_, SubResult1_> subCollector1, BiConstraintCollector<A, B, SubResultContainer2_, SubResult2_> subCollector2, BiFunction<SubResult1_, SubResult2_, Result_> composeFunction) {
        TriFunction subResult1Accumulator = subCollector1.accumulator();
        TriFunction subResult2Accumulator = subCollector2.accumulator();
        return new DefaultBiConstraintCollector<Object, Object, BiResultContainer<SubResultContainer1_, SubResultContainer2_>, Result_>(() -> BiResultContainer.of(subCollector1.supplier(), subCollector2.supplier()), (resultContainer, a, b) -> {
            Runnable undo1 = (Runnable)subResult1Accumulator.apply(resultContainer.resultContainer1, a, b);
            Runnable undo2 = (Runnable)subResult2Accumulator.apply(resultContainer.resultContainer2, a, b);
            return ConstraintCollectors.compose(undo1, undo2);
        }, ConstraintCollectors.createComposedFinisher(subCollector1.finisher(), subCollector2.finisher(), composeFunction));
    }

    public static <A, B, Result_, SubResultContainer1_, SubResultContainer2_, SubResultContainer3_, SubResult1_, SubResult2_, SubResult3_> BiConstraintCollector<A, B, ?, Result_> compose(BiConstraintCollector<A, B, SubResultContainer1_, SubResult1_> subCollector1, BiConstraintCollector<A, B, SubResultContainer2_, SubResult2_> subCollector2, BiConstraintCollector<A, B, SubResultContainer3_, SubResult3_> subCollector3, TriFunction<SubResult1_, SubResult2_, SubResult3_, Result_> composeFunction) {
        TriFunction subResult1Accumulator = subCollector1.accumulator();
        TriFunction subResult2Accumulator = subCollector2.accumulator();
        TriFunction subResult3Accumulator = subCollector3.accumulator();
        return new DefaultBiConstraintCollector<Object, Object, TriResultContainer<SubResultContainer1_, SubResultContainer2_, SubResultContainer3_>, Result_>(() -> TriResultContainer.of(subCollector1.supplier(), subCollector2.supplier(), subCollector3.supplier()), (resultContainer, a, b) -> {
            Runnable undo1 = (Runnable)subResult1Accumulator.apply(resultContainer.resultContainer1, a, b);
            Runnable undo2 = (Runnable)subResult2Accumulator.apply(resultContainer.resultContainer2, a, b);
            Runnable undo3 = (Runnable)subResult3Accumulator.apply(resultContainer.resultContainer3, a, b);
            return ConstraintCollectors.compose(undo1, undo2, undo3);
        }, ConstraintCollectors.createComposedFinisher(subCollector1.finisher(), subCollector2.finisher(), subCollector3.finisher(), composeFunction));
    }

    public static <A, B, Result_, SubResultContainer1_, SubResultContainer2_, SubResultContainer3_, SubResultContainer4_, SubResult1_, SubResult2_, SubResult3_, SubResult4_> BiConstraintCollector<A, B, ?, Result_> compose(BiConstraintCollector<A, B, SubResultContainer1_, SubResult1_> subCollector1, BiConstraintCollector<A, B, SubResultContainer2_, SubResult2_> subCollector2, BiConstraintCollector<A, B, SubResultContainer3_, SubResult3_> subCollector3, BiConstraintCollector<A, B, SubResultContainer4_, SubResult4_> subCollector4, QuadFunction<SubResult1_, SubResult2_, SubResult3_, SubResult4_, Result_> composeFunction) {
        TriFunction subResult1Accumulator = subCollector1.accumulator();
        TriFunction subResult2Accumulator = subCollector2.accumulator();
        TriFunction subResult3Accumulator = subCollector3.accumulator();
        TriFunction subResult4Accumulator = subCollector4.accumulator();
        return new DefaultBiConstraintCollector<Object, Object, QuadResultContainer<SubResultContainer1_, SubResultContainer2_, SubResultContainer3_, SubResultContainer4_>, Result_>(() -> QuadResultContainer.of(subCollector1.supplier(), subCollector2.supplier(), subCollector3.supplier(), subCollector4.supplier()), (resultContainer, a, b) -> {
            Runnable undo1 = (Runnable)subResult1Accumulator.apply(resultContainer.resultContainer1, a, b);
            Runnable undo2 = (Runnable)subResult2Accumulator.apply(resultContainer.resultContainer2, a, b);
            Runnable undo3 = (Runnable)subResult3Accumulator.apply(resultContainer.resultContainer3, a, b);
            Runnable undo4 = (Runnable)subResult4Accumulator.apply(resultContainer.resultContainer4, a, b);
            return ConstraintCollectors.compose(undo1, undo2, undo3, undo4);
        }, ConstraintCollectors.createComposedFinisher(subCollector1.finisher(), subCollector2.finisher(), subCollector3.finisher(), subCollector4.finisher(), composeFunction));
    }

    public static <A, B, C, Result_, SubResultContainer1_, SubResultContainer2_, SubResult1_, SubResult2_> TriConstraintCollector<A, B, C, ?, Result_> compose(TriConstraintCollector<A, B, C, SubResultContainer1_, SubResult1_> subCollector1, TriConstraintCollector<A, B, C, SubResultContainer2_, SubResult2_> subCollector2, BiFunction<SubResult1_, SubResult2_, Result_> composeFunction) {
        QuadFunction subResult1Accumulator = subCollector1.accumulator();
        QuadFunction subResult2Accumulator = subCollector2.accumulator();
        return new DefaultTriConstraintCollector<Object, Object, Object, BiResultContainer<SubResultContainer1_, SubResultContainer2_>, Result_>(() -> BiResultContainer.of(subCollector1.supplier(), subCollector2.supplier()), (resultContainer, a, b, c) -> {
            Runnable undo1 = (Runnable)subResult1Accumulator.apply(resultContainer.resultContainer1, a, b, c);
            Runnable undo2 = (Runnable)subResult2Accumulator.apply(resultContainer.resultContainer2, a, b, c);
            return ConstraintCollectors.compose(undo1, undo2);
        }, ConstraintCollectors.createComposedFinisher(subCollector1.finisher(), subCollector2.finisher(), composeFunction));
    }

    public static <A, B, C, Result_, SubResultContainer1_, SubResultContainer2_, SubResultContainer3_, SubResult1_, SubResult2_, SubResult3_> TriConstraintCollector<A, B, C, ?, Result_> compose(TriConstraintCollector<A, B, C, SubResultContainer1_, SubResult1_> subCollector1, TriConstraintCollector<A, B, C, SubResultContainer2_, SubResult2_> subCollector2, TriConstraintCollector<A, B, C, SubResultContainer3_, SubResult3_> subCollector3, TriFunction<SubResult1_, SubResult2_, SubResult3_, Result_> composeFunction) {
        QuadFunction subResult1Accumulator = subCollector1.accumulator();
        QuadFunction subResult2Accumulator = subCollector2.accumulator();
        QuadFunction subResult3Accumulator = subCollector3.accumulator();
        return new DefaultTriConstraintCollector<Object, Object, Object, TriResultContainer<SubResultContainer1_, SubResultContainer2_, SubResultContainer3_>, Result_>(() -> TriResultContainer.of(subCollector1.supplier(), subCollector2.supplier(), subCollector3.supplier()), (resultContainer, a, b, c) -> {
            Runnable undo1 = (Runnable)subResult1Accumulator.apply(resultContainer.resultContainer1, a, b, c);
            Runnable undo2 = (Runnable)subResult2Accumulator.apply(resultContainer.resultContainer2, a, b, c);
            Runnable undo3 = (Runnable)subResult3Accumulator.apply(resultContainer.resultContainer3, a, b, c);
            return ConstraintCollectors.compose(undo1, undo2, undo3);
        }, ConstraintCollectors.createComposedFinisher(subCollector1.finisher(), subCollector2.finisher(), subCollector3.finisher(), composeFunction));
    }

    public static <A, B, C, Result_, SubResultContainer1_, SubResultContainer2_, SubResultContainer3_, SubResultContainer4_, SubResult1_, SubResult2_, SubResult3_, SubResult4_> TriConstraintCollector<A, B, C, ?, Result_> compose(TriConstraintCollector<A, B, C, SubResultContainer1_, SubResult1_> subCollector1, TriConstraintCollector<A, B, C, SubResultContainer2_, SubResult2_> subCollector2, TriConstraintCollector<A, B, C, SubResultContainer3_, SubResult3_> subCollector3, TriConstraintCollector<A, B, C, SubResultContainer4_, SubResult4_> subCollector4, QuadFunction<SubResult1_, SubResult2_, SubResult3_, SubResult4_, Result_> composeFunction) {
        QuadFunction subResult1Accumulator = subCollector1.accumulator();
        QuadFunction subResult2Accumulator = subCollector2.accumulator();
        QuadFunction subResult3Accumulator = subCollector3.accumulator();
        QuadFunction subResult4Accumulator = subCollector4.accumulator();
        return new DefaultTriConstraintCollector<Object, Object, Object, QuadResultContainer<SubResultContainer1_, SubResultContainer2_, SubResultContainer3_, SubResultContainer4_>, Result_>(() -> QuadResultContainer.of(subCollector1.supplier(), subCollector2.supplier(), subCollector3.supplier(), subCollector4.supplier()), (resultContainer, a, b, c) -> {
            Runnable undo1 = (Runnable)subResult1Accumulator.apply(resultContainer.resultContainer1, a, b, c);
            Runnable undo2 = (Runnable)subResult2Accumulator.apply(resultContainer.resultContainer2, a, b, c);
            Runnable undo3 = (Runnable)subResult3Accumulator.apply(resultContainer.resultContainer3, a, b, c);
            Runnable undo4 = (Runnable)subResult4Accumulator.apply(resultContainer.resultContainer4, a, b, c);
            return ConstraintCollectors.compose(undo1, undo2, undo3, undo4);
        }, ConstraintCollectors.createComposedFinisher(subCollector1.finisher(), subCollector2.finisher(), subCollector3.finisher(), subCollector4.finisher(), composeFunction));
    }

    public static <A, B, C, D, Result_, SubResultContainer1_, SubResultContainer2_, SubResult1_, SubResult2_> QuadConstraintCollector<A, B, C, D, ?, Result_> compose(QuadConstraintCollector<A, B, C, D, SubResultContainer1_, SubResult1_> subCollector1, QuadConstraintCollector<A, B, C, D, SubResultContainer2_, SubResult2_> subCollector2, BiFunction<SubResult1_, SubResult2_, Result_> composeFunction) {
        PentaFunction subResult1Accumulator = subCollector1.accumulator();
        PentaFunction subResult2Accumulator = subCollector2.accumulator();
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, BiResultContainer<SubResultContainer1_, SubResultContainer2_>, Result_>(() -> BiResultContainer.of(subCollector1.supplier(), subCollector2.supplier()), (resultContainer, a, b, c, d) -> {
            Runnable undo1 = (Runnable)subResult1Accumulator.apply(resultContainer.resultContainer1, a, b, c, d);
            Runnable undo2 = (Runnable)subResult2Accumulator.apply(resultContainer.resultContainer2, a, b, c, d);
            return ConstraintCollectors.compose(undo1, undo2);
        }, ConstraintCollectors.createComposedFinisher(subCollector1.finisher(), subCollector2.finisher(), composeFunction));
    }

    public static <A, B, C, D, Result_, SubResultContainer1_, SubResultContainer2_, SubResultContainer3_, SubResult1_, SubResult2_, SubResult3_> QuadConstraintCollector<A, B, C, D, ?, Result_> compose(QuadConstraintCollector<A, B, C, D, SubResultContainer1_, SubResult1_> subCollector1, QuadConstraintCollector<A, B, C, D, SubResultContainer2_, SubResult2_> subCollector2, QuadConstraintCollector<A, B, C, D, SubResultContainer3_, SubResult3_> subCollector3, TriFunction<SubResult1_, SubResult2_, SubResult3_, Result_> composeFunction) {
        PentaFunction subResult1Accumulator = subCollector1.accumulator();
        PentaFunction subResult2Accumulator = subCollector2.accumulator();
        PentaFunction subResult3Accumulator = subCollector3.accumulator();
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, TriResultContainer<SubResultContainer1_, SubResultContainer2_, SubResultContainer3_>, Result_>(() -> TriResultContainer.of(subCollector1.supplier(), subCollector2.supplier(), subCollector3.supplier()), (resultContainer, a, b, c, d) -> {
            Runnable undo1 = (Runnable)subResult1Accumulator.apply(resultContainer.resultContainer1, a, b, c, d);
            Runnable undo2 = (Runnable)subResult2Accumulator.apply(resultContainer.resultContainer2, a, b, c, d);
            Runnable undo3 = (Runnable)subResult3Accumulator.apply(resultContainer.resultContainer3, a, b, c, d);
            return ConstraintCollectors.compose(undo1, undo2, undo3);
        }, ConstraintCollectors.createComposedFinisher(subCollector1.finisher(), subCollector2.finisher(), subCollector3.finisher(), composeFunction));
    }

    public static <A, B, C, D, Result_, SubResultContainer1_, SubResultContainer2_, SubResultContainer3_, SubResultContainer4_, SubResult1_, SubResult2_, SubResult3_, SubResult4_> QuadConstraintCollector<A, B, C, D, ?, Result_> compose(QuadConstraintCollector<A, B, C, D, SubResultContainer1_, SubResult1_> subCollector1, QuadConstraintCollector<A, B, C, D, SubResultContainer2_, SubResult2_> subCollector2, QuadConstraintCollector<A, B, C, D, SubResultContainer3_, SubResult3_> subCollector3, QuadConstraintCollector<A, B, C, D, SubResultContainer4_, SubResult4_> subCollector4, QuadFunction<SubResult1_, SubResult2_, SubResult3_, SubResult4_, Result_> composeFunction) {
        PentaFunction subResult1Accumulator = subCollector1.accumulator();
        PentaFunction subResult2Accumulator = subCollector2.accumulator();
        PentaFunction subResult3Accumulator = subCollector3.accumulator();
        PentaFunction subResult4Accumulator = subCollector4.accumulator();
        return new DefaultQuadConstraintCollector<Object, Object, Object, Object, QuadResultContainer<SubResultContainer1_, SubResultContainer2_, SubResultContainer3_, SubResultContainer4_>, Result_>(() -> QuadResultContainer.of(subCollector1.supplier(), subCollector2.supplier(), subCollector3.supplier(), subCollector4.supplier()), (resultContainer, a, b, c, d) -> {
            Runnable undo1 = (Runnable)subResult1Accumulator.apply(resultContainer.resultContainer1, a, b, c, d);
            Runnable undo2 = (Runnable)subResult2Accumulator.apply(resultContainer.resultContainer2, a, b, c, d);
            Runnable undo3 = (Runnable)subResult3Accumulator.apply(resultContainer.resultContainer3, a, b, c, d);
            Runnable undo4 = (Runnable)subResult4Accumulator.apply(resultContainer.resultContainer4, a, b, c, d);
            return ConstraintCollectors.compose(undo1, undo2, undo3, undo4);
        }, ConstraintCollectors.createComposedFinisher(subCollector1.finisher(), subCollector2.finisher(), subCollector3.finisher(), subCollector4.finisher(), composeFunction));
    }

    private ConstraintCollectors() {
    }

    private static final class QuadResultContainer<ResultContainer1, ResultContainer2, ResultContainer3, ResultContainer4>
    extends TriResultContainer<ResultContainer1, ResultContainer2, ResultContainer3> {
        final ResultContainer4 resultContainer4;

        public static <ResultContainer1_, ResultContainer2_, ResultContainer3_, ResultContainer4_> QuadResultContainer<ResultContainer1_, ResultContainer2_, ResultContainer3_, ResultContainer4_> of(Supplier<ResultContainer1_> resultContainer1Supplier, Supplier<ResultContainer2_> resultContainer2Supplier, Supplier<ResultContainer3_> resultContainer3Supplier, Supplier<ResultContainer4_> resultContainer4Supplier) {
            return new QuadResultContainer<ResultContainer1_, ResultContainer2_, ResultContainer3_, ResultContainer4_>(resultContainer1Supplier.get(), resultContainer2Supplier.get(), resultContainer3Supplier.get(), resultContainer4Supplier.get());
        }

        private QuadResultContainer(ResultContainer1 resultContainer1, ResultContainer2 resultContainer2, ResultContainer3 resultContainer3, ResultContainer4 resultContainer4) {
            super(resultContainer1, resultContainer2, resultContainer3);
            this.resultContainer4 = Objects.requireNonNull(resultContainer4);
        }
    }

    private static class TriResultContainer<ResultContainer1, ResultContainer2, ResultContainer3>
    extends BiResultContainer<ResultContainer1, ResultContainer2> {
        final ResultContainer3 resultContainer3;

        public static <ResultContainer1_, ResultContainer2_, ResultContainer3_> TriResultContainer<ResultContainer1_, ResultContainer2_, ResultContainer3_> of(Supplier<ResultContainer1_> resultContainer1Supplier, Supplier<ResultContainer2_> resultContainer2Supplier, Supplier<ResultContainer3_> resultContainer3Supplier) {
            return new TriResultContainer<ResultContainer1_, ResultContainer2_, ResultContainer3_>(resultContainer1Supplier.get(), resultContainer2Supplier.get(), resultContainer3Supplier.get());
        }

        private TriResultContainer(ResultContainer1 resultContainer1, ResultContainer2 resultContainer2, ResultContainer3 resultContainer3) {
            super(resultContainer1, resultContainer2);
            this.resultContainer3 = Objects.requireNonNull(resultContainer3);
        }
    }

    private static class BiResultContainer<ResultContainer1, ResultContainer2> {
        final ResultContainer1 resultContainer1;
        final ResultContainer2 resultContainer2;

        public static <ResultContainer1_, ResultContainer2_> BiResultContainer<ResultContainer1_, ResultContainer2_> of(Supplier<ResultContainer1_> resultContainer1Supplier, Supplier<ResultContainer2_> resultContainer2Supplier) {
            return new BiResultContainer<ResultContainer1_, ResultContainer2_>(resultContainer1Supplier.get(), resultContainer2Supplier.get());
        }

        public BiResultContainer(ResultContainer1 resultContainer1, ResultContainer2 resultContainer2) {
            this.resultContainer1 = Objects.requireNonNull(resultContainer1);
            this.resultContainer2 = Objects.requireNonNull(resultContainer2);
        }
    }

    private static final class ToMultiMapResultContainer<Key, Value, Set_ extends Set<Value>, Result_ extends Map<Key, Set_>>
    implements ToMapResultContainer<Key, Value, Set_, Result_> {
        private final Supplier<Set_> setSupplier;
        private final Result_ result;
        private final Map<Key, ToMapPerKeyCounter<Value>> valueCounts = new HashMap<Key, ToMapPerKeyCounter<Value>>(0);

        public ToMultiMapResultContainer(Supplier<Result_> resultSupplier, IntFunction<Set_> setFunction) {
            IntFunction nonNullSetFunction = Objects.requireNonNull(setFunction);
            this.setSupplier = () -> (Set)nonNullSetFunction.apply(0);
            this.result = (Map)Objects.requireNonNull(resultSupplier).get();
        }

        public ToMultiMapResultContainer(IntFunction<Result_> resultFunction, IntFunction<Set_> setFunction) {
            IntFunction nonNullSetFunction = Objects.requireNonNull(setFunction);
            this.setSupplier = () -> (Set)nonNullSetFunction.apply(0);
            this.result = (Map)Objects.requireNonNull(resultFunction).apply(0);
        }

        @Override
        public void add(Key key, Value value) {
            ToMapPerKeyCounter counter = this.valueCounts.computeIfAbsent(key, k -> new ToMapPerKeyCounter());
            counter.add(value);
            this.result.computeIfAbsent(key, k -> (Set)this.setSupplier.get()).add(value);
        }

        @Override
        public void remove(Key key, Value value) {
            ToMapPerKeyCounter<Value> counter = this.valueCounts.get(key);
            long newCount = counter.remove(value);
            if (newCount == 0L) {
                ((Set)this.result.get(key)).remove(value);
            }
            if (counter.isEmpty()) {
                this.valueCounts.remove(key);
                this.result.remove(key);
            }
        }

        @Override
        public Result_ getResult() {
            return this.result;
        }
    }

    private static final class ToSimpleMapResultContainer<Key, Value, Result_ extends Map<Key, Value>>
    implements ToMapResultContainer<Key, Value, Value, Result_> {
        private final BinaryOperator<Value> mergeFunction;
        private final Result_ result;
        private final Map<Key, ToMapPerKeyCounter<Value>> valueCounts = new HashMap<Key, ToMapPerKeyCounter<Value>>(0);

        public ToSimpleMapResultContainer(Supplier<Result_> resultSupplier, BinaryOperator<Value> mergeFunction) {
            this.mergeFunction = Objects.requireNonNull(mergeFunction);
            this.result = (Map)Objects.requireNonNull(resultSupplier).get();
        }

        public ToSimpleMapResultContainer(IntFunction<Result_> resultSupplier, BinaryOperator<Value> mergeFunction) {
            this.mergeFunction = Objects.requireNonNull(mergeFunction);
            this.result = (Map)Objects.requireNonNull(resultSupplier).apply(0);
        }

        @Override
        public void add(Key key, Value value) {
            ToMapPerKeyCounter counter = this.valueCounts.computeIfAbsent(key, k -> new ToMapPerKeyCounter());
            long newCount = counter.add(value);
            if (newCount == 1L) {
                this.result.put(key, value);
            } else {
                this.result.put(key, counter.merge(this.mergeFunction));
            }
        }

        @Override
        public void remove(Key key, Value value) {
            ToMapPerKeyCounter<Value> counter = this.valueCounts.get(key);
            long newCount = counter.remove(value);
            if (newCount == 0L) {
                this.result.remove(key);
            } else {
                this.result.put(key, counter.merge(this.mergeFunction));
            }
            if (counter.isEmpty()) {
                this.valueCounts.remove(key);
            }
        }

        @Override
        public Result_ getResult() {
            return this.result;
        }
    }

    private static interface ToMapResultContainer<Key, Value, ResultValue, Result_ extends Map<Key, ResultValue>> {
        public void add(Key var1, Value var2);

        public void remove(Key var1, Value var2);

        public Result_ getResult();
    }

    private static final class ToMapPerKeyCounter<Value> {
        private final Map<Value, Long> counts = new LinkedHashMap<Value, Long>(0);

        private ToMapPerKeyCounter() {
        }

        public long add(Value value) {
            return this.counts.compute(value, (k, currentCount) -> {
                if (currentCount == null) {
                    return 1L;
                }
                return currentCount + 1L;
            });
        }

        public long remove(Value value) {
            Long newCount = this.counts.compute(value, (k, currentCount) -> {
                if (currentCount > 1L) {
                    return currentCount - 1L;
                }
                return null;
            });
            return newCount == null ? 0L : newCount;
        }

        public Value merge(BinaryOperator<Value> mergeFunction) {
            return (Value)this.counts.keySet().stream().reduce(mergeFunction).orElseThrow(() -> new IllegalStateException("Programming error: Should have had at least one value."));
        }

        public boolean isEmpty() {
            return this.counts.isEmpty();
        }
    }

    private static class CountDistinctLongResultContainer {
        long count = 0L;
        Map<Object, long[]> objectCountMap = new HashMap<Object, long[]>();

        private CountDistinctLongResultContainer() {
        }
    }

    private static class CountDistinctResultContainer {
        int count = 0;
        Map<Object, int[]> objectCountMap = new HashMap<Object, int[]>();

        private CountDistinctResultContainer() {
        }
    }
}

