/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bi;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.optaplanner.core.impl.score.stream.bi.AbstractBiJoiner;
import org.optaplanner.core.impl.score.stream.bi.SingleBiJoiner;
import org.optaplanner.core.impl.score.stream.common.JoinerType;

public final class CompositeBiJoiner<A, B>
extends AbstractBiJoiner<A, B> {
    private final List<SingleBiJoiner<A, B>> joinerList;
    private final JoinerType[] joinerTypes;
    private final Function<A, ?>[] leftMappings;
    private final Function<B, ?>[] rightMappings;

    CompositeBiJoiner(List<SingleBiJoiner<A, B>> joinerList) {
        if (joinerList.isEmpty()) {
            throw new IllegalArgumentException("The joinerList (" + joinerList + ") must not be empty.");
        }
        this.joinerList = joinerList;
        this.joinerTypes = (JoinerType[])joinerList.stream().map(SingleBiJoiner::getJoinerType).toArray(JoinerType[]::new);
        this.leftMappings = (Function[])joinerList.stream().map(SingleBiJoiner::getLeftMapping).toArray(Function[]::new);
        this.rightMappings = (Function[])joinerList.stream().map(SingleBiJoiner::getRightMapping).toArray(Function[]::new);
    }

    public List<SingleBiJoiner<A, B>> getJoinerList() {
        return this.joinerList;
    }

    @Override
    public Function<A, Object> getLeftMapping(int index) {
        return this.leftMappings[index];
    }

    @Override
    public Function<A, Object[]> getLeftCombinedMapping() {
        return a -> Arrays.stream(this.leftMappings).map(f -> f.apply(a)).toArray();
    }

    @Override
    public JoinerType[] getJoinerTypes() {
        return this.joinerTypes;
    }

    @Override
    public Function<B, Object> getRightMapping(int index) {
        return this.rightMappings[index];
    }

    @Override
    public Function<B, Object[]> getRightCombinedMapping() {
        return b -> Arrays.stream(this.rightMappings).map(f -> f.apply(b)).toArray();
    }
}

