/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.stream;

import java.util.Arrays;
import org.optaplanner.core.api.score.stream.bi.BiConstraintStream;
import org.optaplanner.core.api.score.stream.bi.BiJoiner;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;
import org.optaplanner.core.impl.score.stream.bi.AbstractBiJoiner;
import org.optaplanner.core.impl.score.stream.bi.FilteringBiJoiner;
import org.optaplanner.core.impl.score.stream.bi.NoneBiJoiner;

public interface ConstraintFactory {
    public String getDefaultConstraintPackage();

    public <A> UniConstraintStream<A> forEach(Class<A> var1);

    public <A> UniConstraintStream<A> forEachIncludingNullVars(Class<A> var1);

    default public <A> BiConstraintStream<A, A> forEachUniquePair(Class<A> sourceClass) {
        return this.forEachUniquePair(sourceClass, (BiJoiner<A, A>)new NoneBiJoiner());
    }

    public <A> BiConstraintStream<A, A> forEachUniquePair(Class<A> var1, BiJoiner<A, A> var2);

    default public <A> BiConstraintStream<A, A> forEachUniquePair(Class<A> sourceClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2) {
        return this.forEachUniquePair(sourceClass, new BiJoiner[]{joiner1, joiner2});
    }

    default public <A> BiConstraintStream<A, A> forEachUniquePair(Class<A> sourceClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2, BiJoiner<A, A> joiner3) {
        return this.forEachUniquePair(sourceClass, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    default public <A> BiConstraintStream<A, A> forEachUniquePair(Class<A> sourceClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2, BiJoiner<A, A> joiner3, BiJoiner<A, A> joiner4) {
        return this.forEachUniquePair(sourceClass, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    default public <A> BiConstraintStream<A, A> forEachUniquePair(Class<A> sourceClass, BiJoiner<A, A> ... joiners) {
        int indexOfFirstFilter = ConstraintFactory.findIndexOfFirstFilteringJoiner(joiners);
        if (indexOfFirstFilter < 0) {
            return this.forEachUniquePair(sourceClass, (BiJoiner<A, A>)AbstractBiJoiner.merge(joiners));
        }
        AbstractBiJoiner<A, A> mergedJoiner = AbstractBiJoiner.merge(Arrays.copyOf(joiners, indexOfFirstFilter));
        BiConstraintStream resultingStream = this.forEachUniquePair(sourceClass, (BiJoiner<A, A>)mergedJoiner);
        for (int filterIndex = indexOfFirstFilter; filterIndex < joiners.length; ++filterIndex) {
            FilteringBiJoiner filteringJoiner = (FilteringBiJoiner)joiners[filterIndex];
            resultingStream = resultingStream.filter(filteringJoiner.getFilter());
        }
        return resultingStream;
    }

    private static <A> int findIndexOfFirstFilteringJoiner(BiJoiner<A, A>[] joiners) {
        int indexOfFirstFilter = -1;
        for (int index = 0; index < joiners.length; ++index) {
            boolean seenFilterAlready = indexOfFirstFilter >= 0;
            BiJoiner<A, A> joiner = joiners[index];
            boolean isFilter = joiner instanceof FilteringBiJoiner;
            if (!seenFilterAlready && isFilter) {
                indexOfFirstFilter = index;
                continue;
            }
            if (!seenFilterAlready || isFilter) continue;
            throw new IllegalStateException("Indexing joiner (" + joiner + ") must not follow a filtering joiner (" + joiners[indexOfFirstFilter] + ").\nMaybe reorder the joiners such that filtering() joiners are later in the parameter list.");
        }
        return indexOfFirstFilter;
    }

    @Deprecated(forRemoval=true)
    public <A> UniConstraintStream<A> from(Class<A> var1);

    @Deprecated(forRemoval=true)
    public <A> UniConstraintStream<A> fromUnfiltered(Class<A> var1);

    @Deprecated(forRemoval=true)
    default public <A> BiConstraintStream<A, A> fromUniquePair(Class<A> fromClass) {
        return this.fromUniquePair(fromClass, (BiJoiner<A, A>)new NoneBiJoiner());
    }

    @Deprecated(forRemoval=true)
    public <A> BiConstraintStream<A, A> fromUniquePair(Class<A> var1, BiJoiner<A, A> var2);

    @Deprecated(forRemoval=true)
    default public <A> BiConstraintStream<A, A> fromUniquePair(Class<A> fromClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2) {
        return this.fromUniquePair(fromClass, new BiJoiner[]{joiner1, joiner2});
    }

    @Deprecated(forRemoval=true)
    default public <A> BiConstraintStream<A, A> fromUniquePair(Class<A> fromClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2, BiJoiner<A, A> joiner3) {
        return this.fromUniquePair(fromClass, new BiJoiner[]{joiner1, joiner2, joiner3});
    }

    @Deprecated(forRemoval=true)
    default public <A> BiConstraintStream<A, A> fromUniquePair(Class<A> fromClass, BiJoiner<A, A> joiner1, BiJoiner<A, A> joiner2, BiJoiner<A, A> joiner3, BiJoiner<A, A> joiner4) {
        return this.fromUniquePair(fromClass, new BiJoiner[]{joiner1, joiner2, joiner3, joiner4});
    }

    @Deprecated(forRemoval=true)
    default public <A> BiConstraintStream<A, A> fromUniquePair(Class<A> fromClass, BiJoiner<A, A> ... joiners) {
        int indexOfFirstFilter = ConstraintFactory.findIndexOfFirstFilteringJoiner(joiners);
        if (indexOfFirstFilter < 0) {
            return this.fromUniquePair(fromClass, (BiJoiner<A, A>)AbstractBiJoiner.merge(joiners));
        }
        AbstractBiJoiner<A, A> mergedJoiner = AbstractBiJoiner.merge(Arrays.copyOf(joiners, indexOfFirstFilter));
        BiConstraintStream resultingStream = this.fromUniquePair(fromClass, (BiJoiner<A, A>)mergedJoiner);
        for (int filterIndex = indexOfFirstFilter; filterIndex < joiners.length; ++filterIndex) {
            FilteringBiJoiner filteringJoiner = (FilteringBiJoiner)joiners[filterIndex];
            resultingStream = resultingStream.filter(filteringJoiner.getFilter());
        }
        return resultingStream;
    }
}

