/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.drools.ancompiler.KieBaseUpdaterANC;
import org.drools.core.io.impl.ClassPathResource;
import org.drools.core.io.impl.FileSystemResource;
import org.drools.modelcompiler.ExecutableModelProject;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.conf.KieBaseMutabilityOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.Resource;
import org.kie.internal.builder.conf.KnowledgeBuilderOption;
import org.kie.internal.builder.conf.PropertySpecificOption;
import org.kie.internal.utils.KieHelper;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.director.AbstractScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.ScoreDirectorFactoryService;
import org.optaplanner.core.impl.score.director.ScoreDirectorType;
import org.optaplanner.core.impl.score.director.drl.DrlScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.drl.testgen.TestGenDrlScoreDirectorFactory;

public final class DrlScoreDirectorFactoryService<Solution_, Score_ extends Score<Score_>>
implements ScoreDirectorFactoryService<Solution_, Score_> {
    private static final String GENERATE_DROOLS_TEST_ON_ERROR_PROPERTY_NAME = "optaplanner.drools.generateTestOnError";

    @Override
    public ScoreDirectorType getSupportedScoreDirectorType() {
        return ScoreDirectorType.DRL;
    }

    @Override
    public Supplier<AbstractScoreDirectorFactory<Solution_, Score_>> buildScoreDirectorFactory(ClassLoader classLoader, SolutionDescriptor<Solution_> solutionDescriptor, ScoreDirectorFactoryConfig config) {
        boolean generateDroolsTestOnError = Boolean.parseBoolean(System.getProperty(GENERATE_DROOLS_TEST_ON_ERROR_PROPERTY_NAME, "false"));
        if (ConfigUtils.isEmptyCollection(config.getScoreDrlList()) && ConfigUtils.isEmptyCollection(config.getScoreDrlFileList())) {
            if (config.getKieBaseConfigurationProperties() != null) {
                throw new IllegalArgumentException("If kieBaseConfigurationProperties (" + config.getKieBaseConfigurationProperties() + ") is not null, the scoreDrlList (" + config.getScoreDrlList() + ") or the scoreDrlFileList (" + config.getScoreDrlFileList() + ") must not be empty.");
            }
            if (generateDroolsTestOnError) {
                throw new IllegalArgumentException("If optaplanner.drools.generateTestOnError system property (" + generateDroolsTestOnError + ") is set, the scoreDrlList (" + config.getScoreDrlList() + ") or the scoreDrlFileList (" + config.getScoreDrlFileList() + ") must not be empty.");
            }
            return null;
        }
        ArrayList<String> scoreDrlList = new ArrayList<String>();
        if (config.getGizmoKieBaseSupplier() == null && !ConfigUtils.isEmptyCollection(config.getScoreDrlList())) {
            for (String scoreDrl : config.getScoreDrlList()) {
                if (scoreDrl == null) {
                    throw new IllegalArgumentException("The scoreDrl (" + scoreDrl + ") cannot be null.");
                }
                scoreDrlList.add(scoreDrl);
            }
        }
        return () -> this.buildScoreDirectorFactory(classLoader, solutionDescriptor, config, scoreDrlList, generateDroolsTestOnError);
    }

    private DrlScoreDirectorFactory<Solution_, Score_> buildScoreDirectorFactory(ClassLoader classLoader, SolutionDescriptor<Solution_> solutionDescriptor, ScoreDirectorFactoryConfig config, List<String> scoreDrlList, boolean generateDroolsTestOnError) {
        KieBase kieBase;
        if (config.getGizmoKieBaseSupplier() != null) {
            kieBase = config.getGizmoKieBaseSupplier().get();
        } else {
            KieHelper kieHelper = new KieHelper(new KnowledgeBuilderOption[]{PropertySpecificOption.ALLOWED}).setClassLoader(classLoader);
            scoreDrlList.forEach(scoreDrl -> kieHelper.addResource((Resource)new ClassPathResource(scoreDrl, classLoader)));
            if (!ConfigUtils.isEmptyCollection(config.getScoreDrlFileList())) {
                for (File scoreDrlFile : config.getScoreDrlFileList()) {
                    kieHelper.addResource((Resource)new FileSystemResource(scoreDrlFile));
                }
            }
            KieBaseConfiguration kieBaseConfiguration = this.buildKieBaseConfiguration(config, KieServices.get());
            kieBaseConfiguration.setOption((KieBaseOption)KieBaseMutabilityOption.DISABLED);
            try {
                kieBase = kieHelper.build(ExecutableModelProject.class, kieBaseConfiguration);
            }
            catch (Exception ex) {
                throw new IllegalStateException("There is an error in a scoreDrl or scoreDrlFile.", ex);
            }
        }
        if (config.isDroolsAlphaNetworkCompilationEnabled()) {
            KieBaseUpdaterANC.generateAndSetInMemoryANC((KieBase)kieBase);
        }
        if (generateDroolsTestOnError) {
            return new TestGenDrlScoreDirectorFactory(solutionDescriptor, kieBase, config.getScoreDrlList(), config.getScoreDrlFileList());
        }
        return new DrlScoreDirectorFactory(solutionDescriptor, kieBase);
    }

    private KieBaseConfiguration buildKieBaseConfiguration(ScoreDirectorFactoryConfig config, KieServices kieServices) {
        KieBaseConfiguration kieBaseConfiguration = kieServices.newKieBaseConfiguration();
        if (config.getKieBaseConfigurationProperties() != null) {
            for (Map.Entry<String, String> entry : config.getKieBaseConfigurationProperties().entrySet()) {
                kieBaseConfiguration.setProperty(entry.getKey(), entry.getValue());
            }
        }
        return kieBaseConfiguration;
    }
}

