/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.common;

import java.math.BigDecimal;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.impl.score.stream.InnerConstraintFactory;
import org.optaplanner.core.impl.score.stream.common.ScoreImpactType;

public abstract class AbstractConstraint<Solution_, Constraint_ extends AbstractConstraint<Solution_, Constraint_, ConstraintFactory_>, ConstraintFactory_ extends InnerConstraintFactory<Solution_, Constraint_>>
implements Constraint {
    private final ConstraintFactory_ constraintFactory;
    private final String constraintPackage;
    private final String constraintName;
    private final String constraintId;
    private final Function<Solution_, Score<?>> constraintWeightExtractor;
    private final ScoreImpactType scoreImpactType;
    private final boolean isConstraintWeightConfigurable;

    protected AbstractConstraint(ConstraintFactory_ constraintFactory, String constraintPackage, String constraintName, Function<Solution_, Score<?>> constraintWeightExtractor, ScoreImpactType scoreImpactType, boolean isConstraintWeightConfigurable) {
        this.constraintFactory = constraintFactory;
        this.constraintPackage = constraintPackage;
        this.constraintName = constraintName;
        this.constraintId = ConstraintMatchTotal.composeConstraintId(constraintPackage, constraintName);
        this.constraintWeightExtractor = constraintWeightExtractor;
        this.scoreImpactType = scoreImpactType;
        this.isConstraintWeightConfigurable = isConstraintWeightConfigurable;
    }

    public final <Score_ extends Score<Score_>> Score_ extractConstraintWeight(Solution_ workingSolution) {
        if (this.isConstraintWeightConfigurable && workingSolution == null) {
            return ((InnerConstraintFactory)this.constraintFactory).getSolutionDescriptor().getScoreDefinition().getOneSoftestScore();
        }
        Score<?> constraintWeight = this.constraintWeightExtractor.apply(workingSolution);
        ((InnerConstraintFactory)this.constraintFactory).getSolutionDescriptor().validateConstraintWeight(this.constraintPackage, this.constraintName, constraintWeight);
        switch (this.scoreImpactType) {
            case PENALTY: {
                return (Score_)constraintWeight.negate();
            }
            case REWARD: 
            case MIXED: {
                return (Score_)constraintWeight;
            }
        }
        throw new IllegalStateException("Unknown score impact type: (" + this.scoreImpactType + ")");
    }

    public final void assertCorrectImpact(int impact) {
        this.assertCorrectImpact(impact, () -> impact < 0);
    }

    public final void assertCorrectImpact(long impact) {
        this.assertCorrectImpact(impact, () -> impact < 0L);
    }

    public final void assertCorrectImpact(BigDecimal impact) {
        this.assertCorrectImpact(impact, () -> impact.signum() < 0);
    }

    private void assertCorrectImpact(Object impact, BooleanSupplier lessThanZero) {
        switch (this.scoreImpactType) {
            case MIXED: {
                break;
            }
            case PENALTY: 
            case REWARD: {
                if (lessThanZero.getAsBoolean()) {
                    throw new IllegalStateException("Negative match weight (" + impact + ") for constraint (" + this.getConstraintId() + "). Check constraint provider implementation.");
                }
                return;
            }
            default: {
                throw new IllegalStateException("Unknown score impact type: (" + this.scoreImpactType + ")");
            }
        }
    }

    public final ConstraintFactory_ getConstraintFactory() {
        return this.constraintFactory;
    }

    @Override
    public final String getConstraintPackage() {
        return this.constraintPackage;
    }

    @Override
    public final String getConstraintName() {
        return this.constraintName;
    }

    @Override
    public final String getConstraintId() {
        return this.constraintId;
    }

    public final ScoreImpactType getScoreImpactType() {
        return this.scoreImpactType;
    }
}

