/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.api.solver.SolverJob;
import org.optaplanner.core.api.solver.SolverManager;
import org.optaplanner.core.api.solver.SolverStatus;
import org.optaplanner.core.api.solver.change.ProblemChange;
import org.optaplanner.core.config.solver.SolverManagerConfig;
import org.optaplanner.core.impl.solver.DefaultSolver;
import org.optaplanner.core.impl.solver.DefaultSolverJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultSolverManager<Solution_, ProblemId_>
implements SolverManager<Solution_, ProblemId_> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSolverManager.class);
    private final BiConsumer<ProblemId_, Throwable> defaultExceptionHandler = (problemId, throwable) -> LOGGER.error("Solving failed for problemId ({}).", problemId, throwable);
    private final SolverFactory<Solution_> solverFactory;
    private final ExecutorService solverThreadPool;
    private final ConcurrentMap<Object, DefaultSolverJob<Solution_, ProblemId_>> problemIdToSolverJobMap;

    public DefaultSolverManager(SolverFactory<Solution_> solverFactory, SolverManagerConfig solverManagerConfig) {
        this.solverFactory = solverFactory;
        this.validateSolverFactory();
        int parallelSolverCount = solverManagerConfig.resolveParallelSolverCount();
        this.solverThreadPool = Executors.newFixedThreadPool(parallelSolverCount);
        this.problemIdToSolverJobMap = new ConcurrentHashMap<Object, DefaultSolverJob<Solution_, ProblemId_>>(parallelSolverCount * 10);
    }

    public SolverFactory<Solution_> getSolverFactory() {
        return this.solverFactory;
    }

    private void validateSolverFactory() {
        this.solverFactory.buildSolver();
    }

    private ProblemId_ getProblemIdOrThrow(ProblemId_ problemId) {
        if (problemId != null) {
            return problemId;
        }
        throw new NullPointerException("Invalid problemId (null) given to SolverManager.");
    }

    private DefaultSolverJob<Solution_, ProblemId_> getSolverJob(ProblemId_ problemId) {
        return (DefaultSolverJob)this.problemIdToSolverJobMap.get(this.getProblemIdOrThrow(problemId));
    }

    @Override
    public SolverJob<Solution_, ProblemId_> solve(ProblemId_ problemId, Function<? super ProblemId_, ? extends Solution_> problemFinder, Consumer<? super Solution_> finalBestSolutionConsumer, BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler) {
        return this.solve(this.getProblemIdOrThrow(problemId), problemFinder, null, finalBestSolutionConsumer, exceptionHandler);
    }

    @Override
    public SolverJob<Solution_, ProblemId_> solveAndListen(ProblemId_ problemId, Function<? super ProblemId_, ? extends Solution_> problemFinder, Consumer<? super Solution_> bestSolutionConsumer, Consumer<? super Solution_> finalBestSolutionConsumer, BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler) {
        return this.solve(this.getProblemIdOrThrow(problemId), problemFinder, bestSolutionConsumer, finalBestSolutionConsumer, exceptionHandler);
    }

    protected SolverJob<Solution_, ProblemId_> solve(ProblemId_ problemId, Function<? super ProblemId_, ? extends Solution_> problemFinder, Consumer<? super Solution_> bestSolutionConsumer, Consumer<? super Solution_> finalBestSolutionConsumer, BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler) {
        Solver<Solution_> solver = this.solverFactory.buildSolver();
        ((DefaultSolver)solver).setMonitorTagMap(Map.of("problem.id", problemId.toString()));
        BiConsumer<Object, Throwable> finalExceptionHandler = exceptionHandler != null ? exceptionHandler : this.defaultExceptionHandler;
        DefaultSolverJob solverJob = this.problemIdToSolverJobMap.compute(problemId, (key, oldSolverJob) -> {
            if (oldSolverJob != null) {
                throw new IllegalStateException("The problemId (" + problemId + ") is already solving.");
            }
            return new DefaultSolverJob(this, solver, problemId, problemFinder, bestSolutionConsumer, finalBestSolutionConsumer, finalExceptionHandler);
        });
        Future future = this.solverThreadPool.submit(solverJob);
        solverJob.setFinalBestSolutionFuture(future);
        return solverJob;
    }

    @Override
    public SolverStatus getSolverStatus(ProblemId_ problemId) {
        DefaultSolverJob<Solution_, ProblemId_> solverJob = this.getSolverJob(problemId);
        if (solverJob == null) {
            return SolverStatus.NOT_SOLVING;
        }
        return solverJob.getSolverStatus();
    }

    @Override
    public void addProblemChange(ProblemId_ problemId, ProblemChange<Solution_> problemChange) {
        DefaultSolverJob<Solution_, ProblemId_> solverJob = this.getSolverJob(problemId);
        if (solverJob == null) {
            throw new IllegalStateException("Cannot add the problem change (" + problemChange + ") because there is no solver solving the problemId (" + problemId + ").");
        }
        solverJob.addProblemChange(problemChange);
    }

    @Override
    public void terminateEarly(ProblemId_ problemId) {
        DefaultSolverJob<Solution_, ProblemId_> solverJob = this.getSolverJob(problemId);
        if (solverJob == null) {
            LOGGER.debug("Ignoring terminateEarly() call because problemId ({}) is not solving.", problemId);
            return;
        }
        solverJob.terminateEarly();
    }

    @Override
    public void close() {
        this.solverThreadPool.shutdownNow();
        this.problemIdToSolverJobMap.values().forEach(solverJob -> solverJob.close());
    }

    protected void unregisterSolverJob(ProblemId_ problemId) {
        this.problemIdToSolverJobMap.remove(this.getProblemIdOrThrow(problemId));
    }
}

