/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.analyzer.exception.LambdaExceptionWrapper;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.owasp.dependencycheck.dependency.naming.CpeIdentifier;

@ThreadSafe
public class NvdCveAnalyzer
extends AbstractAnalyzer {
    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        CveDB cveDB = engine.getDatabase();
        try {
            dependency.getVulnerableSoftwareIdentifiers().stream().filter(i -> i instanceof CpeIdentifier).map(i -> (CpeIdentifier)i).forEach(i -> {
                try {
                    List<Vulnerability> vulns = this.filterEcosystem(dependency.getEcosystem(), cveDB.getVulnerabilities(i.getCpe()));
                    if ("nodejs".equals(dependency.getEcosystem())) {
                        this.replaceOrAddVulnerability(dependency, vulns);
                    } else {
                        dependency.addVulnerabilities(vulns);
                    }
                }
                catch (DatabaseException ex) {
                    throw new LambdaExceptionWrapper(new AnalysisException(ex));
                }
            });
            dependency.getSuppressedIdentifiers().stream().filter(i -> i instanceof CpeIdentifier).map(i -> (CpeIdentifier)i).forEach(i -> {
                try {
                    List<Vulnerability> vulns = cveDB.getVulnerabilities(i.getCpe());
                    dependency.addSuppressedVulnerabilities(vulns);
                }
                catch (DatabaseException ex) {
                    throw new LambdaExceptionWrapper(new AnalysisException(ex));
                }
            });
        }
        catch (LambdaExceptionWrapper ex) {
            throw (AnalysisException)ex.getCause();
        }
    }

    @Override
    public String getName() {
        return "NVD CVE Analyzer";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.FINDING_ANALYSIS;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.nvdcve.enabled";
    }

    private void replaceOrAddVulnerability(Dependency dependency, List<Vulnerability> vulns) {
        vulns.forEach(v -> v.getReferences().forEach(ref -> dependency.getVulnerabilities().forEach(existing -> {
            if (existing.getSource() == Vulnerability.Source.NPM && ref.getName() != null && ref.getName().equals("https://nodesecurity.io/advisories/" + existing.getName())) {
                dependency.removeVulnerability((Vulnerability)existing);
            }
        })));
        dependency.addVulnerabilities(vulns);
    }

    private synchronized List<Vulnerability> filterEcosystem(String ecosystem, List<Vulnerability> vulnerabilities) {
        ArrayList remove = new ArrayList();
        vulnerabilities.forEach(v -> {
            boolean found = false;
            ArrayList<VulnerableSoftware> removeSoftare = new ArrayList<VulnerableSoftware>();
            for (VulnerableSoftware s : v.getVulnerableSoftware()) {
                if (this.ecosystemMatchesTargetSoftware(ecosystem, s.getTargetSw())) {
                    found = true;
                    continue;
                }
                removeSoftare.add(s);
            }
            if (found) {
                if (!removeSoftare.isEmpty()) {
                    removeSoftare.forEach(v.getVulnerableSoftware()::remove);
                }
            } else {
                remove.add(v);
            }
        });
        if (!remove.isEmpty()) {
            vulnerabilities.removeAll(remove);
        }
        return vulnerabilities;
    }

    private boolean ecosystemMatchesTargetSoftware(String ecosystem, String targetSoftware) {
        if ("*".equals(targetSoftware) || "-".equals(targetSoftware)) {
            return true;
        }
        if ("nodejs".equals(ecosystem)) {
            switch (targetSoftware.toLowerCase()) {
                case "nodejs": 
                case "node.js": 
                case "node_js": 
                case "npm": 
                case "node-js": {
                    return true;
                }
            }
            return false;
        }
        return true;
    }
}

