/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.common.properties.query;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.picketlink.common.properties.query.PropertyCriteria;

public class TypedPropertyCriteria
implements PropertyCriteria {
    private final Class<?> propertyClass;
    private final boolean selectSubTypes;

    public TypedPropertyCriteria(Class<?> propertyClass) {
        this(propertyClass, false);
    }

    public TypedPropertyCriteria(Class<?> propertyClass, boolean selectSubTypes) {
        this.propertyClass = propertyClass;
        this.selectSubTypes = selectSubTypes;
    }

    @Override
    public boolean fieldMatches(Field f) {
        return this.propertyClass.equals(f.getType());
    }

    @Override
    public boolean methodMatches(Method m) {
        boolean equals = this.propertyClass.equals(m.getReturnType());
        if (!equals && this.selectSubTypes) {
            equals = this.propertyClass.isAssignableFrom(m.getReturnType());
        }
        return equals;
    }
}

