/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.saml;

import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.parsers.ParserNamespaceSupport;
import org.picketlink.identity.federation.core.parsers.saml.SAMLConditionsParser;
import org.picketlink.identity.federation.core.parsers.saml.SAMLRequestAbstractParser;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.saml.v2.assertion.ConditionsType;
import org.picketlink.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.NameIDPolicyType;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.RequestedAuthnContextType;

public class SAMLAuthNRequestParser
extends SAMLRequestAbstractParser
implements ParserNamespaceSupport {
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, JBossSAMLConstants.AUTHN_REQUEST.get());
        AuthnRequestType authnRequest = this.parseBaseAttributes(startElement);
        while (xmlEventReader.hasNext()) {
            startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
            if (startElement == null) break;
            super.parseCommonElements(startElement, xmlEventReader, (RequestAbstractType)authnRequest);
            String elementName = StaxParserUtil.getStartElementName(startElement);
            if (JBossSAMLConstants.NAMEID_POLICY.get().equals(elementName)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                authnRequest.setNameIDPolicy(this.getNameIDPolicy(startElement));
                continue;
            }
            if (JBossSAMLConstants.SUBJECT.get().equals(elementName)) {
                authnRequest.setSubject(this.getSubject(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.CONDITIONS.get().equals(elementName)) {
                authnRequest.setConditions((ConditionsType)new SAMLConditionsParser().parse(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.REQUESTED_AUTHN_CONTEXT.get().equals(elementName)) {
                authnRequest.setRequestedAuthnContext(this.getRequestedAuthnContextType(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.ISSUER.get().equals(elementName) || JBossSAMLConstants.SIGNATURE.get().equals(elementName)) continue;
            throw new RuntimeException("PL00064: Parser: Unknown Start Element: " + elementName + "::location=" + startElement.getLocation());
        }
        return authnRequest;
    }

    public boolean supports(QName qname) {
        return JBossSAMLURIConstants.PROTOCOL_NSURI.get().equals(qname.getNamespaceURI());
    }

    private AuthnRequestType parseBaseAttributes(StartElement startElement) throws ParsingException {
        Attribute attributeConsumingServiceIndex;
        Attribute isPassive;
        Attribute forceAuthn;
        Attribute providerName;
        Attribute protocolBinding;
        Attribute assertionConsumerServiceIndex;
        super.parseRequiredAttributes(startElement);
        AuthnRequestType authnRequest = new AuthnRequestType(this.id, this.issueInstant);
        super.parseBaseAttributes(startElement, (RequestAbstractType)authnRequest);
        Attribute assertionConsumerServiceURL = startElement.getAttributeByName(new QName(JBossSAMLConstants.ASSERTION_CONSUMER_SERVICE_URL.get()));
        if (assertionConsumerServiceURL != null) {
            String uri = StaxParserUtil.getAttributeValue(assertionConsumerServiceURL);
            authnRequest.setAssertionConsumerServiceURL(URI.create(uri));
        }
        if ((assertionConsumerServiceIndex = startElement.getAttributeByName(new QName(JBossSAMLConstants.ASSERTION_CONSUMER_SERVICE_INDEX.get()))) != null) {
            authnRequest.setAssertionConsumerServiceIndex(Integer.valueOf(Integer.parseInt(StaxParserUtil.getAttributeValue(assertionConsumerServiceIndex))));
        }
        if ((protocolBinding = startElement.getAttributeByName(new QName(JBossSAMLConstants.PROTOCOL_BINDING.get()))) != null) {
            authnRequest.setProtocolBinding(URI.create(StaxParserUtil.getAttributeValue(protocolBinding)));
        }
        if ((providerName = startElement.getAttributeByName(new QName(JBossSAMLConstants.PROVIDER_NAME.get()))) != null) {
            authnRequest.setProviderName(StaxParserUtil.getAttributeValue(providerName));
        }
        if ((forceAuthn = startElement.getAttributeByName(new QName(JBossSAMLConstants.FORCE_AUTHN.get()))) != null) {
            authnRequest.setForceAuthn(Boolean.valueOf(Boolean.parseBoolean(StaxParserUtil.getAttributeValue(forceAuthn))));
        }
        if ((isPassive = startElement.getAttributeByName(new QName(JBossSAMLConstants.IS_PASSIVE.get()))) != null) {
            authnRequest.setIsPassive(Boolean.valueOf(Boolean.parseBoolean(StaxParserUtil.getAttributeValue(isPassive))));
        }
        if ((attributeConsumingServiceIndex = startElement.getAttributeByName(new QName(JBossSAMLConstants.ATTRIBUTE_CONSUMING_SERVICE_INDEX.get()))) != null) {
            authnRequest.setAttributeConsumingServiceIndex(Integer.valueOf(Integer.parseInt(StaxParserUtil.getAttributeValue(attributeConsumingServiceIndex))));
        }
        return authnRequest;
    }

    private NameIDPolicyType getNameIDPolicy(StartElement startElement) {
        Attribute allowCreate;
        NameIDPolicyType nameIDPolicy = new NameIDPolicyType();
        Attribute format = startElement.getAttributeByName(new QName(JBossSAMLConstants.FORMAT.get()));
        if (format != null) {
            nameIDPolicy.setFormat(URI.create(StaxParserUtil.getAttributeValue(format)));
        }
        if ((allowCreate = startElement.getAttributeByName(new QName(JBossSAMLConstants.ALLOW_CREATE.get()))) != null) {
            nameIDPolicy.setAllowCreate(Boolean.valueOf(Boolean.parseBoolean(StaxParserUtil.getAttributeValue(allowCreate))));
        }
        return nameIDPolicy;
    }

    private RequestedAuthnContextType getRequestedAuthnContextType(XMLEventReader xmlEventReader) throws ParsingException {
        RequestedAuthnContextType ract = new RequestedAuthnContextType();
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, JBossSAMLConstants.REQUESTED_AUTHN_CONTEXT.get());
        startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        String elName = StaxParserUtil.getStartElementName(startElement);
        if (!elName.equals(JBossSAMLConstants.AUTHN_CONTEXT_CLASS_REF.get())) {
            throw new RuntimeException("PL00062: Parser : Unknown tag:" + elName);
        }
        String value = StaxParserUtil.getElementText(xmlEventReader);
        ract.addAuthnContextClassRef(value);
        return ract;
    }
}

