/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.wst;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.parsers.AbstractParser;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;
import org.picketlink.identity.federation.core.parsers.wst.WSTRequestSecurityTokenCollectionParser;
import org.picketlink.identity.federation.core.parsers.wst.WSTRequestSecurityTokenParser;
import org.picketlink.identity.federation.core.parsers.wst.WSTRequestSecurityTokenResponseCollectionParser;
import org.picketlink.identity.federation.core.parsers.wst.WSTRequestSecurityTokenResponseParser;

public class WSTrustParser
extends AbstractParser {
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof StartElement) {
                StartElement startElement = (StartElement)xmlEvent;
                String elementName = StaxParserUtil.getStartElementName(startElement);
                if (elementName.equalsIgnoreCase("RequestSecurityTokenCollection")) {
                    WSTRequestSecurityTokenCollectionParser wstrcoll = new WSTRequestSecurityTokenCollectionParser();
                    return wstrcoll.parse(xmlEventReader);
                }
                if (elementName.equalsIgnoreCase("RequestSecurityToken")) {
                    WSTRequestSecurityTokenParser wst = new WSTRequestSecurityTokenParser();
                    return wst.parse(xmlEventReader);
                }
                if (elementName.equalsIgnoreCase("RequestSecurityTokenResponseCollection")) {
                    WSTRequestSecurityTokenResponseCollectionParser wstrcoll = new WSTRequestSecurityTokenResponseCollectionParser();
                    return wstrcoll.parse(xmlEventReader);
                }
                if (!elementName.equalsIgnoreCase("RequestSecurityTokenResponse")) continue;
                WSTRequestSecurityTokenResponseParser wst = new WSTRequestSecurityTokenResponseParser();
                return wst.parse(xmlEventReader);
            }
            StaxParserUtil.getNextEvent(xmlEventReader);
        }
        throw new RuntimeException("PL00067: Parsing has failed:");
    }

    public boolean supports(QName qname) {
        return "http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(qname.getNamespaceURI());
    }
}

