/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v1.writers;

import java.net.URI;
import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v1.writers.BaseSAML11Writer;
import org.picketlink.identity.federation.core.saml.v1.writers.SAML11AssertionWriter;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.util.StaxUtil;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11ActionType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AttributeDesignatorType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AttributeType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11EvidenceType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11SubjectType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11AttributeQueryType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11AuthenticationQueryType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11AuthorizationDecisionQueryType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11QueryAbstractType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11RequestType;

public class SAML11RequestWriter
extends BaseSAML11Writer {
    protected String namespace = "urn:oasis:names:tc:SAML:1.0:protocol";
    protected SAML11AssertionWriter assertionWriter;

    public SAML11RequestWriter(XMLStreamWriter writer) {
        super(writer);
        this.assertionWriter = new SAML11AssertionWriter(writer);
    }

    public void write(SAML11RequestType request) throws ProcessingException {
        SAML11AttributeQueryType attQuery;
        StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, "Request", this.namespace);
        StaxUtil.writeNameSpace(this.writer, PROTOCOL_PREFIX, this.namespace);
        StaxUtil.writeNameSpace(this.writer, ASSERTION_PREFIX, "urn:oasis:names:tc:SAML:1.0:assertion");
        StaxUtil.writeDefaultNameSpace(this.writer, this.namespace);
        StaxUtil.writeAttribute(this.writer, "RequestID", request.getID());
        StaxUtil.writeAttribute(this.writer, "MajorVersion", String.valueOf(request.getMajorVersion()));
        StaxUtil.writeAttribute(this.writer, "MinorVersion", String.valueOf(request.getMinorVersion()));
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ISSUE_INSTANT.get(), request.getIssueInstant().toString());
        List assertionIDRefs = request.getAssertionIDRef();
        for (String assertionIDRef : assertionIDRefs) {
            StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, "AssertionIDReference", "urn:oasis:names:tc:SAML:1.0:assertion");
            StaxUtil.writeCharacters(this.writer, assertionIDRef);
            StaxUtil.writeEndElement(this.writer);
        }
        List assertionArtifacts = request.getAssertionArtifact();
        for (String assertionArtifact : assertionArtifacts) {
            StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, "AssertionArtifact", this.namespace);
            StaxUtil.writeCharacters(this.writer, assertionArtifact);
            StaxUtil.writeEndElement(this.writer);
        }
        SAML11QueryAbstractType query = request.getQuery();
        if (query instanceof SAML11AuthenticationQueryType) {
            SAML11AuthenticationQueryType authQuery = (SAML11AuthenticationQueryType)query;
            this.write(authQuery);
        } else if (query instanceof SAML11AttributeQueryType) {
            attQuery = (SAML11AttributeQueryType)query;
            this.write(attQuery);
        } else if (query instanceof SAML11AuthenticationQueryType) {
            attQuery = (SAML11AuthenticationQueryType)query;
            this.write((SAML11AuthenticationQueryType)attQuery);
        } else if (query instanceof SAML11AuthorizationDecisionQueryType) {
            attQuery = (SAML11AuthorizationDecisionQueryType)query;
            this.write((SAML11AuthorizationDecisionQueryType)attQuery);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(SAML11AuthenticationQueryType auth) throws ProcessingException {
        SAML11SubjectType subject;
        StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, "AuthenticationQuery", this.namespace);
        URI authMethod = auth.getAuthenticationMethod();
        if (authMethod != null) {
            StaxUtil.writeAttribute(this.writer, "AuthenticationMethod", authMethod.toString());
        }
        if ((subject = auth.getSubject()) != null) {
            this.assertionWriter.write(subject);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(SAML11AttributeQueryType attr) throws ProcessingException {
        SAML11SubjectType subject;
        StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, "AttributeQuery", this.namespace);
        URI resource = attr.getResource();
        if (resource != null) {
            StaxUtil.writeAttribute(this.writer, "Resource", resource.toString());
        }
        if ((subject = attr.getSubject()) != null) {
            this.assertionWriter.write(subject);
        }
        List attributes = attr.get();
        for (SAML11AttributeDesignatorType attribute : attributes) {
            if (attribute instanceof SAML11AttributeType) {
                SAML11AttributeType sat = (SAML11AttributeType)attribute;
                this.assertionWriter.write(sat);
                continue;
            }
            throw new ProcessingException("PL00081: Writer: Unknown Type:" + attribute.getClass());
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(SAML11AuthorizationDecisionQueryType attr) throws ProcessingException {
        SAML11SubjectType subject;
        StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, "AuthorizationDecisionQuery", this.namespace);
        URI resource = attr.getResource();
        if (resource != null) {
            StaxUtil.writeAttribute(this.writer, "Resource", resource.toString());
        }
        if ((subject = attr.getSubject()) != null) {
            this.assertionWriter.write(subject);
        }
        List actions = attr.get();
        for (SAML11ActionType action : actions) {
            this.assertionWriter.write(action);
        }
        SAML11EvidenceType evidence = attr.getEvidence();
        if (evidence != null) {
            this.assertionWriter.write(evidence);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }
}

