/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.saml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.parsers.ParserNamespaceSupport;
import org.picketlink.identity.federation.core.parsers.saml.SAMLAuthNRequestParser;
import org.picketlink.identity.federation.core.parsers.saml.SAMLResponseParser;
import org.picketlink.identity.federation.core.parsers.saml.SAMLStatusResponseTypeParser;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.protocol.ArtifactResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.w3c.dom.Element;

public class SAMLArtifactResponseParser
extends SAMLStatusResponseTypeParser
implements ParserNamespaceSupport {
    private final String ARTIFACT_RESPONSE = JBossSAMLConstants.ARTIFACT_RESPONSE.get();

    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, this.ARTIFACT_RESPONSE);
        ArtifactResponseType response = (ArtifactResponseType)this.parseBaseAttributes(startElement);
        while (xmlEventReader.hasNext() && (startElement = StaxParserUtil.peekNextStartElement(xmlEventReader)) != null) {
            AuthnRequestType authn;
            ParserNamespaceSupport authnParser;
            String elementName = StaxParserUtil.getStartElementName(startElement);
            if (JBossSAMLConstants.ISSUER.get().equals(elementName)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                NameIDType issuer = new NameIDType();
                issuer.setValue(StaxParserUtil.getElementText(xmlEventReader));
                response.setIssuer(issuer);
                continue;
            }
            if (JBossSAMLConstants.SIGNATURE.get().equals(elementName)) {
                Element sig = StaxParserUtil.getDOMElement(xmlEventReader);
                response.setSignature(sig);
                continue;
            }
            if (JBossSAMLConstants.AUTHN_REQUEST.get().equals(elementName)) {
                authnParser = new SAMLAuthNRequestParser();
                authn = (AuthnRequestType)((SAMLAuthNRequestParser)authnParser).parse(xmlEventReader);
                response.setAny((Object)authn);
                continue;
            }
            if (JBossSAMLConstants.RESPONSE.get().equals(elementName)) {
                authnParser = new SAMLResponseParser();
                authn = (ResponseType)((SAMLResponseParser)authnParser).parse(xmlEventReader);
                response.setAny((Object)authn);
                continue;
            }
            if (JBossSAMLConstants.STATUS.get().equals(elementName)) {
                response.setStatus(this.parseStatus(xmlEventReader));
                continue;
            }
            throw new RuntimeException("PL00064: Parser: Unknown Start Element: " + elementName + "::location=" + startElement.getLocation());
        }
        return response;
    }

    public boolean supports(QName qname) {
        return JBossSAMLURIConstants.PROTOCOL_NSURI.get().equals(qname.getNamespaceURI()) && this.ARTIFACT_RESPONSE.equals(qname.getLocalPart());
    }

    protected StatusResponseType parseBaseAttributes(StartElement startElement) throws ParsingException {
        ArtifactResponseType response = new ArtifactResponseType(super.parseBaseAttributes(startElement));
        return response;
    }
}

