/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.saml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.parsers.ParserNamespaceSupport;
import org.picketlink.identity.federation.core.parsers.util.SAMLParserUtil;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.saml.v2.assertion.BaseIDAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.EncryptedElementType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectConfirmationDataType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectConfirmationType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyInfoType;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyValueType;
import org.picketlink.identity.xmlsec.w3.xmldsig.RSAKeyValueType;
import org.picketlink.identity.xmlsec.w3.xmldsig.X509CertificateType;
import org.picketlink.identity.xmlsec.w3.xmldsig.X509DataType;
import org.w3c.dom.Element;

public class SAMLSubjectParser
implements ParserNamespaceSupport {
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        StaxParserUtil.getNextEvent(xmlEventReader);
        SubjectType subject = new SubjectType();
        while (xmlEventReader.hasNext()) {
            SubjectType.STSubType subType;
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)xmlEvent;
                if (StaxParserUtil.matches(endElement, JBossSAMLConstants.SUBJECT.get())) {
                    endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                    break;
                }
                throw new RuntimeException("PL00061: Parser: Unknown End Element:" + StaxParserUtil.getEndElementName(endElement));
            }
            StartElement peekedElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
            if (peekedElement == null) break;
            String tag = StaxParserUtil.getStartElementName(peekedElement);
            if (JBossSAMLConstants.NAMEID.get().equalsIgnoreCase(tag)) {
                NameIDType nameID = SAMLParserUtil.parseNameIDType(xmlEventReader);
                subType = new SubjectType.STSubType();
                subType.addBaseID((BaseIDAbstractType)nameID);
                subject.setSubType(subType);
                continue;
            }
            if (JBossSAMLConstants.BASEID.get().equalsIgnoreCase(tag)) {
                throw new ParsingException("PL00069: Parser: Type not supported:" + JBossSAMLConstants.BASEID.get());
            }
            if (JBossSAMLConstants.ENCRYPTED_ID.get().equals(tag)) {
                Element domElement = StaxParserUtil.getDOMElement(xmlEventReader);
                subType = new SubjectType.STSubType();
                subType.setEncryptedID(new EncryptedElementType(domElement));
                subject.setSubType(subType);
                continue;
            }
            if (JBossSAMLConstants.SUBJECT_CONFIRMATION.get().equalsIgnoreCase(tag)) {
                StartElement subjectConfirmationElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                Attribute method = subjectConfirmationElement.getAttributeByName(new QName(JBossSAMLConstants.METHOD.get()));
                SubjectConfirmationType subjectConfirmationType = new SubjectConfirmationType();
                if (method != null) {
                    subjectConfirmationType.setMethod(StaxParserUtil.getAttributeValue(method));
                }
                if ((xmlEvent = StaxParserUtil.peek(xmlEventReader)) instanceof StartElement) {
                    StartElement startElement = (StartElement)xmlEvent;
                    String startTag = StaxParserUtil.getStartElementName(startElement);
                    if (startTag.equals(JBossSAMLConstants.NAMEID.get())) {
                        NameIDType nameID = SAMLParserUtil.parseNameIDType(xmlEventReader);
                        subjectConfirmationType.setNameID(nameID);
                    } else {
                        if (JBossSAMLConstants.BASEID.get().equalsIgnoreCase(tag)) {
                            throw new ParsingException("PL00069: Parser: Type not supported:" + JBossSAMLConstants.BASEID.get());
                        }
                        if (JBossSAMLConstants.ENCRYPTED_ID.get().equals(tag)) {
                            Element domElement = StaxParserUtil.getDOMElement(xmlEventReader);
                            subjectConfirmationType.setEncryptedID(new EncryptedElementType(domElement));
                        } else if (startTag.equals(JBossSAMLConstants.SUBJECT_CONFIRMATION_DATA.get())) {
                            SubjectConfirmationDataType subjectConfirmationData = this.parseSubjectConfirmationData(xmlEventReader);
                            subjectConfirmationType.setSubjectConfirmationData(subjectConfirmationData);
                        }
                    }
                }
                subject.addConfirmation(subjectConfirmationType);
                EndElement endElement = (EndElement)StaxParserUtil.getNextEvent(xmlEventReader);
                StaxParserUtil.matches(endElement, JBossSAMLConstants.SUBJECT_CONFIRMATION.get());
                continue;
            }
            throw new RuntimeException("PL00062: Parser : Unknown tag:" + tag + "::location=" + peekedElement.getLocation());
        }
        return subject;
    }

    public boolean supports(QName qname) {
        String nsURI = qname.getNamespaceURI();
        String localPart = qname.getLocalPart();
        return nsURI.equals(JBossSAMLURIConstants.ASSERTION_NSURI.get()) && localPart.equals(JBossSAMLConstants.SUBJECT.get());
    }

    private SubjectConfirmationDataType parseSubjectConfirmationData(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        Attribute address;
        Attribute recipient;
        Attribute notOnOrAfter;
        Attribute notBefore;
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, JBossSAMLConstants.SUBJECT_CONFIRMATION_DATA.get());
        SubjectConfirmationDataType subjectConfirmationData = new SubjectConfirmationDataType();
        Attribute inResponseTo = startElement.getAttributeByName(new QName(JBossSAMLConstants.IN_RESPONSE_TO.get()));
        if (inResponseTo != null) {
            subjectConfirmationData.setInResponseTo(StaxParserUtil.getAttributeValue(inResponseTo));
        }
        if ((notBefore = startElement.getAttributeByName(new QName(JBossSAMLConstants.NOT_BEFORE.get()))) != null) {
            subjectConfirmationData.setNotBefore(XMLTimeUtil.parse(StaxParserUtil.getAttributeValue(notBefore)));
        }
        if ((notOnOrAfter = startElement.getAttributeByName(new QName(JBossSAMLConstants.NOT_ON_OR_AFTER.get()))) != null) {
            subjectConfirmationData.setNotOnOrAfter(XMLTimeUtil.parse(StaxParserUtil.getAttributeValue(notOnOrAfter)));
        }
        if ((recipient = startElement.getAttributeByName(new QName(JBossSAMLConstants.RECIPIENT.get()))) != null) {
            subjectConfirmationData.setRecipient(StaxParserUtil.getAttributeValue(recipient));
        }
        if ((address = startElement.getAttributeByName(new QName(JBossSAMLConstants.ADDRESS.get()))) != null) {
            subjectConfirmationData.setAddress(StaxParserUtil.getAttributeValue(address));
        }
        if (!((xmlEvent = StaxParserUtil.peek(xmlEventReader)) instanceof EndElement)) {
            startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
            String tag = StaxParserUtil.getStartElementName(startElement);
            if (tag.equals("KeyInfo")) {
                KeyInfoType keyInfo = this.parseKeyInfo(xmlEventReader);
                subjectConfirmationData.setAnyType((Object)keyInfo);
            } else if (tag.equals("EncryptedKey")) {
                subjectConfirmationData.setAnyType((Object)StaxParserUtil.getDOMElement(xmlEventReader));
            } else {
                throw new RuntimeException("PL00062: Parser : Unknown tag:" + tag);
            }
        }
        EndElement endElement = (EndElement)StaxParserUtil.getNextEvent(xmlEventReader);
        StaxParserUtil.matches(endElement, JBossSAMLConstants.SUBJECT_CONFIRMATION_DATA.get());
        return subjectConfirmationData;
    }

    private KeyInfoType parseKeyInfo(XMLEventReader xmlEventReader) throws ParsingException {
        KeyInfoType keyInfo = new KeyInfoType();
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, "KeyInfo");
        XMLEvent xmlEvent = null;
        String tag = null;
        while (xmlEventReader.hasNext()) {
            xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                tag = StaxParserUtil.getEndElementName((EndElement)xmlEvent);
                if (tag.equals("KeyInfo")) {
                    xmlEvent = StaxParserUtil.getNextEndElement(xmlEventReader);
                    break;
                }
                throw new RuntimeException("PL00061: Parser: Unknown End Element:" + tag);
            }
            startElement = (StartElement)xmlEvent;
            tag = StaxParserUtil.getStartElementName(startElement);
            if (tag.equals("EncryptedKey")) {
                keyInfo.addContent((Object)StaxParserUtil.getDOMElement(xmlEventReader));
                continue;
            }
            if (tag.equals("X509Data")) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                X509DataType x509 = new X509DataType();
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                StaxParserUtil.validate(startElement, "X509Certificate");
                X509CertificateType cert = new X509CertificateType();
                String certValue = StaxParserUtil.getElementText(xmlEventReader);
                cert.setEncodedCertificate(certValue.getBytes());
                x509.add((Object)cert);
                EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(endElement, "X509Data");
                keyInfo.addContent((Object)x509);
                continue;
            }
            if (!tag.equals("KeyValue")) continue;
            startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
            KeyValueType keyValue = new KeyValueType();
            startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
            tag = StaxParserUtil.getStartElementName(startElement);
            if (tag.equals("RSAKeyValue")) {
                keyValue.getContent().add(this.parseRSAKeyValue(xmlEventReader));
            } else if (!tag.equals("DSAKeyValue")) {
                throw new ParsingException("PL00062: Parser : Unknown tag:" + tag);
            }
            EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
            StaxParserUtil.validate(endElement, "KeyValue");
            keyInfo.addContent((Object)keyValue);
        }
        return keyInfo;
    }

    private RSAKeyValueType parseRSAKeyValue(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, "RSAKeyValue");
        XMLEvent xmlEvent = null;
        String tag = null;
        RSAKeyValueType rsaKeyValue = new RSAKeyValueType();
        while (xmlEventReader.hasNext()) {
            String text;
            xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                tag = StaxParserUtil.getEndElementName((EndElement)xmlEvent);
                if (tag.equals("RSAKeyValue")) {
                    xmlEvent = StaxParserUtil.getNextEndElement(xmlEventReader);
                    break;
                }
                throw new RuntimeException("PL00061: Parser: Unknown End Element:" + tag);
            }
            startElement = (StartElement)xmlEvent;
            tag = StaxParserUtil.getStartElementName(startElement);
            if (tag.equals("Modulus")) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                text = StaxParserUtil.getElementText(xmlEventReader);
                rsaKeyValue.setModulus(text.getBytes());
                continue;
            }
            if (tag.equals("Exponent")) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                text = StaxParserUtil.getElementText(xmlEventReader);
                rsaKeyValue.setExponent(text.getBytes());
                continue;
            }
            throw new ParsingException("PL00062: Parser : Unknown tag:" + tag);
        }
        return rsaKeyValue;
    }
}

