/*
 * Decompiled with CFR 0.152.
 */
package reactor.logback;

import ch.qos.logback.classic.BasicConfigurator;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Pattern;
import net.openhft.chronicle.ChronicleConfig;
import net.openhft.chronicle.ExcerptTailer;
import net.openhft.chronicle.IndexedChronicle;
import net.openhft.chronicle.tools.ChronicleTools;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.LoggerFactory;
import reactor.logback.LoggingEventRecord;

public class DurableLogUtility {
    private static Options OPTS = new Options();

    public static void main(String ... args) throws ParseException, JoranException, IOException {
        BasicParser parser = new BasicParser();
        CommandLine cl = null;
        try {
            cl = parser.parse(OPTS, args);
        }
        catch (ParseException e) {
            HelpFormatter help = new HelpFormatter();
            help.printHelp("dlog", OPTS, true);
            System.exit(-1);
        }
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        loggerContext.reset();
        if (cl.hasOption("config")) {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)loggerContext);
            configurator.doConfigure(cl.getOptionValue("file", "logback.xml"));
            StatusPrinter.printInCaseOfErrorsOrWarnings((Context)loggerContext);
        } else {
            BasicConfigurator.configure((LoggerContext)loggerContext);
        }
        Appender appender = null;
        if (cl.hasOption("output")) {
            String outputAppender = cl.getOptionValue("output", "console");
            appender = loggerContext.getLogger("ROOT").getAppender(outputAppender);
        }
        ChronicleTools.warmup();
        IndexedChronicle chronicle = new IndexedChronicle(cl.getOptionValue("path"), ChronicleConfig.DEFAULT);
        ExcerptTailer ex = chronicle.createTailer();
        Level level = Level.valueOf((String)cl.getOptionValue("level", "TRACE"));
        if (cl.hasOption("head")) {
            int lines = Integer.parseInt(cl.getOptionValue("head", "10"));
            for (int i = 0; i < lines; ++i) {
                LoggingEvent evt = DurableLogUtility.readLoggingEvent(ex, loggerContext);
                if (!evt.getLevel().isGreaterOrEqual(level)) continue;
                DurableLogUtility.writeEvent(evt, appender);
            }
        } else if (cl.hasOption("tail")) {
            LoggingEvent evt;
            int lines = Integer.parseInt(cl.getOptionValue("tail", "10"));
            LinkedBlockingQueue<LoggingEvent> tail = new LinkedBlockingQueue<LoggingEvent>(lines);
            while (ex.nextIndex()) {
                evt = DurableLogUtility.readLoggingEvent(ex, loggerContext);
                if (tail.offer(evt)) continue;
                tail.poll();
                tail.add(evt);
            }
            while (null != (evt = (LoggingEvent)tail.poll())) {
                if (!evt.getLevel().isGreaterOrEqual(level)) continue;
                DurableLogUtility.writeEvent(evt, appender);
            }
        } else if (cl.hasOption("search")) {
            String regex = cl.getOptionValue("search");
            Pattern regexPatt = Pattern.compile(regex);
            while (ex.nextIndex()) {
                LoggingEvent evt = DurableLogUtility.readLoggingEvent(ex, loggerContext);
                if (null == evt || !evt.getLevel().isGreaterOrEqual(level) || !regexPatt.matcher(evt.getFormattedMessage()).matches()) continue;
                DurableLogUtility.writeEvent(evt, appender);
            }
        }
        loggerContext.stop();
        chronicle.close();
    }

    private static void writeEvent(LoggingEvent evt, Appender appender) {
        if (null == evt) {
            return;
        }
        if (null != appender) {
            appender.doAppend((Object)evt);
        } else {
            System.out.println(evt.getFormattedMessage());
        }
    }

    private static LoggingEvent readLoggingEvent(ExcerptTailer ex, LoggerContext ctx) {
        LoggingEventRecord rec = LoggingEventRecord.read(ex);
        Logger logger = ctx.getLogger(rec.getLoggerName());
        LoggingEvent evt = new LoggingEvent(logger.getClass().getName(), logger, Level.toLevel((int)rec.getLevel()), rec.getMessage(), rec.getCause(), rec.getArgs());
        evt.setTimeStamp(rec.getTimestamp());
        evt.setThreadName(rec.getThreadName());
        evt.setMDCPropertyMap(rec.getMdcProps());
        if (null != rec.getCause()) {
            evt.setThrowableProxy(new ThrowableProxy(rec.getCause()));
        }
        evt.setCallerData(rec.getCallerData());
        return evt;
    }

    static {
        Option path = new Option("p", "path", true, "Base path to a durable log file to interpret");
        path.setRequired(true);
        Option config = new Option("c", "config", true, "Logback configuration XML file to parse");
        Option output = new Option("o", "output", true, "Appender to use to output results");
        Option regex = new Option("search", true, "Search for the given regex and print to standard out");
        Option level = new Option("level", true, "Log level to filter");
        Option head = new Option("head", true, "Number of lines to display from the head of the file");
        Option tail = new Option("tail", true, "Number of lines to display from the tail of the file");
        OptionGroup findOpts = new OptionGroup().addOption(regex).addOption(head).addOption(tail);
        OPTS.addOption(path).addOption(config).addOption(output).addOption(level).addOptionGroup(findOpts);
    }
}

