/*
 * Decompiled with CFR 0.152.
 */
package reactor.logback;

import ch.qos.logback.classic.spi.LoggingEvent;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.ExcerptTailer;

class LoggingEventRecord
implements Serializable {
    private static final long serialVersionUID = 4286033251454846145L;
    private static final String CRLF = "\r\n";
    private long timestamp;
    private String threadName;
    private String loggerName;
    private int level;
    private String message;
    private Object[] args;
    private StackTraceElement[] callerData;
    private Map<String, String> mdcProps;
    private Throwable cause;

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public int getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public StackTraceElement[] getCallerData() {
        return this.callerData;
    }

    public Map<String, String> getMdcProps() {
        return this.mdcProps;
    }

    public Throwable getCause() {
        return this.cause;
    }

    static void write(ExcerptAppender ex, LoggingEvent evt, boolean includeCallerData, int vers) {
        ex.startExcerpt(32768L);
        ex.writeInt(vers);
        if (vers == 1) {
            ex.writeLong(evt.getTimeStamp());
            ex.writeInt(evt.getLevel().toInt());
            Object[] args = evt.getArgumentArray();
            int argLen = null != args ? args.length : 0;
            ex.writeInt(argLen);
            Map mdcProps = evt.getMDCPropertyMap();
            int propsLen = null != mdcProps ? mdcProps.size() : 0;
            ex.writeInt(propsLen);
            StackTraceElement[] callerData = null;
            if (includeCallerData) {
                callerData = evt.getCallerData();
            }
            int callerDataLen = null != callerData ? callerData.length : 0;
            ex.writeInt(callerDataLen);
            ex.writeUTF(evt.getThreadName());
            ex.writeUTF(evt.getLoggerName());
            ex.writeUTF(evt.getMessage());
            for (int i = 0; i < argLen; ++i) {
                ex.writeUTF(args[i].toString());
            }
            for (Map.Entry entry : evt.getMDCPropertyMap().entrySet()) {
                ex.writeUTF((String)entry.getKey());
                ex.writeUTF((String)entry.getValue());
            }
            for (int i = 0; i < callerDataLen; ++i) {
                ex.writeObject((Object)callerData[i]);
            }
            boolean hasCause = null != evt.getThrowableProxy();
            ex.writeBoolean(hasCause);
            if (hasCause) {
                ex.writeObject((Object)((Throwable)evt.getThrowableProxy()));
            }
        }
        ex.finish();
    }

    static LoggingEventRecord read(ExcerptTailer ex) {
        int vers = ex.readInt();
        if (vers == 1) {
            LoggingEventRecord rec = new LoggingEventRecord();
            rec.timestamp = ex.readLong();
            rec.level = ex.readInt();
            int argLen = ex.readInt();
            int propsLen = ex.readInt();
            int callerDataLen = ex.readInt();
            rec.threadName = ex.readUTF();
            rec.loggerName = ex.readUTF();
            rec.message = ex.readUTF();
            String[] args = new String[argLen];
            for (int i = 0; i < argLen; ++i) {
                args[i] = ex.readUTF();
            }
            rec.args = args;
            HashMap<String, String> mdcProps = propsLen > 0 ? new HashMap<String, String>() : Collections.emptyMap();
            for (int i = 0; i < propsLen; ++i) {
                String key = ex.readUTF();
                String val = ex.readUTF();
                mdcProps.put(key, val);
            }
            rec.mdcProps = mdcProps;
            StackTraceElement[] callerData = new StackTraceElement[callerDataLen];
            for (int i = 0; i < callerDataLen; ++i) {
                callerData[i] = (StackTraceElement)ex.readObject(StackTraceElement.class);
            }
            rec.callerData = callerData;
            if (ex.readBoolean()) {
                rec.cause = (Throwable)ex.readObject(Throwable.class);
            }
            return rec;
        }
        throw new IllegalStateException("Version " + vers + " not supported");
    }
}

