/*
 * $Id: AbstractCssRenderer.java,v 1.7 2006/12/18 13:30:33 oeuillot Exp $
 */
package org.rcfaces.renderkit.html.internal;

import javax.faces.FacesException;
import javax.faces.component.UIComponent;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rcfaces.core.component.capability.IBackgroundImageCapability;
import org.rcfaces.core.component.capability.IFontCapability;
import org.rcfaces.core.component.capability.IForegroundBackgroundColorCapability;
import org.rcfaces.core.component.capability.IMarginCapability;
import org.rcfaces.core.component.capability.IPositionCapability;
import org.rcfaces.core.component.capability.ISeverityStyleClassCapability;
import org.rcfaces.core.component.capability.ISizeCapability;
import org.rcfaces.core.component.capability.IStyleClassCapability;
import org.rcfaces.core.component.capability.ITextAlignmentCapability;
import org.rcfaces.core.component.capability.IVisibilityCapability;
import org.rcfaces.core.internal.renderkit.WriterException;

/**
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.7 $ $Date: 2006/12/18 13:30:33 $
 */
public abstract class AbstractCssRenderer extends AbstractJavaScriptRenderer
        implements ICssRenderer {

    private static final String REVISION = "$Revision: 1.7 $";

    private static final Log LOG = LogFactory.getLog(AbstractCssRenderer.class);

    private static final int DEFAULT_RENDERED_HIDDEN_MODE = IVisibilityCapability.IGNORE_HIDDEN_MODE;

    private static final String DEFAULT_MARGIN_UNIT = "px";

    public static final String BLANK_IMAGE_URL = "blank.gif";

    protected static final int CSS_ALL_MASK = 0xffff;

    protected static final int CSS_FONT_MASK = 1;

    protected static final int CSS_SIZE_MASK = 2;

    protected static final int SEVERITY_CLASSES_MASK = 4;

    protected String getComponentStyleClassName() {
        return getMainStyleClassName();
    }

    public final String getMainStyleClassName() {
        return getJavaScriptClassName();
    }

    protected IHtmlWriter writeStyleClass(IHtmlWriter writer, String classSuffix)
            throws WriterException {

        String cssClass = null;

        cssClass = getStyleClassName(writer.getComponentRenderContext()
                .getComponent());
        if (cssClass != null) {
            if (classSuffix != null && classSuffix.length() > 0) {
                cssClass += classSuffix;
            }
            writer.writeClass(cssClass);
        }

        return writer;
    }

    public String getStyleClassName(UIComponent component) {
        if (component instanceof IStyleClassCapability) {
            IStyleClassCapability styleClassCapability = (IStyleClassCapability) component;

            String cssClass = styleClassCapability.getStyleClass();
            if (cssClass != null) {
                return cssClass;
            }
        }

        return getComponentStyleClassName();
    }

    protected final IHtmlWriter writeCssAttributes(IHtmlWriter writer)
            throws WriterException {
        return writeCssAttributes(writer, null, CSS_ALL_MASK);
    }

    protected final IHtmlWriter writeCssAttributes(IHtmlWriter writer,
            String classSuffix, int attributesMask) throws WriterException {
        UIComponent component = writer.getComponentRenderContext()
                .getComponent();

        writeStyleClass(writer, classSuffix);

        if ((attributesMask & SEVERITY_CLASSES_MASK) != 0) {
            if (component instanceof ISeverityStyleClassCapability) {
                writeSeverityStyleClasses(writer,
                        (ISeverityStyleClassCapability) component);
            }
        }

        ICssWriter cssWriter = writer.writeStyle();

        int hiddenMode = DEFAULT_RENDERED_HIDDEN_MODE;

        if (component instanceof IVisibilityCapability) {
            IVisibilityCapability visibilityCapability = (IVisibilityCapability) component;

            cssWriter.writeVisibility(visibilityCapability);

            hiddenMode = visibilityCapability.getHiddenMode();
            if (hiddenMode == 0) {
                hiddenMode = DEFAULT_RENDERED_HIDDEN_MODE;
            }
        }

        if ((attributesMask & CSS_FONT_MASK) != 0) {
            if (component instanceof IFontCapability) {
                cssWriter.writeFont((IFontCapability) component);
            }
        }

        if (component instanceof ITextAlignmentCapability) {
            cssWriter.writeTextAlignment((ITextAlignmentCapability) component);
        }

        if (component instanceof IPositionCapability) {
            cssWriter.writePosition((IPositionCapability) component);
        }

        if ((attributesMask & CSS_SIZE_MASK) != 0) {
            if (component instanceof ISizeCapability) {
                cssWriter.writeSize((ISizeCapability) component);
            }
        }

        if (component instanceof IMarginCapability) {
            cssWriter.writeMargin((IMarginCapability) component);
        }

        IForegroundBackgroundColorCapability foregroundBackgroundColorCapability = null;
        if (component instanceof IForegroundBackgroundColorCapability) {
            foregroundBackgroundColorCapability = (IForegroundBackgroundColorCapability) component;

            cssWriter.writeForeground(foregroundBackgroundColorCapability);
        }

        IBackgroundImageCapability backgroundImageCapability = null;
        if (component instanceof IBackgroundImageCapability) {
            backgroundImageCapability = (IBackgroundImageCapability) component;
        }

        if (backgroundImageCapability != null
                || foregroundBackgroundColorCapability != null) {
            cssWriter.writeBackground(foregroundBackgroundColorCapability,
                    backgroundImageCapability);
        }

        writeCustomCss(writer, cssWriter);

        if (hiddenMode != DEFAULT_RENDERED_HIDDEN_MODE) {
            writer.writeAttribute("v:hiddenMode", hiddenMode);
        }

        return writer;
    }

    protected void writeCustomCss(IHtmlWriter writer, ICssWriter cssWriter) {
    }

    protected static final String getSize(String size) {
        if (size == null) {
            return size;
        }

        int len = size.length();
        if (len < 1) {
            return size;
        }

        if (Character.isDigit(size.charAt(len - 1)) == false) {
            return size;
        }

        return size + "px";
    }

    protected static final String computeSize(String size, int parentWidth,
            int delta) {
        int v = getPixelSize(size, parentWidth);
        if (v < 0) {
            return null;
        }

        return (v + delta) + "px";
    }

    protected static final int getPixelSize(String size, int parentWidth) {
        if (size == null) {
            return -1;
        }

        size = size.trim();

        int len = size.length();
        if (len < 1) {
            return -1;
        }

        boolean unitPX = false;
        for (; Character.isDigit(size.charAt(len - 1)) == false;) {
            if (size.toLowerCase().endsWith("px") == false) {
                return -1;
            }

            if (unitPX) {
                throw new FacesException("More one unit for size '" + size
                        + "' ?");
            }

            unitPX = true;

            size = size.substring(0, size.length() - 2).trim();

            len = size.length();
            if (len < 1) {
                throw new FacesException("Bad format of size '" + size
                        + "' ? (only unit)");
            }
        }

        try {
            return Integer.parseInt(size);

        } catch (NumberFormatException ex) {
            return -1;
        }
    }

    protected static String normalizeMarginValue(String value) {
        value = value.trim();

        if (Constants.NORMALIZE_STYLE_MARGINS == false) {
            if (value.length() < 1) {
                return null;
            }

            return value;
        }

        char chs[] = value.toCharArray();

        int i = 0;
        // Recherche le debut !
        for (; i < chs.length; i++) {
            char c = chs[i];
            if (Character.isDigit(c) || c == '-' || c == '.') {
                break;
            }
        }
        if (i == chs.length) {
            return null;
        }

        boolean negative = false;
        char c = chs[i];
        if (c == '-') {
            i++;
            negative = true;
        }

        double v = 0;
        int decimal = -1;
        // Recherche la fin
        for (; i < chs.length; i++) {
            c = chs[i];

            if (c == '.') {
                if (decimal >= 0) {
                    throw new FacesException("Bad margin unit '" + value + "'.");
                }
                decimal = 0;
                continue;
            }

            if (Character.isDigit(c) == false) {
                break;
            }

            if (decimal >= 0) {
                decimal++;
            }

            v = v * 10 + (c - '0');
        }

        if (decimal > 0) {
            v /= Math.pow(10, decimal);
        }

        // Passe des espaces ....
        for (; i < chs.length; i++) {
            c = chs[i];
            if (Character.isWhitespace(c) == false) {
                break;
            }
        }

        if (v == 0.0) {
            if (i < chs.length) {
                c = chs[i];

                if (Character.isLetter(c) == false && c != '%') {
                    throw new FacesException("Bad unit for margin '" + value
                            + "'.");
                }
            }

            String margin = "0";
            if (LOG.isDebugEnabled()) {
                LOG.debug("Normalize margins original='" + value
                        + "' normalized='" + margin + "'.");
            }

            return margin;
        }

        if (negative) {
            v = -v;
        }

        // La fin !
        String unit;
        if (i == chs.length) {
            // Pas d'unité, on en ajoute une !
            unit = DEFAULT_MARGIN_UNIT;

        } else {
            unit = value.substring(i).trim();
            if (unit.length() < 1) {
                unit = DEFAULT_MARGIN_UNIT;
            }
        }

        String margin;
        if (decimal < 1) {
            margin = Math.floor(v) + DEFAULT_MARGIN_UNIT;
        } else {
            margin = v + DEFAULT_MARGIN_UNIT;
        }

        if (LOG.isDebugEnabled()) {
            LOG.debug("Normalize margins original='" + value + "' normalized='"
                    + margin + "'.");
        }

        return margin;
    }

    protected boolean sendCompleteComponent() {
        return true;
    }
}