/*
 * $Id: NoneBorderRenderer.java,v 1.4 2006/11/10 14:15:43 oeuillot Exp $
 * 
 */
package org.rcfaces.renderkit.html.internal.border;

import org.rcfaces.core.internal.renderkit.WriterException;
import org.rcfaces.renderkit.html.internal.IHtmlWriter;

/**
 * 
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.4 $ $Date: 2006/11/10 14:15:43 $
 */
public class NoneBorderRenderer extends AbstractHtmlBorderRenderer {
    private static final String REVISION = "$Revision: 1.4 $";

    public static final String NONE_BORDER_CLASS = null;

    public static final IHtmlBorderRenderer SINGLETON = new NoneBorderRenderer();

    protected boolean hasBorder() {
        return false;
    }

    protected String getClassName() {
        return NONE_BORDER_CLASS;
    }

    public void initialize(IHtmlWriter writer, String width, String height,
            int horizontalSpan, int verticalSpan, boolean disabled,
            boolean selected) throws WriterException {
        if (horizontalSpan < 2 && verticalSpan < 2) {
            this.noTable = true;
        }

        super.initialize(writer, width, height, horizontalSpan, verticalSpan,
                disabled, selected);
    }
}
