/*
 * $Id: SolidBorderRenderer.java,v 1.3 2006/11/10 14:15:43 oeuillot Exp $
 * 
 */
package org.rcfaces.renderkit.html.internal.border;

import org.rcfaces.core.internal.renderkit.WriterException;
import org.rcfaces.renderkit.html.internal.IHtmlWriter;

/**
 * 
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.3 $ $Date: 2006/11/10 14:15:43 $
 */
public class SolidBorderRenderer extends AbstractHtmlBorderRenderer {
    private static final String REVISION = "$Revision: 1.3 $";

    public static final String SOLID_BORDER_CLASS = "fb_solid";

    protected boolean hasBorder() {
        return false;
    }

    protected String getClassName() {
        return SOLID_BORDER_CLASS;
    }

    public void initialize(IHtmlWriter writer, String width, String height,
            int horizontalSpan, int verticalSpan, boolean disabled,
            boolean selected) throws WriterException {

        if (horizontalSpan < 2 && verticalSpan < 2) {
            // C'est pas Thread-safe ca !!!!
            this.noTable = true;
        }

        super.initialize(writer, width, height, horizontalSpan, verticalSpan,
                disabled, selected);
    }

}
