/*
 * $Id: SubMenuDecorator.java,v 1.6 2006/11/10 14:15:43 oeuillot Exp $
 * 
 */
package org.rcfaces.renderkit.html.internal.decorator;

import java.util.Map;

import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;

import org.rcfaces.core.internal.renderkit.IProcessContext;
import org.rcfaces.core.internal.renderkit.WriterException;
import org.rcfaces.renderkit.html.internal.Constants;
import org.rcfaces.renderkit.html.internal.EventsRenderer;
import org.rcfaces.renderkit.html.internal.util.ListenerTools;

/**
 * 
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.6 $ $Date: 2006/11/10 14:15:43 $
 */
public class SubMenuDecorator extends MenuDecorator {
    private static final String REVISION = "$Revision: 1.6 $";

    protected final String menuId;

    protected String menuVarName;

    private String suffixMenuId;

    private boolean removeAllWhenShown;

    private int itemImageWidth;

    private int itemImageHeight;

    public SubMenuDecorator(UIComponent component, String menuId,
            String suffixMenuId, boolean removeAllWhenShown,
            int itemImageWidth, int itemImageHeight) {
        super(component);

        this.suffixMenuId = suffixMenuId;
        this.menuId = menuId;
        this.removeAllWhenShown = removeAllWhenShown;
        this.itemImageWidth = itemImageWidth;
        this.itemImageHeight = itemImageHeight;
    }

    protected SelectItemsContext createJavaScriptContext()
            throws WriterException {
        SelectItemsJsContext context = (SelectItemsJsContext) super
                .createJavaScriptContext();

        menuVarName = javaScriptWriter.getJavaScriptRenderContext()
                .allocateVarName();

        javaScriptWriter.write("var ").write(menuVarName).write("=")
                .writeMethodCall("f_newSubMenu").writeString(menuId);

        int pred = 0;

        String id = context.getComponentClientId(getComponent());

        if (suffixMenuId != null) {

            if (Constants.CLIENT_NAMING_SEPARATOR_SUPPORT) {
                IProcessContext processContext = getComponentRenderContext()
                        .getRenderContext().getProcessContext();

                String namingSeparator = processContext.getNamingSeparator();
                if (namingSeparator != null) {
                    id += namingSeparator + suffixMenuId;

                } else {
                    id += NamingContainer.SEPARATOR_CHAR + suffixMenuId;
                }
            } else {
                id += NamingContainer.SEPARATOR_CHAR + suffixMenuId;
            }
        }

        if (id != null) {
            javaScriptWriter.write(',').writeString(id);

        } else {
            pred++;
        }

        if (removeAllWhenShown) {
            for (; pred > 0; pred--) {
                javaScriptWriter.write(',').writeNull();
            }

            javaScriptWriter.write(',').writeBoolean(true);
        } else {
            pred++;
        }

        if (itemImageWidth >= 0) {
            for (; pred > 0; pred--) {
                javaScriptWriter.write(',').writeNull();
            }

            javaScriptWriter.write(',').writeInt(itemImageWidth);
        } else {
            pred++;
        }

        if (itemImageHeight >= 0) {
            for (; pred > 0; pred--) {
                javaScriptWriter.write(',').writeNull();
            }

            javaScriptWriter.write(',').writeInt(itemImageHeight);
        } else {
            pred++;
        }

        javaScriptWriter.writeln(");");

        context.pushVarId(menuVarName);

        context.setManagerComponentId(menuVarName);

        return context;
    }

    protected void encodeComponentsBegin() throws WriterException {
        if (javaScriptWriter != null) {
            if (suffixMenuId == null) {
                SelectItemsJsContext context = (SelectItemsJsContext) getContext();

                Map listenersByType = ListenerTools.getListenersByType(
                        ListenerTools.JAVASCRIPT_NAME_SPACE, component);

                EventsRenderer.encodeEventListeners(javaScriptWriter, context
                        .peekVarId(), listenersByType, null);
            }

        }
        super.encodeComponentsBegin();
    }
}
