/*
 * $Id: f_radioButton.js,v 1.6 2006/11/09 19:08:57 oeuillot Exp $
 */

/** 
 * class f_radioButton
 *
 * @class f_radioButton extends f_checkButton, fa_groupName, fa_required
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.6 $ $Date: 2006/11/09 19:08:57 $
 */
var __prototype = {

	f_radioButton: function() {
		this.f_super(arguments);
		
		var input=this._input;
		
		var name=input.name;
		if (name) {
			this.f_addToGroup(name, this);
		}
	},
	/**
	 * @method public 
	 * @return String
	 */
	f_getGroupName: function() {
		var input=this._input;
		if (!input) {
			return null;
		}
		return input.name;
	},
	/*
	 * @method public 
	 * @param String group
	 * @return void
	 *
	f_setGroupName: function(group) {
		var input=this._input;
		if (!input || !group) {
			return;
		}
		
		this.f_changeGroup(this.f_getGroupName(), group, this);
		input.name = group;
	
		this.f_setProperty(f_prop.GROUPNAME,group);
	},
	*/
	
	/**
	 * @method public 
	 * @return f_radioButton
	 */
	f_getSelectedInGroup: function() {
		function search(item) {
			return item.f_isSelected()?item:false;
		}

		return this.f_findIntoGroup(this.f_getGroupName(), search);
	},
	/**
	 * @method public 
	 * @return f_radioButton[]
	 */
	f_listAllInGroup: function() {
		return this.f_listGroup(this.f_getGroupName());
	},
	/**
	 * @method public 
	 * @return boolean
	 */
	f_isSelected: function() {
		var input=this._input;
		if (!input) {
			return false;
		}
		
		return (input.checked==true);
	},
	/**
	 * @method public 
	 * @param boolean set
	 * @return void
	 */
	f_setSelected: function(set) {
		var input=this._input;
		
		if (!input || input.checked==set) {
			return;
		}
		
		if (!set) {
			return;
		}

		if (f_core.IsGecko()) {
			// Pour Gecko, il faut le faire à la main !
			function unselect(item) {
				if (item._input && item._input.checked) {
					item._input.checked=false;
				}
			}
	
			this.f_findIntoGroup(this.f_getGroupName(), unselect);
		}
				
		input.checked = true;
	},
	fa_updateRequired: function() {
	},
	fa_getRadioScope: fa_groupName.GlobalScope
}

var f_radioButton=new f_class("f_radioButton", null, null, __prototype, f_checkButton, fa_groupName, fa_required);
