/*
 * $Id: f_text.js,v 1.5 2006/12/18 13:30:33 oeuillot Exp $
 */

/**
 * @class f_text extends f_component
 * @author Olivier Oeuillot (latest modification by $Author: oeuillot $)
 * @version $Revision: 1.5 $ $Date: 2006/12/18 13:30:33 $
 */
var __prototype = {

	/**
	 * @method public
	 * @return String
	 */
	f_getText: function() {
		return f_core.GetTextNode(this, true);
	},
	/**
	 * @method public
	 * @param String text The text.
	 * @return void
	 */
	f_setText: function(text) {
		f_core.Assert(typeof(text)=="string", "Invalid text parameter ! ('"+text+"')");
		if (this.f_getText() == text) {
			return;
		}
		
		f_core.SetTextNode(this, text, this._accessKey);
		
		this.f_setProperty(f_prop.TEXT,text);
	},
	/**
	 * @method public
	 * @return String
	 */
	f_getValue: function() {
		return this.f_getText();
	},
	/**
	 * @method public
	 * @param String text The text.
	 * @return void
	 */
	f_setValue: function(text) {
		this.f_setText(text);
	}	
}

var f_text=new f_class("f_text", null, null, __prototype, f_component);
