/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.dom;

import org.python.apache.xerces.dom.CharacterDataImpl;
import org.python.apache.xerces.dom.CoreDocumentImpl;
import org.python.apache.xerces.dom.DOMMessageFormatter;
import org.python.apache.xerces.dom.NodeImpl;
import org.scijava.jython.shaded.org.w3c.dom.CharacterData;
import org.scijava.jython.shaded.org.w3c.dom.DOMException;
import org.scijava.jython.shaded.org.w3c.dom.Node;
import org.scijava.jython.shaded.org.w3c.dom.Text;

public class TextImpl
extends CharacterDataImpl
implements CharacterData,
Text {
    static final long serialVersionUID = -5294980852957403469L;

    public TextImpl() {
    }

    public TextImpl(CoreDocumentImpl coreDocumentImpl, String string2) {
        super(coreDocumentImpl, string2);
    }

    public void setValues(CoreDocumentImpl coreDocumentImpl, String string2) {
        this.flags = 0;
        this.nextSibling = null;
        this.previousSibling = null;
        this.setOwnerDocument(coreDocumentImpl);
        this.data = string2;
    }

    public short getNodeType() {
        return 3;
    }

    public String getNodeName() {
        return "#text";
    }

    public void setIgnorableWhitespace(boolean bl) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.isIgnorableWhitespace(bl);
    }

    public boolean isElementContentWhitespace() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.internalIsIgnorableWhitespace();
    }

    public String getWholeText() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.data != null && this.data.length() != 0) {
            stringBuffer.append(this.data);
        }
        this.getWholeTextBackward(this.getPreviousSibling(), stringBuffer, this.getParentNode());
        String string2 = stringBuffer.toString();
        stringBuffer.setLength(0);
        this.getWholeTextForward(this.getNextSibling(), stringBuffer, this.getParentNode());
        return string2 + stringBuffer.toString();
    }

    protected void insertTextContent(StringBuffer stringBuffer) throws DOMException {
        String string2 = this.getNodeValue();
        if (string2 != null) {
            stringBuffer.insert(0, string2);
        }
    }

    private boolean getWholeTextForward(Node node, StringBuffer stringBuffer, Node node2) {
        boolean bl = false;
        if (node2 != null) {
            bl = node2.getNodeType() == 5;
        }
        while (node != null) {
            short s = node.getNodeType();
            if (s == 5) {
                if (this.getWholeTextForward(node.getFirstChild(), stringBuffer, node)) {
                    return true;
                }
            } else if (s == 3 || s == 4) {
                ((NodeImpl)node).getTextContent(stringBuffer);
            } else {
                return true;
            }
            node = node.getNextSibling();
        }
        if (bl) {
            this.getWholeTextForward(node2.getNextSibling(), stringBuffer, node2.getParentNode());
            return true;
        }
        return false;
    }

    private boolean getWholeTextBackward(Node node, StringBuffer stringBuffer, Node node2) {
        boolean bl = false;
        if (node2 != null) {
            bl = node2.getNodeType() == 5;
        }
        while (node != null) {
            short s = node.getNodeType();
            if (s == 5) {
                if (this.getWholeTextBackward(node.getLastChild(), stringBuffer, node)) {
                    return true;
                }
            } else if (s == 3 || s == 4) {
                ((TextImpl)node).insertTextContent(stringBuffer);
            } else {
                return true;
            }
            node = node.getPreviousSibling();
        }
        if (bl) {
            this.getWholeTextBackward(node2.getPreviousSibling(), stringBuffer, node2.getParentNode());
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Text replaceWholeText(String string2) throws DOMException {
        void var3_6;
        Node node;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        Node node2 = this.getParentNode();
        if (string2 == null || string2.length() == 0) {
            if (node2 == null) return null;
            node2.removeChild(this);
            return null;
        }
        if (this.ownerDocument().errorChecking) {
            if (!this.canModifyPrev(this)) {
                throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
            }
            if (!this.canModifyNext(this)) {
                throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
            }
        }
        Object var3_3 = null;
        if (this.isReadOnly()) {
            node = this.ownerDocument().createTextNode(string2);
            if (node2 == null) return node;
            node2.insertBefore(node, this);
            node2.removeChild(this);
            Node node3 = node;
        } else {
            this.setData(string2);
            TextImpl textImpl = this;
        }
        node = var3_6.getPreviousSibling();
        while (node != null) {
            if (node.getNodeType() != 3 && node.getNodeType() != 4 && (node.getNodeType() != 5 || !this.hasTextOnlyChildren(node))) break;
            node2.removeChild(node);
            node = var3_6;
            node = node.getPreviousSibling();
        }
        Node node4 = var3_6.getNextSibling();
        while (node4 != null) {
            if (node4.getNodeType() != 3 && node4.getNodeType() != 4 && (node4.getNodeType() != 5 || !this.hasTextOnlyChildren(node4))) return var3_6;
            node2.removeChild(node4);
            node4 = var3_6;
            node4 = node4.getNextSibling();
        }
        return var3_6;
    }

    /*
     * Unable to fully structure code
     */
    private boolean canModifyPrev(Node var1_1) {
        var2_2 = false;
        var3_3 = var1_1.getPreviousSibling();
        while (var3_3 != null) {
            block9: {
                block8: {
                    var4_4 = var3_3.getNodeType();
                    if (var4_4 != 5) break block8;
                    var5_5 = var3_3.getLastChild();
                    if (var5_5 != null) ** GOTO lbl20
                    return false;
lbl-1000:
                    // 1 sources

                    {
                        var6_6 = var5_5.getNodeType();
                        if (var6_6 == 3 || var6_6 == 4) {
                            var2_2 = true;
                        } else if (var6_6 == 5) {
                            if (!this.canModifyPrev(var5_5)) {
                                return false;
                            }
                            var2_2 = true;
                        } else {
                            return var2_2 == false;
                        }
                        var5_5 = var5_5.getPreviousSibling();
lbl20:
                        // 2 sources

                        ** while (var5_5 != null)
                    }
lbl21:
                    // 1 sources

                    break block9;
                }
                if (var4_4 != 3 && var4_4 != 4) {
                    return true;
                }
            }
            var3_3 = var3_3.getPreviousSibling();
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean canModifyNext(Node var1_1) {
        var2_2 = false;
        var3_3 = var1_1.getNextSibling();
        while (var3_3 != null) {
            block9: {
                block8: {
                    var4_4 = var3_3.getNodeType();
                    if (var4_4 != 5) break block8;
                    var5_5 = var3_3.getFirstChild();
                    if (var5_5 != null) ** GOTO lbl20
                    return false;
lbl-1000:
                    // 1 sources

                    {
                        var6_6 = var5_5.getNodeType();
                        if (var6_6 == 3 || var6_6 == 4) {
                            var2_2 = true;
                        } else if (var6_6 == 5) {
                            if (!this.canModifyNext(var5_5)) {
                                return false;
                            }
                            var2_2 = true;
                        } else {
                            return var2_2 == false;
                        }
                        var5_5 = var5_5.getNextSibling();
lbl20:
                        // 2 sources

                        ** while (var5_5 != null)
                    }
lbl21:
                    // 1 sources

                    break block9;
                }
                if (var4_4 != 3 && var4_4 != 4) {
                    return true;
                }
            }
            var3_3 = var3_3.getNextSibling();
        }
        return true;
    }

    private boolean hasTextOnlyChildren(Node node) {
        Node node2 = node;
        if (node2 == null) {
            return false;
        }
        node2 = node2.getFirstChild();
        while (node2 != null) {
            short s = node2.getNodeType();
            if (s == 5) {
                return this.hasTextOnlyChildren(node2);
            }
            if (s != 3 && s != 4 && s != 5) {
                return false;
            }
            node2 = node2.getNextSibling();
        }
        return true;
    }

    public boolean isIgnorableWhitespace() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.internalIsIgnorableWhitespace();
    }

    public Text splitText(int n) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMException(7, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null));
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (n < 0 || n > this.data.length()) {
            throw new DOMException(1, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null));
        }
        Text text2 = this.getOwnerDocument().createTextNode(this.data.substring(n));
        this.setNodeValue(this.data.substring(0, n));
        Node node = this.getParentNode();
        if (node != null) {
            node.insertBefore(text2, this.nextSibling);
        }
        return text2;
    }

    public void replaceData(String string2) {
        this.data = string2;
    }

    public String removeData() {
        String string2 = this.data;
        this.data = "";
        return string2;
    }
}

