/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jython.shaded.com.kenai.jffi;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.scijava.jython.shaded.com.kenai.jffi.CallContext;
import org.scijava.jython.shaded.com.kenai.jffi.Closure;
import org.scijava.jython.shaded.com.kenai.jffi.Foreign;
import org.scijava.jython.shaded.com.kenai.jffi.MemoryIO;

public final class ClosureMagazine {
    private final Foreign foreign;
    private final CallContext callContext;
    private final long magazineAddress;
    private final AtomicBoolean disposed = new AtomicBoolean(false);

    ClosureMagazine(Foreign foreign, CallContext callContext, long magazineAddress) {
        this.foreign = foreign;
        this.callContext = callContext;
        this.magazineAddress = magazineAddress;
    }

    public Closure.Handle allocate(Object proxy) {
        long closureAddress = this.foreign.closureMagazineGet(this.magazineAddress, proxy);
        return closureAddress != 0L ? new Handle(this, closureAddress, MemoryIO.getInstance().getAddress(closureAddress)) : null;
    }

    public void dispose() {
        if (this.magazineAddress != 0L && !this.disposed.getAndSet(true)) {
            this.foreign.freeClosureMagazine(this.magazineAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.magazineAddress != 0L && !this.disposed.getAndSet(true)) {
                this.foreign.freeClosureMagazine(this.magazineAddress);
            }
        }
        catch (Throwable t) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "exception when freeing " + this.getClass() + ": %s", t.getLocalizedMessage());
        }
        finally {
            super.finalize();
        }
    }

    private static final class Handle
    implements Closure.Handle {
        private final ClosureMagazine magazine;
        private final long closureAddress;
        private final long codeAddress;

        private Handle(ClosureMagazine magazine, long closureAddress, long codeAddress) {
            this.magazine = magazine;
            this.closureAddress = closureAddress;
            this.codeAddress = codeAddress;
        }

        @Override
        public long getAddress() {
            return this.codeAddress;
        }

        @Override
        public void setAutoRelease(boolean autorelease) {
        }

        @Override
        public void dispose() {
        }

        @Override
        public void free() {
        }
    }
}

