/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jython.shaded.javatests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.python.util.Generic;
import org.scijava.jython.shaded.javatests.TestSupport;

public abstract class ListTest {
    private final List<Object> nullList = this.newInstance(Arrays.asList(new Object[]{null}));

    public static ListTest getArrayListTest(final boolean makeReadOnly) {
        return new ListTest(){

            @Override
            public List<Object> newInstance(Collection<Object> c) {
                List<Object> l = null;
                l = c == null ? Generic.list() : new ArrayList<Object>(c);
                return makeReadOnly ? Collections.unmodifiableList(l) : l;
            }

            @Override
            public boolean isReadOnly() {
                return makeReadOnly;
            }
        };
    }

    public static void verifyImutability(List<Object> l) {
        String message2 = "Expected UnsupportedOperationException.";
        try {
            l.add(0, 0);
            TestSupport.fail(message2);
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            l.add(0);
            TestSupport.fail(message2);
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            l.addAll(null);
            TestSupport.fail(message2);
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            l.addAll(0, null);
            TestSupport.fail(message2);
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            l.clear();
            TestSupport.fail(message2);
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            l.remove(0);
            TestSupport.fail(message2);
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            l.remove(new Object());
            TestSupport.fail(message2);
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            l.removeAll(null);
            TestSupport.fail(message2);
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            l.retainAll(null);
            TestSupport.fail(message2);
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            l.set(0, 0);
            TestSupport.fail(message2);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    protected List<Object> defaultList() {
        List<Object> l = Generic.list();
        for (int i = 0; i < 4; ++i) {
            l.add(i);
        }
        return this.newInstance(l);
    }

    public List<Object> newInstance(Collection<Object> c) {
        throw new UnsupportedOperationException("This method must be overridden");
    }

    public boolean isReadOnly() {
        throw new UnsupportedOperationException("This method must be overridden");
    }

    public void testAll() {
        this.test_get();
        this.test_equals();
        this.test_size();
        this.test_contains();
        this.test_containsAll();
        try {
            this.defaultList().hashCode();
            this.test_hashCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.test_subList();
        this.test_indexOf();
        this.test_lastIndexOf();
        this.test_listIterator();
        this.test_toArray();
        this.test_toArray_typed();
        if (!this.isReadOnly()) {
            this.test_add();
            this.test_add_index();
            this.test_set();
            this.test_clear();
            this.test_addAll();
            this.test_addAll_index();
            this.test_remove();
            this.test_remove_index();
            this.test_removeAll();
            this.test_retainAll();
        } else {
            ListTest.verifyImutability(this.newInstance(null));
        }
    }

    public void test_get() {
        List<Object> l = this.defaultList();
        TestSupport.assertThat(l.get(0).equals(0), "get() did not return expected value of Integer(0)");
        try {
            l.get(-1);
            TestSupport.fail("get(<negative index>) did not throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            l.get(l.size());
            TestSupport.fail("get(<index too big>) did not throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void test_set() {
        try {
            this.newInstance(null).set(-1, "spam");
            TestSupport.fail("get(<negative index>) did not throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            this.newInstance(null).set(0, "spam");
            TestSupport.fail("set(<index too big>) did not throw IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        List<Object> a = this.defaultList();
        a.set(a.size() - 1, "spam");
        TestSupport.assertThat(a.get(a.size() - 1).equals("spam"), "set() object was not retrieved via get()");
    }

    public void test_add() {
        List<Object> a = this.newInstance(null);
        for (int i = 0; i < 4; ++i) {
            a.add(i);
        }
        TestSupport.assertEquals(a, this.defaultList(), "add(Object o) failed");
    }

    public void test_isEmpty() {
        List<Object> a = this.newInstance(null);
        TestSupport.assertThat(a.isEmpty(), "isEmpty() is false on an emtpy List");
        a.addAll(this.defaultList());
        TestSupport.assertThat(!a.isEmpty(), "isEmpty() is true on a non-empty List)");
        a.clear();
        TestSupport.assertThat(a.isEmpty(), "isEmpty() is false on an emtpy List");
    }

    public void test_size() {
        List<Object> b = this.newInstance(null);
        TestSupport.assertThat(b.size() == 0, "empty list size was not 0");
        TestSupport.assertThat(this.defaultList().size() == 4, "default list did not have a size of 4");
    }

    public void test_add_index() {
        List<Object> a = this.newInstance(null);
        List<Object> b = this.defaultList();
        for (int i = 0; i < b.size(); ++i) {
            a.add(i, b.get(i));
        }
        try {
            a.add(a.size() + 1, new Integer(a.size() + 1));
            TestSupport.fail("expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            a.add(-1, new Integer(-1));
            TestSupport.fail("expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void test_equals() {
        TestSupport.assertEquals(this.defaultList(), this.defaultList(), "Identical lists weren't equal()");
        TestSupport.assertNotEquals(this.newInstance(null), this.defaultList(), "Different lists were equal()");
        TestSupport.assertNotEquals(this.newInstance(null), new Object(), "List was equal to a non-List type");
    }

    public void test_addAll() {
        List<Object> b;
        List<Object> a = this.defaultList();
        TestSupport.assertThat(a.addAll(b = this.defaultList()), "Mutating addAll(Collection) returned false");
        TestSupport.assertThat(!a.addAll(this.newInstance(null)), "Idempotent addAll(Collection) returned true");
        TestSupport.assertThat(b.addAll(b), "Mutating addAll(Collection) returned false");
        TestSupport.assertEquals(a, b, "Expected equal objects from addAll(collection)");
        TestSupport.assertThat(a.size() == 8, "Expected List to have size 8 after addAll(Collection)");
    }

    public void test_indexOf() {
        TestSupport.assertThat(this.defaultList().indexOf(3) == 3, "indexOf(3) did not return 3");
        TestSupport.assertThat(this.defaultList().indexOf(42) == -1, "indexOf() non-existing entry did not return -1");
        TestSupport.assertThat(this.defaultList().indexOf(null) == -1, "indexOf() non-existing null did not return -1");
    }

    public void test_contains() {
        TestSupport.assertThat(!this.defaultList().contains(42), "contains() returned true for non-existing entry");
        TestSupport.assertThat(this.defaultList().contains(0), "contains() returned false for existing entry");
        TestSupport.assertThat(this.nullList.contains(null), "contains() returned false for existing null entry");
        TestSupport.assertThat(!this.defaultList().contains(null), "contains() returned true for non-existing null entry");
    }

    public void test_remove() {
        List<Object> a = this.defaultList();
        a.add(null);
        TestSupport.assertThat(a.remove(null), "remove() existing null entry returned false");
        TestSupport.assertThat(!a.remove(null), "remove() non-existing null entry returned false");
        a.add("spam");
        TestSupport.assertThat(a.remove("spam"), "remove() existing entry returned false");
        TestSupport.assertThat(!a.remove("spam"), "remove() non-existing entry returned true");
    }

    public void test_remove_index() {
        List<Object> a = this.defaultList();
        int n = a.size();
        for (int i = 0; i < n; ++i) {
            a.remove(0);
        }
        TestSupport.assertThat(a.size() == 0, "remove()-d all entries but size() not 0");
        try {
            a.remove(0);
            TestSupport.fail("removing a non-existing index did not throw exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void test_lastIndexOf() {
        ArrayList<Object> l = new ArrayList<Object>(this.defaultList());
        l.add(0);
        List<Object> a = this.newInstance(l);
        TestSupport.assertThat(a.lastIndexOf(0) == 4, "lastIndexOf() did not return 4");
        TestSupport.assertThat(a.lastIndexOf(42) == -1, "lastIndexOf() non-existing value did not return -1");
    }

    public void test_removeAll() {
        List<Object> a = this.defaultList();
        TestSupport.assertThat(a.removeAll(a), "mutating removeAll() did not return true");
        TestSupport.assertThat(!a.removeAll(a), "idempotent removeAll did not return false");
        TestSupport.assertThat(!a.removeAll(this.nullList), "idempotent removeAll did not return false");
        List<Object> yanl = this.newInstance(null);
        yanl.addAll(this.nullList);
        TestSupport.assertThat(yanl.removeAll(this.nullList), "mutating removeAll() did not return true");
        TestSupport.assertThat(yanl.size() == 0, "empty list had non-zero size");
        TestSupport.assertThat(!yanl.removeAll(this.newInstance(null)), "idempotent removeAll did not return false");
    }

    public void test_addAll_index() {
        List<Object> a = this.defaultList();
        List<Object> b = this.newInstance(null);
        TestSupport.assertThat(b.addAll(0, a), "mutating addAll(index, Collection) did not return true");
        TestSupport.assertEquals(a, b, "addAll(index, Collection) instances failed equals test");
        TestSupport.assertThat(!a.addAll(0, this.newInstance(null)), "idempotent addAll(index, Collection) did not return false");
        TestSupport.assertThat(b.addAll(0, b), "mutating addAll(index, Collection) did not return true");
        b = this.newInstance(null);
        b.addAll(new ArrayList<Object>(this.defaultList()));
        TestSupport.assertEquals(this.defaultList(), b, "addAll(index, <ArrayList>) failed equals test");
    }

    public void test_hashCode() {
        List<Object> a = this.defaultList();
        TestSupport.assertThat(a.hashCode() == this.defaultList().hashCode(), "Instances with same internal state have different hashcode");
        TestSupport.assertThat(a.hashCode() != this.newInstance(null).hashCode(), "Instances with different internal state have the same hashcode");
        if (!this.isReadOnly()) {
            List<Object> b = this.newInstance(null);
            b.addAll(a);
            b.remove(0);
            TestSupport.assertThat(a.hashCode() != b.hashCode(), "Instances with different internal state have the same hashcode");
        }
    }

    public void test_clear() {
        List<Object> a = this.defaultList();
        a.clear();
        TestSupport.assertThat(a.size() == 0, "clear()-ed list did not have size of 0");
    }

    public void test_subList() {
        List<Object> a = this.defaultList();
        TestSupport.assertThat(a.subList(0, a.size()) != a, "subList() returned the same instance");
        TestSupport.assertEquals(a.subList(0, a.size()), a, "Complete subList() did not equal original List");
        TestSupport.assertThat(a.subList(0, 0).size() == 0, "empty subList had non-zero size");
        try {
            a.subList(-1, 1);
            TestSupport.fail("Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            a.subList(1, 0);
            TestSupport.fail("Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            a.subList(0, a.size() + 1);
            TestSupport.fail("Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        if (!this.isReadOnly()) {
            a.subList(0, a.size()).clear();
            TestSupport.assertThat(a.size() == 0, "clear()-ed sublist did not have zero size");
            List<Object> c = this.newInstance(null);
            c.addAll(this.defaultList());
            List<Object> d = c.subList(1, 3);
            TestSupport.assertThat(d.size() == 2, "Expected subList to have size of 2");
            TestSupport.assertThat(c.set(1, "canned").equals(1), "subList.set() did not return Integer(1) from index 1 of defaultList");
            TestSupport.assertThat(d.get(0).equals("canned"), "subList does not update with changes to parent");
            d.set(0, "spam");
            TestSupport.assertThat(c.get(1).equals("spam"), "parent does not update with changes to subList child");
        } else {
            List<Object> b = a.subList(0, a.size());
            ListTest.verifyImutability(b);
        }
    }

    public void test_retainAll() {
        List<Object> a = this.defaultList();
        a.retainAll(this.defaultList());
        TestSupport.assertEquals(a, this.defaultList(), "retainAll(<equal List>) does not equal original list");
        a = this.defaultList();
        a.retainAll(this.newInstance(null));
        TestSupport.assertThat(a.size() == 0, "retainAll(<empty List>))does not have size of zero");
        a = this.defaultList();
        a.remove(0);
        a.remove(0);
        a.add(4);
        a.add(5);
        List<Object> b = this.newInstance(null);
        b.add(2);
        b.add(3);
        a.retainAll(b);
        TestSupport.assertEquals(a, b, "retainAll() on overlap of indices [2,3] did not return that List");
    }

    public void test_containsAll() {
        TestSupport.assertThat(this.defaultList().containsAll(this.defaultList()), "containsAll(<identical List> was false");
        TestSupport.assertThat(this.defaultList().containsAll(this.newInstance(null)), "containsAll(<empty List>) was false");
        TestSupport.assertThat(!this.newInstance(null).containsAll(this.defaultList()), "containsAll(<disjoint List>) returned true");
        TestSupport.assertThat(this.defaultList().containsAll(this.defaultList().subList(1, 3)), "containsAll(<subList>) was false");
    }

    public void test_iterator() {
        TestSupport.assertThat(!this.newInstance(null).iterator().hasNext(), "Iterator for empty list thinks it hasNext()");
        try {
            this.newInstance(null).iterator().next();
            TestSupport.fail("expected NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        List<Object> a = this.defaultList();
        int i = 0;
        for (Object element : a) {
            TestSupport.assertThat(element == a.get(i++), "Iterator next() failed identity test");
        }
        TestSupport.assertThat(i == a.size(), "Iterator did not iterator over entire list");
    }

    public void test_listIterator() {
        ListIterator<Object> li = this.newInstance(null).listIterator();
        TestSupport.assertThat(!li.hasNext(), "ListIterator.hasNext() is true for empty List");
        TestSupport.assertThat(!li.hasPrevious(), "ListIterator.hasPrevious() is true for empty List");
        try {
            li.next();
            TestSupport.fail("expected NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        try {
            li.previous();
            TestSupport.fail("expected NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        int nextIndex = li.nextIndex();
        TestSupport.assertThat(nextIndex == 0, "ListIterator.nextIndex() on empty List did not return 0");
        int prevIndex = li.previousIndex();
        TestSupport.assertThat(prevIndex == -1, "ListIterator.previousIndex() on empty List did not return -1");
        List<Object> l = Generic.list();
        l.add(1);
        li = this.newInstance(l).listIterator();
        TestSupport.assertThat(!li.hasPrevious(), "ListIterator.hasPrevious() is true with nothing previous");
        TestSupport.assertThat(li.hasNext(), "ListIterator.hasNext() is false with next present");
        TestSupport.assertThat(li.next().equals(1), "ListIterator.next() did not return expected Integer(1)");
        if (!this.isReadOnly()) {
            li.remove();
            TestSupport.assertThat(!li.hasNext(), "ListIterator.hasNext() is true for empty List");
            TestSupport.assertThat(!li.hasPrevious(), "ListIterator.hasPrevious() is true for empty List");
            try {
                li.set(42);
                TestSupport.fail("expected IllegalStateException");
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            try {
                li.remove();
                TestSupport.fail("expected IllegalStateException");
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        l = Generic.list(0, 1, 2);
        li = this.newInstance(l).listIterator();
        int n = l.size();
        for (int i = 0; i < n; ++i) {
            TestSupport.assertThat(li.next().equals(i), "ListIterator.previous did not return expected value");
        }
        while (!this.isReadOnly() && li.hasNext()) {
            li.next();
            li.set(42);
            TestSupport.assertThat(li.previous().equals(42), "ListIterator.previous() did not return the value that was set()");
            li.remove();
        }
        if (this.isReadOnly()) {
            li = this.newInstance(null).listIterator();
        }
        li = this.defaultList().listIterator(2);
        TestSupport.assertThat(li.next().equals(2), "List.listIteraor(index) did not return expected value");
        TestSupport.assertThat(li.next().equals(3), "List.listIteraor(index) did not return expected value");
        TestSupport.assertThat(!li.hasNext(), "listIterator.hasNext() at end of list returned true");
    }

    public void test_toArray() {
        Object[] intObjArray = new Object[]{0, 1, 2, 3};
        TestSupport.assertThat(Arrays.equals(this.defaultList().toArray(), intObjArray), "toArray() did not return the expected Integer[] array");
    }

    public void test_toArray_typed() {
        Object[] intObjArray = new Object[]{0, 1, 2, 3};
        TestSupport.assertThat(Arrays.equals((Object[])this.defaultList().toArray(new Integer[0]), intObjArray), "toArray(Integer[]) did not return the expected Integer[] array");
    }
}

