/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jython.shaded.javax.xml.validation;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.scijava.jython.shaded.javax.xml.validation.SchemaFactory;
import org.scijava.jython.shaded.javax.xml.validation.SecuritySupport;

final class SchemaFactoryFinder {
    private static final String W3C_XML_SCHEMA10_NS_URI = "http://www.w3.org/XML/XMLSchema/v1.0";
    private static final String W3C_XML_SCHEMA11_NS_URI = "http://www.w3.org/XML/XMLSchema/v1.1";
    private static boolean debug = false;
    private static Properties cacheProps = new Properties();
    private static boolean firstTime = true;
    private static final int DEFAULT_LINE_LENGTH = 80;
    private final ClassLoader classLoader;
    private static final Class SERVICE_CLASS;
    private static final String SERVICE_ID;
    static /* synthetic */ Class class$javax$xml$validation$SchemaFactory;

    private static void debugPrintln(String string2) {
        if (debug) {
            System.err.println("JAXP: " + string2);
        }
    }

    public SchemaFactoryFinder(ClassLoader classLoader) {
        this.classLoader = classLoader;
        if (debug) {
            this.debugDisplayClassLoader();
        }
    }

    private void debugDisplayClassLoader() {
        try {
            if (this.classLoader == SecuritySupport.getContextClassLoader()) {
                SchemaFactoryFinder.debugPrintln("using thread context class loader (" + this.classLoader + ") for search");
                return;
            }
        }
        catch (VirtualMachineError virtualMachineError) {
            throw virtualMachineError;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.classLoader == ClassLoader.getSystemClassLoader()) {
            SchemaFactoryFinder.debugPrintln("using system class loader (" + this.classLoader + ") for search");
            return;
        }
        SchemaFactoryFinder.debugPrintln("using class loader (" + this.classLoader + ") for search");
    }

    public SchemaFactory newFactory(String string2) {
        if (string2 == null) {
            throw new NullPointerException();
        }
        SchemaFactory schemaFactory = this._newFactory(string2);
        if (debug) {
            if (schemaFactory != null) {
                SchemaFactoryFinder.debugPrintln("factory '" + schemaFactory.getClass().getName() + "' was found for " + string2);
            } else {
                SchemaFactoryFinder.debugPrintln("unable to find a factory for " + string2);
            }
        }
        return schemaFactory;
    }

    private SchemaFactory _newFactory(String string2) {
        Serializable serializable;
        Object object;
        SchemaFactory schemaFactory;
        block31: {
            String string3;
            String string4;
            block30: {
                string4 = SERVICE_CLASS.getName() + ":" + string2;
                try {
                    if (debug) {
                        SchemaFactoryFinder.debugPrintln("Looking up system property '" + string4 + "'");
                    }
                    if ((string3 = SecuritySupport.getSystemProperty(string4)) != null && string3.length() > 0) {
                        if (debug) {
                            SchemaFactoryFinder.debugPrintln("The value is '" + string3 + "'");
                        }
                        if ((schemaFactory = this.createInstance(string3)) != null) {
                            return schemaFactory;
                        }
                    } else if (debug) {
                        SchemaFactoryFinder.debugPrintln("The property is undefined.");
                    }
                }
                catch (VirtualMachineError virtualMachineError) {
                    throw virtualMachineError;
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    if (!debug) break block30;
                    SchemaFactoryFinder.debugPrintln("failed to look up system property '" + string4 + "'");
                    throwable.printStackTrace();
                }
            }
            string3 = SecuritySupport.getSystemProperty("java.home");
            String string5 = string3 + File.separator + "lib" + File.separator + "jaxp.properties";
            String string6 = null;
            try {
                if (firstTime) {
                    object = cacheProps;
                    synchronized (object) {
                        if (firstTime) {
                            serializable = new File(string5);
                            firstTime = false;
                            if (SecuritySupport.doesFileExist((File)serializable)) {
                                if (debug) {
                                    SchemaFactoryFinder.debugPrintln("Read properties file " + serializable);
                                }
                                cacheProps.load(SecuritySupport.getFileInputStream((File)serializable));
                            }
                        }
                    }
                }
                string6 = cacheProps.getProperty(string4);
                if (debug) {
                    SchemaFactoryFinder.debugPrintln("found " + string6 + " in $java.home/jaxp.properties");
                }
                if (string6 != null && (schemaFactory = this.createInstance(string6)) != null) {
                    return schemaFactory;
                }
            }
            catch (Exception exception) {
                if (!debug) break block31;
                exception.printStackTrace();
            }
        }
        object = this.createServiceFileIterator();
        while (object.hasNext()) {
            serializable = (URL)object.next();
            if (debug) {
                SchemaFactoryFinder.debugPrintln("looking into " + serializable);
            }
            try {
                schemaFactory = this.loadFromServicesFile(string2, ((URL)serializable).toExternalForm(), SecuritySupport.getURLInputStream((URL)serializable));
                if (schemaFactory == null) continue;
                return schemaFactory;
            }
            catch (IOException iOException) {
                if (!debug) continue;
                SchemaFactoryFinder.debugPrintln("failed to read " + serializable);
                iOException.printStackTrace();
            }
        }
        if (string2.equals("http://www.w3.org/2001/XMLSchema") || string2.equals(W3C_XML_SCHEMA10_NS_URI)) {
            if (debug) {
                SchemaFactoryFinder.debugPrintln("attempting to use the platform default XML Schema 1.0 validator");
            }
            return this.createInstance("org.python.apache.xerces.jaxp.validation.XMLSchemaFactory");
        }
        if (string2.equals(W3C_XML_SCHEMA11_NS_URI)) {
            if (debug) {
                SchemaFactoryFinder.debugPrintln("attempting to use the platform default XML Schema 1.1 validator");
            }
            return this.createInstance("org.python.apache.xerces.jaxp.validation.XMLSchema11Factory");
        }
        if (debug) {
            SchemaFactoryFinder.debugPrintln("all things were tried, but none was found. bailing out.");
        }
        return null;
    }

    SchemaFactory createInstance(String string2) {
        block8: {
            try {
                Object obj;
                if (debug) {
                    SchemaFactoryFinder.debugPrintln("instanciating " + string2);
                }
                Class<?> clazz = this.classLoader != null ? this.classLoader.loadClass(string2) : Class.forName(string2);
                if (debug) {
                    SchemaFactoryFinder.debugPrintln("loaded it from " + SchemaFactoryFinder.which(clazz));
                }
                if ((obj = clazz.newInstance()) instanceof SchemaFactory) {
                    return (SchemaFactory)obj;
                }
                if (debug) {
                    SchemaFactoryFinder.debugPrintln(string2 + " is not assignable to " + SERVICE_CLASS.getName());
                }
            }
            catch (VirtualMachineError virtualMachineError) {
                throw virtualMachineError;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                SchemaFactoryFinder.debugPrintln("failed to instanciate " + string2);
                if (!debug) break block8;
                throwable.printStackTrace();
            }
        }
        return null;
    }

    private Iterator createServiceFileIterator() {
        if (this.classLoader == null) {
            return new SingleIterator(){
                static /* synthetic */ Class class$javax$xml$validation$SchemaFactoryFinder;

                protected Object value() {
                    ClassLoader classLoader = (class$javax$xml$validation$SchemaFactoryFinder == null ? (class$javax$xml$validation$SchemaFactoryFinder = 1.class$("org.scijava.jython.shaded.javax.xml.validation.SchemaFactoryFinder")) : class$javax$xml$validation$SchemaFactoryFinder).getClassLoader();
                    return SecuritySupport.getResourceAsURL(classLoader, SERVICE_ID);
                }

                static /* synthetic */ Class class$(String string2) {
                    try {
                        return Class.forName(string2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            };
        }
        try {
            final Enumeration enumeration = SecuritySupport.getResources(this.classLoader, SERVICE_ID);
            if (debug && !enumeration.hasMoreElements()) {
                SchemaFactoryFinder.debugPrintln("no " + SERVICE_ID + " file was found");
            }
            return new Iterator(){

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public boolean hasNext() {
                    return enumeration.hasMoreElements();
                }

                public Object next() {
                    return enumeration.nextElement();
                }
            };
        }
        catch (IOException iOException) {
            if (debug) {
                SchemaFactoryFinder.debugPrintln("failed to enumerate resources " + SERVICE_ID);
                iOException.printStackTrace();
            }
            return ((AbstractList)new ArrayList()).iterator();
        }
    }

    private SchemaFactory loadFromServicesFile(String string2, String string3, InputStream inputStream) {
        BufferedReader bufferedReader;
        if (debug) {
            SchemaFactoryFinder.debugPrintln("Reading " + string3);
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"), 80);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream), 80);
        }
        String string4 = null;
        SchemaFactory schemaFactory = null;
        while (true) {
            try {
                string4 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                break;
            }
            if (string4 == null) break;
            int n = string4.indexOf(35);
            if (n != -1) {
                string4 = string4.substring(0, n);
            }
            if ((string4 = string4.trim()).length() == 0) continue;
            try {
                SchemaFactory schemaFactory2 = this.createInstance(string4);
                if (!schemaFactory2.isSchemaLanguageSupported(string2)) continue;
                schemaFactory = schemaFactory2;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return schemaFactory;
    }

    private static String which(Class clazz) {
        return SchemaFactoryFinder.which(clazz.getName(), clazz.getClassLoader());
    }

    private static String which(String string2, ClassLoader classLoader) {
        URL uRL;
        String string3 = string2.replace('.', '/') + ".class";
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((uRL = SecuritySupport.getResourceAsURL(classLoader, string3)) != null) {
            return uRL.toString();
        }
        return null;
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            String string2 = SecuritySupport.getSystemProperty("jaxp.debug");
            debug = string2 != null && !"false".equals(string2);
        }
        catch (Exception exception) {
            debug = false;
        }
        SERVICE_CLASS = class$javax$xml$validation$SchemaFactory == null ? (class$javax$xml$validation$SchemaFactory = SchemaFactoryFinder.class$("org.scijava.jython.shaded.javax.xml.validation.SchemaFactory")) : class$javax$xml$validation$SchemaFactory;
        SERVICE_ID = "META-INF/services/" + SERVICE_CLASS.getName();
    }

    private static abstract class SingleIterator
    implements Iterator {
        private boolean seen = false;

        private SingleIterator() {
        }

        public final void remove() {
            throw new UnsupportedOperationException();
        }

        public final boolean hasNext() {
            return !this.seen;
        }

        public final Object next() {
            if (this.seen) {
                throw new NoSuchElementException();
            }
            this.seen = true;
            return this.value();
        }

        protected abstract Object value();
    }
}

