/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jython.shaded.jnr.ffi.provider.jffi;

import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.python.objectweb.asm.ClassReader;
import org.python.objectweb.asm.ClassVisitor;
import org.python.objectweb.asm.ClassWriter;
import org.scijava.jython.shaded.com.kenai.jffi.Function;
import org.scijava.jython.shaded.jnr.ffi.CallingConvention;
import org.scijava.jython.shaded.jnr.ffi.LibraryOption;
import org.scijava.jython.shaded.jnr.ffi.Runtime;
import org.scijava.jython.shaded.jnr.ffi.mapper.CachingTypeMapper;
import org.scijava.jython.shaded.jnr.ffi.mapper.CompositeTypeMapper;
import org.scijava.jython.shaded.jnr.ffi.mapper.DefaultSignatureType;
import org.scijava.jython.shaded.jnr.ffi.mapper.FromNativeContext;
import org.scijava.jython.shaded.jnr.ffi.mapper.FunctionMapper;
import org.scijava.jython.shaded.jnr.ffi.mapper.MethodResultContext;
import org.scijava.jython.shaded.jnr.ffi.mapper.SignatureTypeMapper;
import org.scijava.jython.shaded.jnr.ffi.mapper.SignatureTypeMapperAdapter;
import org.scijava.jython.shaded.jnr.ffi.mapper.TypeMapper;
import org.scijava.jython.shaded.jnr.ffi.provider.IdentityFunctionMapper;
import org.scijava.jython.shaded.jnr.ffi.provider.InterfaceScanner;
import org.scijava.jython.shaded.jnr.ffi.provider.NativeFunction;
import org.scijava.jython.shaded.jnr.ffi.provider.NativeVariable;
import org.scijava.jython.shaded.jnr.ffi.provider.NullTypeMapper;
import org.scijava.jython.shaded.jnr.ffi.provider.ParameterType;
import org.scijava.jython.shaded.jnr.ffi.provider.ResultType;
import org.scijava.jython.shaded.jnr.ffi.provider.SigType;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.AbstractAsmLibraryInterface;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.AnnotationTypeMapper;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.AsmBuilder;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.AsmClassLoader;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.AsmRuntime;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.AsmUtil;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.BufferMethodGenerator;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.CodegenUtils;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.FastIntMethodGenerator;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.FastLongMethodGenerator;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.FastNumericMethodGenerator;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.InvokerTypeMapper;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.InvokerUtil;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.LibraryLoader;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.MethodGenerator;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.NativeClosureManager;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.NativeFunctionMapperContext;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.NativeLibrary;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.NativeLibraryLoader;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.NativeRuntime;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.NoTrace;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.NoX86;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.NotImplMethodGenerator;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.SkinnyMethodAdapter;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.StubCompiler;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.SymbolNotFoundError;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.VariableAccessorGenerator;
import org.scijava.jython.shaded.jnr.ffi.provider.jffi.X86MethodGenerator;
import org.scijava.jython.shaded.jnr.ffi.util.Annotations;

public class AsmLibraryLoader
extends LibraryLoader {
    public static final boolean DEBUG = Boolean.getBoolean("org.scijava.jython.shaded.jnr.ffi.compile.dump");
    private static final AtomicLong nextClassID = new AtomicLong(0L);
    private static final AtomicLong uniqueId = new AtomicLong(0L);
    private static final ThreadLocal<AsmClassLoader> classLoader = new ThreadLocal();
    private final NativeRuntime runtime = NativeRuntime.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T> T loadLibrary(NativeLibrary library, Class<T> interfaceClass, Map<LibraryOption, ?> libraryOptions) {
        AsmClassLoader oldClassLoader = classLoader.get();
        if (oldClassLoader == null) {
            classLoader.set(new AsmClassLoader(interfaceClass.getClassLoader()));
        }
        try {
            T t = this.generateInterfaceImpl(library, interfaceClass, libraryOptions, classLoader.get());
            return t;
        }
        finally {
            if (oldClassLoader == null) {
                classLoader.remove();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T generateInterfaceImpl(NativeLibrary library, Class<T> interfaceClass, Map<LibraryOption, ?> libraryOptions, AsmClassLoader classLoader) {
        SignatureTypeMapper typeMapper;
        FunctionMapper functionMapper;
        boolean debug2 = DEBUG && !interfaceClass.isAnnotationPresent(NoTrace.class);
        ClassWriter cw = new ClassWriter(2);
        ClassVisitor cv = debug2 ? AsmUtil.newCheckClassAdapter(cw) : cw;
        AsmBuilder builder = new AsmBuilder(this.runtime, CodegenUtils.p(interfaceClass) + "$jnr$ffi$" + nextClassID.getAndIncrement(), cv, classLoader);
        cv.visit(50, 17, builder.getClassNamePath(), null, CodegenUtils.p(AbstractAsmLibraryInterface.class), new String[]{CodegenUtils.p(interfaceClass)});
        FunctionMapper functionMapper2 = functionMapper = libraryOptions.containsKey((Object)LibraryOption.FunctionMapper) ? (FunctionMapper)libraryOptions.get((Object)LibraryOption.FunctionMapper) : IdentityFunctionMapper.getInstance();
        if (libraryOptions.containsKey((Object)LibraryOption.TypeMapper)) {
            Object tm = libraryOptions.get((Object)LibraryOption.TypeMapper);
            if (tm instanceof SignatureTypeMapper) {
                typeMapper = (SignatureTypeMapper)tm;
            } else {
                if (!(tm instanceof TypeMapper)) throw new IllegalArgumentException("TypeMapper option is not a valid TypeMapper instance");
                typeMapper = new SignatureTypeMapperAdapter((TypeMapper)tm);
            }
        } else {
            typeMapper = new NullTypeMapper();
        }
        typeMapper = new CompositeTypeMapper(typeMapper, new CachingTypeMapper(new InvokerTypeMapper(new NativeClosureManager(this.runtime, typeMapper, classLoader), classLoader, NativeLibraryLoader.ASM_ENABLED)), new CachingTypeMapper(new AnnotationTypeMapper()));
        CallingConvention libraryCallingConvention = InvokerUtil.getCallingConvention(interfaceClass, libraryOptions);
        StubCompiler compiler2 = StubCompiler.newCompiler(this.runtime);
        MethodGenerator[] generators = new MethodGenerator[]{!interfaceClass.isAnnotationPresent(NoX86.class) ? new X86MethodGenerator(compiler2) : new NotImplMethodGenerator(), new FastIntMethodGenerator(), new FastLongMethodGenerator(), new FastNumericMethodGenerator(), new BufferMethodGenerator()};
        InterfaceScanner scanner2 = new InterfaceScanner(interfaceClass, typeMapper, libraryCallingConvention);
        block6: for (NativeFunction function : scanner2.functions()) {
            String functionName = functionMapper.mapFunctionName(function.name(), new NativeFunctionMapperContext(library, function.annotations()));
            try {
                long functionAddress = library.findSymbolAddress(functionName);
                MethodResultContext resultContext = new MethodResultContext(this.runtime, function.getMethod());
                DefaultSignatureType signatureType = DefaultSignatureType.create(function.getMethod().getReturnType(), resultContext);
                ResultType resultType = InvokerUtil.getResultType((Runtime)this.runtime, function.getMethod().getReturnType(), resultContext.getAnnotations(), typeMapper.getFromNativeType(signatureType, resultContext), (FromNativeContext)resultContext);
                SigType[] parameterTypes = InvokerUtil.getParameterTypes(this.runtime, typeMapper, function.getMethod());
                Function jffiFunction = new Function(functionAddress, InvokerUtil.getCallContext(resultType, parameterTypes, function.convention(), function.isErrnoRequired()));
                for (MethodGenerator g : generators) {
                    if (!g.isSupported(resultType, (ParameterType[])parameterTypes, function.convention())) continue;
                    g.generate(builder, function.getMethod().getName(), jffiFunction, resultType, (ParameterType[])parameterTypes, !function.isErrnoRequired());
                    continue block6;
                }
            }
            catch (SymbolNotFoundError ex) {
                String errorFieldName = "error_" + uniqueId.incrementAndGet();
                cv.visitField(26, errorFieldName, CodegenUtils.ci(String.class), null, ex.getMessage());
                this.generateFunctionNotFound(cv, builder.getClassNamePath(), errorFieldName, functionName, function.getMethod().getReturnType(), function.getMethod().getParameterTypes());
            }
        }
        VariableAccessorGenerator variableAccessorGenerator = new VariableAccessorGenerator(this.runtime);
        for (NativeVariable v : scanner2.variables()) {
            Method m = v.getMethod();
            Type variableType = ((ParameterizedType)m.getGenericReturnType()).getActualTypeArguments()[0];
            if (!(variableType instanceof Class)) {
                throw new IllegalArgumentException("unsupported variable class: " + variableType);
            }
            String functionName = functionMapper.mapFunctionName(m.getName(), null);
            try {
                variableAccessorGenerator.generate(builder, interfaceClass, m.getName(), library.findSymbolAddress(functionName), (Class)variableType, Annotations.sortedAnnotationCollection(m.getAnnotations()), typeMapper, classLoader);
            }
            catch (SymbolNotFoundError ex) {
                String errorFieldName = "error_" + uniqueId.incrementAndGet();
                cv.visitField(26, errorFieldName, CodegenUtils.ci(String.class), null, ex.getMessage());
                this.generateFunctionNotFound(cv, builder.getClassNamePath(), errorFieldName, functionName, m.getReturnType(), m.getParameterTypes());
            }
        }
        SkinnyMethodAdapter init = new SkinnyMethodAdapter(cv, 1, "<init>", CodegenUtils.sig(Void.TYPE, Runtime.class, NativeLibrary.class, Object[].class), null, null);
        init.start();
        init.aload(0);
        init.aload(1);
        init.aload(2);
        init.invokespecial(CodegenUtils.p(AbstractAsmLibraryInterface.class), "<init>", CodegenUtils.sig(Void.TYPE, Runtime.class, NativeLibrary.class));
        builder.emitFieldInitialization(init, 3);
        init.voidreturn();
        init.visitMaxs(10, 10);
        init.visitEnd();
        cv.visitEnd();
        try {
            byte[] bytes = cw.toByteArray();
            if (debug2) {
                ClassVisitor trace2 = AsmUtil.newTraceClassVisitor(new PrintWriter(System.err));
                new ClassReader(bytes).accept(trace2, 0);
            }
            Class implClass = classLoader.defineClass(builder.getClassNamePath().replace("/", "."), bytes);
            Constructor cons = implClass.getDeclaredConstructor(Runtime.class, NativeLibrary.class, Object[].class);
            Object result2 = cons.newInstance(this.runtime, library, builder.getObjectFieldValues());
            System.err.flush();
            System.out.flush();
            compiler2.attach(implClass);
            return result2;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private void generateFunctionNotFound(ClassVisitor cv, String className, String errorFieldName, String functionName, Class returnType, Class[] parameterTypes) {
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cv, 17, functionName, CodegenUtils.sig(returnType, parameterTypes), null, null);
        mv.start();
        mv.getstatic(className, errorFieldName, CodegenUtils.ci(String.class));
        mv.invokestatic(AsmRuntime.class, "newUnsatisifiedLinkError", UnsatisfiedLinkError.class, String.class);
        mv.athrow();
        mv.visitMaxs(10, 10);
        mv.visitEnd();
    }
}

