/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jython.shaded.jnr.netdb;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.scijava.jython.shaded.jnr.ffi.Platform;
import org.scijava.jython.shaded.jnr.netdb.NetDBEntry;
import org.scijava.jython.shaded.jnr.netdb.NetDBParser;
import org.scijava.jython.shaded.jnr.netdb.Protocol;
import org.scijava.jython.shaded.jnr.netdb.ProtocolsDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileProtocolsDB
implements ProtocolsDB {
    private final File protocolsFile;

    public static final FileProtocolsDB getInstance() {
        return SingletonHolder.INSTANCE;
    }

    FileProtocolsDB(File protocolsFile) {
        this.protocolsFile = protocolsFile;
    }

    private static final File locateProtocolsFile() {
        if (Platform.getNativePlatform().getOS().equals((Object)Platform.OS.WINDOWS)) {
            String systemRoot;
            try {
                systemRoot = System.getProperty("SystemRoot", "C:\\windows");
            }
            catch (SecurityException se) {
                systemRoot = "C:\\windows";
            }
            return new File(systemRoot + "\\system32\\drivers\\etc\\protocol");
        }
        return new File("/etc/protocols");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileProtocolsDB load() {
        try {
            File protocolsFile = FileProtocolsDB.locateProtocolsFile();
            NetDBParser parser2 = new NetDBParser(new FileReader(protocolsFile));
            try {
                parser2.iterator().next();
            }
            finally {
                parser2.close();
            }
            return new FileProtocolsDB(protocolsFile);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public Protocol getProtocolByName(final String name) {
        return this.parse(new Filter(){

            public boolean filter(Protocol p) {
                if (p.getName().equals(name)) {
                    return true;
                }
                for (String alias2 : p.getAliases()) {
                    if (!alias2.equals(name)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public Protocol getProtocolByNumber(final Integer proto) {
        return this.parse(new Filter(){

            public boolean filter(Protocol p) {
                return p.getProto() == proto.intValue();
            }
        });
    }

    @Override
    public Collection<Protocol> getAllProtocols() {
        final LinkedList allProtocols = new LinkedList();
        this.parse(new Filter(){

            public boolean filter(Protocol s) {
                allProtocols.add(s);
                return false;
            }
        });
        return Collections.unmodifiableList(allProtocols);
    }

    private final NetDBParser loadProtocolsFile() {
        try {
            return new NetDBParser(new FileReader(this.protocolsFile));
        }
        catch (FileNotFoundException ex) {
            return new NetDBParser(new StringReader(""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Protocol parse(Filter filter) {
        NetDBParser parser2 = this.loadProtocolsFile();
        try {
            for (NetDBEntry e : parser2) {
                try {
                    Protocol p = new Protocol(e.name, Integer.parseInt(e.data, 10), e.aliases);
                    if (!filter.filter(p)) continue;
                    Protocol protocol = p;
                    return protocol;
                }
                catch (NumberFormatException ex) {}
            }
        }
        finally {
            try {
                parser2.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return null;
    }

    static /* synthetic */ FileProtocolsDB access$000() {
        return FileProtocolsDB.load();
    }

    private static interface Filter {
        public boolean filter(Protocol var1);
    }

    private static final class SingletonHolder {
        public static final FileProtocolsDB INSTANCE = FileProtocolsDB.access$000();

        private SingletonHolder() {
        }
    }
}

